/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.buildsystem;

import com.android.studio.ml.gradle.buildsystem.AbsolutePath;
import com.android.studio.ml.gradle.buildsystem.GetGradleArtifactFromFileKt;
import com.android.studio.ml.gradle.buildsystem.GradleToolsUtilsKt;
import com.android.studio.ml.gradle.buildsystem.ProjectData;
import com.android.studio.ml.gradle.buildsystem.SourceSetModuleData;
import com.android.tools.idea.gradle.model.IdeProjectPath;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.CommonTestType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@ToolDescription(summary="Returns the artifacts that contains the provided file in their sources", instructions="The result can be one or more artifacts for a single sub-project since variants of a single sub-project can share source folders.", examples={})
@ToolResult(description="Returns a JSON array of objects containing the following information:\n- subproject_path: the path of the Gradle sub-project containing the file\n- variant_name: the name of the variant containing the file. This is optional and can be null\n- artifact_type: the name of the artifact containing the file\n- sources: the type of source folder that contains the file. it could be java, kotlin, android resources, android assets, etc...\nReturns an empty array ([]) if no artifacts are found.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/gradle/buildsystem/AbsolutePath;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Companion", "Handler", "aiplugin.android.gradle"})
public final class GetGradleArtifactFromFile
implements Tool<AbsolutePath> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "get_gradle_artifact_from_file";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull AbsolutePath args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull AbsolutePath args) {
        return Tool.super.getDisplayText(args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull AbsolutePath args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile$Companion;", "", "<init>", "()V", "NAME", "", "aiplugin.android.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/android/studio/ml/gradle/buildsystem/AbsolutePath;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/android/studio/ml/gradle/buildsystem/AbsolutePath;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.android.gradle"})
    @SourceDebugExtension(value={"SMAP\nGetGradleArtifactFromFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetGradleArtifactFromFile.kt\ncom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile$Handler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n3829#2:278\n4344#2,2:279\n11158#2:281\n11493#2,3:282\n295#3,2:285\n*S KotlinDebug\n*F\n+ 1 GetGradleArtifactFromFile.kt\ncom/android/studio/ml/gradle/buildsystem/GetGradleArtifactFromFile$Handler\n*L\n120#1:278\n120#1:279,2\n203#1:281\n203#1:282,3\n203#1:285,2\n*E\n"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final AbsolutePath args;

        public Handler(@NotNull ToolContext context2, @NotNull AbsolutePath args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            File file = new File(this.args.getAbsolutePath());
            if (!file.exists()) {
                return new Response(null, "File does not exist", Response.ToolExecutionStatus.ERR_FILE_NOT_FOUND, 1, null);
            }
            return CoroutinesKt.readAction(() -> Handler.handle$lambda$7(this, file), $completion);
        }

        private static final Unit handle$lambda$7$lambda$1(List $matchingArtifacts, IdeProjectPath $projectCoordinates, String $syncedVariantName, String sourceType) {
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            $matchingArtifacts.add(GetGradleArtifactFromFileKt.access$artifactWithSourceDirToJson($projectCoordinates.getProjectPath(), $syncedVariantName, "main_artifact", sourceType));
            return Unit.INSTANCE;
        }

        private static final Unit handle$lambda$7$lambda$2(List $matchingArtifacts, IdeProjectPath $projectCoordinates, String $syncedVariantName, String sourceType) {
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            $matchingArtifacts.add(GetGradleArtifactFromFileKt.access$artifactWithSourceDirToJson($projectCoordinates.getProjectPath(), $syncedVariantName, "unit_test_artifact", sourceType));
            return Unit.INSTANCE;
        }

        private static final Unit handle$lambda$7$lambda$3(List $matchingArtifacts, IdeProjectPath $projectCoordinates, String $syncedVariantName, String sourceType) {
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            $matchingArtifacts.add(GetGradleArtifactFromFileKt.access$artifactWithSourceDirToJson($projectCoordinates.getProjectPath(), $syncedVariantName, "android_test_artifact", sourceType));
            return Unit.INSTANCE;
        }

        private static final Unit handle$lambda$7$lambda$4(List $matchingArtifacts, IdeProjectPath $projectCoordinates, String $syncedVariantName, String sourceType) {
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            $matchingArtifacts.add(GetGradleArtifactFromFileKt.access$artifactWithSourceDirToJson($projectCoordinates.getProjectPath(), $syncedVariantName, "test_fixtures_artifact", sourceType));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Response handle$lambda$7(Handler this$0, File $file) {
            String gradlePath;
            void $this$filterTo$iv$iv;
            Project project2 = this$0.context.getProject();
            AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)project2);
            if (!projectSystem.isAndroidProject()) {
                return GradleToolsUtilsKt.errorNotAndroid();
            }
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(project2);
            Module[] modules = moduleManager.getModules();
            if (modules.length == 0) {
                return GradleToolsUtilsKt.errorNoModules();
            }
            Map allModules = MapsKt.toMutableMap(GradleToolsUtilsKt.buildModulesMap(project2));
            Module[] $this$filter$iv = modules;
            boolean bl = false;
            Module[] moduleArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (List element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl2 = false;
                if (!(LinkedAndroidModuleGroupUtilsKt.isLinkedAndroidModule((Module)it) && LinkedAndroidModuleGroupUtilsKt.isHolderModule((Module)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List holderModules = (List)destination$iv$iv;
            for (Module module2 : holderModules) {
                GradleAndroidModel gradleModel;
                List element$iv$iv;
                ProgressManager.checkCanceled();
                gradlePath = ExternalSystemModulePropertyManager.Companion.getInstance(module2).getLinkedProjectId();
                TypeIntrinsics.asMutableMap((Object)allModules).remove(gradlePath);
                ProgressManager.checkCanceled();
                if (GradleAndroidModel.Companion.get(module2) == null) continue;
                IdeProjectPath projectCoordinates = gradleModel.getAndroidProject().getProjectPath();
                String syncedVariantName = gradleModel.getSelectedVariant().getName();
                List matchingArtifacts = new ArrayList();
                GetGradleArtifactFromFileKt.access$checkForFile(gradleModel.getActiveSourceProviders(), $file, arg_0 -> Handler.handle$lambda$7$lambda$1(matchingArtifacts, projectCoordinates, syncedVariantName, arg_0));
                List list = (List)gradleModel.getHostTestSourceProviders().get(CommonTestType.HostTest.UNIT_TEST);
                if (list != null) {
                    GetGradleArtifactFromFileKt.access$checkForFile(list, $file, arg_0 -> Handler.handle$lambda$7$lambda$2(matchingArtifacts, projectCoordinates, syncedVariantName, arg_0));
                }
                element$iv$iv = (List)gradleModel.getDeviceTestSourceProviders().get(CommonTestType.DeviceTest.ANDROID_TEST);
                if (element$iv$iv != null) {
                    GetGradleArtifactFromFileKt.access$checkForFile(element$iv$iv, $file, arg_0 -> Handler.handle$lambda$7$lambda$3(matchingArtifacts, projectCoordinates, syncedVariantName, arg_0));
                }
                GetGradleArtifactFromFileKt.access$checkForFile(gradleModel.getTestFixturesSourceProviders(), $file, arg_0 -> Handler.handle$lambda$7$lambda$4(matchingArtifacts, projectCoordinates, syncedVariantName, arg_0));
                if (!(!((Collection)matchingArtifacts).isEmpty())) continue;
                String jsonArray = CollectionsKt.joinToString$default((Iterable)matchingArtifacts, (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
                return new Response(jsonArray, null, null, 6, null);
            }
            for (Map.Entry entry : allModules.entrySet()) {
                gradlePath = (String)entry.getKey();
                ProjectData projectData = (ProjectData)entry.getValue();
                for (SourceSetModuleData sourceSetModule : projectData.getSourcesetModules()) {
                    Path matchFolder;
                    Object v1;
                    block10: {
                        void $this$firstOrNull$iv;
                        void $this$mapTo$iv$iv;
                        VirtualFile[] sourceRoots;
                        Object $this$map$iv = sourceRoots = ProjectRootsUtilKt.getSourceRoots((Module)sourceSetModule.getModule());
                        boolean $i$f$map = false;
                        VirtualFile[] virtualFileArray = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(((VirtualFile[])$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        int n = ((void)$this$mapTo$iv$iv).length;
                        for (int j = 0; j < n; ++j) {
                            void it;
                            void item$iv$iv;
                            void var24_33 = item$iv$iv = $this$mapTo$iv$iv[j];
                            Collection collection = destination$iv$iv2;
                            boolean bl3 = false;
                            collection.add(it.toNioPath());
                        }
                        $this$map$iv = (List)destination$iv$iv2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Path it = (Path)element$iv;
                            boolean bl4 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!GetGradleArtifactFromFileKt.access$containsFile(it, $file)) continue;
                            v1 = element$iv;
                            break block10;
                        }
                        v1 = null;
                    }
                    if ((matchFolder = (Path)v1) == null) continue;
                    return new Response("[" + GetGradleArtifactFromFileKt.access$artifactWithSourceDirToJson(gradlePath, null, sourceSetModule.getType(), CollectionsKt.last((Iterable)matchFolder).toString()) + "]", null, null, 6, null);
                }
            }
            return new Response(null, "file not in project", Response.ToolExecutionStatus.ERR_FILE_NOT_IN_PROJECT, 1, null);
        }
    }
}

