/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.experimental;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ErrorHandler;
import com.android.studio.ml.ModelError;
import com.android.studio.ml.SmlBundle;
import com.android.tools.idea.studiobot.Status;
import com.android.tools.idea.studiobot.StatusRuntimeException;
import com.intellij.openapi.actionSystem.AnAction;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/studio/ml/experimental/GeminiErrorHandler;", "Lcom/android/studio/ml/ErrorHandler;", "()V", "convertExceptionToModelError", "Lcom/android/studio/ml/ModelError;", "t", "", "errorSource", "Lcom/android/studio/ml/ErrorHandler$ErrorSource;", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
public final class GeminiErrorHandler
implements ErrorHandler {
    public static final int $stable;

    @Override
    @NotNull
    public ModelError convertExceptionToModelError(@NotNull Throwable t, @NotNull ErrorHandler.ErrorSource errorSource) {
        ModelError modelError;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)((Object)errorSource), (String)"errorSource");
        if (t instanceof StatusRuntimeException) {
            switch (WhenMappings.$EnumSwitchMapping$0[((StatusRuntimeException)t).getStatus().ordinal()]) {
                case 1: {
                    modelError = ModelError.PermissionDenied.INSTANCE;
                    break;
                }
                case 2: {
                    String string = t.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    modelError = new ModelError.ServerSideRateLimit(string);
                    break;
                }
                case 3: {
                    ModelError.ClientSideRateLimit clientSideRateLimit;
                    if (t.getMessage() == null || Intrinsics.areEqual((Object)"CLIENT_SIDE_RATE_LIMIT", (Object)t.getMessage())) {
                        clientSideRateLimit = new ModelError.ClientSideRateLimit(null, null, 3, null);
                    } else {
                        String string = t.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        clientSideRateLimit = new ModelError.ClientSideRateLimit(null, string, 1, null);
                    }
                    modelError = clientSideRateLimit;
                    break;
                }
                case 4: {
                    modelError = ModelError.Unauthenticated.INSTANCE;
                    break;
                }
                case 5: {
                    modelError = new ModelError.Warning(SmlBundle.message("sml.studiobot.timeline.error.network.timeout.title", new Object[0]), SmlBundle.message("sml.studiobot.timeline.error.network.timeout.message", new Object[0]));
                    break;
                }
                default: {
                    Object[] objectArray = (Object[])t.getMessage();
                    String errorDetailedMessage = objectArray == null || StringsKt.isBlank((CharSequence)objectArray) || Intrinsics.areEqual((Object)t.getMessage(), (Object)((StatusRuntimeException)t).getStatus().name()) ? "" : "\n\n`" + t.getMessage() + "`";
                    objectArray = new Object[]{((StatusRuntimeException)t).getStatus().name(), errorDetailedMessage};
                    modelError = new ModelError.Network(SmlBundle.message("sml.studiobot.timeline.error.network.generic.title", new Object[0]), SmlBundle.message("sml.studiobot.timeline.error.network.generic.message", objectArray));
                    break;
                }
            }
        } else {
            modelError = new ModelError.Generic(t.getMessage());
        }
        ModelError modelError2 = modelError;
        return modelError2;
    }

    @Override
    @NotNull
    public List<AnAction> convertKeysToActions(@NotNull List<String> keys) {
        return ErrorHandler.super.convertKeysToActions(keys);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.PERMISSION_DENIED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RESOURCE_EXHAUSTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.CLIENT_SIDE_RATE_LIMIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.UNAUTHENTICATED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.DEADLINE_EXCEEDED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

