/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.device;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.sdklib.deviceprovisioner.DeviceProvisioner;
import com.android.sdklib.deviceprovisioner.DeviceTemplate;
import com.android.studio.ml.device.ListDevicesToolKt;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.google.aiplugin.agents.NoArgs;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.gson.Gson;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Lists the available Android devices", description="Shows all devices which are already connected, plus emulators and remote devices which can be made available using the connect_device tool.", examples={})
@ToolResult(description="Returns a JSON array containing descriptions of the connected and available devices. Some fields include: \n - id: the Device ID that can be used to identify the device to other tools, mostly for machine use\n - name: a human-readable name\n - adbSerialNumber: the token to use to identify the device to ADB\n - isConnected: if false, the connect_device tool must be used to activate the device before use\n - isRemote: if true, this device is rented from a device lab and likely costs money to use")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/studio/ml/device/ListDevicesTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/NoArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class ListDevicesTool
implements Tool<NoArgs> {
    @NotNull
    public static final ListDevicesTool INSTANCE = new ListDevicesTool();
    @NotNull
    private static final String name = "list_devices";
    public static final int $stable;

    private ListDevicesTool() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ToolHandler(context2){
            final /* synthetic */ ToolContext $context;
            {
                this.$context = $context;
            }

            /*
             * WARNING - void declaration
             */
            public Object handle(Continuation<? super Response> $completion) {
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                DeviceHandle it;
                void $this$filterTo$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                ComponentManager $this$service$iv = (ComponentManager)this.$context.getProject();
                boolean $i$f$service = false;
                Class<DeviceProvisionerService> serviceClass$iv = DeviceProvisionerService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                DeviceProvisioner deviceProvisioner = ((DeviceProvisionerService)object).getDeviceProvisioner();
                List devices2 = (List)deviceProvisioner.getDevices().getValue();
                Iterable $this$mapNotNull$iv = devices2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo22 = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    DeviceTemplate it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    DeviceHandle it2 = (DeviceHandle)element$iv$iv;
                    boolean bl2 = false;
                    if (it2.getSourceTemplate() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Set activeTemplates = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                List templates = CollectionsKt.minus((Iterable)((Iterable)deviceProvisioner.getTemplates().getValue()), (Iterable)activeTemplates);
                Iterable $this$filter$iv = devices2;
                boolean $i$f$filter = false;
                Iterable $i$f$mapNotNullTo22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (DeviceHandle)element$iv$iv;
                    boolean bl = false;
                    if (!ListDevicesToolKt.access$isUsable(it)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (DeviceHandle)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(ListDevicesToolKt.access$toListDevicesOutput(it));
                }
                $this$map$iv = templates;
                collection = (List)destination$iv$iv2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (DeviceTemplate)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl = false;
                    collection2.add(ListDevicesToolKt.access$toListDevicesOutput((DeviceTemplate)it));
                }
                List output = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
                return new Response(new Gson().toJson((Object)output), null, null, 6, null);
            }
        };
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull NoArgs args) {
        return Tool.super.getDisplayText(args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull NoArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }
}

