/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.transform;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u000e\n\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0002"}, d2={"PREAMBLE", "", "aiplugin.android"})
public final class GenerateComposeSampleDataActionKt {
    @NotNull
    private static final String PREAMBLE = "\nYou can inject sample data for Composables, so the previews don't render empty and use realistic information.\n\nFor example, if you have a `@Composable` that takes as input user information like this:\n\n```\n@Composable\nfun UserProfile(user: User) {\n    /** Code that renders a user profile */\n}\n```\n\nYou can generate multiple previews of this by annotating the parameter with `@PreviewParameter`. For the example above, the code would look like:\n\n```\n@Preview\n@Composable\nfun UserProfile(\n    @PreviewParameter(UserPreviewParameterProvider::class) user: User\n) {\n    /** Code that renders a user profile */\n}\n\nclass UserPreviewParameterProvider : PreviewParameterProvider<User> {\n    override val values = sequenceOf(\n        User(name = \"John\", surname = \"Doe\", age = 20),\n        User(name = \"Jane\", surname = \"Doe\", age = 30),\n    )\n}\n```\n\nAs a result, multiple previews corresponding to the Composable `UserProfile` will be generated, one per `User` returned as a value from `UserPreviewParameterProvider`.\n\nConsidering this context, generate a `PreviewParameterProvider` with 3 or more pieces of sample data for the following Composable.\nUse real world values, not placeholders. Remember to add a `@Preview` or multi-preview annotation to the Composable.\nAlso remember to add the `@PreviewParameter` annotation to the function parameter.\n";
}

