/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents.tools;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.designer.compose.preview.ComposePreviewActionContext;
import com.android.studio.ml.designer.compose.preview.agents.tools.VisualLintToolHandler;
import com.google.aiplugin.agents.NoArgs;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Returns a list of Accessibility, Color Contrast, Typography and form factor issues of the Compose preview", description="Use this tool to identify Accessibility, Color Contrast, Typography and form factor issues with a Compose Preview", examples={})
@ToolResult(description="Output: returns a list of issues:\n- Empty list: no issues has been detected\n- Returns error if no Previews has been found in the input or if the Preview fails to render.\n- A list of type List<VisualLintRenderIssue> if UI issues has been detected.\n\nThe UI issues can be of type:\n- Accessibility\n- Color contrast\n- Typography\n- Adaptive and layout issues with many different form factors.\n")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/tools/VisualLintServiceTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/NoArgs;", "composePreviewActionContext", "Lcom/android/studio/ml/designer/compose/preview/ComposePreviewActionContext;", "<init>", "(Lcom/android/studio/ml/designer/compose/preview/ComposePreviewActionContext;)V", "name", "", "getName", "()Ljava/lang/String;", "getDisplayText", "args", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class VisualLintServiceTool
implements Tool<NoArgs> {
    @NotNull
    private final ComposePreviewActionContext composePreviewActionContext;
    public static final int $stable = 8;

    public VisualLintServiceTool(@NotNull ComposePreviewActionContext composePreviewActionContext) {
        Intrinsics.checkNotNullParameter((Object)composePreviewActionContext, (String)"composePreviewActionContext");
        this.composePreviewActionContext = composePreviewActionContext;
    }

    @Override
    @NotNull
    public String getName() {
        return "visual_lint_service_tool";
    }

    @Override
    @NotNull
    public String getDisplayText(@NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Check for UI issues in preview";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new VisualLintToolHandler(this.composePreviewActionContext, context2.getProject(), null, 4, null);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull NoArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }
}

