/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents.actions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.StudioGeminiBundle;
import com.android.studio.ml.bot.ResponseMode;
import com.android.studio.ml.designer.compose.preview.BaseComposePreviewAction;
import com.android.studio.ml.designer.compose.preview.ComposePreviewActionContext;
import com.android.studio.ml.designer.compose.preview.agents.AgentInvokerImpl;
import com.android.studio.ml.designer.compose.preview.agents.actions.TransformPreviewBalloon;
import com.android.tools.adtui.actions.ActionEventPopupUtilsKt;
import com.android.tools.idea.studiobot.StudioBot;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import icons.SmlIcons;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/actions/TransformPreviewAction;", "Lcom/android/studio/ml/designer/compose/preview/BaseComposePreviewAction;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performAiAction", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class TransformPreviewAction
extends BaseComposePreviewAction {
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;

    public TransformPreviewAction() {
        super(StudioGeminiBundle.Companion.message("designer.action.transform.ui.with.gemini", new Object[0]), null, SmlIcons.Logo);
        Logger logger = Logger.getInstance(TransformPreviewAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (!e.getPresentation().isEnabledAndVisible()) {
            return;
        }
        Project project2 = e.getProject();
        e.getPresentation().setEnabled(project2 != null && StudioBot.Companion.getInstance().chat(project2).isReadyToReceiveQuery(ResponseMode.Agent));
    }

    @Override
    public void performAiAction(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            throw new IllegalStateException("Project is null.".toString());
        }
        Project project3 = project2;
        if (!this.checkIfPreviewAttachingAllowed(project3)) {
            this.logger.info("Preview attachment is not allowed");
            return;
        }
        Object object = this.getComposePreviewActionContext-IoAF18A(e);
        ResultKt.throwOnFailure((Object)object);
        ComposePreviewActionContext context2 = (ComposePreviewActionContext)object;
        CoroutineScope scope2 = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault()));
        AgentInvokerImpl agentInvoker = new AgentInvokerImpl(project3, context2);
        TransformPreviewBalloon dialog2 = new TransformPreviewBalloon(project3, scope2, agentInvoker);
        dialog2.showBalloon(ActionEventPopupUtilsKt.locationFromEvent((AnActionEvent)e));
    }
}

