/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.designer.compose.preview.agents;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.StudioGeminiBundle;
import com.android.studio.ml.bot.BotToolWindowService;
import com.android.studio.ml.designer.compose.preview.ComposePreviewActionContext;
import com.android.studio.ml.designer.compose.preview.UtilsKt;
import com.android.studio.ml.designer.compose.preview.agents.AgentInvoker;
import com.android.studio.ml.designer.compose.preview.agents.AlignUiToTargetImageAgent;
import com.android.studio.ml.designer.compose.preview.agents.TransformPreviewAgent;
import com.android.studio.ml.util.Blob;
import com.google.aiplugin.agents.ToolsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/designer/compose/preview/agents/AgentInvokerImpl;", "Lcom/android/studio/ml/designer/compose/preview/agents/AgentInvoker;", "project", "Lcom/intellij/openapi/project/Project;", "previewContext", "Lcom/android/studio/ml/designer/compose/preview/ComposePreviewActionContext;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/studio/ml/designer/compose/preview/ComposePreviewActionContext;)V", "invokeAlignUiToTargetImageAgent", "", "targetImage", "Lcom/android/studio/ml/util/Blob;", "invokeTransformPreviewAgent", "userQuery", "", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class AgentInvokerImpl
implements AgentInvoker {
    @NotNull
    private final Project project;
    @NotNull
    private final ComposePreviewActionContext previewContext;
    public static final int $stable = 8;

    public AgentInvokerImpl(@NotNull Project project2, @NotNull ComposePreviewActionContext previewContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewContext, (String)"previewContext");
        this.project = project2;
        this.previewContext = previewContext;
    }

    @Override
    public void invokeAlignUiToTargetImageAgent(@NotNull Blob targetImage) {
        Intrinsics.checkNotNullParameter((Object)targetImage, (String)"targetImage");
        Blob blob = UtilsKt.toBlob(this.previewContext.getImage());
        VirtualFile virtualFile2 = this.previewContext.getFilePointer().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        AlignUiToTargetImageAgent agent2 = new AlignUiToTargetImageAgent(blob, virtualFile2, targetImage, ToolsProvider.Companion.getTools(this.project));
        BotToolWindowService botToolWindowService = BotToolWindowService.Companion.getInstance(this.project);
        String string = StudioGeminiBundle.Companion.message("designer.action.align.ui.to.image", new Object[0]);
        List list = CollectionsKt.listOf((Object)targetImage);
        String string2 = StudioGeminiBundle.Companion.message("designer.action.align.ui.to.image", new Object[0]);
        botToolWindowService.runAgentOnPinnedSession(agent2, string, string2, list);
    }

    @Override
    public void invokeTransformPreviewAgent(@NotNull String userQuery) {
        Intrinsics.checkNotNullParameter((Object)userQuery, (String)"userQuery");
        TransformPreviewAgent transformAgent = new TransformPreviewAgent(this.project, this.previewContext, userQuery, ToolsProvider.Companion.getTools(this.project));
        BotToolWindowService botToolWindowService = BotToolWindowService.Companion.getInstance(this.project);
        Object object = new Object[]{userQuery};
        String string = StudioGeminiBundle.Companion.message("designer.action.transform.ui.with.gemini.agent.title", object);
        object = CollectionsKt.listOf((Object)UtilsKt.toBlob(this.previewContext.getImage()));
        Object[] objectArray = new Object[]{userQuery};
        String string2 = StudioGeminiBundle.Companion.message("designer.action.transform.ui.with.gemini.agent.title", objectArray);
        botToolWindowService.runAgentOnPinnedSession(transformAgent, string, string2, (List<Blob>)object);
    }
}

