/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.timeline.messages;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.SpanStyle;
import com.android.studio.ml.bot.ui.compose.timeline.messages.DiffRenderOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004\u00a8\u0006\f"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/messages/DiffParser;", "", "()V", "buildFinalAnnotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "contentToRender", "", "createDiffLine", "annotatedLine", "parseDiffContent", "Lcom/android/studio/ml/bot/ui/compose/timeline/messages/DiffRenderOutput;", "highlightedContent", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nDiffCodeBlockRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffCodeBlockRenderer.kt\ncom/android/studio/ml/bot/ui/compose/timeline/messages/DiffParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,499:1\n1863#2,2:500\n1863#2,2:503\n1872#2,2:506\n1863#2,2:508\n1874#2:510\n1565#3:502\n1565#3:505\n*S KotlinDebug\n*F\n+ 1 DiffCodeBlockRenderer.kt\ncom/android/studio/ml/bot/ui/compose/timeline/messages/DiffParser\n*L\n117#1:500,2\n167#1:503,2\n190#1:506,2\n195#1:508,2\n190#1:510\n162#1:502\n187#1:505\n*E\n"})
public final class DiffParser {
    @NotNull
    public static final DiffParser INSTANCE = new DiffParser();
    public static final int $stable;

    private DiffParser() {
    }

    @NotNull
    public final DiffRenderOutput parseDiffContent(@NotNull AnnotatedString highlightedContent) {
        Intrinsics.checkNotNullParameter((Object)highlightedContent, (String)"highlightedContent");
        List inserted = new ArrayList();
        List deleted = new ArrayList();
        List hidden = new ArrayList();
        List contentToRender = new ArrayList();
        List lines = StringsKt.lines((CharSequence)highlightedContent.getText());
        int currentOffset = 0;
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            int endOffset = currentOffset + line.length();
            AnnotatedString annotatedLine = highlightedContent.subSequence(currentOffset, RangesKt.coerceAtMost((int)endOffset, (int)highlightedContent.length()));
            currentOffset = endOffset + 1;
            if (StringsKt.startsWith$default((String)line, (String)"--- ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"+++ ", (boolean)false, (int)2, null)) continue;
            if (StringsKt.startsWith$default((String)line, (String)"@@", (boolean)false, (int)2, null)) {
                if (!(!((Collection)contentToRender).isEmpty())) continue;
                hidden.add(contentToRender.size());
                contentToRender.add(new AnnotatedString(" ", null, 2, null));
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"+", (boolean)false, (int)2, null)) {
                inserted.add(contentToRender.size());
                contentToRender.add(INSTANCE.createDiffLine(annotatedLine));
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"-", (boolean)false, (int)2, null)) {
                deleted.add(contentToRender.size());
                contentToRender.add(INSTANCE.createDiffLine(annotatedLine));
                continue;
            }
            contentToRender.add(annotatedLine);
        }
        AnnotatedString text2 = this.buildFinalAnnotatedString(contentToRender);
        return new DiffRenderOutput(text2, inserted, deleted, hidden);
    }

    private final AnnotatedString createDiffLine(AnnotatedString annotatedLine) {
        AnnotatedString.Builder builder;
        boolean $i$f$buildAnnotatedString = false;
        AnnotatedString.Builder $this$createDiffLine_u24lambda_u242 = builder = new AnnotatedString.Builder(0, 1, null);
        boolean bl = false;
        $this$createDiffLine_u24lambda_u242.append(" ");
        if (annotatedLine.length() > 1) {
            AnnotatedString lineContent = annotatedLine.subSequence(1, annotatedLine.length());
            Iterable $this$forEach$iv = lineContent.getSpanStyles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotatedString.Range spanStyle = (AnnotatedString.Range)element$iv;
                boolean bl2 = false;
                $this$createDiffLine_u24lambda_u242.addStyle((SpanStyle)spanStyle.getItem(), spanStyle.getStart() + 1, spanStyle.getEnd() + 1);
            }
            $this$createDiffLine_u24lambda_u242.append(lineContent.getText());
        }
        return builder.toAnnotatedString();
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotatedString buildFinalAnnotatedString(List<AnnotatedString> contentToRender) {
        AnnotatedString.Builder builder;
        boolean $i$f$buildAnnotatedString = false;
        AnnotatedString.Builder $this$buildFinalAnnotatedString_u24lambda_u245 = builder = new AnnotatedString.Builder(0, 1, null);
        boolean bl = false;
        int currentTextOffset = 0;
        Iterable $this$forEachIndexed$iv = contentToRender;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void annotatedLine;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AnnotatedString annotatedString = (AnnotatedString)item$iv;
            int index = n;
            boolean bl2 = false;
            $this$buildFinalAnnotatedString_u24lambda_u245.append(annotatedLine.getText());
            Iterable $this$forEach$iv = annotatedLine.getSpanStyles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotatedString.Range spanStyle = (AnnotatedString.Range)element$iv;
                boolean bl3 = false;
                $this$buildFinalAnnotatedString_u24lambda_u245.addStyle((SpanStyle)spanStyle.getItem(), currentTextOffset + spanStyle.getStart(), currentTextOffset + spanStyle.getEnd());
            }
            currentTextOffset += annotatedLine.length();
            if (index >= CollectionsKt.getLastIndex(contentToRender)) continue;
            $this$buildFinalAnnotatedString_u24lambda_u245.append('\n');
            ++currentTextOffset;
        }
        return builder.toAnnotatedString();
    }
}

