/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.timeline.agent.experimental.changesdrawer;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import androidx.compose.runtime.snapshots.SnapshotStateMap;
import com.android.studio.ml.bot.ui.compose.timeline.agent.experimental.changesdrawer.AgentChangesDrawerState;
import com.android.studio.ml.bot.ui.compose.timeline.agent.experimental.changesdrawer.InlineDiffsKt;
import com.android.studio.ml.suggestion.AnchoredDiffChunk;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.session.SuggestionControlSession;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\u0016J\u0006\u0010\u001a\u001a\u00020\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007H\u0003J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007H\u0003J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0016J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\"\u001a\u00020\u0016J\u000e\u0010#\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007J\u0014\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&J\b\u0010'\u001a\u00020\u0016H\u0002J\b\u0010(\u001a\u00020\u0016H\u0002J\b\u0010)\u001a\u00020\u0016H\u0002J\b\u0010*\u001a\u0004\u0018\u00010+R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "changes", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "Lcom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState$AgentChange;", "getChanges", "()Landroidx/compose/runtime/snapshots/SnapshotStateList;", "inlineDiffSessions", "Landroidx/compose/runtime/snapshots/SnapshotStateMap;", "Lcom/android/studio/ml/suggestion/session/SuggestionControlSession;", "getInlineDiffSessions", "()Landroidx/compose/runtime/snapshots/SnapshotStateMap;", "listenerDisposable", "Lcom/intellij/openapi/Disposable;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "getProject", "()Lcom/intellij/openapi/project/Project;", "acceptAllChanges", "", "acceptChange", "change", "cancelDiffSessions", "clear", "clearDecidedChanges", "openFileForChange", "openInlineDiff", "openSideBySideDiff", "removeChange", "reviewAllChanges", "reviewChange", "rollbackAllChanges", "rollbackChange", "setChanges", "newChanges", "", "showDiffsForOpenFiles", "startFileChangeListener", "startOpenFileListener", "summarizeForPrompt", "", "AgentChange", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAgentChangesDrawerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentChangesDrawerState.kt\ncom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1#2:356\n216#3,2:357\n1062#4:359\n1557#4:360\n1628#4,3:361\n*S KotlinDebug\n*F\n+ 1 AgentChangesDrawerState.kt\ncom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState\n*L\n77#1:357,2\n116#1:359\n209#1:360\n209#1:361,3\n*E\n"})
public final class AgentChangesDrawerState {
    @NotNull
    private final Project project;
    @NotNull
    private final SnapshotStateList<AgentChange> changes;
    @NotNull
    private final SnapshotStateMap<AgentChange, SuggestionControlSession> inlineDiffSessions;
    @Nullable
    private MessageBusConnection messageBusConnection;
    @Nullable
    private Disposable listenerDisposable;
    public static final int $stable = 8;

    public AgentChangesDrawerState(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.changes = SnapshotStateKt.mutableStateListOf();
        this.inlineDiffSessions = SnapshotStateKt.mutableStateMapOf();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final SnapshotStateList<AgentChange> getChanges() {
        return this.changes;
    }

    @NotNull
    public final SnapshotStateMap<AgentChange, SuggestionControlSession> getInlineDiffSessions() {
        return this.inlineDiffSessions;
    }

    public final void setChanges(@NotNull List<AgentChange> newChanges) {
        Intrinsics.checkNotNullParameter(newChanges, (String)"newChanges");
        this.changes.clear();
        this.changes.addAll((Collection)newChanges);
        this.showDiffsForOpenFiles();
        this.startOpenFileListener();
        this.startFileChangeListener();
    }

    public final void clear() {
        block1: {
            this.changes.clear();
            this.inlineDiffSessions.clear();
            Disposable disposable = this.listenerDisposable;
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            MessageBusConnection messageBusConnection = this.messageBusConnection;
            if (messageBusConnection == null) break block1;
            messageBusConnection.disconnect();
        }
    }

    public final void clearDecidedChanges() {
        CollectionsKt.removeAll((List)((List)this.changes), (Function1)clearDecidedChanges.1.INSTANCE);
    }

    public final void removeChange(@NotNull AgentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        SuggestionControlSession suggestionControlSession = (SuggestionControlSession)this.inlineDiffSessions.get((Object)change);
        if (suggestionControlSession != null) {
            SuggestionControlSession it = suggestionControlSession;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.inlineDiffSessions.remove((Object)change);
        this.changes.remove((Object)change);
    }

    public final void cancelDiffSessions() {
        Map $this$forEach$iv = (Map)this.inlineDiffSessions;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it.getValue()));
        }
        this.inlineDiffSessions.clear();
    }

    public final void reviewAllChanges() {
        for (AgentChange change : this.changes.toList()) {
            this.reviewChange(change);
        }
    }

    public final void reviewChange(@NotNull AgentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        change.updateChunks();
        if (!((Map)change.getProposedChunks()).isEmpty()) {
            this.openFileForChange(change);
        } else {
            this.openSideBySideDiff(change);
        }
    }

    public final void acceptAllChanges() {
        List allChanges = this.changes.toList();
        for (AgentChange change : allChanges) {
            this.acceptChange(change);
        }
    }

    public final void acceptChange(@NotNull AgentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        change.setStatus(AgentChange.Status.ACCEPTED);
        SuggestionControlSession suggestionControlSession = (SuggestionControlSession)this.inlineDiffSessions.get((Object)change);
        if (suggestionControlSession != null) {
            SuggestionControlSession it = suggestionControlSession;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.inlineDiffSessions.remove((Object)change);
        this.changes.remove((Object)change);
    }

    public final void rollbackChange(@NotNull AgentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        change.updateChunks();
        Document document = VirtualFileUtil.findDocument((VirtualFile)change.getFile());
        if (document == null) {
            return;
        }
        Document document2 = document;
        Iterable $this$sortedByDescending$iv = change.getProposedChunks().keySet();
        boolean $i$f$sortedByDescending = false;
        for (AnchoredDiffChunk chunk : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AnchoredDiffChunk it = (AnchoredDiffChunk)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getRangeMarker().getTextRange().getStartOffset());
                it = (AnchoredDiffChunk)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRangeMarker().getTextRange().getStartOffset()));
            }
        })) {
            InlineDiffsKt.revertCommittedChange(chunk, document2, this.project);
        }
        change.setStatus(AgentChange.Status.REJECTED);
        this.removeChange(change);
    }

    public final void rollbackAllChanges() {
        List allChanges = this.changes.toList();
        for (AgentChange change : allChanges) {
            this.rollbackChange(change);
        }
    }

    private final void startOpenFileListener() {
        MessageBusConnection messageBusConnection;
        MessageBusConnection it = messageBusConnection = this.project.getMessageBus().connect();
        boolean bl = false;
        MessageBusConnection messageBusConnection2 = this.messageBusConnection;
        if (messageBusConnection2 != null) {
            messageBusConnection2.disconnect();
        }
        this.messageBusConnection = it;
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ AgentChangesDrawerState this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                Object v0;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Iterable $this$singleOrNull$iv = (Iterable)this.this$0.getChanges();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        AgentChange it = (AgentChange)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getFile(), (Object)file)) continue;
                        if (found$iv) {
                            v0 = null;
                            break block3;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v0 = !found$iv ? null : single$iv;
                }
                AgentChange agentChange = v0;
                if (agentChange == null) {
                    return;
                }
                AgentChange change = agentChange;
                AgentChangesDrawerState.access$openInlineDiff(this.this$0, change);
            }
        });
    }

    private final void startFileChangeListener() {
        Disposable disposable = this.listenerDisposable;
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.listenerDisposable = Disposer.newDisposable();
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        DocumentListener documentListener2 = new DocumentListener(this){
            final /* synthetic */ AgentChangesDrawerState this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Object v0;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
                    Iterable $this$singleOrNull$iv = (Iterable)this.this$0.getChanges();
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        AgentChange it = (AgentChange)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getFile(), (Object)file)) continue;
                        if (found$iv) {
                            v0 = null;
                            break block4;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v0 = !found$iv ? null : single$iv;
                }
                AgentChange agentChange = v0;
                if (agentChange == null) {
                    return;
                }
                AgentChange change = agentChange;
                change.updateChunks();
                if (change.getProposedChunks().isEmpty()) {
                    this.this$0.removeChange(change);
                }
            }
        };
        Disposable disposable2 = this.listenerDisposable;
        Intrinsics.checkNotNull((Object)disposable2);
        editorEventMulticaster.addDocumentListener(documentListener2, disposable2);
    }

    private final void showDiffsForOpenFiles() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        for (AgentChange change : this.changes.toList()) {
            if (!fileEditorManager.isFileOpen(change.getFile())) continue;
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> AgentChangesDrawerState.showDiffsForOpenFiles$lambda$7(this, change));
        }
    }

    @RequiresEdt
    private final void openFileForChange(AgentChange change) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> AgentChangesDrawerState.openFileForChange$lambda$8(this, change));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void openInlineDiff(AgentChange change) {
        void $this$mapTo$iv$iv;
        if (change.getStatus() != AgentChange.Status.UNDECIDED) {
            return;
        }
        change.updateChunks();
        SuggestionControlSession currentSession = (SuggestionControlSession)this.inlineDiffSessions.get((Object)change);
        if (currentSession != null) {
            EditorSuggestionControl editorSuggestionControl = currentSession.getActiveControl();
            if (editorSuggestionControl != null) {
                editorSuggestionControl.isVisible();
            }
            EditorSuggestionControl editorSuggestionControl2 = currentSession.getActiveControl();
            boolean bl = editorSuggestionControl2 != null ? editorSuggestionControl2.isVisible() : false;
            if (bl) {
                return;
            }
            Disposer.dispose((Disposable)currentSession);
        }
        Document document = VirtualFileUtil.findDocument((VirtualFile)change.getFile());
        if (document == null) {
            return;
        }
        Document document2 = document;
        Iterable $this$map$iv = change.getProposedChunks().keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AnchoredDiffChunk anchoredDiffChunk = (AnchoredDiffChunk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TextRange textRange = it.getRangeMarker().getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            collection.add(AnchoredDiffChunk.Companion.forCommittedChange(document2, textRange, it.getOriginalContent()));
        }
        List anchoredDiffChunks = (List)destination$iv$iv;
        SuggestionControlSession suggestionControlSession = InlineDiffsKt.startSuggestionSessionAndGetListener(change.getFile(), anchoredDiffChunks, this.project, (Function1<? super AnchoredDiffChunk, Unit>)((Function1)new Function1<AnchoredDiffChunk, Unit>(change){
            final /* synthetic */ AgentChange $change;
            {
                this.$change = $change;
                super(1);
            }

            public final void invoke(AnchoredDiffChunk it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((Map)this.$change.getProposedChunks()).put(it, AgentChange.Status.ACCEPTED);
            }
        }), (Function1<? super AnchoredDiffChunk, Unit>)((Function1)new Function1<AnchoredDiffChunk, Unit>(change){
            final /* synthetic */ AgentChange $change;
            {
                this.$change = $change;
                super(1);
            }

            public final void invoke(AnchoredDiffChunk it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((Map)this.$change.getProposedChunks()).put(it, AgentChange.Status.REJECTED);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(change, this){
            final /* synthetic */ AgentChange $change;
            final /* synthetic */ AgentChangesDrawerState this$0;
            {
                this.$change = $change;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$change.setStatus(AgentChange.Status.ACCEPTED);
                this.this$0.removeChange(this.$change);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(change, this){
            final /* synthetic */ AgentChange $change;
            final /* synthetic */ AgentChangesDrawerState this$0;
            {
                this.$change = $change;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$change.setStatus(AgentChange.Status.REJECTED);
                this.$change.setRollbackAvailable(false);
                this.this$0.removeChange(this.$change);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(change, this){
            final /* synthetic */ AgentChange $change;
            final /* synthetic */ AgentChangesDrawerState this$0;
            {
                this.$change = $change;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$change.setStatus(AgentChange.Status.ALL_DECIDED);
                this.this$0.removeChange(this.$change);
            }
        }));
        if (suggestionControlSession == null) {
            return;
        }
        SuggestionControlSession result2 = suggestionControlSession;
        ((Map)this.inlineDiffSessions).put(change, result2);
    }

    public final void openSideBySideDiff(@NotNull AgentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)diffContentFactory, (String)"getInstance(...)");
        DiffContentFactory diffContentFactory2 = diffContentFactory;
        DocumentContent documentContent = diffContentFactory2.create(this.project, change.getOldText(), change.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        DocumentContent left = documentContent;
        DocumentContent documentContent2 = diffContentFactory2.create(this.project, change.getNewText(), change.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)documentContent2, (String)"create(...)");
        DocumentContent right = documentContent2;
        SimpleDiffRequest diffRequest = new SimpleDiffRequest("Diff: " + change.getFile().getName(), (DiffContent)left, (DiffContent)right, "Before", "After");
        DiffManager.getInstance().showDiff(this.project, (DiffRequest)diffRequest);
    }

    @Nullable
    public final String summarizeForPrompt() {
        if (this.changes.isEmpty()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)this.changes.toList(), (CharSequence)"\n\n", null, null, (int)0, null, (Function1)summarizeForPrompt.1.INSTANCE, (int)30, null);
    }

    private static final void showDiffsForOpenFiles$lambda$7(AgentChangesDrawerState this$0, AgentChange $change) {
        this$0.openInlineDiff($change);
    }

    private static final void openFileForChange$lambda$8(AgentChangesDrawerState this$0, AgentChange $change) {
        FileEditorManager.getInstance((Project)this$0.project).openFile($change.getFile());
    }

    public static final /* synthetic */ void access$openInlineDiff(AgentChangesDrawerState $this, AgentChange change) {
        $this.openInlineDiff(change);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010'\u001a\u00020\u0005J\u0006\u0010(\u001a\u00020)J\f\u0010'\u001a\u00020\u0005*\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR+\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR+\u0010!\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00118F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010 \u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006+"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState$AgentChange;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "oldText", "", "newText", "relativePath", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getNewText", "()Ljava/lang/String;", "getOldText", "proposedChunks", "Landroidx/compose/runtime/snapshots/SnapshotStateMap;", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "Lcom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState$AgentChange$Status;", "getProposedChunks", "()Landroidx/compose/runtime/snapshots/SnapshotStateMap;", "rangeMarkers", "Lcom/intellij/openapi/editor/RangeMarker;", "getRangeMarkers", "getRelativePath", "<set-?>", "", "rollbackAvailable", "getRollbackAvailable", "()Z", "setRollbackAvailable", "(Z)V", "rollbackAvailable$delegate", "Landroidx/compose/runtime/MutableState;", "status", "getStatus", "()Lcom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState$AgentChange$Status;", "setStatus", "(Lcom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState$AgentChange$Status;)V", "status$delegate", "summarizeForPrompt", "updateChunks", "", "Status", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nAgentChangesDrawerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentChangesDrawerState.kt\ncom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState$AgentChange\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,355:1\n1279#2,2:356\n1293#2,4:358\n669#2,11:378\n1279#2,2:392\n1293#2,4:394\n774#2:401\n865#2,2:402\n1557#2:404\n1628#2,3:405\n774#2:408\n865#2,2:409\n1557#2:411\n1628#2,3:412\n85#3:362\n113#3,2:363\n85#3:365\n113#3,2:366\n136#4,9:368\n216#4:377\n217#4:390\n145#4:391\n554#4,3:398\n1#5:389\n*S KotlinDebug\n*F\n+ 1 AgentChangesDrawerState.kt\ncom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState$AgentChange\n*L\n299#1:356,2\n299#1:358,4\n277#1:378,11\n287#1:392,2\n287#1:394,4\n326#1:401\n326#1:402,2\n326#1:404\n326#1:405,3\n327#1:408\n327#1:409,2\n327#1:411\n327#1:412,3\n252#1:362\n252#1:363,2\n255#1:365\n255#1:366,2\n265#1:368,9\n265#1:377\n265#1:390\n265#1:391\n323#1:398,3\n265#1:389\n*E\n"})
    public static final class AgentChange {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final String oldText;
        @NotNull
        private final String newText;
        @NotNull
        private final String relativePath;
        @NotNull
        private final MutableState status$delegate;
        @NotNull
        private final SnapshotStateMap<AnchoredDiffChunk, Status> proposedChunks;
        @NotNull
        private final MutableState rollbackAvailable$delegate;
        @NotNull
        private final SnapshotStateMap<RangeMarker, String> rangeMarkers;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        public AgentChange(@NotNull VirtualFile file, @NotNull String oldText, @NotNull String newText, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            this.file = file;
            this.oldText = oldText;
            this.newText = newText;
            this.relativePath = relativePath;
            this.status$delegate = SnapshotStateKt.mutableStateOf$default((Object)((Object)Status.UNDECIDED), null, (int)2, null);
            this.proposedChunks = SnapshotStateKt.mutableStateMapOf();
            this.rollbackAvailable$delegate = SnapshotStateKt.mutableStateOf$default((Object)true, null, (int)2, null);
            this.rangeMarkers = SnapshotStateKt.mutableStateMapOf();
            Document document = VirtualFileUtil.findDocument((VirtualFile)this.file);
            if (document != null) {
                void $this$associateWith$iv;
                this.proposedChunks.clear();
                List<AnchoredDiffChunk> proposedSuggestions = InlineDiffsKt.getAnchoredDiffChunksForCommittedChange(document, this.oldText);
                Iterable iterable = proposedSuggestions;
                SnapshotStateMap<AnchoredDiffChunk, Status> snapshotStateMap = this.proposedChunks;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    AnchoredDiffChunk anchoredDiffChunk = (AnchoredDiffChunk)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map2 = result$iv;
                    boolean bl = false;
                    Status status2 = Status.UNDECIDED;
                    map2.put(t, status2);
                }
                snapshotStateMap.putAll((Map)result$iv);
                for (AnchoredDiffChunk suggestion : this.proposedChunks.keySet()) {
                    ((Map)this.rangeMarkers).put(suggestion.getRangeMarker(), suggestion.getOriginalContent());
                }
            }
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final String getOldText() {
            return this.oldText;
        }

        @NotNull
        public final String getNewText() {
            return this.newText;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Status getStatus() {
            void $this$getValue$iv;
            State state2 = (State)this.status$delegate;
            AgentChange agentChange = this;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (Status)((Object)$this$getValue$iv.getValue());
        }

        /*
         * WARNING - void declaration
         */
        public final void setStatus(@NotNull Status status2) {
            void $this$setValue$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"<set-?>");
            MutableState mutableState = this.status$delegate;
            AgentChange agentChange = this;
            Object var4_4 = null;
            Status value$iv = status2;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue((Object)value$iv);
        }

        @NotNull
        public final SnapshotStateMap<AnchoredDiffChunk, Status> getProposedChunks() {
            return this.proposedChunks;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean getRollbackAvailable() {
            void $this$getValue$iv;
            State state2 = (State)this.rollbackAvailable$delegate;
            AgentChange agentChange = this;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (Boolean)$this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public final void setRollbackAvailable(boolean bl) {
            void $this$setValue$iv;
            MutableState mutableState = this.rollbackAvailable$delegate;
            AgentChange agentChange = this;
            Object var4_4 = null;
            Boolean value$iv = bl;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue((Object)value$iv);
        }

        @NotNull
        public final SnapshotStateMap<RangeMarker, String> getRangeMarkers() {
            return this.rangeMarkers;
        }

        /*
         * WARNING - void declaration
         */
        public final void updateChunks() {
            Document document = VirtualFileUtil.findDocument((VirtualFile)this.file);
            if (document != null) {
                void $this$associateWith$iv;
                void $this$mapNotNullTo$iv$iv;
                Map currentChunkStatuses = this.proposedChunks.toMap();
                this.proposedChunks.clear();
                Object $this$mapNotNull$iv = this.rangeMarkers.toMap();
                boolean $i$f$mapNotNull = false;
                Map map2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (object.hasNext()) {
                    AnchoredDiffChunk anchoredDiffChunk;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl = false;
                    Map.Entry it = element$iv$iv;
                    boolean bl2 = false;
                    RangeMarker rangeMarker = (RangeMarker)it.getKey();
                    String oldText = (String)it.getValue();
                    if (!rangeMarker.isValid()) {
                        this.rangeMarkers.remove((Object)rangeMarker);
                        anchoredDiffChunk = null;
                    } else {
                        Object v1;
                        block10: {
                            Iterable $this$singleOrNull$iv = currentChunkStatuses.keySet();
                            boolean $i$f$singleOrNull = false;
                            Object single$iv = null;
                            boolean found$iv = false;
                            for (Object element$iv : $this$singleOrNull$iv) {
                                AnchoredDiffChunk chunk = (AnchoredDiffChunk)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)chunk.getRangeMarker().getTextRange(), (Object)rangeMarker.getTextRange())) continue;
                                if (found$iv) {
                                    v1 = null;
                                    break block10;
                                }
                                single$iv = element$iv;
                                found$iv = true;
                            }
                            v1 = !found$iv ? null : single$iv;
                        }
                        AnchoredDiffChunk matchingChunk = v1;
                        if (matchingChunk != null && currentChunkStatuses.get(matchingChunk) == Status.ACCEPTED) {
                            this.rangeMarkers.remove(it.getKey());
                            anchoredDiffChunk = null;
                        } else {
                            TextRange textRange = rangeMarker.getTextRange();
                            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                            anchoredDiffChunk = AnchoredDiffChunk.Companion.forCommittedChange(document, textRange, oldText);
                        }
                    }
                    if (anchoredDiffChunk == null) continue;
                    AnchoredDiffChunk it$iv$iv = anchoredDiffChunk;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List newChunks = (List)destination$iv$iv;
                $this$mapNotNull$iv = newChunks;
                SnapshotStateMap<AnchoredDiffChunk, Status> snapshotStateMap = this.proposedChunks;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    object = (AnchoredDiffChunk)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map3 = result$iv;
                    boolean bl = false;
                    Status status2 = Status.UNDECIDED;
                    map3.put(t, status2);
                }
                snapshotStateMap.putAll((Map)result$iv);
            }
            if (this.proposedChunks.isEmpty()) {
                this.setRollbackAvailable(false);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public final String summarizeForPrompt() {
            v0 = this.file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
            filename = v0;
            switch (WhenMappings.$EnumSwitchMapping$0[this.getStatus().ordinal()]) {
                case 1: {
                    v1 = "The change proposed to " + filename + " was accepted by the user.";
                    break;
                }
                case 2: {
                    v1 = "The change proposed to " + filename + " was rejected by the user and has been rolled back.";
                    break;
                }
                case 3: 
                case 4: {
                    $this$none$iv = chunks = this.proposedChunks.toMap();
                    $i$f$none = false;
                    if (!$this$none$iv.isEmpty()) ** GOTO lbl17
                    v2 = true;
                    ** GOTO lbl25
lbl17:
                    // 1 sources

                    var5_6 = $this$none$iv.entrySet().iterator();
                    while (var5_6.hasNext()) {
                        it = element$iv = var5_6.next();
                        $i$a$-none-AgentChangesDrawerState$AgentChange$summarizeForPrompt$1 = false;
                        if (!(it.getValue() == Status.REJECTED)) continue;
                        v2 = false;
                        ** GOTO lbl25
                    }
                    v2 = true;
lbl25:
                    // 3 sources

                    if (v2) {
                        v1 = "The change proposed to " + filename + " was accepted by the user.";
                        break;
                    }
                    $this$filter$iv = chunks.entrySet();
                    $i$f$filter = false;
                    element$iv = $this$filter$iv;
                    destination$iv$iv /* !! */  = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Map.Entry)element$iv$iv;
                        $i$a$-filter-AgentChangesDrawerState$AgentChange$summarizeForPrompt$rejected$1 = false;
                        if (!(it.getValue() == Status.REJECTED)) continue;
                        destination$iv$iv /* !! */ .add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv /* !! */ ;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Map.Entry)item$iv$iv;
                        var14_21 = destination$iv$iv /* !! */ ;
                        $i$a$-map-AgentChangesDrawerState$AgentChange$summarizeForPrompt$rejected$2 = false;
                        var14_21.add((AnchoredDiffChunk)it.getKey());
                    }
                    rejected = (List)destination$iv$iv /* !! */ ;
                    $this$filter$iv = chunks.entrySet();
                    $i$f$filter = false;
                    destination$iv$iv /* !! */  = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Map.Entry)element$iv$iv;
                        $i$a$-filter-AgentChangesDrawerState$AgentChange$summarizeForPrompt$accepted$1 = false;
                        if (!(it.getValue() != Status.REJECTED)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Map.Entry)item$iv$iv;
                        var14_21 = destination$iv$iv;
                        $i$a$-map-AgentChangesDrawerState$AgentChange$summarizeForPrompt$accepted$2 = false;
                        var14_21.add((AnchoredDiffChunk)it.getKey());
                    }
                    accepted = (List)destination$iv$iv;
                    v1 = StringsKt.trimIndent((String)("\n              Some of the changes proposed to " + filename + " were accepted by the user, but others were rejected and rolled back.\n\n              Accepted changes:\n              " + CollectionsKt.joinToString$default((Iterable)accepted, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<AnchoredDiffChunk, CharSequence>(this){
                        final /* synthetic */ AgentChange this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final CharSequence invoke(AnchoredDiffChunk it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return AgentChange.access$summarizeForPrompt(this.this$0, it);
                        }
                    }), (int)30, null) + "\n\n              Rejected (rolled-back) changes:\n              " + CollectionsKt.joinToString$default((Iterable)rejected, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<AnchoredDiffChunk, CharSequence>(this){
                        final /* synthetic */ AgentChange this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final CharSequence invoke(AnchoredDiffChunk it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return AgentChange.access$summarizeForPrompt(this.this$0, it);
                        }
                    }), (int)30, null) + "\n            "));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return v1;
        }

        private final String summarizeForPrompt(AnchoredDiffChunk $this$summarizeForPrompt) {
            return CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)$this$summarizeForPrompt.getOriginalContent()), (CharSequence)"\n", null, null, (int)0, null, (Function1)summarizeForPrompt.4.INSTANCE, (int)30, null) + "\n" + CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)$this$summarizeForPrompt.getNewContent()), (CharSequence)"\n", null, null, (int)0, null, (Function1)summarizeForPrompt.5.INSTANCE, (int)30, null);
        }

        public static final /* synthetic */ String access$summarizeForPrompt(AgentChange $this, AnchoredDiffChunk $receiver) {
            return $this.summarizeForPrompt($receiver);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/AgentChangesDrawerState$AgentChange$Status;", "", "(Ljava/lang/String;I)V", "UNDECIDED", "ACCEPTED", "REJECTED", "ALL_DECIDED", "aiplugin.core.aicore"})
        public static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status UNDECIDED = new Status();
            public static final /* enum */ Status ACCEPTED = new Status();
            public static final /* enum */ Status REJECTED = new Status();
            public static final /* enum */ Status ALL_DECIDED = new Status();
            private static final /* synthetic */ Status[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String value) {
                return Enum.valueOf(Status.class, value);
            }

            @NotNull
            public static EnumEntries<Status> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = statusArray = new Status[]{Status.UNDECIDED, Status.ACCEPTED, Status.REJECTED, Status.ALL_DECIDED};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Status.values().length];
                try {
                    nArray[Status.ACCEPTED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.REJECTED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.UNDECIDED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Status.ALL_DECIDED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

