/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.timeline;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.graphics.painter.BitmapPainter;
import androidx.compose.ui.graphics.painter.Painter;
import com.android.studio.ml.bot.ui.compose.LoadablePainter;
import com.android.studio.ml.bot.ui.compose.components.ProjectProvider;
import com.android.studio.ml.bot.ui.compose.timeline.Attachment;
import com.android.studio.ml.bot.ui.compose.timeline.AttachmentKt;
import com.android.studio.ml.bot.ui.compose.timeline.AttachmentLoaderKt;
import com.android.studio.ml.bot.ui.compose.timeline.ImageAttachment;
import com.android.studio.ml.bot.ui.compose.timeline.QueryBoxDragAndDropTarget;
import com.android.studio.ml.bot.ui.compose.timeline.messages.MessageClipboardKt;
import com.android.studio.ml.bot.ui.compose.timeline.querybox.QueryBoxController;
import com.android.studio.ml.bot.ui.compose.timeline.querybox.QueryBoxState;
import com.android.tools.idea.studiobot.MimeType;
import com.android.tools.idea.studiobot.mimetype.MimeTypeUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ImageUtil;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.compose.resources.ImageDecodersKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u001a\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\u0010\u000e\u001a\u001c\u0010\u000f\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\u0012\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u0004H\u0002\u001a\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"ALLOW_DROP_NON_IMAGE_FILES", "", "canDropOrPaste", "transferable", "Ljava/awt/datatransfer/Transferable;", "isTextFile", "file", "Ljava/io/File;", "rememberDragAndDropTarget", "Lcom/android/studio/ml/bot/ui/compose/timeline/QueryBoxDragAndDropTarget;", "queryBoxController", "Lcom/android/studio/ml/bot/ui/compose/timeline/querybox/QueryBoxController;", "projectProvider", "Lcom/android/studio/ml/bot/ui/compose/components/ProjectProvider;", "(Lcom/android/studio/ml/bot/ui/compose/timeline/querybox/QueryBoxController;Lcom/android/studio/ml/bot/ui/compose/components/ProjectProvider;Landroidx/compose/runtime/Composer;I)Lcom/android/studio/ml/bot/ui/compose/timeline/QueryBoxDragAndDropTarget;", "addAttachments", "Lcom/android/studio/ml/bot/ui/compose/timeline/querybox/QueryBoxState;", "containsSupportedFiles", "loadImageAttachments", "", "Lcom/android/studio/ml/bot/ui/compose/timeline/Attachment$InMemoryImage;", "toAttachmentOrNull", "Lcom/android/studio/ml/bot/ui/compose/timeline/Attachment;", "aiplugin.core.aicore"})
@SourceDebugExtension(value={"SMAP\nQueryBoxDropAndPasteHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryBoxDropAndPasteHelper.kt\ncom/android/studio/ml/bot/ui/compose/timeline/QueryBoxDropAndPasteHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1755#2,3:255\n1611#2,9:264\n1863#2:273\n1864#2:275\n1620#2:276\n1863#2,2:277\n1247#3,6:258\n1#4:274\n*S KotlinDebug\n*F\n+ 1 QueryBoxDropAndPasteHelper.kt\ncom/android/studio/ml/bot/ui/compose/timeline/QueryBoxDropAndPasteHelperKt\n*L\n70#1:255,3\n159#1:264,9\n159#1:273\n159#1:275\n159#1:276\n165#1:277,2\n91#1:258,6\n159#1:274\n*E\n"})
public final class QueryBoxDropAndPasteHelperKt {
    public static final boolean ALLOW_DROP_NON_IMAGE_FILES = false;

    public static final boolean canDropOrPaste(@NotNull Transferable transferable) {
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        return transferable.isDataFlavorSupported(DataFlavor.stringFlavor) || transferable.isDataFlavorSupported(MessageClipboardKt.getAnnotatedStringFlavor()) || transferable.isDataFlavorSupported(DataFlavor.imageFlavor) || QueryBoxDropAndPasteHelperKt.containsSupportedFiles(transferable);
    }

    private static final boolean containsSupportedFiles(Transferable $this$containsSupportedFiles) {
        boolean bl;
        if (!$this$containsSupportedFiles.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        try {
            boolean bl2;
            block6: {
                Object object = $this$containsSupportedFiles.getTransferData(DataFlavor.javaFileListFlavor);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
                List files = (List)object;
                Iterable $this$any$iv = files;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        File it = (File)element$iv;
                        boolean bl3 = false;
                        String mimeType = MimeTypeUtilsKt.fromExtension(MimeType.Companion, FilesKt.getExtension((File)it));
                        if (!(mimeType != null && ImageAttachment.SupportedImageTypes.INSTANCE.isSupportedImageMimeType-qru2Y28(mimeType))) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public static final QueryBoxDragAndDropTarget rememberDragAndDropTarget(@NotNull QueryBoxController queryBoxController, @NotNull ProjectProvider projectProvider, @Nullable Composer $composer, int $changed) {
        Object object;
        void $this$cache$iv;
        Intrinsics.checkNotNullParameter((Object)queryBoxController, (String)"queryBoxController");
        Intrinsics.checkNotNullParameter((Object)projectProvider, (String)"projectProvider");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1216273240, (int)$changed, (int)-1, (String)"com.android.studio.ml.bot.ui.compose.timeline.rememberDragAndDropTarget (QueryBoxDropAndPasteHelper.kt:90)");
        }
        Composer composer = $composer;
        boolean invalid$iv = (($changed & 0xE ^ 6) > 4 && $composer.changed((Object)queryBoxController) || ($changed & 6) == 4) | (($changed & 0x70 ^ 0x30) > 32 && $composer.changed((Object)projectProvider) || ($changed & 0x30) == 32);
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl = false;
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            boolean bl2 = false;
            QueryBoxDragAndDropTarget value$iv = new QueryBoxDragAndDropTarget(queryBoxController, projectProvider);
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        QueryBoxDragAndDropTarget queryBoxDragAndDropTarget = (QueryBoxDragAndDropTarget)object;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        return queryBoxDragAndDropTarget;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean addAttachments(@NotNull QueryBoxState $this$addAttachments, @NotNull Transferable transferable, @NotNull ProjectProvider projectProvider) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$addAttachments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        Intrinsics.checkNotNullParameter((Object)projectProvider, (String)"projectProvider");
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            void $this$mapNotNullTo$iv$iv;
            Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
            List files = (List)object;
            Iterable $this$mapNotNull$iv = files;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Attachment it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                if (QueryBoxDropAndPasteHelperKt.toAttachmentOrNull(it, projectProvider) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            list = QueryBoxDropAndPasteHelperKt.loadImageAttachments(transferable);
        } else {
            return false;
        }
        List attachments = list;
        Iterable $this$forEach$iv = attachments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attachment attachment = (Attachment)element$iv;
            boolean bl = false;
            if (!(attachment instanceof ImageAttachment)) continue;
            $this$addAttachments.getImageAttachments().add((Object)attachment);
        }
        return !((Collection)attachments).isEmpty();
    }

    private static final Attachment toAttachmentOrNull(File $this$toAttachmentOrNull, ProjectProvider projectProvider) {
        return (Attachment)ActionsKt.runReadAction((Function0)((Function0)new Function0<Attachment>($this$toAttachmentOrNull, projectProvider){
            final /* synthetic */ File $this_toAttachmentOrNull;
            final /* synthetic */ ProjectProvider $projectProvider;
            {
                this.$this_toAttachmentOrNull = $receiver;
                this.$projectProvider = $projectProvider;
                super(0);
            }

            public final Attachment invoke() {
                VirtualFile virtualFile2 = StandardFileSystems.local().findFileByPath(this.$this_toAttachmentOrNull.getPath());
                if (virtualFile2 != null) {
                    Project project2 = this.$projectProvider.getProject();
                    if (virtualFile2.isDirectory()) {
                        return AttachmentKt.toContextDrawerAttachment(virtualFile2, project2, null, true);
                    }
                    String string = MimeTypeUtilsKt.forVirtualFile(MimeType.Companion, project2, virtualFile2);
                    if (string == null) {
                        return null;
                    }
                    String mimeType = string;
                    if (ImageAttachment.SupportedImageTypes.INSTANCE.isSupportedImageMimeType-qru2Y28(mimeType)) {
                        Object path2;
                        try {
                            path2 = this.$this_toAttachmentOrNull.toPath();
                            Intrinsics.checkNotNull((Object)path2);
                            LoadablePainter.Loaded painter2 = AttachmentLoaderKt.loadPainterFrom((Path)path2);
                            path2 = new Attachment.Image((Path)path2, (State<? extends LoadablePainter>)((State)SnapshotStateKt.mutableStateOf$default((Object)painter2, null, (int)2, null)));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            path2 = null;
                        }
                        return (Attachment)path2;
                    }
                    boolean isTextFile = MimeTypeUtilsKt.isText-qru2Y28(mimeType) || QueryBoxDropAndPasteHelperKt.isTextFile(this.$this_toAttachmentOrNull);
                    return AttachmentKt.toContextDrawerAttachment(virtualFile2, project2, null, isTextFile);
                }
                return null;
            }
        }));
    }

    private static final List<Attachment.InMemoryImage> loadImageAttachments(Transferable $this$loadImageAttachments) {
        Object object = $this$loadImageAttachments.getTransferData(DataFlavor.imageFlavor);
        Image image = object instanceof Image ? (Image)object : null;
        if (image == null) {
            return CollectionsKt.emptyList();
        }
        Image image2 = image;
        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(...)");
        BufferedImage bufferedImage2 = bufferedImage;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage2, "png", stream);
        byte[] imageBytes = stream.toByteArray();
        String string = String.valueOf(imageBytes.hashCode());
        String string2 = MimeType.Companion.getPNG-i_3W7CY();
        Intrinsics.checkNotNull((Object)imageBytes);
        return CollectionsKt.listOf((Object)new Attachment.InMemoryImage(string, null, string2, (State)SnapshotStateKt.mutableStateOf$default((Object)new LoadablePainter.Loaded((Painter)new BitmapPainter(ImageDecodersKt.decodeToImageBitmap((byte[])imageBytes), 0L, 0L, 6, null), imageBytes), null, (int)2, null), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static final boolean isTextFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists() || !file.canRead()) {
            return false;
        }
        try {
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                byte[] buffer = new byte[(int)Math.min(1024L, file.length())];
                int bytesRead = it.read(buffer);
                if (bytesRead > 0) {
                    for (int i2 = 0; i2 < bytesRead; ++i2) {
                        if (buffer[i2] != 0) continue;
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

