/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.timeline;

import com.android.studio.ml.bot.ui.compose.timeline.PathInString;
import com.android.studio.ml.util.FileUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a*\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\n\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a(\u0010\n\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"findNextPath", "Lcom/android/studio/ml/bot/ui/compose/timeline/PathInString;", "markdown", "", "offset", "", "allowDirectoryLinks", "", "getPathAt", "end", "linkifyMarkdown", "project", "Lcom/intellij/openapi/project/Project;", "markdown1", "markdown2", "isPathCharacter", "", "aiplugin.core.aicore"})
public final class LinkifyMarkdownKt {
    @NotNull
    public static final String linkifyMarkdown(@NotNull String markdown2, boolean allowDirectoryLinks, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)markdown2, (String)"markdown");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PathInString pathInString = LinkifyMarkdownKt.findNextPath(markdown2, 0, allowDirectoryLinks);
        if (pathInString == null) {
            return markdown2;
        }
        PathInString curr = pathInString;
        StringBuilder sb = new StringBuilder();
        int from = 0;
        while (true) {
            String basePath;
            PathInString pathInString2 = curr;
            int start2 = pathInString2.component1();
            int end = pathInString2.component2();
            String path2 = pathInString2.component3();
            String string = markdown2.substring(from, start2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            sb.append(string);
            from = end;
            String url = FileUtilsKt.fileToUrlString(new File(path2));
            VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)new File(path2), (boolean)false);
            String relative = virtualFile2 != null ? FileUtilsKt.projectRelativePath(virtualFile2, project2) : ((basePath = project2.getBasePath()) != null && StringsKt.startsWith$default((String)path2, (String)basePath, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)path2, (Object)basePath) ? StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)path2, (CharSequence)basePath), (CharSequence)"\\"), (CharSequence)"/") : path2);
            sb.append("[" + relative + "](" + url + ")");
            if (LinkifyMarkdownKt.findNextPath(markdown2, from, allowDirectoryLinks) == null) break;
        }
        String string = markdown2.substring(from);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        sb.append(string);
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public static /* synthetic */ String linkifyMarkdown$default(String string, boolean bl, Project project2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return LinkifyMarkdownKt.linkifyMarkdown(string, bl, project2);
    }

    @NotNull
    public static final String linkifyMarkdown(@NotNull String markdown1, @NotNull String markdown2, boolean allowDirectoryLinks, @NotNull Project project2) {
        int linkSeparator;
        int linkStart;
        Intrinsics.checkNotNullParameter((Object)markdown1, (String)"markdown1");
        Intrinsics.checkNotNullParameter((Object)markdown2, (String)"markdown2");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (StringsKt.endsWith$default((String)markdown1, (String)"/)", (boolean)false, (int)2, null) && (linkStart = StringsKt.lastIndexOf$default((CharSequence)markdown1, (char)'[', (int)((linkSeparator = StringsKt.lastIndexOf$default((CharSequence)markdown1, (String)"](file:", (int)0, (boolean)false, (int)6, null)) + 1), (boolean)false, (int)4, null)) != -1) {
            int pathEnd;
            for (pathEnd = 0; pathEnd < markdown2.length() && LinkifyMarkdownKt.isPathCharacter(markdown2.charAt(pathEnd)); ++pathEnd) {
            }
            if (pathEnd > 0 && (markdown2.charAt(pathEnd - 1) == '.' || markdown2.charAt(pathEnd - 1) == ':')) {
                --pathEnd;
            }
            if (pathEnd > 0) {
                String string = markdown1.substring(linkSeparator + 2, markdown1.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                File file = FileUtilsKt.urlToFile(string);
                String path2 = file.getPath();
                String string2 = markdown2.substring(0, pathEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                File fullFile = new File(file, string2);
                if (fullFile.exists()) {
                    String string3 = markdown1.substring(0, linkStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    String prev = string3 + path2 + (!StringsKt.startsWith$default((String)markdown2, (String)"/", (boolean)false, (int)2, null) ? "/" : "");
                    String combined = prev + markdown2;
                    return LinkifyMarkdownKt.linkifyMarkdown(combined, allowDirectoryLinks, project2);
                }
            }
        }
        return LinkifyMarkdownKt.linkifyMarkdown(markdown1 + markdown2, allowDirectoryLinks, project2);
    }

    public static /* synthetic */ String linkifyMarkdown$default(String string, String string2, boolean bl, Project project2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return LinkifyMarkdownKt.linkifyMarkdown(string, string2, bl, project2);
    }

    private static final PathInString findNextPath(String markdown2, int offset2, boolean allowDirectoryLinks) {
        int i2;
        int balance = 0;
        int quotedPathStart = -1;
        int textPathStart = -1;
        int fileSeparators = 0;
        for (i2 = offset2; i2 < markdown2.length(); ++i2) {
            PathInString pathInString;
            char c = markdown2.charAt(i2);
            if (c == '[') {
                ++balance;
                continue;
            }
            if (c == ']') {
                --balance;
                continue;
            }
            if (c == '\\') {
                if (balance == 0) {
                    if (quotedPathStart != -1 || textPathStart != -1) {
                        ++fileSeparators;
                    } else {
                        textPathStart = i2;
                        fileSeparators = 1;
                    }
                }
                if (quotedPathStart != -1 || i2 >= markdown2.length() - 1) continue;
                ++i2;
                continue;
            }
            if (c == '/') {
                if (balance != 0) continue;
                if (quotedPathStart != -1 || textPathStart != -1) {
                    ++fileSeparators;
                    continue;
                }
                textPathStart = i2;
                fileSeparators = 1;
                continue;
            }
            if (LinkifyMarkdownKt.isPathCharacter(c)) {
                if (balance != 0 || textPathStart != -1 || quotedPathStart != -1) continue;
                textPathStart = i2;
                continue;
            }
            if (c == '`') {
                if (balance == 0) {
                    String path2;
                    File file;
                    if (quotedPathStart == -1) {
                        quotedPathStart = i2;
                        fileSeparators = 0;
                        continue;
                    }
                    int end = i2;
                    Intrinsics.checkNotNullExpressionValue((Object)markdown2.substring(quotedPathStart + 1, end), (String)"substring(...)");
                    if (fileSeparators > 2 && (file = new File(path2)).exists() && (file.isFile() || allowDirectoryLinks && file.isDirectory())) {
                        return new PathInString(quotedPathStart, end + 1, path2);
                    }
                    quotedPathStart = -1;
                    continue;
                }
                quotedPathStart = -1;
                continue;
            }
            if (balance == 0 && textPathStart != -1 && fileSeparators >= 2 && (pathInString = LinkifyMarkdownKt.getPathAt(markdown2, textPathStart, i2, allowDirectoryLinks)) != null) {
                PathInString it = pathInString;
                boolean bl = false;
                return it;
            }
            textPathStart = -1;
            if (quotedPathStart != -1) continue;
            fileSeparators = 0;
        }
        if (balance == 0 && textPathStart != -1 && fileSeparators >= 2) {
            return LinkifyMarkdownKt.getPathAt(markdown2, textPathStart, i2, allowDirectoryLinks);
        }
        return null;
    }

    private static final boolean isPathCharacter(char $this$isPathCharacter) {
        return switch ($this$isPathCharacter) {
            case '#', '$', '+', '-', '.', '/', ':', '@', '\\', '_', '~' -> true;
            default -> Character.isLetterOrDigit($this$isPathCharacter);
        };
    }

    private static final PathInString getPathAt(String markdown2, int offset2, int end, boolean allowDirectoryLinks) {
        if (StringsKt.regionMatches$default((String)markdown2, (int)offset2, (String)"file:", (int)0, (int)5, (boolean)false, (int)16, null)) {
            return null;
        }
        int i2 = end;
        if (markdown2.charAt(i2 - 1) == '.' || markdown2.charAt(i2 - 1) == ':') {
            --i2;
        }
        String string = markdown2.substring(offset2, i2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String path2 = string;
        File file = new File(path2);
        if (file.exists() && (file.isFile() || allowDirectoryLinks && file.isDirectory())) {
            return new PathInString(offset2, i2, path2);
        }
        return null;
    }
}

