/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.timeline;

import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.ui.compose.LoadablePainter;
import com.android.studio.ml.bot.ui.compose.timeline.TypedAttachment;
import com.android.tools.idea.studiobot.MimeType;
import com.android.tools.idea.studiobot.mimetype.MimeTypeUtilsKt;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0001\u000bR\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\f\r\u00a8\u0006\u000e\u00c0\u0006\u0003"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/ImageAttachment;", "Lcom/android/studio/ml/bot/ui/compose/timeline/TypedAttachment;", "painter", "Landroidx/compose/runtime/State;", "Lcom/android/studio/ml/bot/ui/compose/LoadablePainter;", "getPainter", "()Landroidx/compose/runtime/State;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "SupportedImageTypes", "Lcom/android/studio/ml/bot/ui/compose/timeline/Attachment$Image;", "Lcom/android/studio/ml/bot/ui/compose/timeline/Attachment$InMemoryImage;", "aiplugin.core.aicore"})
public interface ImageAttachment
extends TypedAttachment {
    @NotNull
    public State<LoadablePainter> getPainter();

    @Nullable
    public Path getPath();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0005\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/ImageAttachment$SupportedImageTypes;", "", "()V", "extensions", "", "", "getExtensions", "()Ljava/util/Set;", "extensionsByMimeType", "", "Lcom/android/tools/idea/studiobot/MimeType;", "", "mimeTypes", "getMimeTypes", "mimeTypesByExtension", "extensionsForMimeTypeOrNull", "mimeType", "extensionsForMimeTypeOrNull-qru2Y28", "(Ljava/lang/String;)Ljava/util/List;", "isSupportedImageFileExtension", "", "extension", "isSupportedImageMimeType", "isSupportedImageMimeType-qru2Y28", "(Ljava/lang/String;)Z", "mimeTypeForExtensionOrNull", "mimeTypeForExtensionOrNull-QgcU6xs", "(Ljava/lang/String;)Ljava/lang/String;", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class SupportedImageTypes {
        @NotNull
        public static final SupportedImageTypes INSTANCE = new SupportedImageTypes();
        @NotNull
        private static final Map<String, MimeType> mimeTypesByExtension;
        @NotNull
        private static final Map<MimeType, List<String>> extensionsByMimeType;
        @NotNull
        private static final Set<String> extensions;
        @NotNull
        private static final Set<MimeType> mimeTypes;
        public static final int $stable;

        private SupportedImageTypes() {
        }

        @NotNull
        public final Set<String> getExtensions() {
            return extensions;
        }

        @NotNull
        public final Set<MimeType> getMimeTypes() {
            return mimeTypes;
        }

        public final boolean isSupportedImageMimeType-qru2Y28(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return mimeTypes.contains(MimeType.box-impl(MimeTypeUtilsKt.base-qru2Y28(mimeType)));
        }

        @Nullable
        public final List<String> extensionsForMimeTypeOrNull-qru2Y28(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return extensionsByMimeType.get(MimeType.box-impl(MimeTypeUtilsKt.base-qru2Y28(mimeType)));
        }

        @Nullable
        public final String mimeTypeForExtensionOrNull-QgcU6xs(@NotNull String extension) {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            String string = extension.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            MimeType mimeType = mimeTypesByExtension.get(StringsKt.removePrefix((String)string, (CharSequence)"."));
            return mimeType != null ? mimeType.unbox-impl() : null;
        }

        public final boolean isSupportedImageFileExtension(@NotNull String extension) {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            return this.mimeTypeForExtensionOrNull-QgcU6xs(extension) != null;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jpg", (Object)MimeType.box-impl(MimeType.Companion.getJPEG-i_3W7CY())), TuplesKt.to((Object)"jpeg", (Object)MimeType.box-impl(MimeType.Companion.getJPEG-i_3W7CY())), TuplesKt.to((Object)"png", (Object)MimeType.box-impl(MimeType.Companion.getPNG-i_3W7CY()))};
            mimeTypesByExtension = MapsKt.mapOf((Pair[])pairArray);
            pairArray = new Pair[2];
            Object[] objectArray = new String[]{"jpg", "jpeg"};
            pairArray[0] = TuplesKt.to((Object)MimeType.box-impl(MimeType.Companion.getJPEG-i_3W7CY()), (Object)CollectionsKt.listOf((Object[])objectArray));
            pairArray[1] = TuplesKt.to((Object)MimeType.box-impl(MimeType.Companion.getPNG-i_3W7CY()), (Object)CollectionsKt.listOf((Object)"png"));
            extensionsByMimeType = MapsKt.mapOf((Pair[])pairArray);
            extensions = mimeTypesByExtension.keySet();
            mimeTypes = extensionsByMimeType.keySet();
            $stable = 8;
        }
    }
}

