/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.shaders;

import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import com.android.studio.ml.bot.ui.compose.shaders.RotatingSweepShaderBrush;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.RuntimeEffect;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u0010\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u0010\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000e"}, d2={"ROTATING_SWEEP_GRADIENT_EFFECT", "Lorg/jetbrains/skia/RuntimeEffect;", "ROTATING_SWEEP_GRADIENT_SKSL", "", "brandColor1", "Landroidx/compose/ui/graphics/Color;", "J", "brandColor2", "brandColor3", "geminiGradientSweep", "Landroidx/compose/ui/graphics/Brush;", "Landroidx/compose/ui/graphics/Brush$Companion;", "rotationAmount", "", "aiplugin.core.aicore"})
public final class GeminiSweepGradientKt {
    private static final long brandColor1 = ColorKt.Color((long)4281435903L);
    private static final long brandColor2 = ColorKt.Color((long)4281641043L);
    private static final long brandColor3 = ColorKt.Color((long)4283408639L);
    @Language(value="GLSL")
    @NotNull
    private static final String ROTATING_SWEEP_GRADIENT_SKSL = "uniform vec2 iResolution; // Width and height of the composable\nuniform float iTime;      // Rotation offset (0.0 to 2.0 * PI)\nuniform vec3 iColor1;     // First color (e.g., Red)\nuniform vec3 iColor2;     // Second color (e.g., Green)\nuniform vec3 iColor3;     // Third color (e.g., Blue)\n\nconst float PI = 3.141592653589793;\nconst float TWO_PI = 2.0 * PI;\n\nvec4 main(vec2 fragCoord) {\n    // Calculate coordinates relative to the center of the composable.\n    // Normalize by the smaller dimension to keep the gradient circular.\n    vec2 centeredCoord = fragCoord - 0.5 * iResolution;\n    float minDimension = min(iResolution.x, iResolution.y);\n    vec2 uv = centeredCoord / minDimension;\n\n    // Calculate the angle of the current pixel relative to the center.\n    // atan(y, x) returns an angle in the range [-PI, PI].\n    float angle = atan(uv.y, uv.x);\n\n    // Apply the rotation offset.\n    // Subtracting iTime makes the gradient rotate clockwise as iTime increases.\n    angle -= iTime;\n\n    // Normalize the angle to a 0.0 to 1.0 range.\n    // (angle + PI) / TWO_PI maps the angle (which might be outside [-PI, PI] after iTime shift)\n    // to a range that might be outside [0,1].\n    // Using fract() ensures t wraps smoothly within [0,1).\n    float t = fract((angle + PI) / TWO_PI); // Corrected line\n\n    vec3 finalColor;\n    float segmentBoundary1 = 1.0 / 3.0;\n    float segmentBoundary2 = 2.0 / 3.0;\n\n    if (t < segmentBoundary1) {\n        // Interpolate between color1 and color2\n        float local_t = t / segmentBoundary1;\n        finalColor = mix(iColor1, iColor2, local_t);\n    } else if (t < segmentBoundary2) {\n        // Interpolate between color2 and color3\n        float local_t = (t - segmentBoundary1) / segmentBoundary1; // segmentBoundary1 is also the length of the segment\n        finalColor = mix(iColor2, iColor3, local_t);\n    } else {\n        // Interpolate between color3 and color1\n        float local_t = (t - segmentBoundary2) / segmentBoundary1;\n        finalColor = mix(iColor3, iColor1, local_t);\n    }\n\n    return vec4(finalColor, 1.0);\n}";
    @NotNull
    private static final RuntimeEffect ROTATING_SWEEP_GRADIENT_EFFECT = RuntimeEffect.Companion.makeForShader(ROTATING_SWEEP_GRADIENT_SKSL);

    @NotNull
    public static final Brush geminiGradientSweep(@NotNull Brush.Companion $this$geminiGradientSweep, float rotationAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$geminiGradientSweep, (String)"<this>");
        Object[] objectArray = new Color[]{Color.box-impl((long)brandColor1), Color.box-impl((long)brandColor2), Color.box-impl((long)brandColor3)};
        return (Brush)new RotatingSweepShaderBrush(CollectionsKt.listOf((Object[])objectArray), rotationAmount);
    }

    public static /* synthetic */ Brush geminiGradientSweep$default(Brush.Companion companion, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        return GeminiSweepGradientKt.geminiGradientSweep(companion, f);
    }

    public static final /* synthetic */ RuntimeEffect access$getROTATING_SWEEP_GRADIENT_EFFECT$p() {
        return ROTATING_SWEEP_GRADIENT_EFFECT;
    }
}

