/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.Authenticator;
import com.android.studio.ml.util.CoroutineScopesKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBImageIcon;
import icons.SmlIcons;
import java.awt.Image;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lcom/android/studio/ml/bot/ui/UserAvatarService;", "Lcom/intellij/openapi/Disposable;", "()V", "authenticator", "Lcom/android/studio/ml/Authenticator;", "getAuthenticator", "()Lcom/android/studio/ml/Authenticator;", "avatarChanges", "Lkotlinx/coroutines/flow/SharedFlow;", "", "getAvatarChanges", "()Lkotlinx/coroutines/flow/SharedFlow;", "avatarChangesFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "cachedUserAvatarImage", "Ljava/awt/Image;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "refreshJob", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<set-?>", "Ljavax/swing/Icon;", "userAvatar", "getUserAvatar", "()Ljavax/swing/Icon;", "dispose", "refreshCachedAvatar", "updateCurrentAvatar", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nUserAvatarService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserAvatarService.kt\ncom/android/studio/ml/bot/ui/UserAvatarService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,162:1\n25#2:163\n*S KotlinDebug\n*F\n+ 1 UserAvatarService.kt\ncom/android/studio/ml/bot/ui/UserAvatarService\n*L\n48#1:163\n*E\n"})
public final class UserAvatarService
implements Disposable {
    @NotNull
    private final CoroutineScope scope = CoroutineScopesKt.createCoroutineScope$default(this, null, null, 3, null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private Image cachedUserAvatarImage;
    @Nullable
    private Job refreshJob;
    @NotNull
    private Icon userAvatar;
    @NotNull
    private final MutableSharedFlow<Unit> avatarChangesFlow;
    @NotNull
    private final SharedFlow<Unit> avatarChanges;
    public static final int $stable = 8;

    public UserAvatarService() {
        UserAvatarService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(UserAvatarService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.lock = new ReentrantLock();
        this.userAvatar = SmlIcons.DefaultAvatar;
        this.avatarChangesFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.avatarChanges = FlowKt.asSharedFlow(this.avatarChangesFlow);
        StateFlow<Authenticator.AuthState> authenticationState = this.getAuthenticator().getAuthenticationState();
        this.refreshCachedAvatar();
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)authenticationState), (Function2)((Function2)new Function2<Authenticator.AuthState, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ UserAvatarService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Authenticator.AuthState it = (Authenticator.AuthState)this.L$0;
                        this.this$0.logger.debug("User authentication state changed. Now it's " + it);
                        this.this$0.refreshCachedAvatar();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Authenticator.AuthState p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.scope);
    }

    @NotNull
    public final Icon getUserAvatar() {
        return this.userAvatar;
    }

    private final Authenticator getAuthenticator() {
        return Authenticator.Companion.current();
    }

    @NotNull
    public final SharedFlow<Unit> getAvatarChanges() {
        return this.avatarChanges;
    }

    private final void refreshCachedAvatar() {
        Job job2 = this.refreshJob;
        if (job2 != null) {
            JobKt.cancel$default((Job)job2, (String)"Starting new refresh job", null, (int)2, null);
        }
        this.refreshJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UserAvatarService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        UserAvatarService.access$getLogger$p(this.this$0).debug("Refreshing cached user avatar...");
                        authState = (Authenticator.AuthState)UserAvatarService.access$getAuthenticator(this.this$0).getAuthenticationState().getValue();
                        if (authState instanceof Authenticator.AuthState.HasProfileInfo) ** GOTO lbl11
                        UserAvatarService.access$setCachedUserAvatarImage$p(this.this$0, null);
                        ** GOTO lbl53
lbl11:
                        // 1 sources

                        if (!Intrinsics.areEqual((Object)UserAvatarService.access$getCachedUserAvatarImage$p(this.this$0), (Object)((Authenticator.AuthState.HasProfileInfo)authState).getProfileInfo().getProfilePicture())) ** GOTO lbl53
                        var4_5 = $this$launch;
                        var5_6 = this.this$0;
                        $i$a$-runCatching-UserAvatarService$refreshCachedAvatar$1$1 = false;
                        this.label = 1;
                        v0 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var5_6, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ UserAvatarService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$withTimeout = (CoroutineScope)this.L$0;
                                        UserAvatarService.access$getLogger$p(this.this$0).debug("Awaiting avatar changes...");
lbl7:
                                        // 3 sources

                                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$withTimeout) && (newAuthState = (Authenticator.AuthState)UserAvatarService.access$getAuthenticator(this.this$0).getAuthenticationState().getValue()) instanceof Authenticator.AuthState.HasProfileInfo && Intrinsics.areEqual((Object)UserAvatarService.access$getCachedUserAvatarImage$p(this.this$0), (Object)((Authenticator.AuthState.HasProfileInfo)newAuthState).getProfileInfo().getProfilePicture())) {
                                            this.L$0 = $this$withTimeout;
                                            this.label = 1;
                                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                                            if (v0 != var4_2) continue;
                                            return var4_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        $this$withTimeout = (CoroutineScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl7
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        ** if (v0 != var9_2) goto lbl23
lbl22:
                        // 1 sources

                        return var9_2;
lbl23:
                        // 1 sources

                        ** GOTO lbl30
                    }
                    case 1: {
                        $i$a$-runCatching-UserAvatarService$refreshCachedAvatar$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl30:
                            // 2 sources

                            var6_10 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable $i$a$-runCatching-UserAvatarService$refreshCachedAvatar$1$1) {
                            var6_10 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-UserAvatarService$refreshCachedAvatar$1$1));
                        }
                        var4_5 = var6_10;
                        var5_6 = this.this$0;
                        var6_10 = this.this$0;
                        v1 = Result.exceptionOrNull-impl((Object)var4_5);
                        if (v1 == null) {
                            (Unit)var4_5;
                            $i$a$-fold-UserAvatarService$refreshCachedAvatar$1$2 = false;
                            UserAvatarService.access$getLogger$p(var5_6).info("User avatar has changed after waiting");
                        } else {
                            it = v1;
                            $i$a$-fold-UserAvatarService$refreshCachedAvatar$1$3 = false;
                            if (!(it instanceof CancellationException)) {
                                UserAvatarService.access$getLogger$p((UserAvatarService)var6_10).warn("User avatar hasn't changed yet after waiting", it);
                            } else {
                                UserAvatarService.access$getLogger$p((UserAvatarService)var6_10).info("Waiting for user avatar canceled");
                            }
                        }
lbl53:
                        // 5 sources

                        UserAvatarService.access$updateCurrentAvatar(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateCurrentAvatar() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.logger.debug("Updating cached user avatar...");
            Authenticator.AuthState authState = (Authenticator.AuthState)this.getAuthenticator().getAuthenticationState().getValue();
            if (!(authState instanceof Authenticator.AuthState.HasProfileInfo)) {
                this.cachedUserAvatarImage = null;
                this.userAvatar = SmlIcons.DefaultAvatar;
            } else {
                Image image;
                if (((Authenticator.AuthState.HasProfileInfo)((Object)authState)).getProfileInfo().getProfilePicture() == null) {
                    return;
                }
                Image profilePic = image;
                if (!Intrinsics.areEqual((Object)profilePic, (Object)this.cachedUserAvatarImage)) {
                    this.cachedUserAvatarImage = profilePic;
                    this.userAvatar = (Icon)new JBImageIcon(profilePic);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.avatarChangesFlow.tryEmit((Object)Unit.INSTANCE);
    }

    public void dispose() {
        CoroutineScopeKt.cancel((CoroutineScope)this.scope, (CancellationException)new CancellationException("Disposing..."));
    }

    public static final /* synthetic */ Authenticator access$getAuthenticator(UserAvatarService $this) {
        return $this.getAuthenticator();
    }

    public static final /* synthetic */ void access$setCachedUserAvatarImage$p(UserAvatarService $this, Image image) {
        $this.cachedUserAvatarImage = image;
    }

    public static final /* synthetic */ Image access$getCachedUserAvatarImage$p(UserAvatarService $this) {
        return $this.cachedUserAvatarImage;
    }

    public static final /* synthetic */ void access$updateCurrentAvatar(UserAvatarService $this) {
        $this.updateCurrentAvatar();
    }
}

