/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.parse;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.AndroidPluginServices;
import com.android.studio.ml.bot.action.CodeInsertionUtils;
import com.android.studio.ml.bot.action.JavaFormatter;
import com.android.studio.ml.bot.parse.CodeFixer;
import com.android.studio.ml.bot.parse.FileRange;
import com.android.studio.ml.bot.parse.JavaCodeFixerKt;
import com.android.studio.ml.bot.parse.JvmCodeFixer;
import com.android.studio.ml.bot.parse.JvmUtilsKt;
import com.android.studio.ml.bot.parse.resolve.AndroidImportGuesser;
import com.android.studio.ml.bot.parse.resolve.CombinedSimpleNameRegistry;
import com.android.studio.ml.bot.parse.resolve.PrioritizedImportData;
import com.android.tools.idea.studiobot.MimeType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\tH\u0015JH\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0015\u00a8\u0006\u001b"}, d2={"Lcom/android/studio/ml/bot/parse/JavaCodeFixer;", "Lcom/android/studio/ml/bot/parse/JvmCodeFixer;", "<init>", "()V", "chooseBestQualification", "Lcom/android/studio/ml/bot/parse/JvmCodeFixer$QualificationEntry;", "element", "Lcom/intellij/psi/SmartPsiElementPointer;", "options", "", "packages", "", "", "getQualificationsAndPackages", "Lcom/android/studio/ml/bot/parse/JvmCodeFixer$QualificationsAndPackages;", "project", "Lcom/intellij/openapi/project/Project;", "contextFile", "Lcom/intellij/psi/PsiFile;", "elements", "doFixes", "Lcom/android/studio/ml/bot/parse/CodeFixer$FixResult;", "Lcom/intellij/psi/PsiElement;", "qualifications", "", "addedImports", "FullyQualifyAndImportVisitor", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nJavaCodeFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCodeFixer.kt\ncom/android/studio/ml/bot/parse/JavaCodeFixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,377:1\n1628#2,3:378\n774#2:383\n865#2,2:384\n1663#2,8:386\n1628#2,3:394\n1454#2,2:397\n774#2:399\n865#2,2:400\n1663#2,8:402\n1557#2:410\n1628#2,3:411\n1456#2,3:414\n1#3:381\n455#4:382\n*S KotlinDebug\n*F\n+ 1 JavaCodeFixer.kt\ncom/android/studio/ml/bot/parse/JavaCodeFixer\n*L\n284#1:378,3\n352#1:383\n352#1:384,2\n353#1:386,8\n354#1:394,3\n357#1:397,2\n361#1:399\n361#1:400,2\n362#1:402,8\n363#1:410\n363#1:411,3\n357#1:414,3\n315#1:382\n*E\n"})
public final class JavaCodeFixer
extends JvmCodeFixer {
    public static final int $stable = 8;

    public JavaCodeFixer() {
        super(MimeType.Companion.getJAVA-i_3W7CY(), null);
    }

    @Override
    @Nullable
    protected JvmCodeFixer.QualificationEntry chooseBestQualification(@NotNull SmartPsiElementPointer<?> element, @NotNull List<JvmCodeFixer.QualificationEntry> options, @NotNull Set<String> packages) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        return (JvmCodeFixer.QualificationEntry)CollectionsKt.firstOrNull(options);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    protected JvmCodeFixer.QualificationsAndPackages getQualificationsAndPackages(@NotNull Project project2, @NotNull PsiFile contextFile, @NotNull List<? extends SmartPsiElementPointer<?>> elements) {
        void var16_17;
        void destination$iv;
        void $this$mapTo$iv;
        Object elementPointer2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        FullyQualifyAndImportVisitor visitor = new FullyQualifyAndImportVisitor(project2, (PsiElement)contextFile);
        for (Object elementPointer2 : elements) {
            PsiElement element;
            if (elementPointer2.getElement() == null) continue;
            element.accept((PsiElementVisitor)visitor);
        }
        Iterable iterable = visitor.getImportedNames().entrySet();
        elementPointer2 = new LinkedHashSet();
        Set<String> set = visitor.getUsedPackages();
        Map<SmartPsiElementPointer<PsiElement>, List<JvmCodeFixer.QualificationEntry>> map2 = visitor.getQualifications();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Map.Entry entry = (Map.Entry)item$iv;
            var16_17 = destination$iv;
            boolean bl = false;
            String simpleName = (String)entry.getKey();
            String pkg = (String)entry.getValue();
            var16_17.add(pkg + "." + simpleName);
        }
        var16_17 = destination$iv;
        Set set2 = (Set)var16_17;
        Set<String> set3 = set;
        Map<SmartPsiElementPointer<PsiElement>, List<JvmCodeFixer.QualificationEntry>> map3 = map2;
        return new JvmCodeFixer.QualificationsAndPackages(map3, set3, set2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @RequiresWriteLock
    @RequiresEdt
    @NotNull
    protected CodeFixer.FixResult doFixes(@NotNull Project project2, @NotNull PsiFile contextFile, @NotNull List<? extends PsiElement> elements, @NotNull Map<PsiElement, JvmCodeFixer.QualificationEntry> qualifications, @NotNull Set<String> addedImports) {
        void $this$flatMapTo$iv;
        Iterable $this$mapTo$iv;
        Iterable $this$distinctBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String fqName;
        String it;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(qualifications, (String)"qualifications");
        Intrinsics.checkNotNullParameter(addedImports, (String)"addedImports");
        PsiJavaFile cfr_ignored_0 = (PsiJavaFile)contextFile;
        Set imports = new LinkedHashSet();
        PsiImportList psiImportList = ((PsiJavaFile)contextFile).getImportList();
        Intrinsics.checkNotNull((Object)psiImportList);
        for (PsiImportStatement psiImportStatement : psiImportList.getImportStatements()) {
            if (psiImportStatement.getQualifiedName() == null) continue;
            boolean bl = false;
            imports.add(it);
        }
        for (JvmCodeFixer.QualificationEntry qualification : qualifications.values()) {
            if (qualification.getReference().getElement() == null) continue;
            if (qualification.getQualifyInPlace()) {
                RangeMarker rangeToFormat;
                RangeMarker rangeToReplace;
                PsiElement psiElement;
                PsiElement expression;
                Document document = ((PsiJavaFile)contextFile).getViewProvider().getDocument();
                String string = expression.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"<", (boolean)false, (int)2, null)) {
                    PsiElement $this$childrenOfType$iv = expression;
                    boolean $i$f$childrenOfType = false;
                    List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, PsiIdentifier.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                    PsiIdentifier psiIdentifier = (PsiIdentifier)CollectionsKt.singleOrNull((List)list);
                    psiElement = psiIdentifier != null ? (PsiElement)psiIdentifier : expression;
                } else {
                    psiElement = expression;
                }
                PsiElement expressionToReplace = psiElement;
                Intrinsics.checkNotNullExpressionValue((Object)document.createRangeMarker(expressionToReplace.getTextRange()), (String)"createRangeMarker(...)");
                Intrinsics.checkNotNullExpressionValue((Object)document.createRangeMarker(expression.getTextRange()), (String)"createRangeMarker(...)");
                try {
                    CodeInsertionUtils.INSTANCE.commitAndUnblockDocument(contextFile);
                    document.replaceString(rangeToReplace.getStartOffset(), rangeToReplace.getEndOffset(), (CharSequence)qualification.getImportData().getImportedItemFqName());
                    CodeInsertionUtils.INSTANCE.commitAndUnblockDocument(contextFile);
                    CodeInsertionUtils.INSTANCE.completeIndexing((PsiElement)contextFile);
                    TextRange textRange = rangeToFormat.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    FileRange $i$f$childrenOfType = JavaFormatter.INSTANCE.formatRange(new FileRange(contextFile, textRange));
                }
                finally {
                    rangeToReplace.dispose();
                    rangeToFormat.dispose();
                }
            }
            if (!qualification.getAddImport() || imports.contains(fqName = qualification.getImportData().getImportedItemFqName())) continue;
            PsiImportList psiImportList2 = ((PsiJavaFile)contextFile).getImportList();
            Intrinsics.checkNotNull((Object)psiImportList2);
            psiImportList2.add(JvmUtilsKt.createJavaImportStatement(project2, fqName));
            imports.add(fqName);
        }
        Set allDependencies = new LinkedHashSet();
        Iterable qualification = qualifications.values();
        boolean $i$f$filter = false;
        fqName = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JvmCodeFixer.QualificationEntry it2 = (JvmCodeFixer.QualificationEntry)element$iv$iv;
            boolean bl = false;
            if (!(it2.getImportData().getArtifact() != null && it2.getImportData().getVersion() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            JvmCodeFixer.QualificationEntry it3 = (JvmCodeFixer.QualificationEntry)e$iv;
            boolean bl = false;
            String key$iv = it3.getImportData().getArtifact();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        Collection destination$iv = allDependencies;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Object e$iv;
            e$iv = (JvmCodeFixer.QualificationEntry)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(((JvmCodeFixer.QualificationEntry)((Object)it)).getImportData().getArtifact() + ":" + ((JvmCodeFixer.QualificationEntry)((Object)it)).getImportData().getVersion());
        }
        $this$mapTo$iv = addedImports;
        destination$iv = allDependencies;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$distinctBy$iv2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            String string = (String)element$iv;
            boolean bl = false;
            Pair pair = JavaCodeFixerKt.access$splitByPackage(string);
            String simpleName = (String)pair.component1();
            String pkg = (String)pair.component2();
            Iterable iterable = CombinedSimpleNameRegistry.INSTANCE.lookup(simpleName);
            boolean $i$f$filter2 = false;
            void var20_38 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                AndroidPluginServices.ImportData it4 = (AndroidPluginServices.ImportData)element$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it4.getImportedItemPackageName(), (Object)pkg) && it4.getArtifact() != null && it4.getVersion() != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$distinctBy2 = false;
            HashSet<String> set$iv2 = new HashSet<String>();
            ArrayList list$iv2 = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv2) {
                AndroidPluginServices.ImportData it5 = (AndroidPluginServices.ImportData)e$iv;
                boolean bl3 = false;
                String key$iv = it5.getArtifact();
                if (!set$iv2.add(key$iv)) continue;
                list$iv2.add(e$iv);
            }
            $this$distinctBy$iv2 = list$iv2;
            boolean $i$f$map = false;
            set$iv2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it6;
                AndroidPluginServices.ImportData bl3 = (AndroidPluginServices.ImportData)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it6.getArtifact() + ":" + it6.getVersion());
            }
            Iterable list$iv3 = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv3);
        }
        return new CodeFixer.FixResult(allDependencies);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JV\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00152\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001f2\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001f0\"2\u0014\b\u0002\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0\"J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0015H\u0002J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR)\u0010\f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012\u00a8\u00062"}, d2={"Lcom/android/studio/ml/bot/parse/JavaCodeFixer$FullyQualifyAndImportVisitor;", "Lcom/intellij/psi/JavaRecursiveElementVisitor;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getContext", "()Lcom/intellij/psi/PsiElement;", "qualifications", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "", "Lcom/android/studio/ml/bot/parse/JvmCodeFixer$QualificationEntry;", "getQualifications", "()Ljava/util/Map;", "usedPackages", "", "", "getUsedPackages", "()Ljava/util/Set;", "importedNames", "getImportedNames", "addQualifications", "", "reference", "simpleName", "addImport", "", "qualifyInPlace", "elementFilter", "Lkotlin/Function1;", "indexFilter", "Lcom/android/studio/ml/AndroidPluginServices$ImportData;", "processImportedName", "name", "visitCodeFragment", "codeFragment", "Lcom/intellij/psi/JavaCodeFragment;", "visitImportStatement", "statement", "Lcom/intellij/psi/PsiImportStatement;", "visitReferenceElement", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "visitReferenceExpression", "expression", "Lcom/intellij/psi/PsiReferenceExpression;", "aiplugin.android"})
    @SourceDebugExtension(value={"SMAP\nJavaCodeFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCodeFixer.kt\ncom/android/studio/ml/bot/parse/JavaCodeFixer$FullyQualifyAndImportVisitor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 JvmUtils.kt\ncom/android/studio/ml/bot/parse/JvmUtilsKt\n*L\n1#1,377:1\n66#2,2:378\n1557#3:380\n1628#3,3:381\n1863#3,2:384\n1#4:386\n206#5,4:387\n*S KotlinDebug\n*F\n+ 1 JavaCodeFixer.kt\ncom/android/studio/ml/bot/parse/JavaCodeFixer$FullyQualifyAndImportVisitor\n*L\n82#1:378,2\n101#1:380\n101#1:381,3\n126#1:384,2\n224#1:387,4\n*E\n"})
    private static final class FullyQualifyAndImportVisitor
    extends JavaRecursiveElementVisitor {
        @NotNull
        private final Project project;
        @NotNull
        private final PsiElement context;
        @NotNull
        private final Map<SmartPsiElementPointer<PsiElement>, List<JvmCodeFixer.QualificationEntry>> qualifications;
        @NotNull
        private final Set<String> usedPackages;
        @NotNull
        private final Map<String, String> importedNames;

        public FullyQualifyAndImportVisitor(@NotNull Project project2, @NotNull PsiElement context2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.project = project2;
            this.context = context2;
            this.qualifications = new LinkedHashMap();
            this.usedPackages = new LinkedHashSet();
            this.importedNames = new LinkedHashMap();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final PsiElement getContext() {
            return this.context;
        }

        @NotNull
        public final Map<SmartPsiElementPointer<PsiElement>, List<JvmCodeFixer.QualificationEntry>> getQualifications() {
            return this.qualifications;
        }

        @NotNull
        public final Set<String> getUsedPackages() {
            return this.usedPackages;
        }

        @NotNull
        public final Map<String, String> getImportedNames() {
            return this.importedNames;
        }

        /*
         * WARNING - void declaration
         */
        public final void addQualifications(@NotNull PsiElement reference, @NotNull String simpleName, boolean addImport, boolean qualifyInPlace, @NotNull Function1<? super PsiElement, Boolean> elementFilter, @NotNull Function1<? super AndroidPluginServices.ImportData, Boolean> indexFilter) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            Intrinsics.checkNotNullParameter(elementFilter, (String)"elementFilter");
            Intrinsics.checkNotNullParameter(indexFilter, (String)"indexFilter");
            if (reference instanceof PsiCallExpression) {
                return;
            }
            PsiElement $this$parentOfType_u24default$iv = reference;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            PsiCallExpression call = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiCallExpression.class, (boolean)true);
            Function1 filter2 = arg_0 -> FullyQualifyAndImportVisitor.addQualifications$lambda$2(elementFilter, call, reference, arg_0);
            SmartPsiElementPointer<PsiElement> pointer = CodeInsertionUtils.INSTANCE.createSmartPointer(reference);
            Map<SmartPsiElementPointer<PsiElement>, List<JvmCodeFixer.QualificationEntry>> map2 = this.qualifications;
            Iterable iterable = new AndroidImportGuesser(this.project, this.context).getImportsFor(simpleName, (Language)JavaLanguage.INSTANCE, (Function1<? super PsiElement, Boolean>)filter2, indexFilter);
            boolean $i$f$map = false;
            void var13_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void data2;
                PrioritizedImportData prioritizedImportData = (PrioritizedImportData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new JvmCodeFixer.QualificationEntry(pointer, data2.getImport(), data2.getPriority(), addImport, qualifyInPlace));
            }
            Iterable it = iterable = (List)destination$iv$iv;
            boolean bl = false;
            if (it.size() == 1) {
                this.usedPackages.add(((JvmCodeFixer.QualificationEntry)CollectionsKt.single((List)it)).getImportData().getImportedItemPackageName());
            }
            map2.put(pointer, (List<JvmCodeFixer.QualificationEntry>)iterable);
        }

        public static /* synthetic */ void addQualifications$default(FullyQualifyAndImportVisitor fullyQualifyAndImportVisitor, PsiElement psiElement, String string, boolean bl, boolean bl2, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            if ((n & 0x10) != 0) {
                function1 = FullyQualifyAndImportVisitor::addQualifications$lambda$0;
            }
            if ((n & 0x20) != 0) {
                function12 = FullyQualifyAndImportVisitor::addQualifications$lambda$1;
            }
            fullyQualifyAndImportVisitor.addQualifications(psiElement, string, bl, bl2, (Function1<? super PsiElement, Boolean>)function1, (Function1<? super AndroidPluginServices.ImportData, Boolean>)function12);
        }

        private final void processImportedName(String name) {
            Pair pair = JavaCodeFixerKt.access$splitByPackage(name);
            String simpleName = (String)pair.component1();
            String pkg = (String)pair.component2();
            this.usedPackages.add(pkg);
            this.importedNames.put(simpleName, pkg);
        }

        public void visitCodeFragment(@NotNull JavaCodeFragment codeFragment) {
            Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
            String string = codeFragment.importsToString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"importsToString(...)");
            char[] cArray = new char[]{','};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.processImportedName(it);
            }
            super.visitCodeFragment(codeFragment);
        }

        public void visitImportStatement(@NotNull PsiImportStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            String string = statement.getQualifiedName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.processImportedName(it);
            }
            super.visitImportStatement(statement);
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement;
            PsiElement psiElement;
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            if (reference.isQualified()) {
                super.visitReferenceElement(reference);
                return;
            }
            if (this.importedNames.containsKey(reference.getText())) {
                super.visitReferenceElement(reference);
                return;
            }
            if (reference.getParent() instanceof PsiJavaCodeReferenceElement) {
                PsiElement psiElement2 = reference.getParent();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiJavaCodeReferenceElement");
                if (!Intrinsics.areEqual((Object)((PsiJavaCodeReferenceElement)psiElement2).getQualifier(), (Object)reference)) {
                    super.visitReferenceElement(reference);
                    return;
                }
            }
            PsiJavaCodeReferenceElement outermostReference = reference;
            while (((psiElement = outermostReference.getParent()) instanceof PsiJavaCodeReferenceElement ? (PsiJavaCodeReferenceElement)psiElement : null) != null) {
                outermostReference = outermostReference;
            }
            PsiElement parent = outermostReference.getParent();
            if (outermostReference.resolve() != null) {
                super.visitReferenceElement(reference);
                return;
            }
            Object object = parent;
            if (object instanceof PsiReferenceList) {
                psiJavaCodeReferenceElement = outermostReference;
            } else if (object instanceof PsiAnnotation) {
                psiJavaCodeReferenceElement = ((PsiAnnotation)parent).getNameReferenceElement();
            } else if (object instanceof PsiTypeElement) {
                psiJavaCodeReferenceElement = ((PsiTypeElement)parent).getInnermostComponentReferenceElement();
            } else if (object instanceof PsiNewExpression) {
                psiJavaCodeReferenceElement = ((PsiNewExpression)parent).getClassReference();
            } else if (object instanceof PsiAnonymousClass) {
                psiJavaCodeReferenceElement = ((PsiAnonymousClass)parent).getBaseClassReference();
            } else {
                super.visitReferenceElement(reference);
                return;
            }
            PsiJavaCodeReferenceElement expectedReference = psiJavaCodeReferenceElement;
            if (Intrinsics.areEqual((Object)outermostReference, (Object)expectedReference)) {
                String string = expectedReference.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                object = string;
                if (JavaCodeFixerKt.access$getTYPE_REFERENCE_PATTERN$p().matches((CharSequence)object) && JvmUtilsKt.tryResolve((PsiReference)expectedReference) == null) {
                    String string2;
                    PsiElement psiElement3 = (PsiElement)reference;
                    String string3 = reference.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"<", (boolean)false, (int)2, null)) {
                        String string4 = reference.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                        string2 = StringsKt.substringBefore$default((String)string4, (String)"<", null, (int)2, null);
                    } else {
                        string2 = reference.getText();
                    }
                    object = string2;
                    Intrinsics.checkNotNull((Object)object);
                    FullyQualifyAndImportVisitor.addQualifications$default(this, psiElement3, JvmUtilsKt.withoutWhitespace((String)object), false, false, null, null, 60, null);
                }
            }
            super.visitReferenceElement(reference);
        }

        /*
         * WARNING - void declaration
         */
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiElement psiElement;
            String name;
            block15: {
                void $this$getParentOfTypeWithinDistance$iv;
                block17: {
                    block16: {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        if (expression.isQualified()) break block16;
                        String string = expression.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        CharSequence charSequence = string;
                        if (new Regex("[a-zA-Z0-9]+").matches(charSequence)) break block17;
                    }
                    super.visitReferenceExpression(expression);
                    return;
                }
                name = expression.getReferenceName();
                if (this.importedNames.containsKey(expression.getText())) {
                    super.visitReferenceExpression(expression);
                    return;
                }
                PsiElement resolved = JvmUtilsKt.tryResolve((PsiReference)expression);
                if (resolved != null) {
                    super.visitReferenceExpression(expression);
                    return;
                }
                PsiElement psiElement2 = (PsiElement)expression;
                int distance$iv = 2;
                boolean $i$f$getParentOfTypeWithinDistance = false;
                PsiElement current$iv = $this$getParentOfTypeWithinDistance$iv.getParent();
                int i$iv = 1;
                while (true) {
                    if (current$iv instanceof PsiReferenceExpression) {
                        PsiReferenceExpression it = (PsiReferenceExpression)current$iv;
                        boolean bl = false;
                        if (it.isQualified()) {
                            psiElement = current$iv;
                            break block15;
                        }
                    }
                    current$iv = current$iv.getParent();
                    if (i$iv == distance$iv) break;
                    ++i$iv;
                }
                psiElement = null;
            }
            PsiReferenceExpression qualifiedExpressionParent = (PsiReferenceExpression)psiElement;
            if (qualifiedExpressionParent != null) {
                PsiElement psiElement3;
                PsiElement psiElement4 = qualifiedExpressionParent.getQualifier();
                Intrinsics.checkNotNull((Object)psiElement4);
                String string = psiElement4.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String qualifierText = JvmUtilsKt.withoutWhitespace(string);
                PsiReference psiReference = qualifiedExpressionParent.getReference();
                if (Intrinsics.areEqual((Object)name, (Object)(psiReference != null ? psiReference.getCanonicalText() : null)) && CombinedSimpleNameRegistry.INSTANCE.isPackageIndexed(qualifierText)) {
                    String string2 = expression.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    String string3 = JvmUtilsKt.withoutWhitespace(string2);
                    this.addQualifications((PsiElement)expression, string3, false, false, (Function1<? super PsiElement, Boolean>)((Function1)FullyQualifyAndImportVisitor::visitReferenceExpression$lambda$8), (Function1<? super AndroidPluginServices.ImportData, Boolean>)((Function1)arg_0 -> FullyQualifyAndImportVisitor.visitReferenceExpression$lambda$9(qualifierText, arg_0)));
                    this.usedPackages.add(qualifierText);
                } else if (!expression.isQualified() && Intrinsics.areEqual((Object)expression, (Object)qualifiedExpressionParent.getQualifier()) || Intrinsics.areEqual((Object)((psiElement3 = expression.getParent()) instanceof PsiCallExpression ? (PsiCallExpression)psiElement3 : null), (Object)qualifiedExpressionParent.getQualifier())) {
                    PsiElement psiElement5 = (PsiElement)expression;
                    String string4 = expression.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                    FullyQualifyAndImportVisitor.addQualifications$default(this, psiElement5, JvmUtilsKt.withoutWhitespace(string4), false, false, null, null, 60, null);
                }
            } else {
                PsiElement psiElement6 = (PsiElement)expression;
                String string = expression.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                FullyQualifyAndImportVisitor.addQualifications$default(this, psiElement6, JvmUtilsKt.withoutWhitespace(string), false, false, null, null, 60, null);
            }
            super.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        private static final boolean addQualifications$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !KtPsiUtilKt.isExtensionDeclaration((PsiElement)it);
        }

        private static final boolean addQualifications$lambda$1(AndroidPluginServices.ImportData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !it.isExtension();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean addQualifications$lambda$2(Function1 $elementFilter, PsiCallExpression $call, PsiElement $reference, PsiElement e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if ((Boolean)$elementFilter.invoke((Object)e) == false) return false;
            if ($call != null) {
                PsiExpressionList psiExpressionList = $call.getArgumentList();
                bl = JvmUtilsKt.areArgumentsCompatible(psiExpressionList != null ? psiExpressionList.getExpressionCount() : 0, e);
            } else {
                bl = true;
            }
            if (!bl) return false;
            if (!JvmUtilsKt.isJavaAnnotationReference($reference)) return true;
            boolean bl2 = JvmUtilsKt.isAnnotationDeclaration(e);
            if (!bl2) return false;
            return true;
        }

        private static final boolean visitReferenceExpression$lambda$8(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return false;
        }

        private static final boolean visitReferenceExpression$lambda$9(String $qualifierText, AndroidPluginServices.ImportData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getImportedItemPackageName(), (Object)$qualifierText);
        }
    }
}

