/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.configuration;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.ChatModelPickerKt;
import com.android.studio.ml.bot.ModelId;
import com.android.studio.ml.bot.configuration.ContextSharingMode;
import com.android.studio.ml.bot.configuration.QueryHistoryEntry;
import com.android.studio.ml.bot.configuration.StudioBotAppSettings;
import com.android.studio.ml.bot.configuration.StudioBotAppSettingsKt;
import com.android.studio.ml.bot.configuration.StudioBotSettingsNotificationService;
import com.android.studio.ml.bot.ui.compose.timeline.querybox.QueryBoxState;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="StudioBotSettings", storages={@Storage(value="studiobot.xml")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0002J\u0012\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u001e\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0 H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R$\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016R$\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006/"}, d2={"Lcom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl$State;", "Lcom/android/studio/ml/bot/configuration/StudioBotAppSettings;", "()V", "value", "Lcom/android/studio/ml/bot/ModelId;", "chatModelId", "getChatModelId", "()Lcom/android/studio/ml/bot/ModelId;", "setChatModelId", "(Lcom/android/studio/ml/bot/ModelId;)V", "Lcom/android/studio/ml/bot/configuration/ContextSharingMode;", "contextSharingMode", "getContextSharingMode", "()Lcom/android/studio/ml/bot/configuration/ContextSharingMode;", "setContextSharingMode", "(Lcom/android/studio/ml/bot/configuration/ContextSharingMode;)V", "", "isAcceptedCurrentTerms", "()Z", "setAcceptedCurrentTerms", "(Z)V", "isCodeCompletionEnabled", "setCodeCompletionEnabled", "isOnboardingCompleted", "setOnboardingCompleted", "isPreviewAttachmentEnabled", "setPreviewAttachmentEnabled", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "queryHistory", "", "Lcom/android/studio/ml/bot/configuration/QueryHistoryEntry;", "getQueryHistory", "()Ljava/util/List;", "clearQueryHistory", "", "notifySettingsChanged", "readContextSharingModeFrom", "rawMode", "", "saveQueryInHistory", "text", "references", "Lcom/android/studio/ml/bot/ui/compose/timeline/querybox/QueryBoxState$InlineReference;", "State", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStudioBotAppSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StudioBotAppSettings.kt\ncom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n25#2:246\n774#3:247\n865#3,2:248\n1053#3:250\n*S KotlinDebug\n*F\n+ 1 StudioBotAppSettings.kt\ncom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl\n*L\n90#1:246\n189#1:247\n189#1:248,2\n190#1:250\n*E\n"})
public final class StudioBotAppSettingsImpl
extends SimplePersistentStateComponent<State>
implements StudioBotAppSettings {
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;

    public StudioBotAppSettingsImpl() {
        super((BaseState)new State());
        StudioBotAppSettingsImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(StudioBotAppSettingsImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    public boolean isCodeCompletionEnabled() {
        return ((State)this.getState()).getEnableCodeCompletion();
    }

    @Override
    public void setCodeCompletionEnabled(boolean value) {
        this.logger.info("enableCodeCompletion being set to " + value);
        ((State)this.getState()).setEnableCodeCompletion(value);
        this.notifySettingsChanged();
    }

    @Override
    public boolean isPreviewAttachmentEnabled() {
        return ((State)this.getState()).isPreviewAttachingEnabled();
    }

    @Override
    public void setPreviewAttachmentEnabled(boolean value) {
        this.logger.info("isPreviewAttachingEnabled being set to " + value);
        ((State)this.getState()).setPreviewAttachingEnabled(value);
        this.notifySettingsChanged();
    }

    @Override
    @NotNull
    public ModelId getChatModelId() {
        Object object = ((State)this.getState()).getChatModelId();
        if (object == null || (object = StudioBotAppSettingsKt.toModelId(object)) == null) {
            object = ChatModelPickerKt.getDefaultModelId();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setChatModelId(@NotNull ModelId value) {
        void $this$_set_chatModelId__u24lambda_u240;
        State.ModelIdState modelIdState;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.logger.info("chatModelId set to " + value);
        State.ModelIdState modelIdState2 = modelIdState = new State.ModelIdState();
        State state2 = (State)this.getState();
        boolean bl = false;
        $this$_set_chatModelId__u24lambda_u240.setId(value.getId());
        $this$_set_chatModelId__u24lambda_u240.setProviderName(value.getProviderName());
        $this$_set_chatModelId__u24lambda_u240.setGroupName(value.getGroupName());
        $this$_set_chatModelId__u24lambda_u240.setFeedbackSupported(value.isFeedbackSupported());
        state2.setChatModelId(modelIdState);
        this.notifySettingsChanged();
    }

    @Override
    @NotNull
    public ContextSharingMode getContextSharingMode() {
        ContextSharingMode newMode = ((State)this.getState()).getContextSharingModeV2();
        if (newMode != null) {
            return newMode;
        }
        String string = ((State)this.getState()).getContextSharingMode();
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return ContextSharingMode.Unknown;
        }
        String oldMode = string;
        ContextSharingMode parsedOldMode = this.readContextSharingModeFrom(oldMode);
        if (parsedOldMode != ContextSharingMode.Unknown) {
            this.logger.debug("Migrating old/invalid ContextSharingMode value '" + oldMode + "' to '" + parsedOldMode + "'");
            ((State)this.getState()).setContextSharingModeV2(parsedOldMode);
            ((State)this.getState()).setContextSharingMode(null);
        }
        return parsedOldMode;
    }

    @Override
    public void setContextSharingMode(@NotNull ContextSharingMode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.logger.info("contextSharingMode being set to " + value);
        ((State)this.getState()).setContextSharingModeV2(value);
        ((State)this.getState()).setContextSharingMode(null);
        this.notifySettingsChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ContextSharingMode readContextSharingModeFrom(String rawMode) {
        ContextSharingMode contextSharingMode;
        block21: {
            block20: {
                String string;
                block19: {
                    block18: {
                        String string2;
                        block17: {
                            block16: {
                                String string3;
                                if (Intrinsics.areEqual((Object)rawMode, (Object)"AlwaysShare")) break block16;
                                String string4 = rawMode;
                                if (string4 != null) {
                                    String string5 = string4.toUpperCase(Locale.ROOT);
                                    string3 = string5;
                                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                                } else {
                                    string3 = null;
                                }
                                if (!Intrinsics.areEqual((Object)string3, (Object)"ALWAYS_SHARE")) break block17;
                            }
                            contextSharingMode = ContextSharingMode.AlwaysShare;
                            return contextSharingMode;
                        }
                        if (Intrinsics.areEqual((Object)rawMode, (Object)"AskPerProject")) break block18;
                        String string6 = rawMode;
                        if (string6 != null) {
                            String string7 = string6.toUpperCase(Locale.ROOT);
                            string2 = string7;
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toUpperCase(...)");
                        } else {
                            string2 = null;
                        }
                        if (!Intrinsics.areEqual((Object)string2, (Object)"ASK_PER_PROJECT")) break block19;
                    }
                    contextSharingMode = ContextSharingMode.AskPerProject;
                    return contextSharingMode;
                }
                if (Intrinsics.areEqual((Object)rawMode, (Object)"NeverShare")) break block20;
                String string8 = rawMode;
                if (string8 != null) {
                    String string9 = string8.toUpperCase(Locale.ROOT);
                    string = string9;
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toUpperCase(...)");
                } else {
                    string = null;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"NEVER_SHARE")) break block21;
            }
            contextSharingMode = ContextSharingMode.NeverShare;
            return contextSharingMode;
        }
        if (rawMode == null) {
            contextSharingMode = ContextSharingMode.Unknown;
            return contextSharingMode;
        }
        this.logger.warn("Unsupported Context sharing mode found: '" + rawMode + "'. Defaulting to AskPerProject...");
        contextSharingMode = ContextSharingMode.AskPerProject;
        return contextSharingMode;
    }

    @Override
    public boolean isOnboardingCompleted() {
        return ((State)this.getState()).getOnboardedVersion() >= 3;
    }

    @Override
    public void setOnboardingCompleted(boolean value) {
        int version = value ? 3 : 0;
        this.logger.info("onboardedVersion being set to " + version);
        ((State)this.getState()).setOnboardedVersion(version);
        this.notifySettingsChanged();
    }

    @Override
    public boolean isAcceptedCurrentTerms() {
        return ((State)this.getState()).getAcceptedTermsVersion() >= 3;
    }

    @Override
    public void setAcceptedCurrentTerms(boolean value) {
        int version = value ? 3 : 0;
        this.logger.info("acceptedTermsVersion being set to " + version);
        ((State)this.getState()).setAcceptedTermsVersion(version);
        this.notifySettingsChanged();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<QueryHistoryEntry> getQueryHistory() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ((State)this.getState()).getQueryHistory();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            QueryHistoryEntry it = (QueryHistoryEntry)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.takeLast((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                QueryHistoryEntry it = (QueryHistoryEntry)a;
                boolean bl = false;
                Comparable comparable = it.getTimestamp();
                it = (QueryHistoryEntry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getTimestamp());
            }
        }), (int)8);
    }

    @Override
    public void saveQueryInHistory(@NotNull String text2, @NotNull List<QueryBoxState.InlineReference> references2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(references2, (String)"references");
        ((State)this.getState()).getQueryHistory().add(0, new QueryHistoryEntry(System.currentTimeMillis(), text2, references2));
        this.notifySettingsChanged();
    }

    @Override
    public void clearQueryHistory() {
        ((State)this.getState()).getQueryHistory().clear();
        this.notifySettingsChanged();
    }

    private final void notifySettingsChanged() {
        try {
            StudioBotSettingsNotificationService.Companion.getInstance().notifySettingsUpdated();
        }
        catch (Exception e) {
            this.logger.error("Unable to notify of settings changes", (Throwable)e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR/\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R/\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0003\u001a\u0004\u0018\u00010\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u000b\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R/\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0003\u001a\u0004\u0018\u00010\u001a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u000b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR+\u0010\"\u001a\u00020!2\u0006\u0010\u0003\u001a\u00020!8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u000b\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R/\u0010(\u001a\u0004\u0018\u00010\u00132\b\u0010\u0003\u001a\u0004\u0018\u00010\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010\u000b\u001a\u0004\b)\u0010\u0016\"\u0004\b*\u0010\u0018R+\u0010,\u001a\u00020!2\u0006\u0010\u0003\u001a\u00020!8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b.\u0010\u000b\u001a\u0004\b,\u0010$\"\u0004\b-\u0010&R+\u0010/\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b2\u0010\u000b\u001a\u0004\b0\u0010\u0007\"\u0004\b1\u0010\tR7\u00105\u001a\b\u0012\u0004\u0012\u000204032\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u000204038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b:\u0010\u000b\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lcom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl$State;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "acceptedTermsVersion", "getAcceptedTermsVersion", "()I", "setAcceptedTermsVersion", "(I)V", "acceptedTermsVersion$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lcom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl$State$ModelIdState;", "chatModelId", "getChatModelId", "()Lcom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl$State$ModelIdState;", "setChatModelId", "(Lcom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl$State$ModelIdState;)V", "chatModelId$delegate", "", "contextSharingMode", "getContextSharingMode", "()Ljava/lang/String;", "setContextSharingMode", "(Ljava/lang/String;)V", "contextSharingMode$delegate", "Lcom/android/studio/ml/bot/configuration/ContextSharingMode;", "contextSharingModeV2", "getContextSharingModeV2", "()Lcom/android/studio/ml/bot/configuration/ContextSharingMode;", "setContextSharingModeV2", "(Lcom/android/studio/ml/bot/configuration/ContextSharingMode;)V", "contextSharingModeV2$delegate", "", "enableCodeCompletion", "getEnableCodeCompletion", "()Z", "setEnableCodeCompletion", "(Z)V", "enableCodeCompletion$delegate", "geminiApiKey", "getGeminiApiKey", "setGeminiApiKey", "geminiApiKey$delegate", "isPreviewAttachingEnabled", "setPreviewAttachingEnabled", "isPreviewAttachingEnabled$delegate", "onboardedVersion", "getOnboardedVersion", "setOnboardedVersion", "onboardedVersion$delegate", "", "Lcom/android/studio/ml/bot/configuration/QueryHistoryEntry;", "queryHistory", "getQueryHistory", "()Ljava/util/List;", "setQueryHistory", "(Ljava/util/List;)V", "queryHistory$delegate", "ModelIdState", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nStudioBotAppSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StudioBotAppSettings.kt\ncom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl$State\n+ 2 BaseState.kt\ncom/intellij/openapi/components/BaseState\n*L\n1#1,245:1\n88#2:246\n*S KotlinDebug\n*F\n+ 1 StudioBotAppSettings.kt\ncom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl$State\n*L\n216#1:246\n*E\n"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty contextSharingMode$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty contextSharingModeV2$delegate;
        @NotNull
        private final ReadWriteProperty enableCodeCompletion$delegate;
        @NotNull
        private final ReadWriteProperty onboardedVersion$delegate;
        @NotNull
        private final ReadWriteProperty acceptedTermsVersion$delegate;
        @NotNull
        private final ReadWriteProperty queryHistory$delegate;
        @NotNull
        private final ReadWriteProperty isPreviewAttachingEnabled$delegate;
        @NotNull
        private final ReadWriteProperty geminiApiKey$delegate;
        @NotNull
        private final ReadWriteProperty chatModelId$delegate;
        public static final int $stable;

        public State() {
            BaseState this_$iv = this;
            boolean $i$f$enum = false;
            this.contextSharingModeV2$delegate = this_$iv.doEnum(null, ContextSharingMode.class).provideDelegate((Object)this, $$delegatedProperties[1]);
            this.enableCodeCompletion$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[2]);
            this.onboardedVersion$delegate = this.property(0).provideDelegate((Object)this, $$delegatedProperties[3]);
            this.acceptedTermsVersion$delegate = this.property(0).provideDelegate((Object)this, $$delegatedProperties[4]);
            this.queryHistory$delegate = this.list().provideDelegate((Object)this, $$delegatedProperties[5]);
            this.isPreviewAttachingEnabled$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[6]);
            this.geminiApiKey$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[7]);
            this.chatModelId$delegate = this.property().provideDelegate((Object)this, $$delegatedProperties[8]);
        }

        @Nullable
        public final String getContextSharingMode() {
            return (String)this.contextSharingMode$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setContextSharingMode(@Nullable String string) {
            this.contextSharingMode$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
        }

        @Nullable
        public final ContextSharingMode getContextSharingModeV2() {
            return (ContextSharingMode)((Object)this.contextSharingModeV2$delegate.getValue((Object)this, $$delegatedProperties[1]));
        }

        public final void setContextSharingModeV2(@Nullable ContextSharingMode contextSharingMode) {
            this.contextSharingModeV2$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)contextSharingMode);
        }

        public final boolean getEnableCodeCompletion() {
            return (Boolean)this.enableCodeCompletion$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public final void setEnableCodeCompletion(boolean bl) {
            this.enableCodeCompletion$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
        }

        public final int getOnboardedVersion() {
            return ((Number)this.onboardedVersion$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
        }

        public final void setOnboardedVersion(int n) {
            this.onboardedVersion$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)n);
        }

        public final int getAcceptedTermsVersion() {
            return ((Number)this.acceptedTermsVersion$delegate.getValue((Object)this, $$delegatedProperties[4])).intValue();
        }

        public final void setAcceptedTermsVersion(int n) {
            this.acceptedTermsVersion$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)n);
        }

        @NotNull
        public final List<QueryHistoryEntry> getQueryHistory() {
            return (List)this.queryHistory$delegate.getValue((Object)this, $$delegatedProperties[5]);
        }

        public final void setQueryHistory(@NotNull List<QueryHistoryEntry> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.queryHistory$delegate.setValue((Object)this, $$delegatedProperties[5], list);
        }

        public final boolean isPreviewAttachingEnabled() {
            return (Boolean)this.isPreviewAttachingEnabled$delegate.getValue((Object)this, $$delegatedProperties[6]);
        }

        public final void setPreviewAttachingEnabled(boolean bl) {
            this.isPreviewAttachingEnabled$delegate.setValue((Object)this, $$delegatedProperties[6], (Object)bl);
        }

        @Nullable
        public final String getGeminiApiKey() {
            return (String)this.geminiApiKey$delegate.getValue((Object)this, $$delegatedProperties[7]);
        }

        public final void setGeminiApiKey(@Nullable String string) {
            this.geminiApiKey$delegate.setValue((Object)this, $$delegatedProperties[7], (Object)string);
        }

        @Nullable
        public final ModelIdState getChatModelId() {
            return (ModelIdState)((Object)this.chatModelId$delegate.getValue((Object)this, $$delegatedProperties[8]));
        }

        public final void setChatModelId(@Nullable ModelIdState modelIdState) {
            this.chatModelId$delegate.setValue((Object)this, $$delegatedProperties[8], (Object)modelIdState);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "contextSharingMode", "getContextSharingMode()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "contextSharingModeV2", "getContextSharingModeV2()Lcom/android/studio/ml/bot/configuration/ContextSharingMode;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "enableCodeCompletion", "getEnableCodeCompletion()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "onboardedVersion", "getOnboardedVersion()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "acceptedTermsVersion", "getAcceptedTermsVersion()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "queryHistory", "getQueryHistory()Ljava/util/List;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "isPreviewAttachingEnabled", "isPreviewAttachingEnabled()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "geminiApiKey", "getGeminiApiKey()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "chatModelId", "getChatModelId()Lcom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl$State$ModelIdState;", 0)))};
            $$delegatedProperties = kPropertyArray;
            $stable = 8;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R/\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR/\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\tR+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R/\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u000b\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/android/studio/ml/bot/configuration/StudioBotAppSettingsImpl$State$ModelIdState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "groupName", "getGroupName", "()Ljava/lang/String;", "setGroupName", "(Ljava/lang/String;)V", "groupName$delegate", "Lkotlin/properties/ReadWriteProperty;", "id", "getId", "setId", "id$delegate", "", "isFeedbackSupported", "()Z", "setFeedbackSupported", "(Z)V", "isFeedbackSupported$delegate", "providerName", "getProviderName", "setProviderName", "providerName$delegate", "aiplugin.core.aicore"})
        @StabilityInferred(parameters=0)
        public static final class ModelIdState
        extends BaseState {
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            @NotNull
            private final ReadWriteProperty id$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
            @NotNull
            private final ReadWriteProperty providerName$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[1]);
            @NotNull
            private final ReadWriteProperty groupName$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[2]);
            @NotNull
            private final ReadWriteProperty isFeedbackSupported$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[3]);
            public static final int $stable;

            @Nullable
            public final String getId() {
                return (String)this.id$delegate.getValue((Object)this, $$delegatedProperties[0]);
            }

            public final void setId(@Nullable String string) {
                this.id$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
            }

            @Nullable
            public final String getProviderName() {
                return (String)this.providerName$delegate.getValue((Object)this, $$delegatedProperties[1]);
            }

            public final void setProviderName(@Nullable String string) {
                this.providerName$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
            }

            @Nullable
            public final String getGroupName() {
                return (String)this.groupName$delegate.getValue((Object)this, $$delegatedProperties[2]);
            }

            public final void setGroupName(@Nullable String string) {
                this.groupName$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)string);
            }

            public final boolean isFeedbackSupported() {
                return (Boolean)this.isFeedbackSupported$delegate.getValue((Object)this, $$delegatedProperties[3]);
            }

            public final void setFeedbackSupported(boolean bl) {
                this.isFeedbackSupported$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)bl);
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ModelIdState.class, "id", "getId()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ModelIdState.class, "providerName", "getProviderName()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ModelIdState.class, "groupName", "getGroupName()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ModelIdState.class, "isFeedbackSupported", "isFeedbackSupported()Z", 0)))};
                $$delegatedProperties = kPropertyArray;
                $stable = 8;
            }
        }
    }
}

