/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.action;

import com.android.studio.ml.bot.action.CodeFormatter;
import com.android.studio.ml.bot.action.CodeInsertionUtils;
import com.android.studio.ml.bot.parse.FileRange;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u001f\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\bH\u0016\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/bot/action/JavaFormatter;", "Lcom/android/studio/ml/bot/action/CodeFormatter;", "<init>", "()V", "formatRange", "Lcom/android/studio/ml/bot/parse/FileRange;", "fileRange", "formatElement", "T", "Lcom/intellij/psi/PsiElement;", "element", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "shortenJavaReferencesInRange", "", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.lang.kotlin"})
public final class JavaFormatter
extends CodeFormatter {
    @NotNull
    public static final JavaFormatter INSTANCE = new JavaFormatter();

    private JavaFormatter() {
    }

    @Override
    @NotNull
    public FileRange formatRange(@NotNull FileRange fileRange) {
        FileRange fileRange2;
        Intrinsics.checkNotNullParameter((Object)fileRange, (String)"fileRange");
        FileRange $this$formatRange_u24lambda_u240 = fileRange;
        boolean bl = false;
        Project project2 = $this$formatRange_u24lambda_u240.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        Document document = PsiDocumentManager.getInstance((Project)project3).getDocument($this$formatRange_u24lambda_u240.getFile());
        if (document == null) {
            return $this$formatRange_u24lambda_u240;
        }
        Document doc = document;
        RangeMarker rangeMarker = doc.createRangeMarker($this$formatRange_u24lambda_u240.getRange());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker rangeMarker2 = rangeMarker;
        CodeStyleManager.getInstance((Project)project3).reformatRange((PsiElement)$this$formatRange_u24lambda_u240.getFile(), $this$formatRange_u24lambda_u240.getRange().getStartOffset(), $this$formatRange_u24lambda_u240.getRange().getEndOffset());
        if (rangeMarker2.isValid()) {
            PsiFile psiFile2 = $this$formatRange_u24lambda_u240.getFile();
            TextRange textRange = rangeMarker2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            INSTANCE.shortenJavaReferencesInRange(psiFile2, textRange, project3);
        }
        if (rangeMarker2.isValid()) {
            PsiFile psiFile3 = $this$formatRange_u24lambda_u240.getFile();
            TextRange textRange = rangeMarker2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            fileRange2 = new FileRange(psiFile3, textRange);
        } else {
            fileRange2 = $this$formatRange_u24lambda_u240;
        }
        return fileRange2;
    }

    @Override
    @NotNull
    public <T extends PsiElement> T formatElement(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        PsiElement psiElement = CodeStyleManager.getInstance((Project)project3).reformat(element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"reformat(...)");
        PsiElement formattedElement = psiElement;
        PsiElement psiElement2 = JavaCodeStyleManager.getInstance((Project)project3).shortenClassReferences(formattedElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"shortenClassReferences(...)");
        PsiElement shortenedElement = psiElement2;
        return (T)shortenedElement;
    }

    private final void shortenJavaReferencesInRange(PsiFile file, TextRange range, Project project2) {
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        for (PsiElement element : CodeInsertionUtils.INSTANCE.elementsInRange(file, range)) {
            javaCodeStyleManager.shortenClassReferences(element);
        }
    }
}

