/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.backends.local.openai;

import com.android.studio.ml.backends.local.ChatApi;
import com.android.studio.ml.backends.local.openai.OpenAIToolsKt;
import com.android.studio.ml.backends.local.openai.OpenAiChatImpl;
import com.android.studio.ml.backends.local.openai.ToolCallAssembler;
import com.android.studio.ml.prompting.PromptUtilsKt;
import com.android.tools.idea.studiobot.Content;
import com.android.tools.idea.studiobot.GenerationConfig;
import com.android.tools.idea.studiobot.MimeType;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.stream.MalformedJsonException;
import com.openai.client.OpenAIClientAsync;
import com.openai.core.JsonValue;
import com.openai.core.http.AsyncStreamResponse;
import com.openai.models.chat.completions.ChatCompletionAssistantMessageParam;
import com.openai.models.chat.completions.ChatCompletionChunk;
import com.openai.models.chat.completions.ChatCompletionContentPart;
import com.openai.models.chat.completions.ChatCompletionContentPartImage;
import com.openai.models.chat.completions.ChatCompletionContentPartText;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.chat.completions.ChatCompletionMessageToolCall;
import com.openai.models.chat.completions.ChatCompletionToolChoiceOption;
import com.openai.models.chat.completions.ChatCompletionToolMessageParam;
import com.openai.models.chat.completions.ChatCompletionUserMessageParam;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\nJ\u0014\u0010#\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0014J\f\u0010&\u001a\u00020'*\u00020(H\u0002J\f\u0010&\u001a\u00020'*\u00020)H\u0002J\f\u0010*\u001a\u00020'*\u00020+H\u0002J\u0016\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0014H\u0002J\u0014\u00103\u001a\u00020\n2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/studio/ml/backends/local/openai/OpenAiChatImpl;", "Lcom/android/studio/ml/backends/local/ChatApi;", "client", "Lcom/openai/client/OpenAIClientAsync;", "<init>", "(Lcom/openai/client/OpenAIClientAsync;)V", "generateContent", "Lkotlinx/coroutines/flow/Flow;", "Lcom/android/tools/idea/studiobot/Content;", "modelId", "", "prompt", "Lcom/android/tools/idea/studiobot/prompts/Prompt;", "config", "Lcom/android/tools/idea/studiobot/GenerationConfig;", "createParams", "Lcom/openai/models/chat/completions/ChatCompletionCreateParams;", "setBasePromptMessage", "", "allMessages", "", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Message;", "requestBuilder", "Lcom/openai/models/chat/completions/ChatCompletionCreateParams$Builder;", "makeFunctionCallMessage", "Lcom/openai/models/chat/completions/ChatCompletionAssistantMessageParam;", "message", "Lcom/android/tools/idea/studiobot/prompts/Prompt$FunctionCallMessage;", "makeFunctionResponseMessage", "Lcom/openai/models/chat/completions/ChatCompletionToolMessageParam;", "Lcom/android/tools/idea/studiobot/prompts/Prompt$FunctionResponseMessage;", "toolCallId", "defaultSystemMessage", "getDefaultSystemMessage", "()Ljava/lang/String;", "fileContext", "files", "Lcom/android/tools/idea/studiobot/prompts/Prompt$ContextFile;", "toContentPart", "Lcom/openai/models/chat/completions/ChatCompletionContentPart;", "Lcom/android/tools/idea/studiobot/prompts/Prompt$TextChunk;", "Lcom/android/tools/idea/studiobot/prompts/Prompt$CodeChunk;", "toImageContentPart", "Lcom/android/tools/idea/studiobot/prompts/Prompt$BlobChunk;", "supportedImageMimeTypes", "", "Lcom/android/tools/idea/studiobot/MimeType;", "toUserMessage", "Lcom/openai/models/chat/completions/ChatCompletionUserMessageParam$Content;", "chunks", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Chunk;", "chunksToString", "Companion", "aiplugin.backends.local"})
@SourceDebugExtension(value={"SMAP\nOpenAIChatImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAIChatImpl.kt\ncom/android/studio/ml/backends/local/openai/OpenAiChatImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n2642#2:392\n774#2:394\n865#2,2:395\n1557#2:397\n1628#2,3:398\n1557#2:402\n1628#2,3:403\n1#3:393\n1#3:401\n*S KotlinDebug\n*F\n+ 1 OpenAIChatImpl.kt\ncom/android/studio/ml/backends/local/openai/OpenAiChatImpl\n*L\n109#1:392\n129#1:394\n129#1:395,2\n138#1:397\n138#1:398,3\n278#1:402\n278#1:403,3\n109#1:393\n*E\n"})
public final class OpenAiChatImpl
implements ChatApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OpenAIClientAsync client;
    @NotNull
    private final String defaultSystemMessage;
    @NotNull
    private final Set<MimeType> supportedImageMimeTypes;
    @NotNull
    public static final String SEND_AS_SYSTEM_MESSAGE_PROPERTY = "studio.ml.openai.chat.sendAsSystemMessage";
    @NotNull
    private static final Gson GSON;

    public OpenAiChatImpl(@NotNull OpenAIClientAsync client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.defaultSystemMessage = "The assistant is embedded inside Android Studio, the IDE for developing\nAndroid applications.\n\nIt should give concise answers to very simple questions, but provide thorough responses\nto more complex and open ended questions. It adopts a tone used in the official\nAndroid developer documentation at developer.android.com.\n\nIt provides relevant code snippets where applicable. Unless otherwise requested by\nthe user, code snippets are offered in Kotlin and use the modern Jetpack libraries\nand patterns, following modern Android development practices.\n\nWhile the assistant is embedded inside the IDE, it cannot actually see the user's\ncode unless users explicitly share it with the assistant. The IDE provides settings\nthat allow the user to control whether source code is visible to the assistant.\nThe IDE also allows more fine grained privacy controls via the use of a .aiexclude\nfile.\n";
        Object[] objectArray = new MimeType[]{MimeType.box-impl(MimeType.Companion.getJPEG-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getPNG-i_3W7CY()), MimeType.box-impl(MimeType.Companion.getWEBP-i_3W7CY())};
        this.supportedImageMimeTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Flow<Content> generateContent(@NotNull String modelId, @NotNull Prompt prompt2, @NotNull GenerationConfig config2) {
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        ChatCompletionCreateParams completionParams = this.createParams(modelId, prompt2, config2);
        AsyncStreamResponse streamResponse = this.client.chat().completions().createStreaming(completionParams);
        return Companion.assembleResponseChunks((Flow<ChatCompletionChunk.Choice.Delta>)FlowKt.flowOn((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super ChatCompletionChunk.Choice.Delta>, Continuation<? super Unit>, Object>((AsyncStreamResponse<ChatCompletionChunk>)streamResponse, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AsyncStreamResponse<ChatCompletionChunk> $streamResponse;
            {
                this.$streamResponse = $streamResponse;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        Ref.ObjectRef responseError = new Ref.ObjectRef();
                        AsyncStreamResponse.Handler<ChatCompletionChunk> responseHandler2 = new AsyncStreamResponse.Handler<ChatCompletionChunk>((ProducerScope<? super ChatCompletionChunk.Choice.Delta>)$this$callbackFlow, (Ref.ObjectRef<Throwable>)responseError){
                            private final Function1<ChatCompletionChunk.Choice, Boolean> firstChoiceSelector;
                            final /* synthetic */ ProducerScope<ChatCompletionChunk.Choice.Delta> $$this$callbackFlow;
                            final /* synthetic */ Ref.ObjectRef<Throwable> $responseError;
                            {
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                this.$responseError = $responseError;
                                this.firstChoiceSelector = generateContent.responseHandler.1::firstChoiceSelector$lambda$0;
                            }

                            public final Function1<ChatCompletionChunk.Choice, Boolean> getFirstChoiceSelector() {
                                return this.firstChoiceSelector;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void onNext(ChatCompletionChunk completion) {
                                block2: {
                                    ChatCompletionChunk.Choice choice;
                                    Object v0;
                                    block1: {
                                        void $this$firstOrNull$iv;
                                        Intrinsics.checkNotNullParameter((Object)completion, (String)"completion");
                                        Iterable iterable = completion.choices();
                                        Function1<ChatCompletionChunk.Choice, Boolean> predicate$iv = this.firstChoiceSelector;
                                        boolean $i$f$firstOrNull = false;
                                        for (T element$iv : $this$firstOrNull$iv) {
                                            if (!((Boolean)predicate$iv.invoke(element$iv)).booleanValue()) continue;
                                            v0 = element$iv;
                                            break block1;
                                        }
                                        v0 = null;
                                    }
                                    if ((choice = (ChatCompletionChunk.Choice)v0) == null || (choice = choice.delta()) == null) break block2;
                                    ChatCompletionChunk.Choice choice2 = choice;
                                    ProducerScope<ChatCompletionChunk.Choice.Delta> producerScope = this.$$this$callbackFlow;
                                    ChatCompletionChunk.Choice it = choice2;
                                    boolean bl = false;
                                    ChannelResult.box-impl((Object)ChannelsKt.trySendBlocking((SendChannel)((SendChannel)producerScope), (Object)it));
                                }
                            }

                            public void onComplete(Optional<Throwable> error) {
                                Intrinsics.checkNotNullParameter(error, (String)"error");
                                error.ifPresent(arg_0 -> generateContent.responseHandler.1.onComplete$lambda$3(arg_0 -> generateContent.responseHandler.1.onComplete$lambda$2(this.$responseError, arg_0), arg_0));
                                SendChannel.DefaultImpls.close$default((SendChannel)this.$$this$callbackFlow.getChannel(), null, (int)1, null);
                            }

                            private static final boolean firstChoiceSelector$lambda$0(ChatCompletionChunk.Choice it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return it.index() == 0L;
                            }

                            private static final Unit onComplete$lambda$2(Ref.ObjectRef $responseError, Throwable it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                $responseError.element = it;
                                return Unit.INSTANCE;
                            }

                            private static final void onComplete$lambda$3(Function1 $tmp0, Object p0) {
                                $tmp0.invoke(p0);
                            }
                        };
                        this.$streamResponse.subscribe((AsyncStreamResponse.Handler)responseHandler2);
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, () -> generateContent.1.invokeSuspend$lambda$1(this.$streamResponse, responseError), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super ChatCompletionChunk.Choice.Delta> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$1(AsyncStreamResponse $streamResponse, Ref.ObjectRef $responseError) {
                $streamResponse.close();
                Throwable throwable = (Throwable)$responseError.element;
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw it;
                }
                return Unit.INSTANCE;
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getIO())));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final ChatCompletionCreateParams createParams(@NotNull String modelId, @NotNull Prompt prompt2, @NotNull GenerationConfig config2) {
        void $this$filterTo$iv$iv;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        ChatCompletionCreateParams.Builder params = ChatCompletionCreateParams.Companion.builder().model(modelId);
        List<Prompt.Message> messages = prompt2.getMessages();
        String lastToolCallId = null;
        this.setBasePromptMessage(messages, params);
        Iterable $this$onEach$iv = messages;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            Unit unit;
            Prompt.Message it = (Prompt.Message)element$iv;
            boolean bl2 = false;
            Prompt.Message message = it;
            if (message instanceof Prompt.SystemMessage || message instanceof Prompt.RuleMessage) {
                unit = Unit.INSTANCE;
                continue;
            }
            if (message instanceof Prompt.FunctionCallMessage) {
                ChatCompletionAssistantMessageParam functionCall = this.makeFunctionCallMessage((Prompt.FunctionCallMessage)it);
                params.addMessage(functionCall);
                List list = (List)OptionalsKt.getOrNull((Optional)functionCall.toolCalls());
                lastToolCallId = list != null && (list = (ChatCompletionMessageToolCall)CollectionsKt.firstOrNull((List)list)) != null ? list.id() : null;
                unit = Unit.INSTANCE;
                continue;
            }
            if (message instanceof Prompt.FunctionResponseMessage) {
                unit = params.addMessage(this.makeFunctionResponseMessage((Prompt.FunctionResponseMessage)it, lastToolCallId));
                continue;
            }
            if (message instanceof Prompt.ModelMessage) {
                unit = params.addAssistantMessage(this.chunksToString(((Prompt.ModelMessage)it).getChunks()));
                continue;
            }
            if (message instanceof Prompt.ContextMessage) {
                unit = params.addUserMessage(this.fileContext(((Prompt.ContextMessage)it).getFiles()));
                continue;
            }
            if (message instanceof Prompt.MemoryMessage || message instanceof Prompt.UserMessage) {
                unit = params.addUserMessage(this.toUserMessage(it.getChunks()));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Iterable $this$filter$iv = prompt2.getFunctions();
        boolean $i$f$filter = false;
        $this$onEach_u24lambda_u2418$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Prompt.Function p0 = (Prompt.Function)element$iv$iv;
            boolean bl3 = false;
            if (!this.isToolEssential(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tools2 = (List)destination$iv$iv;
        if (!((Collection)tools2).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            params.toolChoice(switch (WhenMappings.$EnumSwitchMapping$0[prompt2.getFunctionCallingMode().ordinal()]) {
                case 1 -> ChatCompletionToolChoiceOption.Auto.AUTO;
                case 2 -> ChatCompletionToolChoiceOption.Auto.REQUIRED;
                case 3 -> ChatCompletionToolChoiceOption.Auto.NONE;
                default -> throw new NoWhenBranchMatchedException();
            });
            $this$filter$iv = tools2;
            ChatCompletionCreateParams.Builder builder = params;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Prompt.Function p0 = (Prompt.Function)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(OpenAIToolsKt.toOpenAiTool$default(p0, false, 2, null));
            }
            builder.tools((List)destination$iv$iv);
        }
        return params.build();
    }

    private final void setBasePromptMessage(List<? extends Prompt.Message> allMessages, ChatCompletionCreateParams.Builder requestBuilder) {
        String string;
        Collection collection;
        List providedSystemChunks = new ArrayList();
        List ruleChunks = new ArrayList();
        for (Prompt.Message message : allMessages) {
            Prompt.Message message2 = message;
            if (message2 instanceof Prompt.SystemMessage) {
                providedSystemChunks.addAll((Collection)((Prompt.SystemMessage)message).getChunks());
                continue;
            }
            if (!(message2 instanceof Prompt.RuleMessage)) continue;
            ruleChunks.addAll((Collection)((Prompt.RuleMessage)message).getChunks());
        }
        Collection collection2 = providedSystemChunks;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)new Prompt.TextChunk(this.defaultSystemMessage, CollectionsKt.emptyList()));
        } else {
            collection = collection2;
        }
        List systemMessageChunks = (List)collection;
        String it = string = this.chunksToString(CollectionsKt.plus((Collection)systemMessageChunks, (Iterable)ruleChunks));
        boolean bl = false;
        String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
        if (string2 == null) {
            return;
        }
        String string3 = string2;
        boolean shouldSendAsSystemMessage = Intrinsics.areEqual((Object)System.getProperty(SEND_AS_SYSTEM_MESSAGE_PROPERTY, "false"), (Object)"true");
        ChatCompletionCreateParams.Builder builder = shouldSendAsSystemMessage ? requestBuilder.addSystemMessage(string3) : requestBuilder.addDeveloperMessage(string3);
    }

    @NotNull
    public final ChatCompletionAssistantMessageParam makeFunctionCallMessage(@NotNull Prompt.FunctionCallMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String toolCallId = message.getName();
        ChatCompletionMessageToolCall.Builder builder = ChatCompletionMessageToolCall.Companion.builder().id(toolCallId);
        ChatCompletionMessageToolCall.Function.Builder builder2 = ChatCompletionMessageToolCall.Function.Companion.builder().name(message.getName());
        String string = GSON.toJson(message.getArgs());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        ChatCompletionMessageToolCall toolCall = builder.function(builder2.arguments(string).build()).type(JsonValue.Companion.from((Object)"function")).build();
        return ChatCompletionAssistantMessageParam.Companion.builder().addToolCall(toolCall).build();
    }

    @NotNull
    public final ChatCompletionToolMessageParam makeFunctionResponseMessage(@NotNull Prompt.FunctionResponseMessage message, @Nullable String toolCallId) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ChatCompletionToolMessageParam.Builder builder = ChatCompletionToolMessageParam.Companion.builder();
        String string = toolCallId;
        if (string == null) {
            string = message.getName();
        }
        return builder.toolCallId(string).content(message.getResponse()).build();
    }

    @NotNull
    public final String getDefaultSystemMessage() {
        return this.defaultSystemMessage;
    }

    @NotNull
    public final String fileContext(@NotNull List<Prompt.ContextFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return CollectionsKt.joinToString$default((Iterable)files, null, null, null, (int)0, null, OpenAiChatImpl::fileContext$lambda$3, (int)31, null);
    }

    private final ChatCompletionContentPart toContentPart(Prompt.TextChunk $this$toContentPart) {
        String nonEmptyText = StringsKt.isBlank((CharSequence)$this$toContentPart.getText()) ? " " : ((Object)StringsKt.trim((CharSequence)$this$toContentPart.getText())).toString();
        return ChatCompletionContentPart.Companion.ofText(ChatCompletionContentPartText.Companion.builder().text(nonEmptyText).build());
    }

    private final ChatCompletionContentPart toContentPart(Prompt.CodeChunk $this$toContentPart) {
        ChatCompletionContentPartText.Builder builder = ChatCompletionContentPartText.Companion.builder();
        String string = PromptUtilsKt.queryString($this$toContentPart);
        if (string == null) {
            string = "";
        }
        return ChatCompletionContentPart.Companion.ofText(builder.text(string).build());
    }

    private final ChatCompletionContentPart toImageContentPart(Prompt.BlobChunk $this$toImageContentPart) {
        String base64Data = "data:" + MimeType.toString-impl($this$toImageContentPart.getMimeType-i_3W7CY()) + ";base64," + Base64.getEncoder().encodeToString($this$toImageContentPart.getData());
        ChatCompletionContentPartImage.ImageUrl imageUrlPart = ChatCompletionContentPartImage.ImageUrl.Companion.builder().url(base64Data).build();
        return ChatCompletionContentPart.Companion.ofImageUrl(ChatCompletionContentPartImage.Companion.builder().imageUrl(imageUrlPart).build());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ChatCompletionUserMessageParam.Content toUserMessage(List<? extends Prompt.Chunk> chunks) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = chunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatCompletionContentPart chatCompletionContentPart;
            void chunk;
            Prompt.Chunk chunk2 = (Prompt.Chunk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_11 = chunk;
            if (var12_11 instanceof Prompt.TextChunk) {
                chatCompletionContentPart = this.toContentPart((Prompt.TextChunk)chunk);
            } else if (var12_11 instanceof Prompt.CodeChunk) {
                chatCompletionContentPart = this.toContentPart((Prompt.CodeChunk)chunk);
            } else {
                if (!(var12_11 instanceof Prompt.BlobChunk)) throw new NoWhenBranchMatchedException();
                if (!this.supportedImageMimeTypes.contains(MimeType.box-impl(((Prompt.BlobChunk)chunk).getMimeType-i_3W7CY()))) throw new IllegalArgumentException("BlobChunk type not supported: " + MimeType.toString-impl(((Prompt.BlobChunk)chunk).getMimeType-i_3W7CY()));
                chatCompletionContentPart = this.toImageContentPart((Prompt.BlobChunk)chunk);
            }
            collection.add(chatCompletionContentPart);
        }
        List parts = (List)destination$iv$iv;
        return ChatCompletionUserMessageParam.Content.Companion.ofArrayOfContentParts(parts);
    }

    @NotNull
    public final String chunksToString(@NotNull List<? extends Prompt.Chunk> chunks) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        String result2 = CollectionsKt.joinToString$default((Iterable)chunks, (CharSequence)"\n", null, null, (int)0, null, OpenAiChatImpl::chunksToString$lambda$5, (int)30, null);
        result2 = ((Object)StringsKt.trim((CharSequence)result2)).toString();
        if (((CharSequence)result2).length() == 0) {
            result2 = " ";
        }
        return result2;
    }

    @Override
    public boolean isToolEssential(@NotNull Prompt.Function function) {
        return ChatApi.super.isToolEssential(function);
    }

    private static final CharSequence fileContext$lambda$3(Prompt.ContextFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getVirtualFile().getPath();
        byte[] byArray = it.getVirtualFile().contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        return StringsKt.trimMargin$default((String)("\n      |Consider the queries below in the context of the following files.\n      |\n      |File path: " + string + "\n      |File Contents:\n      |```\n      |" + StringsKt.decodeToString((byte[])byArray) + "\n      |```\n      |\n    "), null, (int)1, null);
    }

    private static final CharSequence chunksToString$lambda$5(Prompt.Chunk it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Prompt.Chunk chunk = it;
        if (chunk instanceof Prompt.TextChunk) {
            charSequence = ((Prompt.TextChunk)it).getText();
        } else {
            if (chunk instanceof Prompt.BlobChunk) {
                throw new IllegalArgumentException("BlobChunk type not supported: " + MimeType.toString-impl(((Prompt.BlobChunk)it).getMimeType-i_3W7CY()));
            }
            if (chunk instanceof Prompt.CodeChunk) {
                String string = PromptUtilsKt.queryString(it);
                if (string == null) {
                    string = "";
                }
                charSequence = string;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return charSequence;
    }

    static {
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\b\u0012\u0004\u0012\u00020\r0\u000bJ\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/backends/local/openai/OpenAiChatImpl$Companion;", "", "<init>", "()V", "SEND_AS_SYSTEM_MESSAGE_PROPERTY", "", "GSON", "Lcom/google/gson/Gson;", "getGSON$aiplugin_backends_local", "()Lcom/google/gson/Gson;", "assembleResponseChunks", "Lkotlinx/coroutines/flow/Flow;", "Lcom/android/tools/idea/studiobot/Content;", "Lcom/openai/models/chat/completions/ChatCompletionChunk$Choice$Delta;", "parseArguments", "", "rawArguments", "isValidJson", "", "s", "aiplugin.backends.local"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGSON$aiplugin_backends_local() {
            return GSON;
        }

        @NotNull
        public final Flow<Content> assembleResponseChunks(@NotNull Flow<ChatCompletionChunk.Choice.Delta> $this$assembleResponseChunks) {
            Intrinsics.checkNotNullParameter($this$assembleResponseChunks, (String)"<this>");
            return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super Content>, Continuation<? super Unit>, Object>($this$assembleResponseChunks, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Flow<ChatCompletionChunk.Choice.Delta> $this_assembleResponseChunks;
                {
                    this.$this_assembleResponseChunks = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$flow = (FlowCollector)this.L$0;
                            toolCallAssemblers = new LinkedHashMap<K, V>();
                            this.L$0 = $this$flow;
                            this.L$1 = toolCallAssemblers;
                            this.label = 1;
                            v0 = this.$this_assembleResponseChunks.collect(new FlowCollector((FlowCollector<? super Content>)$this$flow, toolCallAssemblers){
                                final /* synthetic */ FlowCollector<Content> $$this$flow;
                                final /* synthetic */ Map<Long, ToolCallAssembler> $toolCallAssemblers;
                                {
                                    this.$$this$flow = $$this$flow;
                                    this.$toolCallAssemblers = $toolCallAssemblers;
                                }

                                /*
                                 * Unable to fully structure code
                                 * Could not resolve type clashes
                                 */
                                public final Object emit(ChatCompletionChunk.Choice.Delta var1_1, Continuation<? super Unit> $completion) {
                                    if (!($completion instanceof assembleResponseChunks.emit.1)) ** GOTO lbl-1000
                                    var23_3 = $completion;
                                    if ((var23_3.label & -2147483648) != 0) {
                                        var23_3.label -= -2147483648;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        $continuation = new ContinuationImpl(this, $completion){
                                            Object L$0;
                                            /* synthetic */ Object result;
                                            final /* synthetic */ Companion.assembleResponseChunks.1<T> this$0;
                                            int label;
                                            {
                                                this.this$0 = this$0;
                                                super($completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                this.result = $result;
                                                this.label |= Integer.MIN_VALUE;
                                                return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                            }
                                        };
                                    }
                                    $result = $continuation.result;
                                    var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch ($continuation.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = (String)OptionalsKt.getOrNull((Optional)chunk.content());
                                            if (v0 == null) break;
                                            var3_6 = v0;
                                            var4_7 /* !! */  = this.$$this$flow;
                                            it = var3_6;
                                            $i$a$-let-OpenAiChatImpl$Companion$assembleResponseChunks$1$1$1 = false;
                                            $continuation.L$0 = chunk;
                                            $continuation.label = 1;
                                            v1 = var4_7 /* !! */ .emit((Object)new Content.TextContent(it, null, null, null, null, 30, null), (Continuation)$continuation);
                                            if (v1 == var24_5) {
                                                return var24_5;
                                            }
                                            break;
                                        }
                                        case 1: {
                                            $i$a$-let-OpenAiChatImpl$Companion$assembleResponseChunks$1$1$1 = false;
                                            chunk = (ChatCompletionChunk.Choice.Delta)$continuation.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
                                            break;
                                        }
                                    }
                                    v2 = (List)OptionalsKt.getOrNull((Optional)chunk.toolCalls());
                                    if (v2 != null) {
                                        var3_6 = v2;
                                        var4_7 /* !! */  = this.$toolCallAssemblers;
                                        $i$f$onEach = false;
                                        $this$onEach_u24lambda_u2418$iv = var6_11 = $this$onEach$iv;
                                        $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
                                        for (T element$iv : $this$onEach_u24lambda_u2418$iv) {
                                            toolCall = (ChatCompletionChunk.Choice.Delta.ToolCall)element$iv;
                                            $i$a$-onEach-OpenAiChatImpl$Companion$assembleResponseChunks$1$1$2 = false;
                                            index = toolCall.index();
                                            var15_19 /* !! */  = var4_7 /* !! */ ;
                                            key$iv = Boxing.boxLong((long)index);
                                            $i$f$getOrPut = false;
                                            value$iv = $this$getOrPut$iv.get(key$iv);
                                            if (value$iv == null) {
                                                $i$a$-getOrPut-OpenAiChatImpl$Companion$assembleResponseChunks$1$1$2$assembler$1 = false;
                                                answer$iv = new ToolCallAssembler(index);
                                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                                v3 /* !! */  = answer$iv;
                                            } else {
                                                v3 /* !! */  = value$iv;
                                            }
                                            assembler = (ToolCallAssembler)v3 /* !! */ ;
                                            if ((String)OptionalsKt.getOrNull((Optional)toolCall.id()) != null) {
                                                $i$a$-let-OpenAiChatImpl$Companion$assembleResponseChunks$1$1$2$1 = false;
                                                assembler.setId(it);
                                            }
                                            if ((ChatCompletionChunk.Choice.Delta.ToolCall.Function)OptionalsKt.getOrNull((Optional)toolCall.function()) == null) continue;
                                            $i$a$-let-OpenAiChatImpl$Companion$assembleResponseChunks$1$1$2$2 = false;
                                            if ((String)OptionalsKt.getOrNull((Optional)function.name()) != null) {
                                                $i$a$-let-OpenAiChatImpl$Companion$assembleResponseChunks$1$1$2$2$1 = false;
                                                assembler.setName(it);
                                            }
                                            if ((String)OptionalsKt.getOrNull((Optional)function.arguments()) == null) continue;
                                            $i$a$-let-OpenAiChatImpl$Companion$assembleResponseChunks$1$1$2$2$2 = false;
                                            assembler.getArguments().append(it);
                                        }
                                        (List)var6_11;
                                    }
                                    return Unit.INSTANCE;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                            }, (Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            toolCallAssemblers = (Map)this.L$1;
                            $this$flow = (FlowCollector)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            this.L$0 = null;
                            this.L$1 = null;
                            this.label = 2;
                            v1 = assembleResponseChunks.1.invokeSuspend$emitToolCalls(toolCallAssemblers, (FlowCollector<? super Content>)$this$flow, (Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl29
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl29:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(FlowCollector<? super Content> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                /*
                 * Unable to fully structure code
                 */
                private static final Object invokeSuspend$emitToolCalls(Map<Long, ToolCallAssembler> var0, FlowCollector<? super Content> var1_1, Continuation<? super Unit> $completion) {
                    if (!($completion instanceof assembleResponseChunks.emitToolCalls.1)) ** GOTO lbl-1000
                    var10_3 = $completion;
                    if ((var10_3.label & -2147483648) != 0) {
                        var10_3.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl($completion){
                            Object L$0;
                            Object L$1;
                            /* synthetic */ Object result;
                            int label;

                            public final Object invokeSuspend(Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return assembleResponseChunks.1.access$invokeSuspend$emitToolCalls(null, null, (Continuation)this);
                            }
                        };
                    }
                    $result = $continuation.result;
                    var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var3_6 = toolCallAssemblers.values().iterator();
lbl13:
                            // 3 sources

                            while (var3_6.hasNext()) {
                                toolCall = var3_6.next();
                                Intrinsics.checkNotNullExpressionValue((Object)toolCall.getArguments().toString(), (String)"toString(...)");
                                (Map)new LinkedHashMap<K, V>();
                                try {
                                    arguments = OpenAiChatImpl.Companion.parseArguments(rawArguments);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException("Failed to parse arguments for '" + toolCall.getName() + " 'Tool", e);
                                }
                                var8_12 = new Pair[]{TuplesKt.to((Object)"toolCallId", (Object)toolCall.getId()), TuplesKt.to((Object)"rawArguments", (Object)rawArguments)};
                                metadata = MapsKt.mapOf((Pair[])var8_12);
                                value = new Content.FunctionCall(toolCall.getName(), arguments, null, null, metadata, 12, null);
                                $continuation.L$0 = $this$flow;
                                $continuation.L$1 = var3_6;
                                $continuation.label = 1;
                                v0 = $this$flow.emit((Object)value, (Continuation)$continuation);
                                if (v0 != var11_5) continue;
                                return var11_5;
                            }
                            break;
                        }
                        case 1: {
                            var3_6 = (Iterator<ToolCallAssembler>)$continuation.L$1;
                            $this$flow = (FlowCollector)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            ** GOTO lbl13
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public static final /* synthetic */ Object access$invokeSuspend$emitToolCalls(Map toolCallAssemblers, FlowCollector $this$flow, Continuation $completion) {
                    return assembleResponseChunks.1.invokeSuspend$emitToolCalls(toolCallAssemblers, (FlowCollector<? super Content>)$this$flow, (Continuation<? super Unit>)$completion);
                }
            }));
        }

        @NotNull
        public final Map<String, Object> parseArguments(@NotNull String rawArguments) {
            Intrinsics.checkNotNullParameter((Object)rawArguments, (String)"rawArguments");
            try {
                Type argumentsType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                Object object = this.getGSON$aiplugin_backends_local().fromJson(rawArguments, argumentsType2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                return (Map)object;
            }
            catch (JsonParseException e) {
                String maybeSanitized = OpenAIToolsKt.sanitizeMultilineString(rawArguments, this.getGSON$aiplugin_backends_local());
                if (maybeSanitized != null && this.isValidJson(maybeSanitized)) {
                    return this.parseArguments(maybeSanitized);
                }
                throw e;
            }
        }

        public final boolean isValidJson(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            try {
                this.getGSON$aiplugin_backends_local().fromJson(s, Map.class);
                return true;
            }
            catch (MalformedJsonException e) {
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Prompt.FunctionCallingMode.values().length];
            try {
                nArray[Prompt.FunctionCallingMode.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Prompt.FunctionCallingMode.ANY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Prompt.FunctionCallingMode.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

