/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.api;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ChatBotEvent;
import com.android.studio.ml.MetricsReporter;
import com.android.studio.ml.bot.BotToolWindowService;
import com.android.studio.ml.bot.ResponseMode;
import com.android.studio.ml.bot.ui.compose.timeline.ComposeAgentTimelineController;
import com.android.studio.ml.bot.ui.compose.timeline.ComposeChatTimelineController;
import com.android.studio.ml.bot.ui.compose.timeline.TimelineState;
import com.android.studio.ml.prompting.PromptUtilsKt;
import com.android.studio.ml.util.Blob;
import com.android.tools.idea.studiobot.ChatService;
import com.android.tools.idea.studiobot.GenerationConfig;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\"\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J&\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/studio/ml/api/ChatServiceImpl;", "Lcom/android/tools/idea/studiobot/ChatService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isReadyToReceiveQuery", "", "responseMode", "Lcom/android/studio/ml/bot/ResponseMode;", "sendChatQuery", "", "prompt", "Lcom/android/tools/idea/studiobot/prompts/Prompt;", "entryPoint", "Lcom/android/studio/ml/ChatBotEvent$EntryPoint;", "displayText", "", "config", "Lcom/android/tools/idea/studiobot/GenerationConfig;", "isMarkdown", "sendConfiguredChatQuery", "query", "stageChatQuery", "attachments", "", "Lcom/android/studio/ml/util/Blob;", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChatServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatServiceImpl.kt\ncom/android/studio/ml/api/ChatServiceImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,92:1\n31#2,2:93\n31#2,2:95\n31#2,2:97\n31#2,2:99\n31#2,2:101\n*S KotlinDebug\n*F\n+ 1 ChatServiceImpl.kt\ncom/android/studio/ml/api/ChatServiceImpl\n*L\n40#1:93,2\n41#1:95,2\n60#1:97,2\n75#1:99,2\n84#1:101,2\n*E\n"})
public final class ChatServiceImpl
implements ChatService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    public static final int $stable = 8;

    public ChatServiceImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public boolean isReadyToReceiveQuery(@NotNull ResponseMode responseMode2) {
        Intrinsics.checkNotNullParameter((Object)((Object)responseMode2), (String)"responseMode");
        TimelineState timelineState = switch (WhenMappings.$EnumSwitchMapping$0[responseMode2.ordinal()]) {
            case 1 -> {
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class serviceClass$iv = ComposeChatTimelineController.class;
                Object v0 = $this$service$iv.getService(serviceClass$iv);
                if (v0 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                yield (TimelineState)((ComposeChatTimelineController)v0).getTimelineState().getValue();
            }
            case 2 -> {
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class serviceClass$iv = ComposeAgentTimelineController.class;
                Object v2 = $this$service$iv.getService(serviceClass$iv);
                if (v2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                yield (TimelineState)((ComposeAgentTimelineController)v2).getTimelineState().getValue();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        return timelineState instanceof TimelineState.Content && !((TimelineState.Content)timelineState).isBusyReceiving();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendChatQuery(@NotNull Prompt prompt2, @NotNull ChatBotEvent.EntryPoint entryPoint, @Nullable String displayText, @Nullable GenerationConfig config2, boolean isMarkdown) {
        void $this$service$iv;
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)((Object)entryPoint), (String)"entryPoint");
        if (!(PromptUtilsKt.lastMessage(prompt2) instanceof Prompt.UserMessage)) {
            boolean $i$a$-check-ChatServiceImpl$sendChatQuery$22 = false;
            String $i$a$-check-ChatServiceImpl$sendChatQuery$22 = "The last message in the prompt should be a user message.";
            throw new IllegalStateException($i$a$-check-ChatServiceImpl$sendChatQuery$22.toString());
        }
        MetricsReporter.Companion.getInstance().logChatBotEvent(new ChatBotEvent.BotInvoked(entryPoint));
        ComponentManager componentManager = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<BotToolWindowService> serviceClass$iv = BotToolWindowService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BotToolWindowService botToolWindowService = (BotToolWindowService)object;
        String string = displayText;
        if (string == null) {
            string = PromptUtilsKt.queryString(PromptUtilsKt.lastMessage(prompt2));
        }
        botToolWindowService.sendQuery(prompt2, string, config2, isMarkdown);
    }

    @Override
    public void sendConfiguredChatQuery(@NotNull String query, @NotNull ChatBotEvent.EntryPoint entryPoint, @Nullable GenerationConfig config2) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)((Object)entryPoint), (String)"entryPoint");
        MetricsReporter.Companion.getInstance().logChatBotEvent(new ChatBotEvent.BotInvoked(entryPoint));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<BotToolWindowService> serviceClass$iv = BotToolWindowService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((BotToolWindowService)object).sendUserQuery(query, config2);
    }

    @Override
    public void stageChatQuery(@NotNull String prompt2, @NotNull ChatBotEvent.EntryPoint entryPoint, @NotNull List<Blob> attachments) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)((Object)entryPoint), (String)"entryPoint");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        MetricsReporter.Companion.getInstance().logChatBotEvent(new ChatBotEvent.BotInvoked(entryPoint));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<BotToolWindowService> serviceClass$iv = BotToolWindowService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((BotToolWindowService)object).stageQueryInToolWindow(prompt2, attachments);
    }

    @JvmStatic
    @NotNull
    public static final ChatServiceImpl getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/studio/ml/api/ChatServiceImpl$Companion;", "", "()V", "getInstance", "Lcom/android/studio/ml/api/ChatServiceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.core.aicore"})
    @SourceDebugExtension(value={"SMAP\nChatServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatServiceImpl.kt\ncom/android/studio/ml/api/ChatServiceImpl$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,92:1\n31#2,2:93\n*S KotlinDebug\n*F\n+ 1 ChatServiceImpl.kt\ncom/android/studio/ml/api/ChatServiceImpl$Companion\n*L\n89#1:93,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ChatServiceImpl getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ChatServiceImpl> serviceClass$iv = ChatServiceImpl.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ChatServiceImpl)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseMode.values().length];
            try {
                nArray[ResponseMode.Chat.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseMode.Agent.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

