/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.api;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.AiExcludeEvent;
import com.android.studio.ml.MetricsReporter;
import com.android.studio.ml.aiexclude.ExcludeFileParser;
import com.android.studio.ml.aiexclude.ExcludeFileParserKt;
import com.android.studio.ml.aiexclude.ExcludePattern;
import com.android.studio.ml.aiexclude.PathPatternMatcher;
import com.android.tools.idea.studiobot.AiExcludeService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u000bH\u0017J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000eH\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016Rf\u0010\t\u001aZ\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \f*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r \f*,\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \f*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/android/studio/ml/api/AiExcludeServiceImpl;", "Lcom/android/tools/idea/studiobot/AiExcludeService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "projectBasePath", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "exclusionStatusCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProjectBasePath", "()Ljava/lang/String;", "dispose", "", "getBlockingFiles", "file", "path", "virtualFileAncestor", "getExclusionStatus", "Lcom/android/tools/idea/studiobot/AiExcludeService$ExclusionStatus;", "getFirstVirtualFileAncestor", "isFileExcluded", "", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAiExcludeServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiExcludeServiceImpl.kt\ncom/android/studio/ml/api/AiExcludeServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1#2:270\n1053#3:271\n*S KotlinDebug\n*F\n+ 1 AiExcludeServiceImpl.kt\ncom/android/studio/ml/api/AiExcludeServiceImpl\n*L\n196#1:271\n*E\n"})
public final class AiExcludeServiceImpl
implements AiExcludeService,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final String projectBasePath;
    private final Cache<Path, List<VirtualFile>> exclusionStatusCache;
    public static final int $stable = 8;

    public AiExcludeServiceImpl(@NotNull Project project2, @Nullable String projectBasePath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.projectBasePath = projectBasePath;
        this.exclusionStatusCache = Caffeine.newBuilder().maximumSize(100L).build();
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    Path path2;
                    VirtualFile virtualFile2;
                    if (vFileEvent.getFile() == null) continue;
                    if (ExcludeFileParserKt.getRECOGNIZED_EXCLUDE_FILES().contains(virtualFile2.getName())) {
                        exclusionStatusCache.invalidateAll();
                        continue;
                    }
                    if (VirtualFileUtil.toNioPathOrNull((VirtualFile)virtualFile2) == null) {
                        return;
                    }
                    exclusionStatusCache.invalidate((Object)path2);
                }
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (project.isDisposed()) {
                    return;
                }
                VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
                VirtualFile virtualFile2 = file;
                if (CollectionsKt.contains((Iterable)ExcludeFileParserKt.getRECOGNIZED_EXCLUDE_FILES(), (Object)(virtualFile2 != null ? virtualFile2.getName() : null))) {
                    exclusionStatusCache.invalidateAll();
                }
            }
        }, (Disposable)this);
    }

    @Nullable
    public final String getProjectBasePath() {
        return this.projectBasePath;
    }

    public AiExcludeServiceImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this(project2, project2.getBasePath());
    }

    public void dispose() {
        this.exclusionStatusCache.invalidateAll();
    }

    @Override
    public boolean isFileExcluded(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getExclusionStatus(file) != AiExcludeService.ExclusionStatus.ALLOWED;
    }

    @Override
    public boolean isFileExcluded(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getExclusionStatus(file) != AiExcludeService.ExclusionStatus.ALLOWED;
    }

    @Override
    @NotNull
    public AiExcludeService.ExclusionStatus getExclusionStatus(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile2 = this.getFirstVirtualFileAncestor(file);
        if (virtualFile2 == null) {
            return AiExcludeService.ExclusionStatus.NOT_IN_PROJECT_OR_VCS;
        }
        VirtualFile virtualFileAncestor = virtualFile2;
        AiExcludeService.ExclusionStatus status2 = (AiExcludeService.ExclusionStatus)((Object)ActionsKt.runReadAction((Function0)((Function0)new Function0<AiExcludeService.ExclusionStatus>(virtualFileAncestor, this, file){
            final /* synthetic */ VirtualFile $virtualFileAncestor;
            final /* synthetic */ AiExcludeServiceImpl this$0;
            final /* synthetic */ Path $file;
            {
                this.$virtualFileAncestor = $virtualFileAncestor;
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            public final AiExcludeService.ExclusionStatus invoke() {
                return !AiExcludeServiceImpl.Companion.isFileInProject(this.$virtualFileAncestor, AiExcludeServiceImpl.access$getProject$p(this.this$0), this.this$0.getProjectBasePath()) && !AiExcludeServiceImpl.Companion.isPathInVcsRoot(((Object)this.$file).toString(), AiExcludeServiceImpl.access$getProject$p(this.this$0)) ? AiExcludeService.ExclusionStatus.NOT_IN_PROJECT_OR_VCS : (AiExcludeServiceImpl.access$getBlockingFiles(this.this$0, this.$file, this.$virtualFileAncestor).isEmpty() ? AiExcludeService.ExclusionStatus.ALLOWED : AiExcludeService.ExclusionStatus.EXCLUDED);
            }
        })));
        if (status2 != AiExcludeService.ExclusionStatus.ALLOWED) {
            MetricsReporter.Companion.getInstance().logAiExcludeEvent(new AiExcludeEvent(null, null, null, null, 15, null));
        }
        return status2;
    }

    @Override
    @NotNull
    public AiExcludeService.ExclusionStatus getExclusionStatus(@NotNull VirtualFile file) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFileSystem virtualFileSystem = file.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem fs = virtualFileSystem;
        if (fs instanceof ArchiveFileSystem) {
            VirtualFile virtualFile2 = ((ArchiveFileSystem)fs).getLocalByEntry(file);
            v2 = virtualFile2 != null ? VirtualFileUtil.toNioPathOrNull((VirtualFile)virtualFile2) : null;
        } else {
            v2 = path2 = VirtualFileUtil.toNioPathOrNull((VirtualFile)file);
        }
        if (path2 == null) {
            return AiExcludeService.ExclusionStatus.NOT_IN_PROJECT_OR_VCS;
        }
        return this.getExclusionStatus(path2);
    }

    @Override
    @RequiresReadLock
    @NotNull
    public List<VirtualFile> getBlockingFiles(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isFileExcluded(file)) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = this.getFirstVirtualFileAncestor(file);
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFileAncestor = virtualFile2;
        return this.getBlockingFiles(file, virtualFileAncestor);
    }

    @Override
    @NotNull
    public List<VirtualFile> getBlockingFiles(@NotNull VirtualFile file) {
        Iterable<Path> iterable;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                iterable = VirtualFileUtil.toNioPathOrNull((VirtualFile)file);
                if (iterable == null) break block2;
                Path it = iterable;
                boolean bl = false;
                List<VirtualFile> list = this.getBlockingFiles(it);
                iterable = list;
                if (list != null) break block3;
            }
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    private final VirtualFile getFirstVirtualFileAncestor(Path path2) {
        Path ancestorPath = path2;
        VirtualFile vf;
        while ((vf = VfsUtil.findFile((Path)ancestorPath, (boolean)false)) == null) {
            if (ancestorPath.getParent() != null) continue;
            return null;
        }
        return vf;
    }

    @RequiresReadLock
    private final List<VirtualFile> getBlockingFiles(Path path2, VirtualFile virtualFileAncestor) {
        List cachedValue;
        List list = cachedValue = (List)this.exclusionStatusCache.getIfPresent((Object)path2);
        if (list != null) {
            return list;
        }
        List<VirtualFile> excludeFiles = ExcludeFileParser.INSTANCE.getExcludeFilesFor(virtualFileAncestor, this.project, this.projectBasePath);
        Iterable $this$sortedBy$iv = excludeFiles;
        boolean $i$f$sortedBy = false;
        List sortedExcludeFiles = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VirtualFile it = (VirtualFile)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPath().length());
                it = (VirtualFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPath().length()));
            }
        });
        Set blockingFiles = new LinkedHashSet();
        for (VirtualFile aiExcludeFile : sortedExcludeFiles) {
            List<ExcludePattern> patterns = ExcludeFileParser.INSTANCE.collectPatternsFor(aiExcludeFile, this.project);
            for (ExcludePattern pattern : patterns) {
                if (pattern.getNegated() && blockingFiles.isEmpty() || !pattern.getNegated() && blockingFiles.contains(aiExcludeFile)) continue;
                String string = ((Object)path2).toString();
                String string2 = path2.getFileSystem().getSeparator();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeparator(...)");
                if (!PathPatternMatcher.INSTANCE.matches(StringsKt.replace$default((String)string, (String)string2, (String)"/", (boolean)false, (int)4, null), pattern)) continue;
                if (pattern.getNegated()) {
                    blockingFiles.clear();
                    continue;
                }
                blockingFiles.add(aiExcludeFile);
            }
        }
        List list2 = CollectionsKt.toList((Iterable)blockingFiles);
        this.exclusionStatusCache.put((Object)path2, (Object)list2);
        return list2;
    }

    public static final /* synthetic */ List access$getBlockingFiles(AiExcludeServiceImpl $this, Path path2, VirtualFile virtualFileAncestor) {
        return $this.getBlockingFiles(path2, virtualFileAncestor);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/studio/ml/api/AiExcludeServiceImpl$Companion;", "", "()V", "isFileInProject", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "projectBasePath", "", "isPathInVcsRoot", "path", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        public final boolean isFileInProject(@NotNull VirtualFile virtualFile2, @NotNull Project project2, @Nullable String projectBasePath) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (projectBasePath != null) {
                String string = virtualFile2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (StringsKt.startsWith$default((String)string, (String)projectBasePath, (boolean)false, (int)2, null) && !ApplicationManager.getApplication().isUnitTestMode()) {
                    return true;
                }
            }
            ProjectFileIndex projectFileIndex2 = ProjectFileIndex.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex2, (String)"getInstance(...)");
            ProjectFileIndex fileIndex = projectFileIndex2;
            if (fileIndex.isInProject(virtualFile2)) {
                return true;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            GlobalSearchScope searchScope = globalSearchScope;
            if (searchScope.contains(virtualFile2)) {
                return true;
            }
            VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile2);
            return jarRoot != null && fileIndex.isInProject(jarRoot);
        }

        public static /* synthetic */ boolean isFileInProject$default(Companion companion, VirtualFile virtualFile2, Project project2, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = project2.getBasePath();
            }
            return companion.isFileInProject(virtualFile2, project2, string);
        }

        @RequiresReadLock
        public final boolean isPathInVcsRoot(@NotNull String path2, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return VcsUtil.isFileUnderVcs((Project)project2, (String)path2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

