/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.aiexclude;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.aiexclude.ExcludeFileParserKt;
import com.android.studio.ml.aiexclude.ExcludePattern;
import com.android.studio.ml.api.AiExcludeServiceImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\u00020\n*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/studio/ml/aiexclude/ExcludeFileParser;", "", "()V", "COMMENT_MARKER", "", "ESCAPED_NEGATION_MARKER", "ESCAPE_MARKER", "NEGATION_MARKER", "collectPatternsFor", "", "Lcom/android/studio/ml/aiexclude/ExcludePattern;", "aiExcludeFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getExcludeFilesFor", "file", "projectBasePath", "parseExcludeRules", "fileContents", "", "toExcludePattern", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nExcludeFileParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExcludeFileParser.kt\ncom/android/studio/ml/aiexclude/ExcludeFileParser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n3829#2:112\n4344#2,2:113\n1#3:115\n1557#4:116\n1628#4,3:117\n774#4:120\n865#4,2:121\n1557#4:123\n1628#4,3:124\n*S KotlinDebug\n*F\n+ 1 ExcludeFileParser.kt\ncom/android/studio/ml/aiexclude/ExcludeFileParser\n*L\n72#1:112\n72#1:113,2\n107#1:116\n107#1:117,3\n108#1:120\n108#1:121,2\n85#1:123\n85#1:124,3\n*E\n"})
public final class ExcludeFileParser {
    @NotNull
    public static final ExcludeFileParser INSTANCE = new ExcludeFileParser();
    @NotNull
    private static final String COMMENT_MARKER = "#";
    @NotNull
    private static final String NEGATION_MARKER = "!";
    @NotNull
    private static final String ESCAPE_MARKER = "\\";
    @NotNull
    private static final String ESCAPED_NEGATION_MARKER = "\\!";
    public static final int $stable;

    private ExcludeFileParser() {
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public final List<VirtualFile> getExcludeFilesFor(@NotNull VirtualFile file, @NotNull Project project2, @Nullable String projectBasePath) {
        Path path2;
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List excludeFiles = new ArrayList();
        if (file.isDirectory()) {
            virtualFile2 = file;
        } else {
            virtualFile2 = file.getParent();
            if (virtualFile2 == null) {
                return CollectionsKt.emptyList();
            }
        }
        VirtualFile dir = virtualFile2;
        while (VirtualFileUtil.toNioPathOrNull((VirtualFile)dir) != null && (AiExcludeServiceImpl.Companion.isFileInProject(dir, project2, projectBasePath) || AiExcludeServiceImpl.Companion.isPathInVcsRoot(((Object)path2).toString(), project2))) {
            if (dir.getChildren() != null) {
                void $this$filterTo$iv$iv;
                VirtualFile[] $this$filter$iv;
                boolean $i$f$filter = false;
                VirtualFile[] virtualFileArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[j];
                    boolean bl = false;
                    if (!ExcludeFileParserKt.getRECOGNIZED_EXCLUDE_FILES().contains(it.getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List it = (List)destination$iv$iv;
                boolean bl = false;
                excludeFiles.addAll(it);
            }
            if (dir.getParent() == null) break;
        }
        return excludeFiles;
    }

    public static /* synthetic */ List getExcludeFilesFor$default(ExcludeFileParser excludeFileParser, VirtualFile virtualFile2, Project project2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = project2.getBasePath();
        }
        return excludeFileParser.getExcludeFilesFor(virtualFile2, project2, string);
    }

    @RequiresReadLock
    @NotNull
    public final List<ExcludePattern> collectPatternsFor(@NotNull VirtualFile aiExcludeFile, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)aiExcludeFile, (String)"aiExcludeFile");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Document document = VirtualFileUtil.findDocument((VirtualFile)aiExcludeFile);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Document document2 = document;
        Object object = CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)document2, () -> ExcludeFileParser.collectPatternsFor$lambda$3(document2, aiExcludeFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private final ExcludePattern toExcludePattern(String $this$toExcludePattern, VirtualFile aiExcludeFile) {
        String string = aiExcludeFile.getParent().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String directoryPath = string;
        boolean isNegated = StringsKt.startsWith$default((String)$this$toExcludePattern, (String)NEGATION_MARKER, (boolean)false, (int)2, null);
        boolean startsWithEscapedBang = StringsKt.startsWith$default((String)$this$toExcludePattern, (String)ESCAPED_NEGATION_MARKER, (boolean)false, (int)2, null);
        String cleanedString = isNegated ? StringsKt.removePrefix((String)$this$toExcludePattern, (CharSequence)NEGATION_MARKER) : (startsWithEscapedBang ? StringsKt.removePrefix((String)$this$toExcludePattern, (CharSequence)ESCAPE_MARKER) : $this$toExcludePattern);
        return new ExcludePattern(directoryPath, cleanedString, isNegated);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> parseExcludeRules(@NotNull CharSequence fileContents) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fileContents, (String)"fileContents");
        Iterable $this$map$iv = StringsKt.lines((CharSequence)fileContents);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)it).length() > 0 && !StringsKt.startsWith$default((String)it, (String)COMMENT_MARKER, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result collectPatternsFor$lambda$3(Document $document, VirtualFile $aiExcludeFile) {
        void $this$mapTo$iv$iv;
        CharSequence charSequence = $document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        List<String> ruleLines = INSTANCE.parseExcludeRules(charSequence);
        Iterable $this$map$iv = ruleLines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void str;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.toExcludePattern((String)str, $aiExcludeFile));
        }
        List rules = (List)destination$iv$iv;
        Object[] objectArray = new Object[]{$document};
        return new CachedValueProvider.Result((Object)rules, objectArray);
    }
}

