/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.visuallint.analyzers;

import android.graphics.Rect;
import android.text.Layout;
import android.text.TextPaint;
import android.widget.TextView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.configurations.Configuration;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.android.tools.visuallint.VisualLintAnalyzer;
import com.android.tools.visuallint.VisualLintBaseConfigIssues;
import com.android.tools.visuallint.VisualLintErrorType;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0002J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006%"}, d2={"Lcom/android/tools/visuallint/analyzers/LocaleAnalyzer;", "Lcom/android/tools/visuallint/VisualLintAnalyzer;", "baseConfigIssues", "Lcom/android/tools/visuallint/VisualLintBaseConfigIssues;", "<init>", "(Lcom/android/tools/visuallint/VisualLintBaseConfigIssues;)V", "type", "Lcom/android/tools/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/visuallint/VisualLintErrorType;", "findIssues", "", "Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "renderResult", "Lcom/android/tools/rendering/RenderResult;", "configuration", "Lcom/android/tools/configurations/Configuration;", "buildMap", "", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "getKey", "", "root", "(Lcom/android/ide/common/rendering/api/ViewInfo;)Ljava/lang/Integer;", "isBaseConfig", "", "config", "findLocaleIssues", "createEllipsizedIssue", "locale", "", "createTextTooBigIssue", "value", "Lcom/android/tools/visuallint/VisualLintBaseConfigIssues$BaseConfigComponentState;", "isEllipsized", "isTextTooBig", "intellij.android.visual-lint"})
@SourceDebugExtension(value={"SMAP\nLocaleAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocaleAnalyzer.kt\ncom/android/tools/visuallint/analyzers/LocaleAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,176:1\n1863#2,2:177\n1863#2,2:179\n1755#2,3:188\n381#3,7:181\n*S KotlinDebug\n*F\n+ 1 LocaleAnalyzer.kt\ncom/android/tools/visuallint/analyzers/LocaleAnalyzer\n*L\n45#1:177,2\n52#1:179,2\n143#1:188,3\n66#1:181,7\n*E\n"})
public final class LocaleAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    private final VisualLintBaseConfigIssues baseConfigIssues;

    public LocaleAnalyzer(@NotNull VisualLintBaseConfigIssues baseConfigIssues) {
        Intrinsics.checkNotNullParameter((Object)baseConfigIssues, (String)"baseConfigIssues");
        this.baseConfigIssues = baseConfigIssues;
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.LOCALE_TEXT;
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        List issues = new ArrayList();
        if (this.isBaseConfig(configuration)) {
            ImmutableList immutableList = renderResult.getRootViews();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
            ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
            while (!((Collection)viewsToAnalyze).isEmpty()) {
                ViewInfo view = (ViewInfo)viewsToAnalyze.removeLast();
                List list = view.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ViewInfo it = (ViewInfo)element$iv;
                    boolean bl = false;
                    viewsToAnalyze.addLast((Object)it);
                }
                Intrinsics.checkNotNull((Object)view);
                this.buildMap(view, this.baseConfigIssues);
            }
        } else {
            ImmutableList immutableList = renderResult.getRootViews();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
            ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
            while (!((Collection)viewsToAnalyze).isEmpty()) {
                ViewInfo view = (ViewInfo)viewsToAnalyze.removeLast();
                List list = view.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ViewInfo it = (ViewInfo)element$iv;
                    boolean bl = false;
                    viewsToAnalyze.addLast((Object)it);
                }
                Intrinsics.checkNotNull((Object)view);
                issues.addAll((Collection)this.findLocaleIssues(view, this.baseConfigIssues, configuration));
            }
        }
        return issues;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildMap(ViewInfo view, VisualLintBaseConfigIssues baseConfigIssues) {
        block2: {
            Object object;
            void $this$getOrPut$iv;
            Integer n = this.getKey(view);
            if (n == null) break block2;
            int key = ((Number)n).intValue();
            boolean bl = false;
            Map<Integer, VisualLintBaseConfigIssues.BaseConfigComponentState> map2 = baseConfigIssues.getComponentState();
            Integer key$iv = key;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                VisualLintBaseConfigIssues.BaseConfigComponentState answer$iv = new VisualLintBaseConfigIssues.BaseConfigComponentState(false, false, 3, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((VisualLintBaseConfigIssues.BaseConfigComponentState)object).setHasI18NEllipsis(this.isEllipsized(view));
            VisualLintBaseConfigIssues.BaseConfigComponentState baseConfigComponentState = baseConfigIssues.getComponentState().get(key);
            Intrinsics.checkNotNull((Object)baseConfigComponentState);
            baseConfigComponentState.setHasI18NTextTooBig(this.isTextTooBig(view));
        }
    }

    private final Integer getKey(ViewInfo root) {
        Object object = root.getCookie();
        TagSnapshot tagSnapshot = object instanceof TagSnapshot ? (TagSnapshot)object : null;
        return tagSnapshot != null && (tagSnapshot = tagSnapshot.tag) != null ? Integer.valueOf(tagSnapshot.hashCode()) : null;
    }

    private final boolean isBaseConfig(Configuration config) {
        Configuration configuration = config;
        return Intrinsics.areEqual((Object)(configuration != null && (configuration = configuration.getLocale()) != null ? configuration.toString() : null), (Object)"__");
    }

    private final List<VisualLintAnalyzer.VisualLintIssueContent> findLocaleIssues(ViewInfo view, VisualLintBaseConfigIssues baseConfigIssues, Configuration configuration) {
        List issues = new ArrayList();
        Integer n = this.getKey(view);
        if (n == null) {
            return issues;
        }
        int key = n;
        VisualLintBaseConfigIssues.BaseConfigComponentState value = baseConfigIssues.getComponentState().get(key);
        String string = configuration.getLocale().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String locale = string;
        if (this.isEllipsized(view) && value != null && !value.getHasI18NEllipsis()) {
            issues.add(this.createEllipsizedIssue(view, locale));
        } else if (this.isTextTooBig(view) && (value == null || !value.getHasI18NTextTooBig())) {
            issues.add(this.createTextTooBigIssue(value, view, locale));
        }
        return issues;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createEllipsizedIssue(ViewInfo view, String locale) {
        String summary = "The text is ellipsized in locale \"" + locale + "\".";
        HtmlBuilder content = new HtmlBuilder().add("The text is ellipsized in locale \"" + locale + "\" but not in default locale.").newline().add("This might not be the intended behaviour. Consider increasing the text view size.");
        return new VisualLintAnalyzer.VisualLintIssueContent(view, summary, null, arg_0 -> LocaleAnalyzer.createEllipsizedIssue$lambda$4(content, arg_0), 4, null);
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createTextTooBigIssue(VisualLintBaseConfigIssues.BaseConfigComponentState value, ViewInfo view, String locale) {
        String summary = "The text might be cut off.";
        HtmlBuilder content = value == null ? new HtmlBuilder().add("The text is too large in locale \"" + locale + "\" to fit inside the TextView.") : new HtmlBuilder().add("The text is too large in locale \"" + locale + "\" to fit inside the TextView.").newline().add("This behavior is different from default locale and might not be intended behavior.");
        return new VisualLintAnalyzer.VisualLintIssueContent(view, summary, null, arg_0 -> LocaleAnalyzer.createTextTooBigIssue$lambda$5(content, arg_0), 4, null);
    }

    private final boolean isEllipsized(ViewInfo view) {
        boolean bl;
        block5: {
            if (!(view.getViewObject() instanceof TextView)) {
                return false;
            }
            Object object = view.getViewObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.widget.TextView");
            TextView textView = (TextView)object;
            Layout layout = textView.getLayout();
            if (layout == null) {
                return false;
            }
            Layout layout2 = layout;
            int lines = layout2.getLineCount();
            Iterable $this$any$iv = (Iterable)RangesKt.downTo((int)(lines - 1), (int)0);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(layout2.getEllipsisCount(it) > 0)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isTextTooBig(ViewInfo view) {
        if (!(view.getViewObject() instanceof TextView)) {
            return false;
        }
        Object object = view.getViewObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.widget.TextView");
        TextView textView = (TextView)object;
        TextPaint paint = textView.getPaint();
        CharSequence text = textView.getText();
        int lineHeight = textView.getLineHeight();
        int lineCount = textView.getLineCount();
        int requiredTextBoundsHeight = lineHeight * lineCount;
        if (requiredTextBoundsHeight > textView.getHeight()) {
            return true;
        }
        int requiredTextBoundsWidth = 0;
        for (int line = 0; line < lineCount; ++line) {
            int start = textView.getLayout().getLineStart(line);
            int end = textView.getLayout().getLineEnd(line);
            Rect rect = new Rect();
            paint.getTextBounds(text, start, end, rect);
            requiredTextBoundsWidth = RangesKt.coerceAtLeast((int)requiredTextBoundsWidth, (int)rect.width());
        }
        return requiredTextBoundsWidth > textView.getWidth();
    }

    private static final HtmlBuilder createEllipsizedIssue$lambda$4(HtmlBuilder $content, int it) {
        Intrinsics.checkNotNull((Object)$content);
        return $content;
    }

    private static final HtmlBuilder createTextTooBigIssue$lambda$5(HtmlBuilder $content, int it) {
        Intrinsics.checkNotNull((Object)$content);
        return $content;
    }
}

