/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.visuallint.analyzers;

import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorResult;
import com.android.tools.rendering.RenderResult;
import com.android.tools.visuallint.VisualLintAnalyzer;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001aB\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\fH\u0002\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u0011*\u00020\u0016\u001a\n\u0010\u0018\u001a\u00020\u0011*\u00020\u0016\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"validateAndUpdateLint", "", "Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "renderResult", "Lcom/android/tools/rendering/RenderResult;", "validatorResult", "Lcom/android/tools/idea/validator/ValidatorResult;", "viewInfoFromSrcId", "Lcom/android/ide/common/rendering/api/ViewInfo;", "id", "", "accessibilityToViewInfo", "", "Landroid/view/accessibility/AccessibilityNodeInfo;", "viewToViewInfo", "Landroid/view/View;", "CONTENT_LABELING", "", "TOUCH_TARGET_SIZE", "LOW_CONTRAST", "isLowContrast", "", "Lcom/android/tools/idea/validator/ValidatorData$Issue;", "summarize", "describe", "intellij.android.visual-lint"})
@SourceDebugExtension(value={"SMAP\nAtfAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtfAnalyzer.kt\ncom/android/tools/visuallint/analyzers/AtfAnalyzerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1863#2,2:172\n1863#2,2:174\n*S KotlinDebug\n*F\n+ 1 AtfAnalyzer.kt\ncom/android/tools/visuallint/analyzers/AtfAnalyzerKt\n*L\n89#1:172,2\n96#1:174,2\n*E\n"})
public final class AtfAnalyzerKt {
    @NotNull
    private static final String CONTENT_LABELING = "CONTENT_LABELING";
    @NotNull
    private static final String TOUCH_TARGET_SIZE = "TOUCH_TARGET_SIZE";
    @NotNull
    private static final String LOW_CONTRAST = "LOW_CONTRAST";

    private static final List<VisualLintAnalyzer.VisualLintIssueContent> validateAndUpdateLint(RenderResult renderResult, ValidatorResult validatorResult) {
        ArrayList<VisualLintAnalyzer.VisualLintIssueContent> issues = new ArrayList<VisualLintAnalyzer.VisualLintIssueContent>();
        Map accessibilityToViewInfo = new LinkedHashMap();
        Map viewToViewInfo = new LinkedHashMap();
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
        ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewInfo viewInfo = (ViewInfo)viewsToAnalyze.removeLast();
            List list = viewInfo.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Object $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                ViewInfo it = (ViewInfo)element$iv;
                boolean bl = false;
                viewsToAnalyze.addLast((Object)it);
            }
            if (viewInfo.getAccessibilityObject() instanceof AccessibilityNodeInfo) {
                $this$forEach$iv = accessibilityToViewInfo;
                Object object = viewInfo.getAccessibilityObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.accessibility.AccessibilityNodeInfo");
                $this$forEach$iv.put((AccessibilityNodeInfo)object, viewInfo);
                continue;
            }
            if (!(viewInfo.getViewObject() instanceof View)) continue;
            $this$forEach$iv = viewToViewInfo;
            Object object = viewInfo.getViewObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.View");
            $this$forEach$iv.put((View)object, viewInfo);
        }
        List list = validatorResult.getIssues();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIssues(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValidatorData.Issue it = (ValidatorData.Issue)element$iv;
            boolean bl = false;
            if (it.mLevel != ValidatorData.Level.ERROR && it.mLevel != ValidatorData.Level.WARNING || it.mType != ValidatorData.Type.ACCESSIBILITY) continue;
            Long l = it.mSrcId;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"mSrcId");
            ViewInfo viewInfo = AtfAnalyzerKt.viewInfoFromSrcId(validatorResult, ((Number)l).longValue(), accessibilityToViewInfo, viewToViewInfo);
            Intrinsics.checkNotNull((Object)it);
            String description = AtfAnalyzerKt.describe(it);
            issues.add(new VisualLintAnalyzer.VisualLintIssueContent(viewInfo, AtfAnalyzerKt.summarize(it), it, (Function1<? super Integer, ? extends HtmlBuilder>)((Function1)arg_0 -> AtfAnalyzerKt.validateAndUpdateLint$lambda$2$lambda$1(description, arg_0))));
        }
        return issues;
    }

    private static final ViewInfo viewInfoFromSrcId(ValidatorResult validatorResult, long id, Map<AccessibilityNodeInfo, ViewInfo> accessibilityToViewInfo, Map<View, ViewInfo> viewToViewInfo) {
        ViewInfo viewInfo;
        View view = (View)validatorResult.getSrcMap().get((Object)id);
        if (view != null && (viewInfo = viewToViewInfo.get(view)) != null) {
            return viewInfo;
        }
        AccessibilityNodeInfo accessibilityNodeInfo = (AccessibilityNodeInfo)validatorResult.getNodeInfoMap().get((Object)id);
        if (accessibilityNodeInfo == null) {
            return null;
        }
        AccessibilityNodeInfo node = accessibilityNodeInfo;
        return accessibilityToViewInfo.get(node);
    }

    public static final boolean isLowContrast(@NotNull ValidatorData.Issue $this$isLowContrast) {
        Intrinsics.checkNotNullParameter((Object)$this$isLowContrast, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isLowContrast.mSourceClass, (Object)"TextContrastCheck") || Intrinsics.areEqual((Object)$this$isLowContrast.mSourceClass, (Object)"ImageContrastCheck") || Intrinsics.areEqual((Object)$this$isLowContrast.mCategory, (Object)LOW_CONTRAST);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String summarize(@NotNull ValidatorData.Issue $this$summarize) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$summarize, (String)"<this>");
        String string2 = $this$summarize.mSourceClass;
        if (string2 != null) {
            n = -1;
            switch (string2.hashCode()) {
                case 1267412697: {
                    if (!string2.equals("TextContrastCheck")) break;
                    n = 1;
                    break;
                }
                case -81065639: {
                    if (!string2.equals("RedundantDescriptionCheck")) break;
                    n = 2;
                    break;
                }
                case 1014273495: {
                    if (!string2.equals("TouchTargetSizeCheck")) break;
                    n = 3;
                    break;
                }
                case 415991192: {
                    if (!string2.equals("TraversalOrderCheck")) break;
                    n = 4;
                    break;
                }
                case 113969112: {
                    if (!string2.equals("LinkPurposeUnclearCheck")) break;
                    n = 5;
                    break;
                }
                case -1101169318: {
                    if (!string2.equals("DuplicateSpeakableTextCheck")) break;
                    n = 6;
                    break;
                }
                case -119857348: {
                    if (!string2.equals("ClickableSpanCheck")) break;
                    n = 7;
                    break;
                }
                case 2145583531: {
                    if (!string2.equals("ImageContrastCheck")) break;
                    n = 8;
                    break;
                }
                case 2064391942: {
                    if (!string2.equals("SpeakableTextPresentCheck")) break;
                    n = 9;
                    break;
                }
                case 97108677: {
                    if (!string2.equals("ClassNameCheck")) break;
                    n = 10;
                    break;
                }
                case -1393599710: {
                    if (!string2.equals("EditableContentDescCheck")) break;
                    n = 11;
                    break;
                }
                case 1762882716: {
                    if (!string2.equals("DuplicateClickableBoundsCheck")) break;
                    n = 12;
                    break;
                }
            }
            switch (n) {
                case 9: {
                    return "No speakable text present";
                }
                case 11: {
                    return "Editable text view with contentDescription";
                }
                case 3: {
                    return "Touch target size too small";
                }
                case 6: {
                    return "Duplicate speakable text present";
                }
                case 1: {
                    return "Insufficient text color contrast ratio";
                }
                case 7: {
                    return "Accessibility issue with clickable span";
                }
                case 12: {
                    return "Duplicated clickable Views";
                }
                case 2: {
                    return "Item labelled with type or state";
                }
                case 8: {
                    return "Insufficient image color contrast ratio";
                }
                case 10: {
                    return "Accessibility Issue";
                }
                case 4: {
                    return "Unpredictable traversal behavior";
                }
                case 5: {
                    return "Unclear text in link";
                }
            }
        }
        if ((string = $this$summarize.mCategory) == null) return "Accessibility Issue";
        tmp = -1;
        switch (string.hashCode()) {
            case 811661716: {
                if (!string.equals(CONTENT_LABELING)) break;
                tmp = 1;
                break;
            }
            case 1384507309: {
                if (!string.equals(LOW_CONTRAST)) break;
                tmp = 2;
                break;
            }
            case -62747441: {
                if (!string.equals(TOUCH_TARGET_SIZE)) break;
                tmp = 3;
                break;
            }
        }
        switch (tmp) {
            case 1: {
                return "Content labels missing or ambiguous";
            }
            case 3: {
                return "Touch target size too small";
            }
            case 2: {
                return "Insufficient color contrast ratio";
            }
        }
        return "Accessibility Issue";
    }

    @NotNull
    public static final String describe(@NotNull ValidatorData.Issue $this$describe) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$describe, (String)"<this>");
        CharSequence charSequence = $this$describe.mHelpfulUrl;
        if (charSequence == null || charSequence.length() == 0) {
            charSequence = $this$describe.mMsg;
            Intrinsics.checkNotNull((Object)charSequence);
            object = charSequence;
        } else {
            object = $this$describe.mMsg + "<br><br>Learn more at <a href=\"" + $this$describe.mHelpfulUrl + "\">" + $this$describe.mHelpfulUrl + "</a>";
        }
        return object;
    }

    private static final HtmlBuilder validateAndUpdateLint$lambda$2$lambda$1(String $description, int it) {
        HtmlBuilder htmlBuilder = new HtmlBuilder().addHtml($description);
        Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"addHtml(...)");
        return htmlBuilder;
    }

    public static final /* synthetic */ List access$validateAndUpdateLint(RenderResult renderResult, ValidatorResult validatorResult) {
        return AtfAnalyzerKt.validateAndUpdateLint(renderResult, validatorResult);
    }
}

