/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.layer;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.idea.common.diagnostics.NlDiagnosticKey;
import com.android.tools.idea.common.diagnostics.NlDiagnosticsManager;
import com.android.tools.idea.common.diagnostics.NlDiagnosticsRead;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.uibuilder.surface.Graphics2DExtensionKt;
import com.android.tools.idea.uibuilder.surface.layer.DiagnosticsLayerKt;
import com.android.tools.rendering.imagepool.ImagePool;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import libcore.util.NativeAllocationRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J.\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/uibuilder/surface/layer/DiagnosticsLayer;", "Lcom/android/tools/idea/common/surface/Layer;", "diagnosticKey", "Lcom/android/tools/idea/common/diagnostics/NlDiagnosticKey;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/idea/common/diagnostics/NlDiagnosticKey;Lcom/intellij/openapi/project/Project;)V", "getDiagnosticsString", "", "diagnostics", "Lcom/android/tools/idea/common/diagnostics/NlDiagnosticsRead;", "paint", "", "graphics2D", "Ljava/awt/Graphics2D;", "drawLastRenders", "g", "lastRenders", "", "", "x", "", "startLine", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiagnosticsLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsLayer.kt\ncom/android/tools/idea/uibuilder/surface/layer/DiagnosticsLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n1863#3,2:127\n*S KotlinDebug\n*F\n+ 1 DiagnosticsLayer.kt\ncom/android/tools/idea/uibuilder/surface/layer/DiagnosticsLayer\n*L\n117#1:127,2\n*E\n"})
public final class DiagnosticsLayer
extends Layer {
    @NotNull
    private final NlDiagnosticKey diagnosticKey;
    @NotNull
    private final Project project;
    public static final int $stable = 8;

    public DiagnosticsLayer(@NotNull NlDiagnosticKey diagnosticKey, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)diagnosticKey, (String)"diagnosticKey");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.diagnosticKey = diagnosticKey;
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    private final String getDiagnosticsString(NlDiagnosticsRead diagnostics) {
        long l;
        long l2;
        Runtime runtime = Runtime.getRuntime();
        double freeMemPct = (double)runtime.freeMemory() / (double)runtime.totalMemory() * (double)100;
        Long l3 = (Long)CollectionsKt.firstOrNull((List)CollectionsKt.takeLast(diagnostics.lastRenders(), (int)1));
        long lastRenderMs = l3 != null ? l3 : -1L;
        ImagePool.BucketStats[] poolStats = StudioRenderService.Companion.getInstance(this.project).getSharedImagePool().getStats();
        Collection collection = NativeAllocationRegistry.getMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getMetrics(...)");
        Iterable iterable = collection;
        long l4 = 0L;
        for (Object t : iterable) {
            void it;
            NativeAllocationRegistry.Metrics metrics = (NativeAllocationRegistry.Metrics)t;
            l2 = l4;
            boolean bl = false;
            l = it.getMallocedBytes();
            l4 = l2 + l;
        }
        long mallocedBytes = l4;
        Collection collection2 = NativeAllocationRegistry.getMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getMetrics(...)");
        Iterable iterable2 = collection2;
        long l5 = 0L;
        for (Object e : iterable2) {
            void it;
            NativeAllocationRegistry.Metrics metrics = (NativeAllocationRegistry.Metrics)e;
            l2 = l5;
            boolean bl = false;
            l = it.getNonmallocedBytes();
            l5 = l2 + l;
        }
        long nonmallocedBytes = l5;
        Object object = poolStats;
        if (poolStats == null || (object = object.getBucketStats()) == null || (object = ArraysKt.joinToString$default((Object[])object, (CharSequence)"\n", null, null, (int)0, null, DiagnosticsLayer::getDiagnosticsString$lambda$2, (int)30, null)) == null) {
            object = "";
        }
        Object[] bucketStats = object;
        return StringsKt.trimMargin$default((String)("\n      |General\n      | Mem avail     " + runtime.freeMemory() / (long)0x100000 + "MB " + DiagnosticsLayerKt.access$getPCT_FORMAT$p().format(freeMemPct) + "%\n      | 90% Render    " + DiagnosticsLayerKt.access$getPCT_FORMAT$p().format(diagnostics.renderTime(90)) + "ms\n      | Last render   " + DiagnosticsLayerKt.access$getPCT_FORMAT$p().format(lastRenderMs) + "ms / " + diagnostics.lastRenderImageSize() / (long)0x100000 + "MB\n      |\n      |Image pool\n      | Allocated     " + (poolStats != null ? poolStats.totalBytesAllocated() : -1L) / (long)0x100000 + "MB\n      | In use        " + (poolStats != null ? poolStats.totalBytesInUse() : -1L) / (long)0x100000 + "MB\n      | Free          " + ((poolStats != null ? poolStats.totalBytesAllocated() : -1L) - (poolStats != null ? poolStats.totalBytesInUse() : 0L)) / (long)0x100000 + "MB\n      |\n      |Native memory\n      | mallocedBytes       " + mallocedBytes / (long)0x100000 + "MB\n      | nonmallocedBytes    " + nonmallocedBytes / (long)0x100000 + "MB\n      |\n      |Buckets\n      |" + (String)bucketStats + "\n    "), null, (int)1, null);
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"graphics2D");
        Graphics graphics = graphics2D.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D gc = (Graphics2D)graphics;
        gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        JBColor jBColor = JBColor.BLUE;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLUE");
        GraphicsUtilKt.setColorAndAlpha((Graphics2D)gc, (Color)((Color)jBColor));
        gc.setFont((Font)Graphics2DExtensionKt.getLAYER_FONT());
        Rectangle clipBounds = gc.getClipBounds();
        NlDiagnosticsRead diagnostics = NlDiagnosticsManager.getReadInstance(this.diagnosticKey);
        int startY = clipBounds.y + 20;
        int startX = clipBounds.x + 20;
        startY += Graphics2DExtensionKt.drawMultilineString(gc, this.getDiagnosticsString(diagnostics), startX, startY);
        this.drawLastRenders(gc, diagnostics.lastRenders(), startX, startY);
        gc.dispose();
    }

    private final void drawLastRenders(Graphics2D g, List<Long> lastRenders, int x, int startLine) {
        g.setColor(DiagnosticsLayerKt.access$getLAST_RENDER_BACKGROUND$p());
        g.fillRect(x, startLine, 158, 50);
        int startX = 0;
        startX = x;
        Iterable $this$forEach$iv = CollectionsKt.takeLast(lastRenders, (int)20);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            g.setColor(DiagnosticsLayerKt.access$colorForRenderTime(it));
            int barLength = Math.min((int)(it / (long)3), 50);
            g.fillRect(startX, startLine + (50 - barLength), 6, barLength);
            startX += 8;
        }
    }

    private static final CharSequence getDiagnosticsString$lambda$2(ImagePool.BucketStats it) {
        return " (" + it.getMinWidth() + "x" + it.getMinHeight() + " s=" + it.maxSize() + ") lastAccess=" + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - it.getLastAccessTimeMs()) + "s ago hits=" + it.bucketHits() + " misses=" + it.bucketMisses() + " wasFull=" + it.bucketWasFull() + " hadSpace=" + it.imageWasReturned();
    }
}

