/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.layer;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.surface.Graphics2DExtensionKt;
import com.intellij.openapi.module.Module;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.uipreview.ModuleClassLoaderHatchery;
import org.jetbrains.android.uipreview.ReadyState;
import org.jetbrains.android.uipreview.Stats;
import org.jetbrains.android.uipreview.StudioModuleClassLoaderManagerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/uibuilder/surface/layer/ClassLoadingDebugLayer;", "Lcom/android/tools/idea/common/surface/Layer;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "paint", "", "gc", "Ljava/awt/Graphics2D;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nClassLoadingDebugLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLoadingDebugLayer.kt\ncom/android/tools/idea/uibuilder/surface/layer/ClassLoadingDebugLayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1863#2:80\n1863#2,2:81\n1864#2:83\n*S KotlinDebug\n*F\n+ 1 ClassLoadingDebugLayer.kt\ncom/android/tools/idea/uibuilder/surface/layer/ClassLoadingDebugLayer\n*L\n56#1:80\n58#1:81,2\n56#1:83\n*E\n"})
public final class ClassLoadingDebugLayer
extends Layer {
    @NotNull
    private final Module module;
    public static final int $stable = 8;

    public ClassLoadingDebugLayer(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        Graphics graphics = gc.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        JBColor jBColor = JBColor.BLUE;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLUE");
        GraphicsUtilKt.setColorAndAlpha((Graphics2D)g, (Color)((Color)jBColor));
        g.setFont((Font)Graphics2DExtensionKt.getLAYER_FONT());
        Rectangle clipBounds = g.getClipBounds();
        int startY = 0;
        startY = clipBounds.y + 20;
        int startX = clipBounds.x + 20;
        ModuleClassLoaderHatchery hatchery = (ModuleClassLoaderHatchery)this.module.getUserData(StudioModuleClassLoaderManagerKt.getHATCHERY());
        if (hatchery != null) {
            startY += Graphics2DExtensionKt.drawMultilineString(gc, "Preloading progress:", startX, startY);
            List stats = hatchery.getStats();
            if (stats.isEmpty()) {
                Graphics2DExtensionKt.drawMultilineString(gc, "No clutches", startX, startY);
            } else {
                int horShift = 0;
                Iterable $this$forEach$iv = stats;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Stats it = (Stats)element$iv;
                    boolean bl = false;
                    int vertShift = 0;
                    vertShift = Graphics2DExtensionKt.drawMultilineString(gc, it.getLabel(), startX + horShift, startY);
                    Iterable $this$forEach$iv2 = it.getStates();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        ReadyState stat = (ReadyState)element$iv2;
                        boolean bl2 = false;
                        Color color = Color.GREEN;
                        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"GREEN");
                        GraphicsUtilKt.setColorAndAlpha((Graphics2D)g, (Color)color);
                        g.drawRect(startX + horShift, startY + vertShift, 100, 20);
                        g.fillRect(startX + horShift, startY + vertShift, 100 * stat.getProgress() / stat.getToDo(), 20);
                        vertShift += 40;
                    }
                    horShift += 150;
                }
            }
        } else {
            Graphics2DExtensionKt.drawMultilineString(gc, "No hatchery available", startX, startY);
        }
        g.dispose();
    }
}

