/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.layer;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/uibuilder/surface/layer/CanvasResizeLayer;", "Lcom/android/tools/idea/common/surface/Layer;", "screenView", "Lcom/android/tools/idea/uibuilder/surface/ScreenView;", "repaint", "Lkotlin/Function0;", "", "isVisibleCustom", "", "<init>", "(Lcom/android/tools/idea/uibuilder/surface/ScreenView;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "isHovering", "onHover", "x", "", "y", "paint", "g2d", "Ljava/awt/Graphics2D;", "isVisible", "()Z", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class CanvasResizeLayer
extends Layer {
    @NotNull
    private final ScreenView screenView;
    @NotNull
    private final Function0<Unit> repaint;
    @NotNull
    private final Function0<Boolean> isVisibleCustom;
    private boolean isHovering;
    public static final int $stable = 8;

    @JvmOverloads
    public CanvasResizeLayer(@NotNull ScreenView screenView, @NotNull Function0<Unit> repaint, @NotNull Function0<Boolean> isVisibleCustom) {
        Intrinsics.checkNotNullParameter((Object)screenView, (String)"screenView");
        Intrinsics.checkNotNullParameter(repaint, (String)"repaint");
        Intrinsics.checkNotNullParameter(isVisibleCustom, (String)"isVisibleCustom");
        this.screenView = screenView;
        this.repaint = repaint;
        this.isVisibleCustom = isVisibleCustom;
    }

    public /* synthetic */ CanvasResizeLayer(ScreenView screenView, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function02 = CanvasResizeLayer::_init_$lambda$0;
        }
        this(screenView, (Function0<Unit>)function0, (Function0<Boolean>)function02);
    }

    @Override
    public void onHover(int x, int y) {
        boolean oldHovering = this.isHovering;
        Dimension size = this.screenView.getScaledContentSize();
        Rectangle resizeZone = new Rectangle(this.screenView.getX() + size.width, this.screenView.getY() + size.height, 48, 48);
        this.isHovering = resizeZone.contains(x, y);
        if (this.isHovering != oldHovering) {
            this.repaint.invoke();
        }
    }

    @Override
    public void paint(@NotNull Graphics2D g2d) {
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        Dimension size = this.screenView.getScaledContentSize();
        int x = this.screenView.getX();
        int y = this.screenView.getY();
        Graphics graphics = g2d.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D graphics2 = (Graphics2D)graphics;
        graphics2.setStroke(NlConstants.SOLID_STROKE);
        graphics2.setColor(this.isHovering ? NlConstants.RESIZING_CORNER_COLOR : NlConstants.RESIZING_CUE_COLOR);
        graphics2.drawLine(x + size.width + 20, y + size.height + 4, x + size.width + 4, y + size.height + 20);
        graphics2.drawLine(x + size.width + 20, y + size.height + 12, x + size.width + 12, y + size.height + 20);
        graphics2.dispose();
    }

    @Override
    public boolean isVisible() {
        return this.screenView.getScene().isResizeAvailable() && (Boolean)this.isVisibleCustom.invoke() != false;
    }

    @JvmOverloads
    public CanvasResizeLayer(@NotNull ScreenView screenView, @NotNull Function0<Unit> repaint) {
        Intrinsics.checkNotNullParameter((Object)screenView, (String)"screenView");
        Intrinsics.checkNotNullParameter(repaint, (String)"repaint");
        this(screenView, repaint, null, 4, null);
    }

    private static final boolean _init_$lambda$0() {
        return true;
    }
}

