/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.validator.ValidatorData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J8\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\u00052\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020'0&J\u0006\u0010(\u001a\u00020\u001eJ\u0006\u0010)\u001a\u00020*R(\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\nR(\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\nR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0017j\b\u0012\u0004\u0012\u00020\u0007`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlScannerLayoutParser;", "", "<init>", "()V", "idToComponent", "Lcom/google/common/collect/BiMap;", "", "Lcom/android/tools/idea/common/model/NlComponent;", "getIdToComponent$annotations", "getIdToComponent", "()Lcom/google/common/collect/BiMap;", "viewToComponent", "Landroid/view/View;", "getViewToComponent$annotations", "getViewToComponent", "nodeIdToComponent", "", "getNodeIdToComponent", "includeComponents", "", "getIncludeComponents", "()Ljava/util/List;", "_includeComponents", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "value", "componentCount", "getComponentCount", "()I", "buildViewToComponentMap", "", "component", "tryFindingRootWithViewInfo", "findComponent", "result", "Lcom/android/tools/idea/validator/ValidatorData$Issue;", "map", "nodeInfoMap", "Lcom/google/common/collect/ImmutableBiMap;", "Landroid/view/accessibility/AccessibilityNodeInfo;", "clear", "isEmpty", "", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNlScannerLayoutParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlScannerLayoutParser.kt\ncom/android/tools/idea/uibuilder/surface/NlScannerLayoutParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1863#2,2:138\n1863#2,2:140\n*S KotlinDebug\n*F\n+ 1 NlScannerLayoutParser.kt\ncom/android/tools/idea/uibuilder/surface/NlScannerLayoutParser\n*L\n79#1:138,2\n94#1:140,2\n*E\n"})
public final class NlScannerLayoutParser {
    @NotNull
    private final BiMap<Integer, NlComponent> idToComponent;
    @NotNull
    private final BiMap<View, NlComponent> viewToComponent;
    @NotNull
    private final BiMap<Long, NlComponent> nodeIdToComponent;
    @NotNull
    private final ArrayList<NlComponent> _includeComponents;
    private int componentCount;
    public static final int $stable = 8;

    public NlScannerLayoutParser() {
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
        this.idToComponent = (BiMap)hashBiMap;
        HashBiMap hashBiMap2 = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap2, (String)"create(...)");
        this.viewToComponent = (BiMap)hashBiMap2;
        HashBiMap hashBiMap3 = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap3, (String)"create(...)");
        this.nodeIdToComponent = (BiMap)hashBiMap3;
        this._includeComponents = new ArrayList();
    }

    @NotNull
    public final BiMap<Integer, NlComponent> getIdToComponent() {
        return this.idToComponent;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIdToComponent$annotations() {
    }

    @NotNull
    public final BiMap<View, NlComponent> getViewToComponent() {
        return this.viewToComponent;
    }

    @VisibleForTesting
    public static /* synthetic */ void getViewToComponent$annotations() {
    }

    @NotNull
    public final BiMap<Long, NlComponent> getNodeIdToComponent() {
        return this.nodeIdToComponent;
    }

    @NotNull
    public final List<NlComponent> getIncludeComponents() {
        return this._includeComponents;
    }

    public final int getComponentCount() {
        return this.componentCount;
    }

    public final void buildViewToComponentMap(@NotNull NlComponent component) {
        block5: {
            Object accessibilityNodeInfo;
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            NlComponent root = this.tryFindingRootWithViewInfo(component);
            int n = this.componentCount;
            this.componentCount = n + 1;
            String string = root.getTagName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagName(...)");
            String className = string;
            if (Intrinsics.areEqual((Object)className, (Object)"include") && !Intrinsics.areEqual((Object)root.getAttribute("http://schemas.android.com/tools", "ignore"), (Object)"ignoreA11yLints")) {
                this._includeComponents.add(root);
                return;
            }
            ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(root);
            if (viewInfo == null) break block5;
            ViewInfo viewInfo2 = viewInfo;
            boolean bl = false;
            Object viewObj = viewInfo2.getViewObject();
            if (viewObj instanceof View) {
                ((Map)this.viewToComponent).put(viewObj, component);
                if (-1 != ((View)viewObj).getId()) {
                    ((Map)this.idToComponent).put(((View)viewObj).getId(), component);
                }
            }
            if ((accessibilityNodeInfo = viewInfo2.getAccessibilityObject()) instanceof AccessibilityNodeInfo) {
                ((Map)this.nodeIdToComponent).put(((AccessibilityNodeInfo)accessibilityNodeInfo).getSourceNodeId(), component);
            }
            List<NlComponent> list = component.getChildren();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NlComponent it = (NlComponent)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                this.buildViewToComponentMap(it);
            }
        }
    }

    @NotNull
    public final NlComponent tryFindingRootWithViewInfo(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        if ((viewInfo != null ? viewInfo.getViewObject() : null) != null) {
            return component;
        }
        List<NlComponent> list = component.getChildren();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NlComponent it = (NlComponent)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            ViewInfo viewInfo2 = NlComponentHelperKt.getViewInfo(it);
            if ((viewInfo2 != null ? viewInfo2.getViewObject() : null) == null) continue;
            return it;
        }
        return component;
    }

    @Nullable
    public final NlComponent findComponent(@NotNull ValidatorData.Issue result, @NotNull BiMap<Long, View> map2, @NotNull ImmutableBiMap<Long, AccessibilityNodeInfo> nodeInfoMap) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter(nodeInfoMap, (String)"nodeInfoMap");
        View view = (View)map2.get((Object)result.mSrcId);
        if (view != null) {
            NlComponent toReturn = (NlComponent)this.viewToComponent.get((Object)view);
            if (toReturn == null) {
                toReturn = (NlComponent)this.idToComponent.get((Object)view.getId());
            }
            return toReturn;
        }
        AccessibilityNodeInfo accessibilityNodeInfo = (AccessibilityNodeInfo)nodeInfoMap.get((Object)result.mSrcId);
        if (accessibilityNodeInfo == null) {
            return null;
        }
        AccessibilityNodeInfo node = accessibilityNodeInfo;
        return (NlComponent)this.nodeIdToComponent.get((Object)node.getSourceNodeId());
    }

    public final void clear() {
        this.viewToComponent.clear();
        this.idToComponent.clear();
        this.nodeIdToComponent.clear();
        this._includeComponents.clear();
        this.componentCount = 0;
    }

    public final boolean isEmpty() {
        return this.viewToComponent.isEmpty() && this.idToComponent.isEmpty() && this._includeComponents.isEmpty();
    }
}

