/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.LayoutScannerControl;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.AccessibilityLintIntegrator;
import com.android.tools.idea.uibuilder.surface.NlAtfIssue;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlLayoutScanner;
import com.android.tools.idea.uibuilder.surface.NlLayoutScannerMetricTracker;
import com.android.tools.idea.uibuilder.surface.NlScannerLayoutParser;
import com.android.tools.idea.validator.LayoutValidator;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorHierarchy;
import com.android.tools.idea.validator.ValidatorResult;
import com.android.tools.rendering.RenderResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000u\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0001\u001b\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u00010B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u001c\u0010 \u001a\u00020\u001e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"H\u0016J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u0014J\u000e\u0010,\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u0014J\b\u0010-\u001a\u00020\u001eH\u0016J\b\u0010.\u001a\u00020/H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R,\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u000ej\b\u0012\u0004\u0012\u00020\u0014`\u00108\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0012R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\u00a8\u00061"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/common/surface/LayoutScannerControl;", "surface", "Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;", "parent", "<init>", "(Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;Lcom/intellij/openapi/Disposable;)V", "(Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;)V", "layoutParser", "Lcom/android/tools/idea/uibuilder/surface/NlScannerLayoutParser;", "lintIntegrator", "Lcom/android/tools/idea/uibuilder/surface/AccessibilityLintIntegrator;", "issues", "Ljava/util/HashSet;", "Lcom/android/tools/idea/common/error/Issue;", "Lkotlin/collections/HashSet;", "getIssues", "()Ljava/util/HashSet;", "listeners", "Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner$Listener;", "getListeners$annotations", "()V", "getListeners", "metricTracker", "Lcom/android/tools/idea/uibuilder/surface/NlLayoutScannerMetricTracker;", "atfIssueEventListener", "com/android/tools/idea/uibuilder/surface/NlLayoutScanner$atfIssueEventListener$1", "Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner$atfIssueEventListener$1;", "pause", "", "resume", "validateAndUpdateLint", "results", "", "Lcom/android/tools/idea/uibuilder/scene/LayoutlibSceneManager;", "Lcom/android/tools/rendering/RenderResult;", "updateLint", "validatorResult", "Lcom/android/tools/idea/validator/ValidatorResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "addListener", "listener", "removeListener", "dispose", "isParserCleaned", "", "Listener", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNlLayoutScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlLayoutScanner.kt\ncom/android/tools/idea/uibuilder/surface/NlLayoutScanner\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n216#2:198\n217#2:203\n1863#3,2:199\n1863#3,2:201\n1863#3,2:204\n1863#3,2:206\n*S KotlinDebug\n*F\n+ 1 NlLayoutScanner.kt\ncom/android/tools/idea/uibuilder/surface/NlLayoutScanner\n*L\n89#1:198\n89#1:203\n97#1:199,2\n104#1:201,2\n146#1:204,2\n125#1:206,2\n*E\n"})
public final class NlLayoutScanner
implements Disposable,
LayoutScannerControl {
    @NotNull
    private final NlScannerLayoutParser layoutParser;
    @NotNull
    private final AccessibilityLintIntegrator lintIntegrator;
    @NotNull
    private final HashSet<Listener> listeners;
    @NotNull
    private final NlLayoutScannerMetricTracker metricTracker;
    @NotNull
    private final atfIssueEventListener.1 atfIssueEventListener;
    public static final int $stable = 8;

    public NlLayoutScanner(@NotNull NlDesignSurface surface2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.layoutParser = new NlScannerLayoutParser();
        this.lintIntegrator = new AccessibilityLintIntegrator(surface2.getIssueModel());
        this.listeners = new HashSet();
        this.metricTracker = new NlLayoutScannerMetricTracker(surface2);
        this.atfIssueEventListener = new NlAtfIssue.EventListener(this){
            final /* synthetic */ NlLayoutScanner this$0;
            {
                this.this$0 = $receiver;
            }

            public void onApplyFixButtonClicked(ValidatorData.Issue issue) {
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                NlLayoutScanner.access$getMetricTracker$p(this.this$0).trackApplyFixButtonClicked(issue);
            }

            public void onIgnoreButtonClicked(ValidatorData.Issue issue) {
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                NlLayoutScanner.access$getMetricTracker$p(this.this$0).trackIgnoreButtonClicked(issue);
            }
        };
        Disposer.register((Disposable)parent, (Disposable)this);
        LayoutValidator.setObtainCharacterLocations((boolean)true);
    }

    public NlLayoutScanner(@NotNull NlDesignSurface surface2) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        this(surface2, surface2);
    }

    @NotNull
    public HashSet<Issue> getIssues() {
        return this.lintIntegrator.getIssues();
    }

    @NotNull
    public final HashSet<Listener> getListeners() {
        return this.listeners;
    }

    @VisibleForTesting
    public static /* synthetic */ void getListeners$annotations() {
    }

    @Override
    public void pause() {
        LayoutValidator.setPaused((boolean)true);
    }

    @Override
    public void resume() {
        LayoutValidator.setPaused((boolean)false);
    }

    @Override
    public void validateAndUpdateLint(@NotNull Map<LayoutlibSceneManager, ? extends RenderResult> results) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        this.lintIntegrator.clear();
        Map<LayoutlibSceneManager, ? extends RenderResult> $this$forEach$iv = results;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<LayoutlibSceneManager, ? extends RenderResult>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Listener it;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv2;
            Map.Entry<LayoutlibSceneManager, ? extends RenderResult> element$iv;
            Map.Entry<LayoutlibSceneManager, ? extends RenderResult> entry = element$iv = iterator.next();
            boolean bl = false;
            LayoutlibSceneManager manager = entry.getKey();
            RenderResult renderResult = entry.getValue();
            if (!manager.getSceneRenderConfiguration().getLayoutScannerConfig().isIntegrateWithDefaultIssuePanel()) continue;
            Object validatorResult = renderResult.getValidatorResult();
            if (validatorResult instanceof ValidatorHierarchy) {
                if (!((ValidatorHierarchy)validatorResult).isHierarchyBuilt()) {
                    $this$forEach$iv2 = this.listeners;
                    $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        it = (Listener)element$iv2;
                        boolean bl2 = false;
                        it.lintUpdated(null);
                    }
                    continue;
                }
                ValidatorResult validatorResult2 = LayoutValidator.validate((ValidatorHierarchy)((ValidatorHierarchy)validatorResult));
                Intrinsics.checkNotNullExpressionValue((Object)validatorResult2, (String)"validate(...)");
                this.updateLint(validatorResult2, manager.getModel());
                continue;
            }
            $this$forEach$iv2 = this.listeners;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Listener)element$iv2;
                boolean bl3 = false;
                it.lintUpdated(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void updateLint(@NotNull ValidatorResult validatorResult, @NotNull NlModel model) {
        ImmutableList<NlComponent> components;
        ValidatorResult result;
        block8: {
            Intrinsics.checkNotNullParameter((Object)validatorResult, (String)"validatorResult");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.layoutParser.clear();
            result = null;
            components = model.getTreeReader().getComponents();
            if (!components.isEmpty()) break block8;
            this.layoutParser.clear();
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Listener it = (Listener)element$iv;
                boolean bl = false;
                it.lintUpdated(result);
            }
            return;
        }
        try {
            int issuesWithoutSources = 0;
            NlComponent root = (NlComponent)components.get(0);
            Intrinsics.checkNotNull((Object)root);
            this.layoutParser.buildViewToComponentMap(root);
            List list = validatorResult.getIssues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIssues(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ValidatorData.Issue it = (ValidatorData.Issue)element$iv;
                boolean bl = false;
                if (it.mLevel != ValidatorData.Level.ERROR && it.mLevel != ValidatorData.Level.WARNING || it.mType != ValidatorData.Type.ACCESSIBILITY) continue;
                Intrinsics.checkNotNull((Object)it);
                ImmutableBiMap immutableBiMap = validatorResult.getSrcMap();
                Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"getSrcMap(...)");
                BiMap biMap = (BiMap)immutableBiMap;
                ImmutableBiMap immutableBiMap2 = validatorResult.getNodeInfoMap();
                Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap2, (String)"getNodeInfoMap(...)");
                NlComponent component = this.layoutParser.findComponent(it, (BiMap<Long, View>)biMap, (ImmutableBiMap<Long, AccessibilityNodeInfo>)immutableBiMap2);
                if (component == null) {
                    int n = issuesWithoutSources;
                    issuesWithoutSources = n + 1;
                    continue;
                }
                this.lintIntegrator.createIssue(it, component, this.atfIssueEventListener);
            }
            this.lintIntegrator.populateLints();
            result = validatorResult;
            this.layoutParser.clear();
        }
        catch (Throwable throwable) {
            this.layoutParser.clear();
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Listener it = (Listener)element$iv;
                boolean bl = false;
                it.lintUpdated(result);
            }
            throw throwable;
        }
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.lintUpdated(result);
        }
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public void dispose() {
        this.metricTracker.clear();
        this.layoutParser.clear();
        this.listeners.clear();
        this.lintIntegrator.clear();
    }

    @VisibleForTesting
    public final boolean isParserCleaned() {
        return this.layoutParser.isEmpty();
    }

    public static final /* synthetic */ NlLayoutScannerMetricTracker access$getMetricTracker$p(NlLayoutScanner $this) {
        return $this.metricTracker;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner$Listener;", "", "lintUpdated", "", "result", "Lcom/android/tools/idea/validator/ValidatorResult;", "intellij.android.designer"})
    public static interface Listener {
        public void lintUpdated(@Nullable ValidatorResult var1);
    }
}

