/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ScoutArrange {
    static Comparator<ScoutWidget> sSortRecY = (w1, w2) -> w1.getDpY() - w2.getDpY();
    static Comparator<ScoutWidget> sSortRecX = (w1, w2) -> w1.getDpX() - w2.getDpX();

    /*
     * WARNING - void declaration
     */
    public static void align(Scout.Arrange type, List<NlComponent> widgetList, boolean applyConstraints) {
        if (widgetList == null || widgetList.isEmpty()) {
            return;
        }
        if (widgetList.get(0).getParent() == null) {
            return;
        }
        ScoutWidget parentScoutWidget = new ScoutWidget(widgetList.get(0).getParent(), null);
        ScoutWidget[] scoutWidgets = ScoutWidget.create(widgetList, parentScoutWidget);
        int margin = Scout.getMargin();
        switch (type) {
            case AlignHorizontallyCenter: 
            case AlignHorizontallyLeft: 
            case AlignHorizontallyRight: {
                Arrays.sort(scoutWidgets, sSortRecY);
                if (ScoutArrange.rootDistance(scoutWidgets[0].mNlComponent) <= ScoutArrange.rootDistance(scoutWidgets[scoutWidgets.length - 1].mNlComponent)) break;
                ScoutArrange.reverse(scoutWidgets);
                break;
            }
            case DistributeVertically: {
                Arrays.sort(scoutWidgets, sSortRecY);
                break;
            }
            case AlignVerticallyTop: 
            case AlignVerticallyMiddle: 
            case AlignBaseline: 
            case AlignVerticallyBottom: {
                Arrays.sort(scoutWidgets, sSortRecX);
                if (ScoutArrange.rootDistance(scoutWidgets[0].mNlComponent) <= ScoutArrange.rootDistance(scoutWidgets[scoutWidgets.length - 1].mNlComponent)) break;
                ScoutArrange.reverse(scoutWidgets);
                break;
            }
            case DistributeHorizontally: {
                Arrays.sort(scoutWidgets, sSortRecX);
                break;
            }
        }
        switch (type) {
            case ConnectTop: {
                ScoutArrange.connect(scoutWidgets, parentScoutWidget, Direction.TOP, applyConstraints ? 0 : -1);
                break;
            }
            case ConnectBottom: {
                ScoutArrange.connect(scoutWidgets, parentScoutWidget, Direction.BOTTOM, applyConstraints ? 0 : -1);
                break;
            }
            case ConnectStart: {
                ScoutArrange.connect(scoutWidgets, parentScoutWidget, Direction.LEFT, applyConstraints ? 0 : -1);
                break;
            }
            case ConnectEnd: {
                ScoutArrange.connect(scoutWidgets, parentScoutWidget, Direction.RIGHT, applyConstraints ? 0 : -1);
                break;
            }
            case CreateHorizontalChain: {
                Arrays.sort(scoutWidgets, sSortRecX);
                Rectangle rectangle = new Rectangle();
                NlComponent nlComponent = parentScoutWidget.mNlComponent;
                ScoutWidget[] scoutWidgetArray = ScoutWidget.create(nlComponent.getChildren(), parentScoutWidget);
                ScoutWidget leftConnect = null;
                for (int i = 0; i < scoutWidgets.length; ++i) {
                    void var13_179;
                    void var13_182;
                    ScoutWidget rightConnect;
                    ScoutWidget widget = scoutWidgets[i];
                    if (i + 1 < scoutWidgets.length) {
                        rightConnect = scoutWidgets[i + 1];
                    } else {
                        rectangle.x = widget.getDpX();
                        rectangle.y = widget.getDpY();
                        rectangle.width = widget.getDpWidth();
                        rectangle.height = widget.getDpHeight();
                        rightConnect = ScoutArrange.gapWidget(Direction.RIGHT, rectangle, scoutWidgetArray, parentScoutWidget);
                    }
                    if (leftConnect == null) {
                        rectangle.x = widget.getDpX();
                        rectangle.y = widget.getDpY();
                        rectangle.width = widget.getDpWidth();
                        rectangle.height = widget.getDpHeight();
                        leftConnect = ScoutArrange.gapWidget(Direction.LEFT, rectangle, scoutWidgetArray, parentScoutWidget);
                    } else {
                        leftConnect = scoutWidgets[i - 1];
                    }
                    Direction direction = Direction.RIGHT;
                    if (leftConnect == parentScoutWidget) {
                        Direction direction2 = Direction.LEFT;
                    }
                    ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.LEFT, leftConnect.mNlComponent, (Direction)var13_182, 0);
                    Direction direction3 = Direction.LEFT;
                    if (rightConnect == parentScoutWidget) {
                        Direction direction4 = Direction.RIGHT;
                    }
                    ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.RIGHT, rightConnect.mNlComponent, (Direction)var13_179, 0);
                    ConstraintComponentUtilities.setScoutHorizontalBiasPercent(widget.mNlComponent, 0.5f);
                }
                break;
            }
            case CreateVerticalChain: {
                Arrays.sort(scoutWidgets, sSortRecY);
                Rectangle rectangle = new Rectangle();
                NlComponent nlComponent = parentScoutWidget.mNlComponent;
                ScoutWidget[] scoutWidgetArray = ScoutWidget.create(nlComponent.getChildren(), parentScoutWidget);
                ScoutWidget topConnect = null;
                for (int i = 0; i < scoutWidgets.length; ++i) {
                    void var13_185;
                    void var13_188;
                    ScoutWidget bottomConnect;
                    ScoutWidget widget = scoutWidgets[i];
                    if (i + 1 < scoutWidgets.length) {
                        bottomConnect = scoutWidgets[i + 1];
                    } else {
                        rectangle.x = widget.getDpX();
                        rectangle.y = widget.getDpY();
                        rectangle.width = widget.getDpWidth();
                        rectangle.height = widget.getDpHeight();
                        bottomConnect = ScoutArrange.gapWidget(Direction.BOTTOM, rectangle, scoutWidgetArray, parentScoutWidget);
                    }
                    if (topConnect == null) {
                        rectangle.x = widget.getDpX();
                        rectangle.y = widget.getDpY();
                        rectangle.width = widget.getDpWidth();
                        rectangle.height = widget.getDpHeight();
                        topConnect = ScoutArrange.gapWidget(Direction.TOP, rectangle, scoutWidgetArray, parentScoutWidget);
                    } else {
                        topConnect = scoutWidgets[i - 1];
                    }
                    Direction direction = Direction.BOTTOM;
                    if (topConnect == parentScoutWidget) {
                        Direction direction5 = Direction.TOP;
                    }
                    ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.TOP, topConnect.mNlComponent, (Direction)var13_188, 0);
                    Direction direction6 = Direction.TOP;
                    if (bottomConnect == parentScoutWidget) {
                        Direction direction7 = Direction.BOTTOM;
                    }
                    ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.BOTTOM, bottomConnect.mNlComponent, (Direction)var13_185, 0);
                    ConstraintComponentUtilities.setScoutHorizontalBiasPercent(widget.mNlComponent, 0.5f);
                }
                break;
            }
            case CenterHorizontally: {
                Rectangle rectangle = new Rectangle();
                NlComponent nlComponent = parentScoutWidget.mNlComponent;
                ScoutWidget[] scoutWidgetArray = ScoutWidget.create(nlComponent.getChildren(), parentScoutWidget);
                for (ScoutWidget widget : scoutWidgets) {
                    rectangle.x = widget.getDpX();
                    rectangle.y = widget.getDpY();
                    rectangle.width = widget.getDpWidth();
                    rectangle.height = widget.getDpHeight();
                    int n = ScoutArrange.gap(Direction.LEFT, rectangle, scoutWidgetArray, parentScoutWidget);
                    int eastDistance = ScoutArrange.gap(Direction.RIGHT, rectangle, scoutWidgetArray, parentScoutWidget);
                    int x = widget.getDpX();
                    if (applyConstraints) {
                        ScoutWidget westConnect = ScoutArrange.gapWidget(Direction.LEFT, rectangle, scoutWidgetArray, parentScoutWidget);
                        ScoutWidget eastConnect = ScoutArrange.gapWidget(Direction.RIGHT, rectangle, scoutWidgetArray, parentScoutWidget);
                        Direction dir = Direction.RIGHT;
                        if (westConnect == parentScoutWidget) {
                            dir = Direction.LEFT;
                        }
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.LEFT, westConnect.mNlComponent, dir, 0);
                        dir = Direction.LEFT;
                        if (eastConnect == parentScoutWidget) {
                            dir = Direction.RIGHT;
                        }
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.RIGHT, eastConnect.mNlComponent, dir, 0);
                        ConstraintComponentUtilities.setScoutHorizontalBiasPercent(widget.mNlComponent, 0.5f);
                        continue;
                    }
                    ConstraintComponentUtilities.setScoutAbsoluteDpX(widget.mNlComponent, x + (eastDistance - n) / 2, true);
                }
                break;
            }
            case CenterVertically: {
                Rectangle rectangle = new Rectangle();
                NlComponent nlComponent = parentScoutWidget.mNlComponent;
                ScoutWidget[] scoutWidgetArray = ScoutWidget.create(nlComponent.getChildren(), parentScoutWidget);
                for (ScoutWidget widget : scoutWidgets) {
                    rectangle.x = widget.getDpX();
                    rectangle.y = widget.getDpY();
                    rectangle.width = widget.getDpWidth();
                    rectangle.height = widget.getDpHeight();
                    int n = ScoutArrange.gap(Direction.TOP, rectangle, scoutWidgetArray, parentScoutWidget);
                    int southDistance = ScoutArrange.gap(Direction.BOTTOM, rectangle, scoutWidgetArray, parentScoutWidget);
                    int Y = widget.getDpY();
                    if (applyConstraints) {
                        ScoutWidget northConnect = ScoutArrange.gapWidget(Direction.TOP, rectangle, scoutWidgetArray, parentScoutWidget);
                        ScoutWidget southConnect = ScoutArrange.gapWidget(Direction.BOTTOM, rectangle, scoutWidgetArray, parentScoutWidget);
                        Direction dir = Direction.BOTTOM;
                        if (northConnect == parentScoutWidget) {
                            dir = Direction.TOP;
                        }
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.TOP, northConnect.mNlComponent, dir, 0);
                        dir = Direction.TOP;
                        if (southConnect == parentScoutWidget) {
                            dir = Direction.BOTTOM;
                        }
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.BOTTOM, southConnect.mNlComponent, dir, 0);
                        ConstraintComponentUtilities.setScoutVerticalBiasPercent(widget.mNlComponent, 0.5f);
                        continue;
                    }
                    ConstraintComponentUtilities.setScoutAbsoluteDpY(widget.mNlComponent, Y + (southDistance - n) / 2, true);
                }
                break;
            }
            case CenterHorizontallyInParent: {
                void var8_59;
                ScoutWidget[] rectangle = scoutWidgets;
                int n = rectangle.length;
                boolean bl = false;
                while (var8_59 < n) {
                    ScoutWidget widget = rectangle[var8_59];
                    int parentWidth = parentScoutWidget.getDpWidth();
                    int width = widget.getDpWidth();
                    ConstraintComponentUtilities.setScoutAbsoluteDpX(widget.mNlComponent, (parentWidth - width) / 2, true);
                    if (applyConstraints) {
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.LEFT, parentScoutWidget.mNlComponent, Direction.LEFT, 0);
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.RIGHT, parentScoutWidget.mNlComponent, Direction.RIGHT, 0);
                        ConstraintComponentUtilities.setScoutHorizontalBiasPercent(widget.mNlComponent, 0.5f);
                    }
                    ++var8_59;
                }
                break;
            }
            case CenterVerticallyInParent: {
                void var8_61;
                ScoutWidget[] rectangle = scoutWidgets;
                int n = rectangle.length;
                boolean bl = false;
                while (var8_61 < n) {
                    ScoutWidget widget = rectangle[var8_61];
                    int parentHeight = parentScoutWidget.getDpHeight();
                    int height = widget.getDpHeight();
                    ConstraintComponentUtilities.setScoutAbsoluteDpY(widget.mNlComponent, (parentHeight - height) / 2, true);
                    if (applyConstraints) {
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.TOP, parentScoutWidget.mNlComponent, Direction.TOP, 0);
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.BOTTOM, parentScoutWidget.mNlComponent, Direction.BOTTOM, 0);
                        ConstraintComponentUtilities.setScoutVerticalBiasPercent(widget.mNlComponent, 0.5f);
                    }
                    ++var8_61;
                }
                break;
            }
            case AlignHorizontallyCenter: {
                int count = 0;
                float f = 0.0f;
                for (ScoutWidget widget : scoutWidgets) {
                    f += (float)widget.getDpX() + (float)widget.getDpWidth() / 2.0f;
                    ++count;
                }
                f /= (float)count;
                Object var8_63 = null;
                for (ScoutWidget widget : scoutWidgets) {
                    void var8_64;
                    float f2 = (float)widget.getDpWidth() / 2.0f;
                    ConstraintComponentUtilities.setScoutAbsoluteDpX(widget.mNlComponent, (int)(f - f2), true);
                    if (applyConstraints && var8_64 != null) {
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.LEFT, (NlComponent)var8_64, Direction.LEFT, 0);
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.RIGHT, (NlComponent)var8_64, Direction.RIGHT, 0);
                    }
                    NlComponent nlComponent = widget.mNlComponent;
                }
                break;
            }
            case AlignHorizontallyLeft: {
                int min = Integer.MAX_VALUE;
                if (applyConstraints) {
                    ScoutArrange.flipConnectionsAndReverse(scoutWidgets, Direction.LEFT, ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourStartAttributes);
                }
                for (ScoutWidget widget : scoutWidgets) {
                    min = Math.min(min, widget.getDpX());
                }
                Object var7_31 = null;
                for (ScoutWidget widget : scoutWidgets) {
                    void var7_32;
                    ConstraintComponentUtilities.setScoutAbsoluteDpX(widget.mNlComponent, min, true);
                    if (applyConstraints && var7_32 != null) {
                        ConstraintComponentUtilities.scoutClearAttributes(widget.mNlComponent, ConstraintComponentUtilities.ourRightAttributes);
                        ConstraintComponentUtilities.scoutClearAttributes(widget.mNlComponent, ConstraintComponentUtilities.ourEndAttributes);
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.LEFT, (NlComponent)var7_32, Direction.LEFT, 0);
                    }
                    NlComponent nlComponent = widget.mNlComponent;
                }
                break;
            }
            case AlignHorizontallyRight: {
                int max = Integer.MIN_VALUE;
                if (applyConstraints) {
                    ScoutArrange.flipConnectionsAndReverse(scoutWidgets, Direction.RIGHT, ConstraintComponentUtilities.ourRightAttributes, ConstraintComponentUtilities.ourEndAttributes);
                }
                for (ScoutWidget widget : scoutWidgets) {
                    max = Math.max(max, widget.getDpX() + widget.getDpWidth());
                }
                Object var7_35 = null;
                for (ScoutWidget widget : scoutWidgets) {
                    void var7_36;
                    float current = widget.getDpWidth();
                    ConstraintComponentUtilities.setScoutAbsoluteDpX(widget.mNlComponent, (int)((float)max - current), true);
                    if (applyConstraints && var7_36 != null) {
                        ConstraintComponentUtilities.scoutClearAttributes(widget.mNlComponent, ConstraintComponentUtilities.ourLeftAttributes);
                        ConstraintComponentUtilities.scoutClearAttributes(widget.mNlComponent, ConstraintComponentUtilities.ourStartAttributes);
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.RIGHT, (NlComponent)var7_36, Direction.RIGHT, 0);
                    }
                    NlComponent nlComponent = widget.mNlComponent;
                }
                break;
            }
            case AlignVerticallyTop: {
                int min = Integer.MAX_VALUE;
                if (applyConstraints) {
                    ScoutArrange.flipConnectionsAndReverse(scoutWidgets, Direction.TOP, ConstraintComponentUtilities.ourTopAttributes, null);
                }
                for (ScoutWidget widget : scoutWidgets) {
                    min = Math.min(min, widget.getDpY());
                }
                Object var7_39 = null;
                for (ScoutWidget widget : scoutWidgets) {
                    void var7_40;
                    ConstraintComponentUtilities.setScoutAbsoluteDpY(widget.mNlComponent, min, true);
                    if (applyConstraints && var7_40 != null) {
                        ConstraintComponentUtilities.scoutClearAttributes(widget.mNlComponent, ConstraintComponentUtilities.ourBottomAttributes);
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.TOP, (NlComponent)var7_40, Direction.TOP, 0);
                    }
                    NlComponent nlComponent = widget.mNlComponent;
                }
                break;
            }
            case AlignVerticallyMiddle: {
                int count = 0;
                float f = 0.0f;
                for (ScoutWidget widget : scoutWidgets) {
                    f += (float)widget.getDpY() + (float)widget.getDpHeight() / 2.0f;
                    ++count;
                }
                f /= (float)count;
                Object var8_73 = null;
                for (ScoutWidget widget2 : scoutWidgets) {
                    void var8_74;
                    float f3 = (float)widget2.getDpHeight() / 2.0f;
                    ConstraintComponentUtilities.setScoutAbsoluteDpY(widget2.mNlComponent, (int)(f - f3), true);
                    if (applyConstraints && var8_74 != null) {
                        ConstraintComponentUtilities.scoutConnect(widget2.mNlComponent, Direction.TOP, (NlComponent)var8_74, Direction.TOP, 0);
                        ConstraintComponentUtilities.scoutConnect(widget2.mNlComponent, Direction.BOTTOM, (NlComponent)var8_74, Direction.BOTTOM, 0);
                    }
                    NlComponent nlComponent = widget2.mNlComponent;
                }
                break;
            }
            case AlignBaseline: {
                void var8_77;
                int count = 0;
                float f = 0.0f;
                if (applyConstraints) {
                    ScoutArrange.flipBaselineAndReverse(scoutWidgets);
                }
                boolean bl = false;
                NlComponent fixedWidget = null;
                for (ScoutWidget scoutWidget : scoutWidgets) {
                    if (ScoutArrange.isVerticallyConstrained(scoutWidget.mNlComponent)) {
                        ++var8_77;
                        fixedWidget = scoutWidget.mNlComponent;
                    }
                    f += (float)(scoutWidget.getDpY() + scoutWidget.getDpBaseline());
                    ++count;
                }
                f /= (float)count;
                if (var8_77 == true) {
                    f = ConstraintComponentUtilities.getDpX(fixedWidget) + ConstraintComponentUtilities.getDpBaseline(fixedWidget);
                }
                NlComponent previousWidget = null;
                if (!applyConstraints || var8_77 == false) {
                    void var13_197;
                    ScoutWidget[] widget = scoutWidgets;
                    int widget2 = widget.length;
                    boolean bl2 = false;
                    while (var13_197 < widget2) {
                        ScoutWidget widget3 = widget[var13_197];
                        float baseline = widget3.getDpBaseline();
                        ConstraintComponentUtilities.setScoutAbsoluteDpY(widget3.mNlComponent, (int)(f - baseline), true);
                        if (applyConstraints && previousWidget != null) {
                            ConstraintComponentUtilities.scoutConnect(widget3.mNlComponent, Direction.BASELINE, previousWidget, Direction.BASELINE, 0);
                        }
                        previousWidget = widget3.mNlComponent;
                        ++var13_197;
                    }
                } else {
                    ArrayList<ScoutWidget> unconstrained = new ArrayList<ScoutWidget>();
                    ArrayList<ScoutWidget> constrained = new ArrayList<ScoutWidget>();
                    for (ScoutWidget widget : scoutWidgets) {
                        if (ScoutArrange.isVerticallyConstrained(widget.mNlComponent)) {
                            constrained.add(widget);
                            continue;
                        }
                        unconstrained.add(widget);
                    }
                    while (!unconstrained.isEmpty()) {
                        void var13_201;
                        Object var13_200 = null;
                        ScoutWidget from = null;
                        int min = Integer.MAX_VALUE;
                        for (ScoutWidget fromCandidate : unconstrained) {
                            for (ScoutWidget toCandidate : constrained) {
                                int fromLeft = fromCandidate.getDpX();
                                int fromRight = fromLeft + fromCandidate.getDpWidth();
                                int toLeft = toCandidate.getDpX();
                                int toRight = toLeft + toCandidate.getDpWidth();
                                int dist = Math.abs(toLeft - fromLeft);
                                dist = Math.min(dist, Math.abs(toLeft - fromRight));
                                dist = Math.min(dist, Math.abs(toRight - fromRight));
                                if ((dist = Math.min(dist, Math.abs(toRight - fromLeft))) >= min) continue;
                                min = dist;
                                ScoutWidget scoutWidget = toCandidate;
                                from = fromCandidate;
                            }
                        }
                        ConstraintComponentUtilities.scoutConnect(from.mNlComponent, Direction.BASELINE, var13_201.mNlComponent, Direction.BASELINE, 0);
                        constrained.add(from);
                        unconstrained.remove(from);
                    }
                }
                break;
            }
            case AlignVerticallyBottom: {
                int max = Integer.MIN_VALUE;
                if (applyConstraints) {
                    ScoutArrange.flipConnectionsAndReverse(scoutWidgets, Direction.BOTTOM, ConstraintComponentUtilities.ourBottomAttributes, null);
                }
                for (ScoutWidget widget : scoutWidgets) {
                    max = Math.max(max, widget.getDpY() + widget.getDpHeight());
                }
                Object var7_45 = null;
                for (ScoutWidget widget : scoutWidgets) {
                    void var7_46;
                    float current = widget.getDpHeight();
                    ConstraintComponentUtilities.setScoutAbsoluteDpY(widget.mNlComponent, (int)((float)max - current), true);
                    if (applyConstraints && var7_46 != null) {
                        ConstraintComponentUtilities.scoutClearAttributes(widget.mNlComponent, ConstraintComponentUtilities.ourTopAttributes);
                        ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, Direction.BOTTOM, (NlComponent)var7_46, Direction.BOTTOM, 0);
                    }
                    NlComponent nlComponent = widget.mNlComponent;
                }
                break;
            }
            case DistributeVertically: {
                void var7_49;
                int n;
                int size;
                int count = 0;
                boolean bl = false;
                int n2 = ConstraintComponentUtilities.getDpY(widgetList.get(0));
                int max = ConstraintComponentUtilities.getDpY(widgetList.get(0)) + ConstraintComponentUtilities.getDpHeight(widgetList.get(0));
                for (ScoutWidget scoutWidget : scoutWidgets) {
                    int start = scoutWidget.getDpY();
                    size = scoutWidget.getDpHeight();
                    int end = start + size;
                    var7_49 += size;
                    n = Math.min(n, start);
                    max = Math.max(max, end);
                    ++count;
                }
                int gaps = count - 1;
                int totalGap = max - n - var7_49;
                void lastY = n;
                boolean bl3 = ScoutArrange.rootDistanceY(scoutWidgets[0].mNlComponent) > ScoutArrange.rootDistanceY(scoutWidgets[scoutWidgets.length - 1].mNlComponent);
                for (int i = 0; i < count; ++i) {
                    if (i <= 0) continue;
                    size = scoutWidgets[i - 1].getDpHeight();
                    void pos = (var8_82 += size) + totalGap * i / gaps;
                    ConstraintComponentUtilities.setScoutAbsoluteDpY(scoutWidgets[i].mNlComponent, (int)pos, true);
                    if (!applyConstraints) continue;
                    if (bl3) {
                        ConstraintComponentUtilities.scoutConnect(scoutWidgets[i - 1].mNlComponent, Direction.BOTTOM, scoutWidgets[i].mNlComponent, Direction.TOP, (int)(pos - lastY - size));
                    } else {
                        ConstraintComponentUtilities.scoutConnect(scoutWidgets[i].mNlComponent, Direction.TOP, scoutWidgets[i - 1].mNlComponent, Direction.BOTTOM, (int)(pos - lastY - size));
                    }
                    lastY = pos;
                }
                break;
            }
            case DistributeHorizontally: {
                void var7_51;
                int n;
                int size;
                int count = 0;
                boolean bl = false;
                int n3 = ConstraintComponentUtilities.getDpX(widgetList.get(0));
                int max = ConstraintComponentUtilities.getDpX(widgetList.get(0)) + ConstraintComponentUtilities.getDpHeight(widgetList.get(0));
                for (ScoutWidget scoutWidget : scoutWidgets) {
                    int start = scoutWidget.getDpX();
                    size = scoutWidget.getDpWidth();
                    int end = start + size;
                    var7_51 += size;
                    n = Math.min(n, start);
                    max = Math.max(max, end);
                    ++count;
                }
                int gaps = count - 1;
                int totalGap = max - n - var7_51;
                void lastX = n;
                boolean bl4 = ScoutArrange.rootDistanceX(scoutWidgets[0].mNlComponent) > ScoutArrange.rootDistanceX(scoutWidgets[scoutWidgets.length - 1].mNlComponent);
                for (int i = 0; i < count; ++i) {
                    if (i <= 0) continue;
                    size = scoutWidgets[i - 1].getDpWidth();
                    void pos = (var8_85 += size) + totalGap * i / gaps;
                    ConstraintComponentUtilities.setScoutAbsoluteDpX(scoutWidgets[i].mNlComponent, (int)pos, true);
                    if (!applyConstraints) continue;
                    if (bl4) {
                        ConstraintComponentUtilities.scoutConnect(scoutWidgets[i - 1].mNlComponent, Direction.RIGHT, scoutWidgets[i].mNlComponent, Direction.LEFT, (int)(pos - lastX - size));
                    } else {
                        ConstraintComponentUtilities.scoutConnect(scoutWidgets[i].mNlComponent, Direction.LEFT, scoutWidgets[i - 1].mNlComponent, Direction.RIGHT, (int)(pos - lastX - size));
                    }
                    lastX = pos;
                }
                break;
            }
            case VerticalPack: {
                void var8_87;
                NlComponent[] wArray = new NlComponent[widgetList.size()];
                wArray = widgetList.toArray(wArray);
                Arrays.sort(wArray, (w1, w2) -> Integer.compare(ConstraintComponentUtilities.getDpY(w1), ConstraintComponentUtilities.getDpY(w2)));
                ScoutWidget[] scoutWidgetArray = ScoutWidget.getWidgetArray(widgetList.get(0).getParent());
                Object var8_86 = null;
                for (int i = 0; i < wArray.length; ++i) {
                    String id = "@+id/" + wArray[i].getId();
                    ScoutWidget w = scoutWidgetArray[0].getChild(id);
                    if (var8_87 == null) {
                        Rectangle rectangle = new Rectangle(w.getRectangle());
                        continue;
                    }
                    Rectangle rectangle = var8_87.union(w.getRectangle());
                }
                for (NlComponent cw : wArray) {
                    for (ScoutWidget scoutWidget : scoutWidgetArray) {
                        if (scoutWidget.mNlComponent != cw) continue;
                        int gapN = scoutWidget.gap(Direction.TOP, scoutWidgetArray);
                        int newY = margin + scoutWidget.getDpY() - gapN;
                        newY = Math.max(newY, var8_87.y);
                        scoutWidget.setY(newY);
                    }
                }
                break;
            }
            case HorizontalPack: {
                void var8_92;
                NlComponent[] wArray = new NlComponent[widgetList.size()];
                wArray = widgetList.toArray(wArray);
                Arrays.sort(wArray, (w1, w2) -> Integer.compare(ConstraintComponentUtilities.getDpX(w1), ConstraintComponentUtilities.getDpX(w2)));
                ScoutWidget[] scoutWidgetArray = ScoutWidget.getWidgetArray(widgetList.get(0).getParent());
                Object var8_91 = null;
                for (int i = 0; i < wArray.length; ++i) {
                    String id = "@+id/" + wArray[i].getId();
                    ScoutWidget w = scoutWidgetArray[0].getChild(id);
                    if (var8_92 == null) {
                        Rectangle rectangle = new Rectangle(w.getRectangle());
                        continue;
                    }
                    Rectangle rectangle = var8_92.union(w.getRectangle());
                }
                for (NlComponent cw : wArray) {
                    for (ScoutWidget scoutWidget : scoutWidgetArray) {
                        if (scoutWidget.mNlComponent != cw) continue;
                        int gapW = scoutWidget.gap(Direction.LEFT, scoutWidgetArray);
                        int newX = margin + ConstraintComponentUtilities.getDpX(scoutWidget.mNlComponent) - gapW;
                        newX = Math.max(newX, var8_92.x);
                        scoutWidget.setX(newX);
                    }
                }
                break;
            }
            case ExpandVertically: {
                ScoutArrange.expandVertically(scoutWidgets, parentScoutWidget, margin, true);
                break;
            }
            case ExpandHorizontally: {
                ScoutArrange.expandHorizontally(scoutWidgets, parentScoutWidget, margin, true);
                break;
            }
        }
    }

    public static void expandVertically(ScoutWidget[] list, ScoutWidget parent, int margin, boolean apply) {
        if (margin <= 0) {
            margin = 1;
        }
        ScoutWidget[] pears = ScoutWidget.create(parent.mNlComponent.getChildren(), parent);
        Rectangle selectBounds = ScoutArrange.getBoundingBox(list);
        Rectangle clip = new Rectangle();
        int gapNorth = ScoutArrange.gap(Direction.TOP, selectBounds, pears, parent);
        int gapSouth = ScoutArrange.gap(Direction.BOTTOM, selectBounds, pears, parent);
        clip.y = selectBounds.y - gapNorth;
        clip.height = selectBounds.height + gapSouth + gapNorth;
        ArrayList<ScoutWidget> selectedList = new ArrayList<ScoutWidget>(Arrays.asList(list));
        while (!selectedList.isEmpty()) {
            ScoutWidget widget = selectedList.remove(0);
            ArrayList<ScoutWidget> col = new ArrayList<ScoutWidget>();
            col.add(widget);
            Iterator<ScoutWidget> iterator = selectedList.iterator();
            while (iterator.hasNext()) {
                ScoutWidget elem = iterator.next();
                if (!ScoutArrange.isSameColumn(widget, elem)) continue;
                if (!col.contains(elem)) {
                    col.add(elem);
                }
                iterator.remove();
            }
            ScoutWidget[] colArray = new ScoutWidget[col.size()];
            colArray = col.toArray(colArray);
            Arrays.sort(colArray, sSortRecY);
            int gaps = (colArray.length - 1) * margin;
            int totalHeight = clip.height - gaps - 2 * margin;
            for (int i = 0; i < colArray.length; ++i) {
                int y = margin * i + i * totalHeight / colArray.length;
                ScoutWidget constraintWidget = colArray[i];
                ConstraintComponentUtilities.setScoutAbsoluteDpY(constraintWidget.mNlComponent, y + clip.y + margin, apply);
                int yend = margin * i + totalHeight * (i + 1) / colArray.length;
                ConstraintComponentUtilities.setScoutAbsoluteDpHeight(constraintWidget.mNlComponent, yend - y, apply);
                constraintWidget.setY(y + clip.y + margin);
                constraintWidget.setHeight(yend - y);
            }
        }
    }

    public static void expandHorizontally(ScoutWidget[] list, ScoutWidget parent, int margin, boolean apply) {
        if (margin <= 0) {
            margin = 1;
        }
        ScoutWidget[] pears = ScoutWidget.create(parent.mNlComponent.getChildren(), parent);
        Rectangle selectBounds = ScoutArrange.getBoundingBox(list);
        Rectangle clip = new Rectangle();
        int gapWest = ScoutArrange.gap(Direction.LEFT, selectBounds, pears, parent);
        int gapEast = ScoutArrange.gap(Direction.RIGHT, selectBounds, pears, parent);
        clip.x = selectBounds.x - gapWest;
        clip.width = selectBounds.width + gapEast + gapWest;
        ArrayList<ScoutWidget> selectedList = new ArrayList<ScoutWidget>(Arrays.asList(list));
        while (!selectedList.isEmpty()) {
            ScoutWidget widget = selectedList.remove(0);
            ArrayList<ScoutWidget> row = new ArrayList<ScoutWidget>();
            row.add(widget);
            Iterator<ScoutWidget> iterator = selectedList.iterator();
            while (iterator.hasNext()) {
                ScoutWidget elem = iterator.next();
                if (!ScoutArrange.isSameRow(widget, elem)) continue;
                if (!row.contains(elem)) {
                    row.add(elem);
                }
                iterator.remove();
            }
            ScoutWidget[] rowArray = new ScoutWidget[row.size()];
            rowArray = row.toArray(rowArray);
            Arrays.sort(rowArray, sSortRecX);
            int gaps = (rowArray.length - 1) * margin;
            int totalWidth = clip.width - gaps - 2 * margin;
            for (int i = 0; i < rowArray.length; ++i) {
                int x = margin * i + i * totalWidth / rowArray.length;
                ScoutWidget constraintWidget = rowArray[i];
                ConstraintComponentUtilities.setScoutAbsoluteDpX(constraintWidget.mNlComponent, x + clip.x + margin, apply);
                int xend = margin * i + totalWidth * (i + 1) / rowArray.length;
                ConstraintComponentUtilities.setScoutAbsoluteDpWidth(constraintWidget.mNlComponent, xend - x, apply);
                constraintWidget.setX(x + clip.x + margin);
                constraintWidget.setWidth(xend - x);
            }
        }
    }

    static boolean isSameRow(ScoutWidget a, ScoutWidget b) {
        return Math.max(a.getDpY(), b.getDpY()) < Math.min(a.getDpY() + a.getDpHeight(), b.getDpY() + b.getDpHeight());
    }

    static boolean isSameColumn(ScoutWidget a, ScoutWidget b) {
        return Math.max(a.getDpX(), b.getDpX()) < Math.min(a.getDpX() + a.getDpWidth(), b.getDpX() + b.getDpWidth());
    }

    static Rectangle getRectangle(ScoutWidget widget) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = widget.getDpX();
        rectangle.y = widget.getDpY();
        rectangle.width = widget.getDpWidth();
        rectangle.height = widget.getDpHeight();
        if (ConstraintComponentUtilities.isVerticalLine(widget.mNlComponent)) {
            rectangle.height = widget.getParent().getDpHeight();
            rectangle.y = 0;
        } else if (ConstraintComponentUtilities.isHorizontalLine(widget.mNlComponent)) {
            rectangle.width = widget.getParent().getDpWidth();
            rectangle.x = 0;
        }
        return rectangle;
    }

    public static ScoutWidget gapWidget(Direction direction, Rectangle region, ScoutWidget[] list, ScoutWidget parent) {
        int rootWidth = parent.getDpWidth();
        int rootHeight = parent.getDpHeight();
        Rectangle rect = new Rectangle();
        switch (direction) {
            case TOP: {
                rect.y = 0;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = region.y;
                break;
            }
            case BOTTOM: {
                rect.y = region.y + region.height + 1;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = rootHeight - rect.y;
                break;
            }
            case LEFT: {
                rect.y = region.y + 1;
                rect.x = 0;
                rect.width = region.x;
                rect.height = region.height - 2;
                break;
            }
            case RIGHT: {
                rect.y = region.y + 1;
                rect.x = region.x + region.width + 1;
                rect.width = rootWidth - rect.x;
                rect.height = region.height - 2;
                break;
            }
        }
        int min = Integer.MAX_VALUE;
        ScoutWidget minWidget = null;
        for (ScoutWidget widget : list) {
            int dist;
            Rectangle r;
            if (widget.isHorizontalGuideline() && (direction == Direction.LEFT || direction == Direction.RIGHT) || widget.isVerticalGuideline() && (direction == Direction.TOP || direction == Direction.BOTTOM) || !(r = ScoutArrange.getRectangle(widget)).intersects(rect) || min <= (dist = (int)ScoutArrange.distance(r, region))) continue;
            minWidget = widget;
            min = dist;
        }
        if (min > Math.max(rootHeight, rootWidth)) {
            return list[0].getParent();
        }
        return minWidget;
    }

    public static void flipBaselineAndReverse(ScoutWidget[] scoutWidgets) {
        ScoutWidget last = null;
        boolean isAlreadyConnected = true;
        for (ScoutWidget widget : scoutWidgets) {
            if (last != null && !widget.isConnected(Direction.BASELINE)) {
                isAlreadyConnected = false;
            }
            last = widget;
        }
        if (isAlreadyConnected) {
            ScoutArrange.reverse(scoutWidgets);
        }
        for (ScoutWidget widget : scoutWidgets) {
            ConstraintComponentUtilities.scoutClearAttributes(widget.mNlComponent, ConstraintComponentUtilities.ourBaselineAttributes);
        }
    }

    public static void flipConnectionsAndReverse(ScoutWidget[] scoutWidgets, Direction direction, ArrayList<String> clear, ArrayList<String> clearRtl) {
        ScoutWidget last = null;
        boolean isAlreadyConnected = true;
        for (ScoutWidget widget : scoutWidgets) {
            if (last != null && (!widget.isConnected(direction) || widget.isConnected(direction.getOpposite()))) {
                isAlreadyConnected = false;
            }
            last = widget;
        }
        if (isAlreadyConnected) {
            ScoutArrange.reverse(scoutWidgets);
        }
        if (scoutWidgets[0].isConnected(direction)) {
            for (ScoutWidget widget : scoutWidgets) {
                if (!scoutWidgets[0].isConnected(direction, widget)) continue;
                ConstraintComponentUtilities.scoutClearAttributes(scoutWidgets[0].mNlComponent, clear);
                if (clearRtl == null) break;
                ConstraintComponentUtilities.scoutClearAttributes(scoutWidgets[0].mNlComponent, clearRtl);
                break;
            }
        }
    }

    public static int gap(Direction direction, Rectangle region, ScoutWidget[] list, ScoutWidget root) {
        int rootWidth = root.getDpWidth();
        int rootHeight = root.getDpHeight();
        Rectangle rect = new Rectangle();
        switch (direction) {
            case TOP: {
                rect.y = 0;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = region.y;
                break;
            }
            case BOTTOM: {
                rect.y = region.y + region.height + 1;
                rect.x = region.x + 1;
                rect.width = region.width - 2;
                rect.height = rootHeight - rect.y;
                break;
            }
            case LEFT: {
                rect.y = region.y + 1;
                rect.x = 0;
                rect.width = region.x;
                rect.height = region.height - 2;
                break;
            }
            case RIGHT: {
                rect.y = region.y + 1;
                rect.x = region.x + region.width + 1;
                rect.width = rootWidth - rect.x;
                rect.height = region.height - 2;
                break;
            }
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < list.length; ++i) {
            int dist;
            ScoutWidget widget = list[i];
            Rectangle r = ScoutArrange.getRectangle(widget);
            if (!r.intersects(rect) || min <= (dist = (int)ScoutArrange.distance(r, region))) continue;
            min = dist;
        }
        if (min > Math.max(rootHeight, rootWidth)) {
            switch (direction) {
                case TOP: {
                    return region.y;
                }
                case BOTTOM: {
                    return rootHeight - (region.y + region.height);
                }
                case LEFT: {
                    return region.x;
                }
                case RIGHT: {
                    return rootWidth - (region.x + region.width);
                }
            }
        }
        return min;
    }

    static float distance(Rectangle a, Rectangle b) {
        float ax1 = a.x;
        float ax2 = a.x + a.width;
        float ay1 = a.y;
        float ay2 = a.y + a.height;
        float bx1 = b.x;
        float bx2 = b.x + b.width;
        float by1 = b.y;
        float by2 = b.y + b.height;
        float xdiff11 = Math.abs(ax1 - bx1);
        float xdiff12 = Math.abs(ax1 - bx2);
        float xdiff21 = Math.abs(ax2 - bx1);
        float xdiff22 = Math.abs(ax2 - bx2);
        float ydiff11 = Math.abs(ay1 - by1);
        float ydiff12 = Math.abs(ay1 - by2);
        float ydiff21 = Math.abs(ay2 - by1);
        float ydiff22 = Math.abs(ay2 - by2);
        float xmin = Math.min(Math.min(xdiff11, xdiff12), Math.min(xdiff21, xdiff22));
        float ymin = Math.min(Math.min(ydiff11, ydiff12), Math.min(ydiff21, ydiff22));
        boolean yOverlap = ay1 <= by2 && by1 <= ay2;
        boolean xOverlap = ax1 <= bx2 && bx1 <= ax2;
        float xReturn = yOverlap ? xmin : (float)Math.hypot(xmin, ymin);
        float yReturn = xOverlap ? ymin : (float)Math.hypot(xmin, ymin);
        return Math.min(xReturn, yReturn);
    }

    static int rootDistanceX(NlComponent widget) {
        int rootWidth = ConstraintComponentUtilities.getDpWidth(widget.getParent());
        int aX = ConstraintComponentUtilities.getDpX(widget);
        int aWidth = ConstraintComponentUtilities.getDpWidth(widget);
        return Math.min(aX, rootWidth - (aX + aWidth));
    }

    static int rootDistanceY(NlComponent widget) {
        int rootHeight = ConstraintComponentUtilities.getDpHeight(widget.getParent());
        int aY = ConstraintComponentUtilities.getDpY(widget);
        int aHeight = ConstraintComponentUtilities.getDpHeight(widget);
        return Math.min(aY, rootHeight - (aY + aHeight));
    }

    static Rectangle getBoundingBox(ScoutWidget[] widgets) {
        Rectangle all = null;
        Rectangle tmp = new Rectangle();
        for (ScoutWidget widget : widgets) {
            if (ConstraintComponentUtilities.isLine(widget.mNlComponent)) continue;
            tmp.x = widget.getDpX();
            tmp.y = widget.getDpY();
            tmp.width = widget.getDpWidth();
            tmp.height = widget.getDpHeight();
            all = all == null ? new Rectangle(tmp) : all.union(tmp);
        }
        return all;
    }

    private static void reverse(ScoutWidget[] widgets) {
        for (int i = 0; i < widgets.length / 2; ++i) {
            ScoutWidget widget = widgets[i];
            widgets[i] = widgets[widgets.length - 1 - i];
            widgets[widgets.length - 1 - i] = widget;
        }
    }

    private static int rootDistance(NlComponent widget) {
        int rootHeight = ConstraintComponentUtilities.getDpHeight(widget.getParent());
        int rootWidth = ConstraintComponentUtilities.getDpWidth(widget.getParent());
        int aX = ConstraintComponentUtilities.getDpX(widget);
        int aY = ConstraintComponentUtilities.getDpY(widget);
        int aWidth = ConstraintComponentUtilities.getDpHeight(widget);
        int aHeight = ConstraintComponentUtilities.getDpWidth(widget);
        int minx = Math.min(aX, rootWidth - (aX + aWidth));
        int miny = Math.min(aY, rootHeight - (aY + aHeight));
        return Math.min(minx, miny);
    }

    private static boolean isVerticallyConstrained(NlComponent widget) {
        if (ScoutWidget.isConnected(widget, Direction.BOTTOM)) {
            return true;
        }
        if (ScoutWidget.isConnected(widget, Direction.TOP)) {
            return true;
        }
        return ScoutWidget.isConnected(widget, Direction.BASELINE);
    }

    public static void connect(ScoutWidget[] scoutWidgets, ScoutWidget parentScoutWidget, Direction dir, int margin) {
        Rectangle rectangle = new Rectangle();
        NlComponent parent = parentScoutWidget.mNlComponent;
        ScoutWidget[] peers = ScoutWidget.create(parent.getChildren(), parentScoutWidget);
        for (ScoutWidget widget : scoutWidgets) {
            Direction connectDir;
            rectangle.x = widget.getDpX();
            rectangle.y = widget.getDpY();
            rectangle.width = widget.getDpWidth();
            rectangle.height = widget.getDpHeight();
            int dist = ScoutArrange.gap(dir, rectangle, peers, parentScoutWidget);
            ScoutWidget connect = ScoutArrange.gapWidget(dir, rectangle, peers, parentScoutWidget);
            Direction direction = connectDir = connect != parentScoutWidget ? dir.getOpposite() : dir;
            if (connect == null) continue;
            ConstraintComponentUtilities.scoutConnect(widget.mNlComponent, dir, connect.mNlComponent, connectDir, margin == -1 ? dist : margin);
        }
    }

    class Anchor {
        Direction myDirection;
        NlComponent mNlComponent;

        Anchor(NlComponent component, Direction dir) {
            this.mNlComponent = component;
            this.myDirection = dir;
        }

        public boolean isConnected() {
            String[] attrs = ScoutWidget.ATTR_CONNECTIONS[this.myDirection.ordinal()];
            for (int i = 0; i < attrs.length; ++i) {
                String attr2 = attrs[i];
                String id = this.mNlComponent.getAttribute("http://schemas.android.com/apk/res-auto", attr2);
                if (id == null) continue;
                return true;
            }
            return false;
        }

        public Direction getType() {
            return this.myDirection;
        }
    }
}

