/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.uibuilder.scout.Connection;
import com.android.tools.idea.uibuilder.scout.ConstrainedWidget;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;

public class ConstraintSet {
    private ArrayList<ConstrainedWidget> myWidgets;
    private ArrayList<Chain> myChains;
    private ArrayList<Connection> myChainConnnections;
    private double myError;
    private double connectionWeight = 5.0;

    public ConstraintSet(int[] cWidgets, ArrayList<ArrayList<ConstrainedWidget>> validConns, ScoutWidget parent) {
        this.myWidgets = new ArrayList();
        this.myChainConnnections = new ArrayList();
        for (int i = 0; i < validConns.size(); ++i) {
            ConstrainedWidget widget = validConns.get(i).get(cWidgets[i]);
            this.myWidgets.add(widget);
        }
    }

    public ConstraintSet(ScoutWidget[] widgets) {
        this.myChainConnnections = new ArrayList();
        this.myWidgets = new ArrayList();
        Connection[] connections = new Connection[5];
        for (int i = 1; i < widgets.length; ++i) {
            ScoutWidget wid = widgets[i];
            for (Direction dir : Direction.getAllDirections()) {
                if (wid.getAnchor(dir).isConnected()) {
                    ScoutWidget destWid = wid.getAnchor(dir).getTarget().getOwner();
                    Direction destDir = wid.getAnchor(dir).getTarget().getType();
                    int destIdx = 0;
                    for (int j = 0; j < widgets.length; ++j) {
                        if (widgets[j] != destWid) continue;
                        destIdx = j - 1;
                    }
                    connections[dir.ordinal()] = destIdx == 0 ? new Connection(-1, destDir) : new Connection(destIdx, destDir);
                    int originLine = wid.getPos(dir);
                    int destLine = destWid.getPos(destDir);
                    connections[dir.ordinal()].setMargin(destLine - originLine);
                    continue;
                }
                connections[dir.ordinal()] = new Connection(-2, dir);
            }
            ConstrainedWidget temp = new ConstrainedWidget(connections[Direction.TOP.ordinal()], connections[Direction.BOTTOM.ordinal()], connections[Direction.RIGHT.ordinal()], connections[Direction.LEFT.ordinal()], connections[Direction.BASELINE.ordinal()], wid);
            this.myWidgets.add(temp);
        }
    }

    boolean hasCycles() {
        boolean hasCycles;
        ArrayList<ConstrainedWidget> remaining = new ArrayList<ConstrainedWidget>(this.myWidgets);
        Stack<ConstrainedWidget> visited = new Stack<ConstrainedWidget>();
        for (hasCycles = false; remaining.size() != 0 && !hasCycles; hasCycles |= this.searchCycles(remaining, visited, remaining.get(0), 0)) {
        }
        remaining.addAll(this.myWidgets);
        visited.empty();
        while (remaining.size() != 0 && !hasCycles) {
            hasCycles |= this.searchCycles(remaining, visited, remaining.get(0), 1);
        }
        return hasCycles;
    }

    boolean searchCycles(ArrayList<ConstrainedWidget> remaining, Stack<ConstrainedWidget> visited, ConstrainedWidget current, int orientation) {
        boolean cycle = false;
        for (ConstrainedWidget cWid : visited) {
            if (cWid.getScoutWidget() != current.getScoutWidget()) continue;
            return true;
        }
        visited.add(current);
        if (!current.getScoutWidget().isGuideline()) {
            for (Direction dir : Direction.getDirections(orientation)) {
                if (cycle || current.getConnection(dir).isParentConnection() || !current.getConnection(dir).isConnected() || this.formsChain(visited, dir)) continue;
                cycle |= this.searchCycles(remaining, visited, this.myWidgets.get(current.getConnection(dir).destWidget()), orientation);
            }
        }
        if (!cycle) {
            visited.pop();
            remaining.remove(current);
        }
        return cycle;
    }

    public boolean formsChain(Stack<ConstrainedWidget> visited, Direction dir) {
        ConstrainedWidget current = visited.peek();
        if (dir == Direction.BASELINE) {
            return false;
        }
        if (visited.size() == 1) {
            return false;
        }
        if (this.myWidgets.get(current.getConnection(dir).destWidget()) != visited.get(visited.size() - 2)) {
            return false;
        }
        ConstrainedWidget looped = (ConstrainedWidget)visited.get(visited.size() - 2);
        if (looped.getConnection(dir.getOpposite()).isParentConnection() || !looped.getConnection(dir.getOpposite()).isConnected()) {
            return false;
        }
        if (this.myWidgets.get(looped.getConnection(dir.getOpposite()).destWidget()) != current) {
            return false;
        }
        if (dir == current.getConnection(dir).destDirection()) {
            return false;
        }
        if (dir.getOpposite() == looped.getConnection(dir.getOpposite()).destDirection()) {
            return false;
        }
        if (!current.getConnection(dir.getOpposite()).isConnected()) {
            return false;
        }
        if (!looped.getConnection(dir).isConnected()) {
            return false;
        }
        if (current.isBackwardsConnection(dir) || looped.isBackwardsConnection(dir.getOpposite())) {
            return false;
        }
        this.myChainConnnections.add(current.getConnection(dir));
        this.myChainConnnections.add(looped.getConnection(dir.getOpposite()));
        return true;
    }

    public boolean isValidCentered() {
        for (ConstrainedWidget wid : this.myWidgets) {
            for (Direction anchor : Direction.getAllDirections()) {
                if (!wid.isBackwardsConnection(anchor)) continue;
                if (!wid.isBackwardsConnection(anchor.getOpposite())) {
                    return false;
                }
                if (wid.getConnection(anchor).destWidget() == wid.getConnection(anchor.getOpposite()).destWidget()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validate() {
        return !this.hasCycles() && this.isValidCentered();
    }

    public String toString() {
        Object str = "";
        for (ConstrainedWidget wid : this.myWidgets) {
            str = (String)str + wid.toString();
            str = (String)str + " -- ";
        }
        return str;
    }

    void calculateError() {
        double[] error = new double[]{0.0, 0.0};
        this.createChains();
        for (Chain chain : this.myChains) {
            int n = chain.orientation();
            error[n] = error[n] + (double)chain.totalError();
        }
        for (ConstrainedWidget wid : this.myWidgets) {
            if (!wid.getConnection(Direction.TOP).isConnected() || !wid.getConnection(Direction.BOTTOM).isConnected()) {
                error[0] = error[0] + (double)Math.abs(wid.getConnection(Direction.TOP).getMargin() + wid.getConnection(Direction.BOTTOM).getMargin());
            } else if (!this.myChainConnnections.contains(wid.getConnection(Direction.TOP)) && !this.myChainConnnections.contains(wid.getConnection(Direction.BOTTOM))) {
                error[0] = error[0] + wid.getCenterError(0);
            }
            if (!wid.getConnection(Direction.LEFT).isConnected() || !wid.getConnection(Direction.RIGHT).isConnected()) {
                error[1] = error[1] + (double)Math.abs(wid.getConnection(Direction.LEFT).getMargin() + wid.getConnection(Direction.RIGHT).getMargin());
                continue;
            }
            if (this.myChainConnnections.contains(wid.getConnection(Direction.LEFT)) || this.myChainConnnections.contains(wid.getConnection(Direction.RIGHT))) continue;
            error[1] = error[1] + wid.getCenterError(1);
        }
        double connections = 0.0;
        for (ConstrainedWidget widget : this.myWidgets) {
            connections += (double)widget.numberOfConnections();
        }
        this.myError = Arrays.stream(error).sum();
        this.myError += this.connectionWeight * connections;
    }

    public void createChains() {
        this.myChains = new ArrayList();
        if (this.myChainConnnections.size() == 0) {
            return;
        }
        for (ConstrainedWidget wid : this.myWidgets) {
            if (!this.myChainConnnections.contains(wid.getConnection(Direction.LEFT)) && this.myChainConnnections.contains(wid.getConnection(Direction.RIGHT))) {
                Chain hChainStart = new Chain(1);
                hChainStart.addWidget(wid);
                this.myChains.add(hChainStart);
            }
            if (this.myChainConnnections.contains(wid.getConnection(Direction.TOP)) || !this.myChainConnnections.contains(wid.getConnection(Direction.BOTTOM))) continue;
            Chain vChainStart = new Chain(0);
            vChainStart.addWidget(wid);
            this.myChains.add(vChainStart);
        }
        for (Chain chain : this.myChains) {
            ConstrainedWidget chained = chain.getGroup().get(0);
            Direction dir = Direction.getDirections(chain.orientation())[1];
            while (this.myChainConnnections.contains(chained.getConnection(dir))) {
                chain.addWidget(this.myWidgets.get(chained.getConnection(dir).destWidget()));
                chained = this.myWidgets.get(chained.getConnection(dir).destWidget());
            }
            chain.calculateChainError();
        }
    }

    public double error() {
        return this.myError;
    }

    private class Chain {
        private int myOrientation;
        private ArrayList<ConstrainedWidget> myGroup;
        private int myTotalError;
        private int errorFactor = 5;

        public Chain(int orientation) {
            this.myOrientation = orientation;
            this.myGroup = new ArrayList();
        }

        public int orientation() {
            return this.myOrientation;
        }

        public void addWidget(ConstrainedWidget wid) {
            this.myGroup.add(wid);
        }

        public ArrayList<ConstrainedWidget> getGroup() {
            return this.myGroup;
        }

        public int totalError() {
            return this.myTotalError;
        }

        public void calculateChainError() {
            ArrayList<Integer> spread = this.spreadError();
            int spreadTotal = spread.stream().mapToInt(Integer::intValue).sum();
            ArrayList<Integer> packed = this.packedError();
            int packedTotal = packed.stream().mapToInt(Integer::intValue).sum();
            ArrayList<Integer> spreadIn = this.spreadInError();
            int spreadInTotal = spreadIn.stream().mapToInt(Integer::intValue).sum();
            if (spreadTotal < packedTotal && spreadTotal < spreadInTotal) {
                this.myTotalError = spreadTotal * this.errorFactor;
            }
            if (packedTotal < spreadTotal && packedTotal < spreadInTotal) {
                this.myTotalError = packedTotal * this.errorFactor;
            }
            if (spreadInTotal < packedTotal && spreadInTotal < spreadTotal) {
                this.myTotalError = spreadInTotal * this.errorFactor;
            }
        }

        ArrayList<Integer> spreadError() {
            Direction dir = Direction.getDirections(this.myOrientation)[1];
            int minMargin = this.myGroup.get(0).getConnection(dir.getOpposite()).getAbsoluteMargin();
            for (ConstrainedWidget wid : this.myGroup) {
                minMargin = Math.min(minMargin, wid.getConnection(dir).getAbsoluteMargin());
            }
            ArrayList<Integer> spreadMargins = new ArrayList<Integer>();
            spreadMargins.add(this.myGroup.get(0).getConnection(dir.getOpposite()).getAbsoluteMargin() - minMargin);
            for (ConstrainedWidget wid : this.myGroup) {
                spreadMargins.add(wid.getConnection(dir).getAbsoluteMargin() - minMargin);
            }
            return spreadMargins;
        }

        ArrayList<Integer> packedError() {
            Direction dir = Direction.getDirections(this.myOrientation)[1];
            ArrayList<Integer> packed = new ArrayList<Integer>();
            for (ConstrainedWidget wid : this.myGroup.subList(0, this.myGroup.size() - 1)) {
                packed.add(wid.getConnection(dir).getAbsoluteMargin());
            }
            int closingDiff = this.myGroup.get(0).getConnection(dir.getOpposite()).getAbsoluteMargin() - this.myGroup.get(this.myGroup.size() - 1).getConnection(dir).getAbsoluteMargin();
            if (closingDiff > 0) {
                packed.add(0, closingDiff);
                packed.add(0);
            } else {
                packed.add(0, 0);
                packed.add(-1 * closingDiff);
            }
            return packed;
        }

        ArrayList<Integer> spreadInError() {
            Direction dir = Direction.getDirections(this.myOrientation)[1];
            int minMargin = Integer.MAX_VALUE;
            for (ConstrainedWidget wid : this.myGroup.subList(0, this.myGroup.size() - 1)) {
                minMargin = Math.min(minMargin, wid.getConnection(dir).getMargin());
            }
            ArrayList<Integer> spreadIn = new ArrayList<Integer>();
            for (ConstrainedWidget wid : this.myGroup.subList(0, this.myGroup.size() - 1)) {
                spreadIn.add(wid.getConnection(dir).getAbsoluteMargin() - minMargin);
            }
            spreadIn.add(0, this.myGroup.get(0).getConnection(dir.getOpposite()).getAbsoluteMargin());
            spreadIn.add(this.myGroup.get(this.myGroup.size() - 1).getConnection(dir).getAbsoluteMargin());
            return spreadIn;
        }
    }
}

