/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.rendering.parsers.PsiXmlTag;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.ViewInfoTagSnapshotNode;
import com.android.tools.idea.uibuilder.type.MenuFileType;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModelHierarchyUpdater {
    private static final int VISUAL_EMPTY_COMPONENT_SIZE = 1;

    public static boolean updateHierarchy(@NotNull RenderResult result, @NotNull NlModel model) {
        return NlModelHierarchyUpdater.updateHierarchy(NlModelHierarchyUpdater.getRootViews(result, model.getType()), model);
    }

    public static boolean updateHierarchy(@NotNull List<ViewInfo> views, @NotNull NlModel model) {
        XmlTag root = NlModelHierarchyUpdater.getRootTag(model);
        if (root != null) {
            return NlModelHierarchyUpdater.updateHierarchy(root, views, model);
        }
        return false;
    }

    public static boolean updateHierarchy(@NotNull XmlTag rootTag, @NotNull List<ViewInfo> views, @NotNull NlModel model) {
        model.syncWithPsi(rootTag, ContainerUtil.map(views, ViewInfoTagSnapshotNode::new));
        model.updateAccessibility(views);
        NlModelHierarchyUpdater.updateBounds(views, model);
        ImmutableList<NlComponent> components = model.getTreeReader().getComponents();
        if (!components.isEmpty()) {
            return NlModelHierarchyUpdater.updateScroll((NlComponent)components.get(0));
        }
        return false;
    }

    @NotNull
    public static List<ViewInfo> getRootViews(@NotNull RenderResult result, @NotNull DesignerEditorFileType type) {
        return type == MenuFileType.INSTANCE ? result.getSystemRootViews() : result.getRootViews();
    }

    @Nullable
    private static XmlTag getRootTag(@NotNull NlModel model) {
        if (Disposer.isDisposed((Disposable)model)) {
            return null;
        }
        return AndroidPsiUtils.getRootTagSafely((XmlFile)model.getFile());
    }

    private static void updateBounds(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model) {
        model.getTreeReader().flattenComponents().forEach(NlModelHierarchyUpdater::clearDerivedData);
        Map<TagSnapshot, NlComponent> snapshotToComponent = model.getTreeReader().flattenComponents().collect(Collectors.toMap(NlComponent::getSnapshot, Function.identity(), (n1, n2) -> n1));
        Map<XmlTag, NlComponent> tagToComponent = model.getTreeReader().flattenComponents().collect(Collectors.toMap(NlComponent::getTagDeprecated, Function.identity(), (n1, n2) -> n1));
        Map<Long, NlComponent> sourceIdToComponent = model.getTreeReader().flattenComponents().collect(Collectors.toMap(NlComponent::getAccessibilityId, Function.identity(), (n1, n2) -> n1));
        for (ViewInfo view : rootViews) {
            NlModelHierarchyUpdater.updateBounds(view, 0, 0, snapshotToComponent, tagToComponent, sourceIdToComponent);
        }
        ImmutableList<NlComponent> components = model.getTreeReader().getComponents();
        if (!rootViews.isEmpty() && !components.isEmpty()) {
            NlModelHierarchyUpdater.fixBounds((NlComponent)components.get(0));
        }
    }

    private static boolean updateScroll(@NotNull NlComponent component) {
        Object viewObject;
        boolean scrollHasChanged = false;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        Object object = viewObject = viewInfo != null ? viewInfo.getViewObject() : null;
        if (viewObject instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)viewObject;
            int savedScrollX = NlComponentHelperKt.getScrollX(component);
            int savedScrollY = NlComponentHelperKt.getScrollY(component);
            if (savedScrollX != viewGroup.getScrollX() || savedScrollY != viewGroup.getScrollY()) {
                scrollHasChanged = true;
                viewGroup.setScrollX(savedScrollX);
                viewGroup.setScrollY(savedScrollY);
            }
        }
        List<NlComponent> children = component.getChildren();
        for (NlComponent child : children) {
            scrollHasChanged = scrollHasChanged || NlModelHierarchyUpdater.updateScroll(child);
        }
        return scrollHasChanged;
    }

    private static void updateBounds(@NotNull ViewInfo view, int parentX, int parentY, Map<TagSnapshot, NlComponent> snapshotToComponent, Map<XmlTag, NlComponent> tagToComponent, Map<Long, NlComponent> sourceIdToComponent) {
        ViewInfo bounds2 = RenderService.getSafeBounds((ViewInfo)view);
        Object cookie = view.getCookie();
        NlComponent component = null;
        if (cookie instanceof TagSnapshot) {
            TagSnapshot snapshot = (TagSnapshot)cookie;
            component = snapshotToComponent.get(snapshot);
            if (component == null) {
                PsiXmlTag psiXmlTag = (PsiXmlTag)snapshot.tag;
                component = tagToComponent.get(psiXmlTag != null ? psiXmlTag.getPsiXmlTag() : null);
            }
        } else {
            Object accessibilityObject = view.getAccessibilityObject();
            if (accessibilityObject != null) {
                AccessibilityNodeInfo nodeInfo = (AccessibilityNodeInfo)accessibilityObject;
                component = sourceIdToComponent.get(nodeInfo.getSourceNodeId());
            }
        }
        if (component != null && NlComponentHelperKt.getViewInfo(component) == null) {
            NlComponentHelperKt.setViewInfo(component, view);
            int left = parentX + bounds2.getLeft();
            int top = parentY + bounds2.getTop();
            int width = bounds2.getRight() - bounds2.getLeft();
            int height = bounds2.getBottom() - bounds2.getTop();
            NlComponentHelperKt.setBounds(component, left, top, Math.max(width, 1), Math.max(height, 1));
        }
        parentX += bounds2.getLeft();
        parentY += bounds2.getTop();
        for (ViewInfo child : view.getChildren()) {
            NlModelHierarchyUpdater.updateBounds(child, parentX, parentY, snapshotToComponent, tagToComponent, sourceIdToComponent);
        }
    }

    private static void fixBounds(@NotNull NlComponent root) {
        List<NlComponent> children;
        boolean computeBounds = false;
        if (NlComponentHelperKt.getW(root) == -1 && NlComponentHelperKt.getH(root) == -1) {
            computeBounds = true;
            NlComponent parent = root.getParent();
            if (parent != null && NlComponentHelperKt.getW(parent) >= 0) {
                NlComponentHelperKt.setBounds(root, NlComponentHelperKt.getX(parent), NlComponentHelperKt.getY(parent), 0, 0);
            }
        }
        if (!(children = root.getChildren()).isEmpty()) {
            for (NlComponent child : children) {
                NlModelHierarchyUpdater.fixBounds(child);
            }
            if (computeBounds) {
                Rectangle rectangle = new Rectangle(NlComponentHelperKt.getX(root), NlComponentHelperKt.getY(root), NlComponentHelperKt.getW(root), NlComponentHelperKt.getH(root));
                for (NlComponent child : children) {
                    rectangle = rectangle.union(new Rectangle(NlComponentHelperKt.getX(child), NlComponentHelperKt.getY(child), NlComponentHelperKt.getW(child), NlComponentHelperKt.getH(child)));
                }
                NlComponentHelperKt.setBounds(root, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static void clearDerivedData(@NotNull NlComponent component) {
        NlComponentHelperKt.setBounds(component, 0, 0, -1, -1);
        NlComponentHelperKt.setViewInfo(component, null);
    }
}

