/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.lint;

import com.android.tools.idea.common.model.NlComponent;
import com.intellij.designer.model.EmptyXmlTag;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\f\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004\u00a8\u0006\u0005"}, d2={"createDefaultHyperLinkListener", "Ljavax/swing/event/HyperlinkListener;", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/android/tools/idea/common/model/NlComponent;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nLintUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintUtil.kt\ncom/android/tools/idea/uibuilder/lint/LintUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class LintUtilKt {
    @NotNull
    public static final HyperlinkListener createDefaultHyperLinkListener() {
        return LintUtilKt::createDefaultHyperLinkListener$lambda$0;
    }

    @Nullable
    public static final TextRange getTextRange(@NotNull NlComponent $this$getTextRange) {
        ASTNode nameElement;
        ASTNode aSTNode;
        Intrinsics.checkNotNullParameter((Object)$this$getTextRange, (String)"<this>");
        if ($this$getTextRange.getTag() == null || Intrinsics.areEqual((Object)$this$getTextRange.getTag(), (Object)EmptyXmlTag.INSTANCE)) {
            Navigatable navigatable = $this$getTextRange.getNavigatable();
            OpenFileDescriptor openFileDescriptor = navigatable instanceof OpenFileDescriptor ? (OpenFileDescriptor)navigatable : null;
            return openFileDescriptor != null && (openFileDescriptor = openFileDescriptor.getRangeMarker()) != null ? openFileDescriptor.getTextRange() : null;
        }
        XmlTag xmlTag = $this$getTextRange.getTag();
        if (xmlTag != null) {
            XmlTag it = xmlTag;
            boolean bl = false;
            aSTNode = XmlChildRole.START_TAG_NAME_FINDER.findChild(it.getNode());
        } else {
            aSTNode = null;
        }
        ASTNode aSTNode2 = nameElement = aSTNode;
        return aSTNode2 != null ? aSTNode2.getTextRange() : null;
    }

    private static final void createDefaultHyperLinkListener$lambda$0(HyperlinkEvent it) {
        String url = it.getDescription();
        if (Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            try {
                BrowserUtil.browse((String)url);
            }
            catch (Exception exception) {
                Project project = null;
                StringBuilder builder = new StringBuilder();
                builder.append("Unable to open a default browser. \n");
                builder.append("Please open a browser manually and goto the url.\n");
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                    builder.append("\"" + url + "\" has been copied to the clipboard.\n");
                }
                catch (Exception exception2) {
                    builder.append("\"" + url + "\"");
                }
                Messages.showErrorDialog(project, (String)builder.toString(), (String)"Error");
            }
        }
    }
}

