/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.Region;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SnappingInfo;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J2\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/linear/LinearPlaceholderFactory;", "", "<init>", "()V", "createVerticalPlaceholder", "Lcom/android/tools/idea/common/scene/Placeholder;", "host", "Lcom/android/tools/idea/common/scene/SceneComponent;", "anchor", "snappedY", "", "left", "right", "createHorizontalPlaceholder", "snappedX", "top", "bottom", "LinearPlaceholder", "VerticalPlaceholder", "HorizontalPlaceholder", "intellij.android.designer"})
@StabilityInferred(parameters=1)
public final class LinearPlaceholderFactory {
    @NotNull
    public static final LinearPlaceholderFactory INSTANCE = new LinearPlaceholderFactory();
    public static final int $stable;

    private LinearPlaceholderFactory() {
    }

    @JvmStatic
    @NotNull
    public static final Placeholder createVerticalPlaceholder(@NotNull SceneComponent host, @Nullable SceneComponent anchor, int snappedY, int left, int right) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new VerticalPlaceholder(host, anchor, snappedY, left, right);
    }

    @JvmStatic
    @NotNull
    public static final Placeholder createHorizontalPlaceholder(@NotNull SceneComponent host, @Nullable SceneComponent anchor, int snappedX, int top, int bottom) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new HorizontalPlaceholder(host, anchor, snappedX, top, bottom);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/linear/LinearPlaceholderFactory$HorizontalPlaceholder;", "Lcom/android/tools/idea/uibuilder/handlers/linear/LinearPlaceholderFactory$LinearPlaceholder;", "host", "Lcom/android/tools/idea/common/scene/SceneComponent;", "anchor", "snappedX", "", "top", "bottom", "<init>", "(Lcom/android/tools/idea/common/scene/SceneComponent;Lcom/android/tools/idea/common/scene/SceneComponent;III)V", "region", "Lcom/android/tools/idea/common/scene/Region;", "getRegion", "()Lcom/android/tools/idea/common/scene/Region;", "snap", "", "info", "Lcom/android/tools/idea/common/scene/SnappingInfo;", "retPoint", "Ljava/awt/Point;", "intellij.android.designer"})
    private static final class HorizontalPlaceholder
    extends LinearPlaceholder {
        private final int snappedX;
        @NotNull
        private final Region region;

        public HorizontalPlaceholder(@NotNull SceneComponent host, @Nullable SceneComponent anchor, int snappedX, int top, int bottom) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            super(host, anchor);
            this.snappedX = snappedX;
            this.region = new Region(this.snappedX - 8, top, this.snappedX + 8, bottom, host.getDepth());
        }

        @Override
        @NotNull
        public Region getRegion() {
            return this.region;
        }

        @Override
        public boolean snap(@NotNull SnappingInfo info, @NotNull Point retPoint) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)retPoint, (String)"retPoint");
            Region r = this.getRegion();
            if (r.contains(info.getCenterX(), info.getCenterY())) {
                retPoint.x = this.snappedX - (info.getCenterX() - info.getLeft());
                retPoint.y = info.getTop();
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/linear/LinearPlaceholderFactory$LinearPlaceholder;", "Lcom/android/tools/idea/common/scene/Placeholder;", "host", "Lcom/android/tools/idea/common/scene/SceneComponent;", "anchor", "<init>", "(Lcom/android/tools/idea/common/scene/SceneComponent;Lcom/android/tools/idea/common/scene/SceneComponent;)V", "findNextSibling", "appliedComponent", "newParent", "updateAttribute", "", "sceneComponent", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "intellij.android.designer"})
    private static abstract class LinearPlaceholder
    extends Placeholder {
        @Nullable
        private final SceneComponent anchor;

        public LinearPlaceholder(@NotNull SceneComponent host, @Nullable SceneComponent anchor) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            super(host);
            this.anchor = anchor;
        }

        @Override
        @Nullable
        public SceneComponent findNextSibling(@NotNull SceneComponent appliedComponent, @NotNull SceneComponent newParent) {
            Intrinsics.checkNotNullParameter((Object)appliedComponent, (String)"appliedComponent");
            Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
            return this.anchor;
        }

        @Override
        public void updateAttribute(@NotNull SceneComponent sceneComponent, @NotNull NlAttributesHolder attributes) {
            Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"sceneComponent");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/linear/LinearPlaceholderFactory$VerticalPlaceholder;", "Lcom/android/tools/idea/uibuilder/handlers/linear/LinearPlaceholderFactory$LinearPlaceholder;", "host", "Lcom/android/tools/idea/common/scene/SceneComponent;", "anchor", "snappedY", "", "left", "right", "<init>", "(Lcom/android/tools/idea/common/scene/SceneComponent;Lcom/android/tools/idea/common/scene/SceneComponent;III)V", "region", "Lcom/android/tools/idea/common/scene/Region;", "getRegion", "()Lcom/android/tools/idea/common/scene/Region;", "snap", "", "info", "Lcom/android/tools/idea/common/scene/SnappingInfo;", "retPoint", "Ljava/awt/Point;", "intellij.android.designer"})
    private static final class VerticalPlaceholder
    extends LinearPlaceholder {
        private final int snappedY;
        @NotNull
        private final Region region;

        public VerticalPlaceholder(@NotNull SceneComponent host, @Nullable SceneComponent anchor, int snappedY, int left, int right) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            super(host, anchor);
            this.snappedY = snappedY;
            this.region = new Region(left, this.snappedY - 8, right, this.snappedY + 8, host.getDepth());
        }

        @Override
        @NotNull
        public Region getRegion() {
            return this.region;
        }

        @Override
        public boolean snap(@NotNull SnappingInfo info, @NotNull Point retPoint) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)retPoint, (String)"retPoint");
            Region r = this.getRegion();
            if (r.contains(info.getCenterX(), info.getCenterY())) {
                retPoint.x = info.getLeft();
                retPoint.y = this.snappedY - (info.getCenterY() - info.getTop());
                return true;
            }
            return false;
        }
    }
}

