/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.ui.DesignSurfaceToolbarUI;
import com.android.tools.idea.uibuilder.analytics.AnimationToolbarAnalyticsManager;
import com.android.tools.idea.uibuilder.editor.AnimationController;
import com.android.tools.idea.uibuilder.editor.AnimationControllerListener;
import com.android.tools.idea.uibuilder.editor.AnimationListener;
import com.android.tools.idea.uibuilder.editor.AnimationToolbarAction;
import com.android.tools.idea.uibuilder.editor.AnimationToolbarKt;
import com.android.tools.idea.uibuilder.editor.AnimationToolbarSliderUI;
import com.android.tools.idea.uibuilder.editor.AnimationToolbarType;
import com.android.tools.idea.uibuilder.editor.PlaySpeed;
import com.android.tools.idea.uibuilder.editor.PlayStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.PanelUI;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001d\b\u0017\u0018\u0000 o2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002opB9\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ2\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010M2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0002J0\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u0002042\u0006\u0010V\u001a\u0002042\u0006\u0010W\u001a\u0002042\u0006\u0010X\u001a\u0002042\u0006\u0010Y\u001a\u000204H\u0004J\u0010\u0010Z\u001a\u00020T2\u0006\u0010[\u001a\u000204H\u0004J&\u0010\\\u001a\u00020T2\b\u0010U\u001a\u0004\u0018\u00010M2\b\u0010V\u001a\u0004\u0018\u00010M2\b\u0010W\u001a\u0004\u0018\u00010MH\u0004J\u0006\u0010U\u001a\u00020TJ\u0006\u0010V\u001a\u00020TJ\b\u0010]\u001a\u00020TH\u0002J\u0006\u0010W\u001a\u00020TJ\u000e\u0010^\u001a\u00020T2\u0006\u0010_\u001a\u00020\bJ\u0010\u0010`\u001a\u00020T2\u0006\u0010a\u001a\u00020\bH\u0002J\u0010\u0010b\u001a\u00020T2\u0006\u0010c\u001a\u00020\bH\u0002J\u0006\u0010d\u001a\u00020\u0015J\u0006\u0010e\u001a\u00020\bJ\u000e\u0010f\u001a\u00020T2\u0006\u0010g\u001a\u00020\bJ\u0006\u0010h\u001a\u00020\bJ\u000e\u0010i\u001a\u00020T2\u0006\u0010j\u001a\u000204J\u0006\u0010k\u001a\u000204J\u000e\u0010l\u001a\u00020T2\u0006\u0010\u0005\u001a\u00020HJ\b\u0010n\u001a\u00020TH\u0016R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00106\u001a\u0002042\u0006\u00105\u001a\u0002048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u000e\u0010;\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0002\b\u0003\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020CX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0014\u0010F\u001a\b\u0012\u0004\u0012\u00020H0GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010m\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bm\u00108\u00a8\u0006q"}, d2={"Lcom/android/tools/idea/uibuilder/editor/AnimationToolbar;", "Ljavax/swing/JPanel;", "Lcom/android/tools/idea/uibuilder/editor/AnimationController;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "listener", "Lcom/android/tools/idea/uibuilder/editor/AnimationListener;", "tickStepMs", "", "minTimeMs", "initialMaxTimeMs", "toolbarType", "Lcom/android/tools/idea/uibuilder/editor/AnimationToolbarType;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/uibuilder/editor/AnimationListener;JJJLcom/android/tools/idea/uibuilder/editor/AnimationToolbarType;)V", "myAnimationListener", "myPlayButton", "Ljavax/swing/JButton;", "myPauseButton", "myStopButton", "playStatus", "Lcom/android/tools/idea/uibuilder/editor/PlayStatus;", "myTickStepMs", "myMinTimeMs", "controlBar", "getControlBar", "()Ljavax/swing/JPanel;", "myFrameControl", "Ljavax/swing/JSlider;", "myTimeSliderModel", "Ljavax/swing/DefaultBoundedRangeModel;", "speedControlButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "getSpeedControlButton", "()Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "myTimeSlider", "getMyTimeSlider", "()Ljavax/swing/JSlider;", "setMyTimeSlider", "(Ljavax/swing/JSlider;)V", "myTimeSliderChangeModel", "Ljavax/swing/event/ChangeListener;", "timeSliderSeparator", "Ljavax/swing/JSeparator;", "getTimeSliderSeparator", "()Ljavax/swing/JSeparator;", "setTimeSliderSeparator", "(Ljavax/swing/JSeparator;)V", "myMaxTimeMs", "currentSpeedFactor", "", "myLoopEnabled", "", "value", "forceElapsedReset", "getForceElapsedReset", "()Z", "setForceElapsedReset", "(Z)V", "_forceElapsedReset", "myTicker", "Ljava/util/concurrent/ScheduledFuture;", "myFramePositionMs", "myLastTickMs", "getToolbarType", "()Lcom/android/tools/idea/uibuilder/editor/AnimationToolbarType;", "myAnalyticsManager", "Lcom/android/tools/idea/uibuilder/analytics/AnimationToolbarAnalyticsManager;", "getMyAnalyticsManager", "()Lcom/android/tools/idea/uibuilder/analytics/AnimationToolbarAnalyticsManager;", "controllerListeners", "", "Lcom/android/tools/idea/uibuilder/editor/AnimationControllerListener;", "newControlButton", "baseIcon", "Ljavax/swing/Icon;", "label", "", "tooltip", "action", "Lcom/android/tools/idea/uibuilder/editor/AnimationToolbarAction;", "callback", "Ljava/lang/Runnable;", "setEnabledState", "", "play", "pause", "stop", "frame", "speed", "setVisibilityOfPlayAndPauseButtons", "playing", "setTooltips", "stopFrameTicker", "setFrameMs", "frameMs", "seek", "newPositionMs", "onTick", "elapsed", "getPlayStatus", "getFrameMs", "setMaxTimeMs", "maxTimeMs", "getMaxTimeMs", "setLooping", "enabled", "isLooping", "registerAnimationControllerListener", "isUnlimitedAnimationToolbar", "dispose", "Companion", "MyControllerListener", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAnimationToolbar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationToolbar.kt\ncom/android/tools/idea/uibuilder/editor/AnimationToolbar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,523:1\n1863#2,2:524\n1863#2,2:526\n1863#2,2:528\n1863#2,2:530\n1863#2,2:532\n1863#2,2:534\n1863#2,2:536\n*S KotlinDebug\n*F\n+ 1 AnimationToolbar.kt\ncom/android/tools/idea/uibuilder/editor/AnimationToolbar\n*L\n207#1:524,2\n212#1:526,2\n225#1:528,2\n237#1:530,2\n265#1:532,2\n272#1:534,2\n200#1:536,2\n*E\n"})
public class AnimationToolbar
extends JPanel
implements AnimationController,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimationListener myAnimationListener;
    @NotNull
    private final JButton myPlayButton;
    @NotNull
    private final JButton myPauseButton;
    @NotNull
    private final JButton myStopButton;
    @NotNull
    private PlayStatus playStatus;
    private final long myTickStepMs;
    private final long myMinTimeMs;
    @NotNull
    private final JPanel controlBar;
    @NotNull
    private final JSlider myFrameControl;
    @Nullable
    private DefaultBoundedRangeModel myTimeSliderModel;
    @NotNull
    private final ActionButton speedControlButton;
    @Nullable
    private JSlider myTimeSlider;
    @Nullable
    private ChangeListener myTimeSliderChangeModel;
    @Nullable
    private JSeparator timeSliderSeparator;
    private long myMaxTimeMs;
    private double currentSpeedFactor;
    private boolean myLoopEnabled;
    private boolean _forceElapsedReset;
    @Nullable
    private ScheduledFuture<?> myTicker;
    private long myFramePositionMs;
    private long myLastTickMs;
    @NotNull
    private final AnimationToolbarType toolbarType;
    @NotNull
    private final AnimationToolbarAnalyticsManager myAnalyticsManager;
    @NotNull
    private final List<AnimationControllerListener> controllerListeners;
    public static final int $stable = 8;
    private static final int TICKER_STEP = 33;
    @NotNull
    private static final Font BUTTON_FONT;

    protected AnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener2, long tickStepMs, long minTimeMs, long initialMaxTimeMs, @NotNull AnimationToolbarType toolbarType) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)((Object)toolbarType), (String)"toolbarType");
        this.currentSpeedFactor = PlaySpeed.x1.getSpeedFactor();
        this.myLoopEnabled = true;
        this.myAnalyticsManager = new AnimationToolbarAnalyticsManager();
        this.controllerListeners = new ArrayList();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myAnimationListener = listener2;
        this.myTickStepMs = tickStepMs;
        this.myMinTimeMs = minTimeMs;
        this.myMaxTimeMs = initialMaxTimeMs;
        this.toolbarType = toolbarType;
        Icon icon2 = StudioIcons.LayoutEditor.Motion.PLAY;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PLAY");
        this.myPlayButton = this.newControlButton(icon2, "Play", "Play", AnimationToolbarAction.PLAY, () -> AnimationToolbar._init_$lambda$9(this));
        this.myPlayButton.setEnabled(true);
        Icon icon3 = StudioIcons.LayoutEditor.Motion.PAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"PAUSE");
        this.myPauseButton = this.newControlButton(icon3, "Pause", "Pause", AnimationToolbarAction.PAUSE, () -> AnimationToolbar._init_$lambda$10(this));
        this.myPauseButton.setEnabled(false);
        this.myPauseButton.setVisible(false);
        Icon icon4 = StudioIcons.LayoutEditor.Motion.GO_TO_START;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"GO_TO_START");
        this.myStopButton = this.newControlButton(icon4, "Stop", "Reset", AnimationToolbarAction.STOP, () -> AnimationToolbar._init_$lambda$11(this));
        FlowLayout flowLayout = new FlowLayout();
        this.controlBar = new JPanel(flowLayout){

            @Override
            public void updateUI() {
                this.setUI((PanelUI)new DesignSurfaceToolbarUI());
            }
        };
        this.speedControlButton = AnimationToolbarKt.access$createPlaySpeedActionButton(arg_0 -> AnimationToolbar._init_$lambda$12(this, arg_0));
        Box buttonsPanel = Box.createHorizontalBox();
        buttonsPanel.add(this.myStopButton);
        buttonsPanel.add(this.myPlayButton);
        buttonsPanel.add(this.myPauseButton);
        buttonsPanel.add((Component)this.speedControlButton);
        this.controlBar.add(buttonsPanel);
        if (this.isUnlimitedAnimationToolbar()) {
            this.myTimeSlider = null;
            this.myTimeSliderModel = null;
            this.myTimeSliderChangeModel = null;
        } else {
            this.myTimeSliderModel = new DefaultBoundedRangeModel(0, 0, 0, 100);
            this.myTimeSliderChangeModel = arg_0 -> AnimationToolbar._init_$lambda$13(this, arg_0);
            JSlider jSlider = this.myTimeSlider = (JSlider)new JSlider(){

                @Override
                public void updateUI() {
                    this.setUI(new AnimationToolbarSliderUI(this));
                    this.updateLabelUIs();
                }
            };
            Intrinsics.checkNotNull((Object)jSlider);
            jSlider.setOpaque(false);
            JSlider jSlider2 = this.myTimeSlider;
            Intrinsics.checkNotNull((Object)jSlider2);
            jSlider2.setBorder((Border)JBUI.Borders.empty());
            DefaultBoundedRangeModel defaultBoundedRangeModel = this.myTimeSliderModel;
            Intrinsics.checkNotNull((Object)defaultBoundedRangeModel);
            defaultBoundedRangeModel.addChangeListener(this.myTimeSliderChangeModel);
            JSlider jSlider3 = this.myTimeSlider;
            Intrinsics.checkNotNull((Object)jSlider3);
            jSlider3.setModel(this.myTimeSliderModel);
            this.timeSliderSeparator = new JSeparator(1);
            buttonsPanel.add(this.timeSliderSeparator);
            this.controlBar.add(this.myTimeSlider);
        }
        this.myFrameControl = new JSlider(-5, 5, 0);
        this.myFrameControl.setSnapToTicks(true);
        this.add(this.controlBar);
        (this.controlBar).setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        this.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.myFrameControl.addChangeListener(arg_0 -> AnimationToolbar._init_$lambda$15(this, arg_0));
        this.myFrameControl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!myFrameControl.isEnabled()) {
                    return;
                }
                this.stopFrameTicker();
                myFrameControl.setValue(0);
            }
        });
        this.stop();
        this.playStatus = PlayStatus.STOP;
        this.registerAnimationControllerListener(new MyControllerListener());
    }

    @NotNull
    protected final JPanel getControlBar() {
        return this.controlBar;
    }

    @NotNull
    protected final ActionButton getSpeedControlButton() {
        return this.speedControlButton;
    }

    @Nullable
    protected final JSlider getMyTimeSlider() {
        return this.myTimeSlider;
    }

    protected final void setMyTimeSlider(@Nullable JSlider jSlider) {
        this.myTimeSlider = jSlider;
    }

    @Nullable
    protected final JSeparator getTimeSliderSeparator() {
        return this.timeSliderSeparator;
    }

    protected final void setTimeSliderSeparator(@Nullable JSeparator jSeparator) {
        this.timeSliderSeparator = jSeparator;
    }

    @Override
    public boolean getForceElapsedReset() {
        return this._forceElapsedReset;
    }

    @Override
    public void setForceElapsedReset(boolean value) {
        this._forceElapsedReset = value;
    }

    @NotNull
    public final AnimationToolbarType getToolbarType() {
        return this.toolbarType;
    }

    @NotNull
    protected final AnimationToolbarAnalyticsManager getMyAnalyticsManager() {
        return this.myAnalyticsManager;
    }

    private final JButton newControlButton(Icon baseIcon, String label, String tooltip, AnimationToolbarAction action2, Runnable callback) {
        JButton button = (JButton)new CommonButton();
        button.setName(label);
        button.setIcon(baseIcon);
        button.addActionListener(arg_0 -> AnimationToolbar.newControlButton$lambda$0(this, action2, callback, arg_0));
        button.setMinimumSize((Dimension)JBUI.size((int)22, (int)22));
        button.setBorderPainted(false);
        button.setFont(BUTTON_FONT);
        button.setEnabled(false);
        button.setToolTipText(tooltip);
        return button;
    }

    protected final void setEnabledState(boolean play, boolean pause, boolean stop, boolean frame, boolean speed) {
        this.myPlayButton.setEnabled(play);
        this.myPauseButton.setEnabled(pause);
        this.myStopButton.setEnabled(stop);
        this.myFrameControl.setEnabled(frame);
        this.speedControlButton.setEnabled(speed);
    }

    protected final void setVisibilityOfPlayAndPauseButtons(boolean playing) {
        this.myPlayButton.setVisible(!playing);
        this.myPauseButton.setVisible(playing);
    }

    protected final void setTooltips(@Nullable String play, @Nullable String pause, @Nullable String stop) {
        this.myPlayButton.setToolTipText(play);
        this.myPauseButton.setToolTipText(pause);
        this.myStopButton.setToolTipText(stop);
    }

    @Override
    public final void play() {
        this.stopFrameTicker();
        this.myLastTickMs = System.currentTimeMillis();
        this.onTick(0L);
        this.myTicker = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> AnimationToolbar.play$lambda$2(this), 0L, 33L, TimeUnit.MILLISECONDS);
        Iterable $this$forEach$iv = this.controllerListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnimationControllerListener it = (AnimationControllerListener)element$iv;
            boolean bl = false;
            it.onPlayStatusChanged(PlayStatus.PLAY);
        }
    }

    @Override
    public final void pause() {
        this.stopFrameTicker();
        Iterable $this$forEach$iv = this.controllerListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnimationControllerListener it = (AnimationControllerListener)element$iv;
            boolean bl = false;
            it.onPlayStatusChanged(PlayStatus.PAUSE);
        }
    }

    private final void stopFrameTicker() {
        if (this.myTicker != null) {
            ScheduledFuture<?> scheduledFuture = this.myTicker;
            Intrinsics.checkNotNull(scheduledFuture);
            scheduledFuture.cancel(false);
            this.myTicker = null;
        }
    }

    @Override
    public final void stop() {
        this.stopFrameTicker();
        this.setFrameMs(this.myMinTimeMs);
        Iterable $this$forEach$iv = this.controllerListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnimationControllerListener it = (AnimationControllerListener)element$iv;
            boolean bl = false;
            it.onPlayStatusChanged(PlayStatus.STOP);
        }
    }

    @Override
    public final void setFrameMs(long frameMs) {
        long calibratedFramePosition;
        this.myFramePositionMs = calibratedFramePosition = frameMs < this.myMinTimeMs ? (this.myLoopEnabled ? this.myMaxTimeMs : this.myMinTimeMs) : (!this.isUnlimitedAnimationToolbar() && frameMs > this.myMaxTimeMs ? (this.myLoopEnabled ? this.myMinTimeMs : this.myMaxTimeMs) : frameMs);
        Iterable $this$forEach$iv = this.controllerListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnimationControllerListener it = (AnimationControllerListener)element$iv;
            boolean bl = false;
            it.onCurrentFrameMsChanged(calibratedFramePosition);
        }
        this.myAnimationListener.animateTo(this, this.myFramePositionMs);
    }

    private final void seek(long newPositionMs) {
        this.setFrameMs(this.myMinTimeMs + newPositionMs);
    }

    private final void onTick(long elapsed) {
        this.setFrameMs(this.myFramePositionMs + elapsed);
    }

    @Override
    @NotNull
    public final PlayStatus getPlayStatus() {
        return this.playStatus;
    }

    @Override
    public final long getFrameMs() {
        return this.myFramePositionMs;
    }

    @Override
    public final void setMaxTimeMs(long maxTimeMs) {
        this.myMaxTimeMs = maxTimeMs;
        Iterable $this$forEach$iv = this.controllerListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnimationControllerListener it = (AnimationControllerListener)element$iv;
            boolean bl = false;
            it.onMaxTimeMsChanged(this.myMaxTimeMs);
        }
    }

    @Override
    public final long getMaxTimeMs() {
        return this.myMaxTimeMs;
    }

    @Override
    public final void setLooping(boolean enabled) {
        this.myLoopEnabled = enabled;
        Iterable $this$forEach$iv = this.controllerListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnimationControllerListener it = (AnimationControllerListener)element$iv;
            boolean bl = false;
            it.onLoopingChanged(enabled);
        }
    }

    @Override
    public final boolean isLooping() {
        return this.myLoopEnabled;
    }

    @Override
    public final void registerAnimationControllerListener(@NotNull AnimationControllerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.controllerListeners.add(listener2);
    }

    private final boolean isUnlimitedAnimationToolbar() {
        return this.myMaxTimeMs == -1L;
    }

    public void dispose() {
        this.controllerListeners.clear();
        this.stopFrameTicker();
    }

    private static final void newControlButton$lambda$0(AnimationToolbar this$0, AnimationToolbarAction $action, Runnable $callback, ActionEvent e) {
        this$0.myAnalyticsManager.trackAction(this$0.toolbarType, $action);
        this$0.requestFocusInWindow();
        $callback.run();
    }

    private static final void play$lambda$2(AnimationToolbar this$0) {
        long now = System.currentTimeMillis();
        long elapsed = now - this$0.myLastTickMs;
        this$0.myLastTickMs = now;
        this$0.onTick(MathKt.roundToLong((double)((double)elapsed * this$0.currentSpeedFactor)));
        if (this$0.myMaxTimeMs != -1L && this$0.myFramePositionMs >= this$0.myMaxTimeMs) {
            ScheduledFuture<?> scheduledFuture = this$0.myTicker;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            this$0.myTicker = null;
            Iterable $this$forEach$iv = this$0.controllerListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnimationControllerListener it = (AnimationControllerListener)element$iv;
                boolean bl = false;
                it.onPlayStatusChanged(PlayStatus.COMPLETE);
            }
        }
    }

    private static final void _init_$lambda$9(AnimationToolbar this$0) {
        this$0.play();
    }

    private static final void _init_$lambda$10(AnimationToolbar this$0) {
        this$0.pause();
    }

    private static final void _init_$lambda$11(AnimationToolbar this$0) {
        this$0.stop();
    }

    private static final Unit _init_$lambda$12(AnimationToolbar this$0, double it) {
        this$0.currentSpeedFactor = it;
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$13(AnimationToolbar this$0, ChangeEvent e) {
        this$0.myAnalyticsManager.trackAction(this$0.toolbarType, AnimationToolbarAction.FRAME_CONTROL);
        DefaultBoundedRangeModel defaultBoundedRangeModel = this$0.myTimeSliderModel;
        Intrinsics.checkNotNull((Object)defaultBoundedRangeModel);
        int sliderValue = defaultBoundedRangeModel.getValue();
        long newPositionMs = (long)((float)(this$0.myMaxTimeMs - this$0.myMinTimeMs) * ((float)sliderValue / 100.0f));
        this$0.myStopButton.setEnabled(sliderValue != 0);
        this$0.seek(newPositionMs);
        JSlider jSlider = this$0.myTimeSlider;
        Intrinsics.checkNotNull((Object)jSlider);
        jSlider.repaint();
    }

    private static final void lambda$15$lambda$14(AnimationToolbar this$0, long $frameChange) {
        this$0.onTick($frameChange);
    }

    private static final void _init_$lambda$15(AnimationToolbar this$0, ChangeEvent e) {
        this$0.stopFrameTicker();
        int value = this$0.myFrameControl.getValue();
        if (value == 0) {
            this$0.stopFrameTicker();
            return;
        }
        long frameChange = this$0.myTickStepMs * (long)value;
        this$0.myTicker = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> AnimationToolbar.lambda$15$lambda$14(this$0, frameChange), 0L, 33L, TimeUnit.MILLISECONDS);
    }

    static {
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getLabelFont(...)");
        BUTTON_FONT = font;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J.\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/uibuilder/editor/AnimationToolbar$Companion;", "", "<init>", "()V", "TICKER_STEP", "", "BUTTON_FONT", "Ljava/awt/Font;", "Lorg/jetbrains/annotations/NotNull;", "createUnlimitedAnimationToolbar", "Lcom/android/tools/idea/uibuilder/editor/AnimationToolbar;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lcom/android/tools/idea/uibuilder/editor/AnimationListener;", "tickStepMs", "", "minTimeMs", "createAnimationToolbar", "initialMaxTimeMs", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnimationToolbar createUnlimitedAnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener2, long tickStepMs, long minTimeMs) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            return new AnimationToolbar(parentDisposable, listener2, tickStepMs, minTimeMs, -1L, AnimationToolbarType.UNLIMITED);
        }

        @NotNull
        public final AnimationToolbar createAnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener2, long tickStepMs, long minTimeMs, long initialMaxTimeMs) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            return new AnimationToolbar(parentDisposable, listener2, tickStepMs, minTimeMs, initialMaxTimeMs, AnimationToolbarType.LIMITED);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/uibuilder/editor/AnimationToolbar$MyControllerListener;", "Lcom/android/tools/idea/uibuilder/editor/AnimationControllerListener;", "<init>", "(Lcom/android/tools/idea/uibuilder/editor/AnimationToolbar;)V", "onPlayStatusChanged", "", "newStatus", "Lcom/android/tools/idea/uibuilder/editor/PlayStatus;", "onCurrentFrameMsChanged", "newFrameMs", "", "intellij.android.designer"})
    private final class MyControllerListener
    implements AnimationControllerListener {
        @Override
        public void onPlayStatusChanged(@NotNull PlayStatus newStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)newStatus), (String)"newStatus");
            AnimationToolbar.this.playStatus = newStatus;
            switch (WhenMappings.$EnumSwitchMapping$0[newStatus.ordinal()]) {
                case 1: {
                    AnimationToolbar.this.setEnabledState(false, true, true, false, true);
                    AnimationToolbar.this.setVisibilityOfPlayAndPauseButtons(true);
                    break;
                }
                case 2: {
                    AnimationToolbar.this.setEnabledState(true, false, true, true, true);
                    AnimationToolbar.this.setVisibilityOfPlayAndPauseButtons(false);
                    break;
                }
                case 3: {
                    AnimationToolbar.this.setEnabledState(true, false, false, false, true);
                    AnimationToolbar.this.setVisibilityOfPlayAndPauseButtons(false);
                    break;
                }
                case 4: {
                    AnimationToolbar.this.setEnabledState(false, false, true, true, true);
                    AnimationToolbar.this.setVisibilityOfPlayAndPauseButtons(true);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @Override
        public void onCurrentFrameMsChanged(long newFrameMs) {
            DefaultBoundedRangeModel timeSliderModel;
            if (!AnimationToolbar.this.isUnlimitedAnimationToolbar() && (timeSliderModel = AnimationToolbar.this.myTimeSliderModel) != null) {
                timeSliderModel.removeChangeListener(AnimationToolbar.this.myTimeSliderChangeModel);
                timeSliderModel.setValue((int)((float)(newFrameMs - AnimationToolbar.this.myMinTimeMs) / (float)(AnimationToolbar.this.myMaxTimeMs - AnimationToolbar.this.myMinTimeMs) * (float)100));
                timeSliderModel.addChangeListener(AnimationToolbar.this.myTimeSliderChangeModel);
            }
        }

        @Override
        public void onMaxTimeMsChanged(long newMaxTimeMs) {
            AnimationControllerListener.super.onMaxTimeMsChanged(newMaxTimeMs);
        }

        @Override
        public void onLoopingChanged(boolean enabled) {
            AnimationControllerListener.super.onLoopingChanged(enabled);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PlayStatus.values().length];
                try {
                    nArray[PlayStatus.PLAY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlayStatus.PAUSE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlayStatus.STOP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlayStatus.COMPLETE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

