/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.editor.AnimationController;
import com.android.tools.idea.uibuilder.editor.AnimationListener;
import com.android.tools.idea.uibuilder.editor.DesignFilesPreviewEditorKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.rendering.RenderResult;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\fH\u0002J.\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/uibuilder/editor/AnimationListListener;", "Lcom/android/tools/idea/uibuilder/editor/AnimationListener;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "<init>", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "getSurface", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "currentAnimationDrawable", "Landroid/graphics/drawable/AnimationDrawable;", "modelTimeMap", "", "", "animateTo", "", "controller", "Lcom/android/tools/idea/uibuilder/editor/AnimationController;", "framePositionMs", "updateAnimationDrawableInformation", "manager", "Lcom/android/tools/idea/uibuilder/scene/LayoutlibSceneManager;", "findTargetDuration", "", "animationDrawable", "binarySearch", "map", "target", "start", "end", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nDesignFilesPreviewEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignFilesPreviewEditor.kt\ncom/android/tools/idea/uibuilder/editor/AnimationListListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n1#2:400\n*E\n"})
final class AnimationListListener
implements AnimationListener {
    @NotNull
    private final DesignSurface<?> surface;
    @Nullable
    private AnimationDrawable currentAnimationDrawable;
    @NotNull
    private List<Long> modelTimeMap;

    public AnimationListListener(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        this.surface = surface2;
        this.modelTimeMap = CollectionsKt.emptyList();
    }

    @NotNull
    public final DesignSurface<?> getSurface() {
        return this.surface;
    }

    @Override
    public void animateTo(@NotNull AnimationController controller, long framePositionMs) {
        block5: {
            Object v1;
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            NlModel nlModel = this.surface.getModel();
            if (nlModel != null) {
                NlModel it = nlModel;
                boolean bl = false;
                v1 = this.surface.getSceneManager(it);
            } else {
                v1 = null;
            }
            Object var4_6 = v1;
            LayoutlibSceneManager layoutlibSceneManager = var4_6 instanceof LayoutlibSceneManager ? (LayoutlibSceneManager)var4_6 : null;
            if (layoutlibSceneManager == null) break block5;
            LayoutlibSceneManager sceneManager = layoutlibSceneManager;
            boolean bl = false;
            RenderResult renderResult = sceneManager.getRenderResult();
            ImageView imageView = (ImageView)(renderResult != null && (renderResult = renderResult.getRootViews()) != null && (renderResult = (ViewInfo)CollectionsKt.firstOrNull((List)((List)renderResult))) != null ? renderResult.getViewObject() : null);
            if (imageView == null) {
                return;
            }
            ImageView imageView2 = imageView;
            Drawable drawable = imageView2.getDrawable();
            AnimationDrawable animationDrawable = drawable instanceof AnimationDrawable ? (AnimationDrawable)drawable : null;
            if (animationDrawable == null) {
                return;
            }
            AnimationDrawable animationDrawable2 = animationDrawable;
            if (!Intrinsics.areEqual((Object)this.currentAnimationDrawable, (Object)animationDrawable2)) {
                this.updateAnimationDrawableInformation(controller, sceneManager);
                this.currentAnimationDrawable = animationDrawable2;
            }
            int targetImageIndex = this.findTargetDuration(animationDrawable2, framePositionMs);
            animationDrawable2.setCurrentIndex(targetImageIndex);
            sceneManager.requestRender();
        }
    }

    private final void updateAnimationDrawableInformation(AnimationController controller, LayoutlibSceneManager manager) {
        List list;
        AnimationDrawable animationDrawable = DesignFilesPreviewEditorKt.access$findAnimationDrawable(manager);
        AnimationListListener animationListListener = this;
        if (animationDrawable != null) {
            List timeMap = new ArrayList();
            long durationSum = 0L;
            int n = animationDrawable.getNumberOfFrames();
            AnimationListListener animationListListener2 = animationListListener;
            int n2 = 0;
            while (n2 < n) {
                int index = n2++;
                boolean bl = false;
                timeMap.add(durationSum += (long)animationDrawable.getDuration(index));
            }
            animationListListener = animationListListener2;
            controller.setLooping(!animationDrawable.isOneShot());
            controller.setMaxTimeMs(durationSum);
            list = timeMap;
        } else {
            list = CollectionsKt.emptyList();
        }
        animationListListener.modelTimeMap = list;
    }

    private final int findTargetDuration(AnimationDrawable animationDrawable, long framePositionMs) {
        return this.binarySearch(this.modelTimeMap, framePositionMs, 0, animationDrawable.getNumberOfFrames() - 1);
    }

    private final int binarySearch(List<Long> map2, long target, int start, int end) {
        if (end <= start) {
            return end;
        }
        int mid = (start + end) / 2;
        return ((Number)map2.get(mid)).longValue() < target ? this.binarySearch(map2, target, mid + 1, end) : (target < ((Number)map2.get(mid)).longValue() ? this.binarySearch(map2, target, start, mid) : mid + 1);
    }
}

