/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.support.AndroidxName;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.actions.ConvertToConstraintLayoutForm;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.scout.ScoutDirectConvert;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.rendering.parsers.AttributeSnapshot;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToConstraintLayoutAction
extends AnAction {
    public static final String TITLE = "Convert to ConstraintLayout";
    public static final boolean ENABLED = true;
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH = "layout_conversion_absoluteWidth";
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT = "layout_conversion_absoluteHeight";
    public static final String ATTR_LAYOUT_CONVERSION_WRAP_WIDTH = "layout_conversion_wrapWidth";
    public static final String ATTR_LAYOUT_CONVERSION_WRAP_HEIGHT = "layout_conversion_wrapHeight";
    private static final HashSet<String> ourExcludedTags = new HashSet<String>(Arrays.asList("layout", "data", "variable", "import"));
    public static final String ACTION_UNDO_ID = "convert_constraintlayout_id";

    public ConvertToConstraintLayoutAction() {
        super(TITLE, TITLE, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        DesignSurface surface2 = (DesignSurface)e.getData(DesignerDataKeys.DESIGN_SURFACE);
        if (surface2 == null) {
            return;
        }
        Presentation presentation = e.getPresentation();
        SceneView screenView = surface2.getFocusedSceneView();
        NlComponent target = ConvertToConstraintLayoutAction.findTarget(screenView);
        if (target != null) {
            String tagName = target.getTagName();
            if (NlComponentHelperKt.isOrHasSuperclass(target, AndroidXConstants.CONSTRAINT_LAYOUT)) {
                presentation.setVisible(false);
                return;
            }
            if (ourExcludedTags.contains(tagName)) {
                presentation.setVisible(false);
                return;
            }
            presentation.setVisible(true);
            tagName = tagName.substring(tagName.lastIndexOf(46) + 1);
            presentation.setText("Convert " + tagName + " to ConstraintLayout");
            presentation.setEnabled(true);
        } else {
            presentation.setText(TITLE);
            presentation.setEnabled(false);
            presentation.setVisible(true);
        }
    }

    @Nullable
    private static NlComponent findTarget(@Nullable SceneView screenView) {
        List<NlComponent> selection;
        if (screenView != null && (selection = screenView.getSelectionModel().getSelection()).size() == 1) {
            NlComponent selected;
            for (selected = selection.get(0); selected != null && !selected.isRoot() && selected.getChildren().isEmpty(); selected = selected.getParent()) {
            }
            return selected;
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Set notAdded;
        DesignSurface surface2 = (DesignSurface)e.getData(DesignerDataKeys.DESIGN_SURFACE);
        if (surface2 == null) {
            return;
        }
        SceneView sceneView = surface2.getFocusedSceneView();
        if (sceneView == null) {
            return;
        }
        assert (sceneView instanceof ScreenView);
        ScreenView screenView = (ScreenView)sceneView;
        NlComponent target = ConvertToConstraintLayoutAction.findTarget(screenView);
        if (target == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ConvertToConstraintLayoutForm dialog = new ConvertToConstraintLayoutForm(project);
        if (!dialog.showAndGet()) {
            return;
        }
        boolean flatten = dialog.getFlattenHierarchy();
        boolean includeIds = dialog.getFlattenReferenced();
        boolean includeCustomViews = dialog.getIncludeCustomViews();
        boolean isAndroidx = MigrateToAndroidxUtil.isAndroidx((Project)project);
        GoogleMavenArtifactId artifact = isAndroidx ? GoogleMavenArtifactId.ANDROIDX_CONSTRAINTLAYOUT : GoogleMavenArtifactId.CONSTRAINT_LAYOUT;
        Module module = sceneView.getSceneManager().getModel().getModule();
        if (!DependencyManagementUtil.dependsOn((Module)module, (GoogleMavenArtifactId)artifact) && !(notAdded = DependencyManagementUtil.addDependenciesWithUiConfirmation((Module)module, Set.of(artifact), (boolean)false)).isEmpty()) {
            String message = "Converting to ConstraintLayout requires that the '" + module.getName() + "' module\ndepend on the constraint layout library. Please update the module's dependencies and try the action again.";
            Messages.showErrorDialog((Project)project, (String)message, (String)"Couldn't Convert Layout");
            return;
        }
        ConstraintLayoutConverter converter = new ConstraintLayoutConverter(screenView, target, flatten, includeIds, includeCustomViews);
        converter.execute();
    }

    private static void inferConstraints(@NotNull NlComponent target) {
        try {
            Scout.inferConstraintsFromConvert(target);
            ArrayList<NlComponent> list = new ArrayList<NlComponent>(target.getChildren());
            list.add(0, target);
            for (NlComponent component : list) {
                AttributesTransaction transaction = component.startAttributeTransaction();
                transaction.commit();
            }
            ConvertToConstraintLayoutAction.removeAbsolutePositionAndSizes(target);
        }
        catch (Throwable t) {
            Logger.getInstance(ConvertToConstraintLayoutAction.class).warn(t);
        }
    }

    private static void removeAbsolutePositionAndSizes(NlComponent component) {
        for (NlComponent child : component.getChildren()) {
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH, null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT, null);
            child.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
            child.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_WRAP_WIDTH, null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_WRAP_HEIGHT, null);
            ConvertToConstraintLayoutAction.removeAbsolutePositionAndSizes(child);
        }
    }

    private static class ConstraintLayoutConverter {
        private static final boolean DIRECT_INFERENCE = true;
        private final ScreenView myScreenView;
        private final boolean myFlatten;
        private final boolean myIncludeIds;
        private final boolean myIncludeCustomViews;
        private ViewEditorImpl myEditor;
        private List<NlComponent> myToBeFlattened;
        private NlComponent myRoot;
        private NlComponent myLayout;

        public ConstraintLayoutConverter(@NotNull ScreenView screenView, @NotNull NlComponent target, boolean flatten, boolean includeIds, boolean includeCustomViews) {
            this.myScreenView = screenView;
            this.myFlatten = flatten;
            this.myIncludeIds = includeIds;
            this.myIncludeCustomViews = includeCustomViews;
            this.myLayout = target;
            this.myRoot = (NlComponent)this.myScreenView.getSceneManager().getModel().getTreeReader().getComponents().get(0);
            this.myEditor = new ViewEditorImpl(this.myScreenView);
        }

        private Project getProject() {
            return this.myScreenView.getSurface().getProject();
        }

        public void execute() {
            WriteCommandAction.Builder builder = WriteCommandAction.writeCommandAction((Project)this.myScreenView.getSurface().getProject(), (PsiFile[])new PsiFile[]{this.myScreenView.getSceneManager().getModel().getFile()}).withName(ConvertToConstraintLayoutAction.TITLE).withGroupId(ConvertToConstraintLayoutAction.ACTION_UNDO_ID);
            builder.run(() -> this.preLayoutRun());
            this.layout();
            builder.run(() -> this.postLayoutRun());
        }

        public void preLayoutRun() {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.myLayout == null) {
                return;
            }
            this.myLayout.ensureId();
            boolean directConvert = true;
            if (this.myFlatten) {
                for (NlComponent child : this.myLayout.getChildren()) {
                    if (!this.isLayout(child)) continue;
                    directConvert = false;
                }
            }
            if (directConvert && ScoutDirectConvert.directProcess(this.myLayout)) {
                return;
            }
            this.myToBeFlattened = new ArrayList<NlComponent>();
            this.processComponent(this.myLayout);
            this.flatten();
        }

        public void layout() {
            NlDesignSurface surface2 = this.myScreenView.getSurface();
            LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager(surface2.getModel());
            assert (manager != null);
            try {
                manager.requestLayoutAsync(false).get(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Logger.getInstance(ConvertToConstraintLayoutAction.class).warn("Unable to run layout()", (Throwable)e);
            }
        }

        public void postLayoutRun() {
            LayoutlibSceneManager manager = this.myScreenView.getSceneManager();
            if (manager == null) {
                Logger.getInstance(ConvertToConstraintLayoutAction.class).warn("null SceneManager");
                return;
            }
            NlModel model = this.myLayout.getModel();
            XmlTag layoutTag = this.myLayout.getTagDeprecated();
            XmlTag rootTag = this.myRoot.getTagDeprecated();
            PsiElement tag = this.myLayout.getTagDeprecated().setName(DependencyManagementUtil.mapAndroidxName((Module)model.getModule(), (AndroidxName)AndroidXConstants.CLASS_CONSTRAINT_LAYOUT));
            this.myRoot = model.getTreeReader().findViewByTag(rootTag);
            this.myLayout = model.getTreeReader().findViewByTag(layoutTag);
            tag = CodeStyleManager.getInstance((Project)this.getProject()).reformat(tag);
            this.myLayout.getModel().syncWithPsi((XmlTag)tag, Collections.emptyList());
            final String id = this.myLayout.getId();
            model.addListener(new ModelListener(){

                @Override
                public void modelDerivedDataChanged(@NotNull NlModel model) {
                    assert (id != null);
                    NlComponent layout = model.getTreeReader().find(id);
                    if (layout != null) {
                        model.removeListener(this);
                        myEditor.measureChildren(layout, null).whenCompleteAsync((sizes, ex) -> NlWriteCommandActionUtil.run(Collections.singletonList(layout), "Infer Constraints", ConvertToConstraintLayoutAction.ACTION_UNDO_ID, () -> {
                            for (NlComponent component : sizes.keySet()) {
                                Dimension d = (Dimension)sizes.get(component);
                                component.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_WRAP_WIDTH, Integer.toString(d.width));
                                component.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_WRAP_HEIGHT, Integer.toString(d.height));
                            }
                            ConvertToConstraintLayoutAction.inferConstraints(layout);
                        }), (Executor)EdtExecutorService.getInstance());
                    }
                }
            });
        }

        private void processComponent(NlComponent component) {
            for (NlComponent child : component.getChildren()) {
                int dpx = this.myEditor.pxToDp(NlComponentHelperKt.getX(child) - NlComponentHelperKt.getX(this.myRoot));
                int dpy = this.myEditor.pxToDp(NlComponentHelperKt.getY(child) - NlComponentHelperKt.getY(this.myRoot));
                int dpw = this.myEditor.pxToDp(NlComponentHelperKt.getW(child));
                int dph = this.myEditor.pxToDp(NlComponentHelperKt.getH(child));
                AttributesTransaction transaction = child.startAttributeTransaction();
                transaction.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH, String.format(Locale.US, "%ddp", dpw));
                transaction.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT, String.format(Locale.US, "%ddp", dph));
                transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", String.format(Locale.US, "%ddp", dpx));
                transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", String.format(Locale.US, "%ddp", dpy));
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", "wrap_content");
                transaction.commit();
                ArrayList<String> toDelete = null;
                for (AttributeSnapshot attribute : child.getAttributes()) {
                    String name = attribute.name;
                    if (!name.startsWith("layout_") || !"http://schemas.android.com/apk/res/android".equals(attribute.namespace) || name.equals("layout_width") || name.equals("layout_height")) continue;
                    if (toDelete == null) {
                        toDelete = new ArrayList<String>();
                    }
                    toDelete.add(name);
                }
                if (toDelete != null) {
                    for (String name : toDelete) {
                        child.setAttribute("http://schemas.android.com/apk/res/android", name, null);
                    }
                }
                if (this.isLayout(child)) {
                    if (!this.myFlatten || !this.shouldFlatten(child)) continue;
                    this.myToBeFlattened.add(child);
                }
                this.processComponent(child);
            }
        }

        private void flatten() {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
            Document document = documentManager.getDocument((PsiFile)this.myScreenView.getSceneManager().getModel().getFile());
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            for (NlComponent component : this.myToBeFlattened) {
                XmlTag tag = component.getTagDeprecated();
                PsiElement openStart = null;
                PsiElement openEnd = null;
                PsiElement closeStart = null;
                PsiElement closeEnd = null;
                for (PsiElement curr = tag.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                    IElementType elementType = curr.getNode().getElementType();
                    if (elementType == XmlTokenType.XML_START_TAG_START) {
                        openStart = curr;
                        continue;
                    }
                    if (elementType == XmlTokenType.XML_TAG_END) {
                        if (closeStart == null) {
                            openEnd = curr;
                            continue;
                        }
                        closeEnd = curr;
                        break;
                    }
                    if (elementType == XmlTokenType.XML_END_TAG_START) {
                        closeStart = curr;
                        continue;
                    }
                    if (elementType != XmlTokenType.XML_EMPTY_ELEMENT_END) continue;
                    openEnd = curr;
                    break;
                }
                if (openStart == null || openEnd == null || closeStart == null || closeEnd == null) continue;
                ranges.add(new TextRange(openStart.getTextOffset(), openEnd.getTextOffset() + openEnd.getTextLength()));
                ranges.add(new TextRange(closeStart.getTextOffset(), closeEnd.getTextOffset() + closeEnd.getTextLength()));
            }
            ranges.sort((o1, o2) -> o2.getStartOffset() - o1.getStartOffset());
            for (TextRange range : ranges) {
                document.deleteString(range.getStartOffset(), range.getEndOffset());
            }
            documentManager.commitDocument(document);
        }

        private boolean isLayout(@NotNull NlComponent component) {
            Object viewObject;
            NlComponent child;
            if (!this.myIncludeCustomViews && ConstraintLayoutConverter.isCustomView(component)) {
                return false;
            }
            List<NlComponent> children = component.getChildren();
            if (children.size() > 1) {
                return true;
            }
            if (children.size() == 1 && !"requestFocus".equals((child = children.get(0)).getTagName())) {
                return true;
            }
            ViewInfo info = NlComponentHelperKt.getViewInfo(component);
            if (info != null && (viewObject = info.getViewObject()) != null) {
                for (Class<?> cls = viewObject.getClass(); cls != null; cls = cls.getSuperclass()) {
                    String fqcn = cls.getName();
                    if ("android.widget.AdapterView".equals(fqcn)) {
                        return false;
                    }
                    if (fqcn.startsWith("android.webkit.") && fqcn.endsWith("WebView")) {
                        return false;
                    }
                    if (!"android.view.ViewGroup".equals(fqcn)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isCustomView(NlComponent component) {
            String tag = component.getTagName();
            return tag.indexOf(46) != -1;
        }

        private boolean shouldFlatten(@NotNull NlComponent component) {
            XmlAttributeValue valueElement;
            XmlAttribute attribute;
            if (!this.myIncludeCustomViews && ConstraintLayoutConverter.isCustomView(component)) {
                return false;
            }
            if (component.getAttribute("http://schemas.android.com/apk/res/android", "background") != null || component.getAttribute("http://schemas.android.com/apk/res/android", "foreground") != null) {
                return false;
            }
            String id = component.getAttribute("http://schemas.android.com/apk/res/android", "id");
            if (id == null) {
                return true;
            }
            if (!this.myIncludeIds && (attribute = component.getTagDeprecated().getAttribute("id", "http://schemas.android.com/apk/res/android")) != null && (valueElement = attribute.getValueElement()) != null && valueElement.isValid()) {
                UsageInfo[] usages;
                RenameProcessor processor = new RenameProcessor(this.myScreenView.getSurface().getProject(), (PsiElement)valueElement, "NONEXISTENT_ID12345", false, false);
                processor.setPreviewUsages(false);
                XmlFile layoutFile = this.myScreenView.getSceneManager().getModel().getFile();
                for (UsageInfo info : usages = processor.findUsages()) {
                    PsiFile file2 = info.getFile();
                    if (layoutFile.equals(file2)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

