/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.errors;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.rendering.errors.RenderErrorContributorUtilKt;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.rendering.HtmlLinkManager;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderProblem;
import com.android.utils.HtmlBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\r\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u000e\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u000f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/rendering/errors/ComposeRenderErrorContributor;", "", "<init>", "()V", "isCompositionLocalStackTrace", "", "throwable", "", "isViewModelStackTraceInternal", "stackTrace", "", "isViewModelStackTrace", "isComposeNotFoundThrowable", "isPreviewParameterMismatchThrowable", "isFailToLoadPreviewParameterProvider", "isTimeoutToLoadPreview", "isHandledByComposeContributor", "reportComposeErrors", "", "Lcom/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue;", "logger", "Lcom/android/tools/rendering/RenderLogger;", "linkManager", "Lcom/android/tools/rendering/HtmlLinkManager;", "linkHandler", "Ljavax/swing/event/HyperlinkListener;", "intellij.android.designer"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nComposeRenderErrorContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeRenderErrorContributor.kt\ncom/android/tools/idea/rendering/errors/ComposeRenderErrorContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1755#2,3:241\n1611#2,9:244\n1863#2:253\n1864#2:255\n1620#2:256\n1557#2:257\n1628#2,3:258\n1#3:254\n*S KotlinDebug\n*F\n+ 1 ComposeRenderErrorContributor.kt\ncom/android/tools/idea/rendering/errors/ComposeRenderErrorContributor\n*L\n43#1:241,3\n134#1:244,9\n134#1:253\n134#1:255\n134#1:256\n238#1:257\n238#1:258,3\n134#1:254\n*E\n"})
public final class ComposeRenderErrorContributor {
    @NotNull
    public static final ComposeRenderErrorContributor INSTANCE = new ComposeRenderErrorContributor();
    public static final int $stable;

    private ComposeRenderErrorContributor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCompositionLocalStackTrace(Throwable throwable) {
        if (!(throwable instanceof IllegalStateException)) return false;
        String string = ((IllegalStateException)throwable).getMessage();
        if (string == null) return false;
        if (!StringsKt.startsWith$default((String)string, (String)"CompositionLocal", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        String string2 = ((IllegalStateException)throwable).getMessage();
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)string2, (String)"not present", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isViewModelStackTraceInternal(String stackTrace) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = StringsKt.lines((CharSequence)stackTrace);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String line = (String)element$iv;
                    boolean bl2 = false;
                    if (!(StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)"at", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)line, (CharSequence)"androidx.lifecycle", (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)line, (CharSequence)"viewModel", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"ViewModelProvider", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"ViewModelKt", (boolean)false, (int)2, null)))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isViewModelStackTrace(@NotNull String stackTrace) {
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        return INSTANCE.isViewModelStackTraceInternal(stackTrace);
    }

    @JvmStatic
    public static final boolean isViewModelStackTrace(@Nullable Throwable throwable) {
        boolean bl;
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl2 = false;
            StringWriter stringWriter = new StringWriter();
            it.printStackTrace(new PrintWriter(stringWriter));
            String string = stringWriter.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            bl = INSTANCE.isViewModelStackTraceInternal(string);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isComposeNotFoundThrowable(Throwable throwable) {
        if (!(throwable instanceof NoSuchMethodException)) return false;
        String string = ((NoSuchMethodException)throwable).getStackTrace()[1].getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"invokeComposableViaReflection", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPreviewParameterMismatchThrowable(Throwable throwable) {
        if (!(throwable instanceof IllegalArgumentException)) return false;
        if (!Intrinsics.areEqual((Object)((IllegalArgumentException)throwable).getMessage(), (Object)"argument type mismatch")) return false;
        StackTraceElement[] stackTraceElementArray = ((IllegalArgumentException)throwable).getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        StackTraceElement stackTraceElement = (StackTraceElement)CollectionsKt.firstOrNull((List)ArraysKt.drop((Object[])stackTraceElementArray, (int)5));
        Object object = stackTraceElement;
        if (stackTraceElement == null) return false;
        String string = ((StackTraceElement)object).getMethodName();
        object = string;
        if (string == null) return false;
        boolean bl = StringsKt.startsWith$default((String)object, (String)"invokeComposable", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFailToLoadPreviewParameterProvider(Throwable throwable) {
        boolean bl;
        String providerClass = "$FailToLoadPreviewParameterProvider";
        if (!(throwable instanceof NoSuchMethodException)) return false;
        String string = ((NoSuchMethodException)throwable).getMessage();
        if (string != null) {
            if (StringsKt.endsWith$default((String)string, (String)providerClass, (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        String string2 = ((NoSuchMethodException)throwable).getMessage();
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)string2, (String)(providerClass + " not found"), (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isTimeoutToLoadPreview(Throwable throwable) {
        return throwable instanceof TimeoutException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isHandledByComposeContributor(@Nullable Throwable throwable) {
        if (INSTANCE.isComposeNotFoundThrowable(throwable)) return true;
        if (INSTANCE.isCompositionLocalStackTrace(throwable)) return true;
        if (INSTANCE.isPreviewParameterMismatchThrowable(throwable)) return true;
        if (INSTANCE.isFailToLoadPreviewParameterProvider(throwable)) return true;
        if (INSTANCE.isTimeoutToLoadPreview(throwable)) return true;
        if (!ComposeRenderErrorContributor.isViewModelStackTrace(throwable)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<RenderErrorModel.Issue> reportComposeErrors(@NotNull RenderLogger logger, @NotNull HtmlLinkManager linkManager, @NotNull HyperlinkListener linkHandler) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)linkManager, (String)"linkManager");
        Intrinsics.checkNotNullParameter((Object)linkHandler, (String)"linkHandler");
        List list = logger.getMessages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMessages(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        RenderErrorModel.Issue.Builder builder = $this$forEach$iv$iv$iv.iterator();
        while (builder.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = builder.next();
            boolean bl = false;
            RenderProblem it = (RenderProblem)element$iv$iv;
            boolean bl2 = false;
            if (ComposeRenderErrorContributor.isViewModelStackTrace(it.getThrowable())) {
                RenderErrorModel.Issue.Builder builder2 = RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.INFORMATION).setSummary("Failed to instantiate a ViewModel");
                HtmlBuilder htmlBuilder = new HtmlBuilder().addLink("This preview uses a ", "ViewModel", ". ", "https://developer.android.com/topic/libraries/architecture/viewmodel").add("ViewModels often trigger operations not supported by Compose Preview, such as database access, I/O operations, or network requests. ").addLink("You can ", "read more", " about preview limitations in our external documentation.", "https://developer.android.com/jetpack/compose/tooling/previews#preview-viewmodel").newlineIfNecessary();
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"newlineIfNecessary(...)");
                object = builder2.setHtmlContent(RenderErrorContributorUtilKt.addExceptionMessage((HtmlBuilder)htmlBuilder, (HtmlLinkManager)linkManager, (Throwable)it.getThrowable()));
            } else if (INSTANCE.isCompositionLocalStackTrace(it.getThrowable())) {
                RenderErrorModel.Issue.Builder builder3 = RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.INFORMATION).setSummary("Failed to instantiate Composition Local");
                HtmlBuilder htmlBuilder = new HtmlBuilder().addLink("This preview was unable to find a ", "CompositionLocal", ". ", "https://developer.android.com/jetpack/compose/compositionlocal").add("You might need to define it so it can render correctly.").newlineIfNecessary();
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"newlineIfNecessary(...)");
                object = builder3.setHtmlContent(RenderErrorContributorUtilKt.addExceptionMessage((HtmlBuilder)htmlBuilder, (HtmlLinkManager)linkManager, (Throwable)it.getThrowable()));
            } else if (INSTANCE.isComposeNotFoundThrowable(it.getThrowable())) {
                RenderErrorModel.Issue.Builder builder4 = RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.WARNING);
                Throwable throwable = it.getThrowable();
                Intrinsics.checkNotNull((Object)throwable);
                object = builder4.setSummary("Unable to find @Preview '" + throwable.getMessage() + "'").addMessageTip(RenderErrorContributorUtilKt.createBuildTheProjectMessage((HtmlLinkManager)linkManager, (String)"The preview will display after rebuilding the project."));
            } else {
                object = INSTANCE.isPreviewParameterMismatchThrowable(it.getThrowable()) ? RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.ERROR).setSummary("PreviewParameterProvider/@Preview type mismatch.").addMessageTip(RenderErrorContributorUtilKt.createBuildTheProjectMessage((HtmlLinkManager)linkManager, (String)"The type of the PreviewParameterProvider must match the @Preview input parameter type annotated with it.")) : (INSTANCE.isFailToLoadPreviewParameterProvider(it.getThrowable()) ? RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.ERROR).setSummary("Fail to load PreviewParameterProvider").setHtmlContent(new HtmlBuilder().addLink("There was problem to load the ", "PreviewParameterProvider", " defined. Please double-check its constructor and the values property implementation. The IDE logs should contain the full exception stack trace.", "https://developer.android.com/develop/ui/compose/tooling/previews#preview-data")) : (INSTANCE.isTimeoutToLoadPreview(it.getThrowable()) ? RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.ERROR).setSummary("Timeout error").setHtmlContent(new HtmlBuilder().add("The preview took too long to load. The issue can be caused by long operations or infinite loops on the Preview code.").newline().add("If you think this issue is not caused by your code, you can report a bug in our issue tracker.")).addMessageTip(RenderErrorContributorUtilKt.createAddReportBugMessage((HtmlLinkManager)linkManager, null)) : null));
            }
            if (object == null) continue;
            RenderErrorModel.Issue.Builder it$iv$iv = object;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            builder = (RenderErrorModel.Issue.Builder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.setLinkHandler(linkHandler).build());
        }
        return (List)destination$iv$iv;
    }
}

