/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.viewmodels;

import com.android.ide.common.rendering.api.Bridge;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.idea.editors.build.RenderingBuildStatus;
import com.android.tools.idea.editors.build.RenderingBuildStatusManager;
import com.android.tools.idea.editors.shortcuts.UtilsKt;
import com.android.tools.idea.preview.PreviewBundle;
import com.android.tools.idea.preview.PreviewRefreshManager;
import com.android.tools.idea.preview.mvvm.PreviewView;
import com.android.tools.idea.preview.mvvm.PreviewViewModel;
import com.android.tools.idea.preview.mvvm.PreviewViewModelStatus;
import com.android.tools.idea.preview.viewmodels.CommonPreviewViewModelKt;
import com.android.tools.idea.rendering.tokens.BuildSystemFilePreviewServicesKt;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ui.UIUtil;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002Bf\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020!H\u0016J\b\u0010$\u001a\u00020!H\u0016J\b\u0010%\u001a\u00020!H\u0016J\b\u0010&\u001a\u00020!H\u0016J\b\u0010'\u001a\u00020!H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u0018\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020!H\u0016J\b\u0010.\u001a\u00020!H\u0016J\b\u0010/\u001a\u00020!H\u0002J\b\u00100\u001a\u00020!H\u0002J\b\u00105\u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u0002028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00106\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00107R\u0014\u0010:\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00107R\u0014\u0010<\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u00107R\u0014\u0010=\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u00107R\u0016\u0010?\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\u00a8\u0006B"}, d2={"Lcom/android/tools/idea/preview/viewmodels/CommonPreviewViewModel;", "Lcom/android/tools/idea/preview/mvvm/PreviewViewModel;", "Lcom/android/tools/idea/preview/mvvm/PreviewViewModelStatus;", "previewView", "Lcom/android/tools/idea/preview/mvvm/PreviewView;", "renderingBuildStatusManager", "Lcom/android/tools/idea/editors/build/RenderingBuildStatusManager;", "previewRefreshManager", "Lcom/android/tools/idea/preview/PreviewRefreshManager;", "project", "Lcom/intellij/openapi/project/Project;", "psiFilePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiFile;", "hasErrorRenderResult", "Lkotlin/Function0;", "", "previewRefreshNotificationFactory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "durationString", "Lcom/intellij/notification/Notification;", "<init>", "(Lcom/android/tools/idea/preview/mvvm/PreviewView;Lcom/android/tools/idea/editors/build/RenderingBuildStatusManager;Lcom/android/tools/idea/preview/PreviewRefreshManager;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/SmartPsiElementPointer;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "hasRendered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "hasPreviews", "checkForNativeCrash", "runnable", "Ljava/lang/Runnable;", "refreshStarted", "", "refreshFinished", "beforePreviewsRefreshed", "afterPreviewsRefreshed", "buildStarted", "buildSucceeded", "buildFailed", "setHasPreviews", "refreshCompleted", "isCancelled", "durationNanos", "", "onEnterSmartMode", "activate", "updateNotifications", "updateViewAndNotifications", "buildAndRefreshAction", "Lcom/android/tools/adtui/stdui/ActionData;", "getBuildAndRefreshAction", "()Lcom/android/tools/adtui/stdui/ActionData;", "updateView", "isRefreshing", "()Z", "hasRenderErrors", "getHasRenderErrors", "hasSyntaxErrors", "getHasSyntaxErrors", "isOutOfDate", "areResourcesOutOfDate", "getAreResourcesOutOfDate", "previewedFile", "getPreviewedFile", "()Lcom/intellij/psi/PsiFile;", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nCommonPreviewViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonPreviewViewModel.kt\ncom/android/tools/idea/preview/viewmodels/CommonPreviewViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public class CommonPreviewViewModel
implements PreviewViewModel,
PreviewViewModelStatus {
    @NotNull
    private final PreviewView previewView;
    @NotNull
    private final RenderingBuildStatusManager renderingBuildStatusManager;
    @NotNull
    private final PreviewRefreshManager previewRefreshManager;
    @NotNull
    private final Project project;
    @NotNull
    private final SmartPsiElementPointer<PsiFile> psiFilePointer;
    @NotNull
    private final Function0<Boolean> hasErrorRenderResult;
    @NotNull
    private final Function1<String, Notification> previewRefreshNotificationFactory;
    @NotNull
    private final AtomicBoolean hasRendered;
    @NotNull
    private final AtomicBoolean hasPreviews;

    public CommonPreviewViewModel(@NotNull PreviewView previewView, @NotNull RenderingBuildStatusManager renderingBuildStatusManager, @NotNull PreviewRefreshManager previewRefreshManager, @NotNull Project project, @NotNull SmartPsiElementPointer<PsiFile> psiFilePointer, @NotNull Function0<Boolean> hasErrorRenderResult, @NotNull Function1<? super String, ? extends Notification> previewRefreshNotificationFactory) {
        Intrinsics.checkNotNullParameter((Object)previewView, (String)"previewView");
        Intrinsics.checkNotNullParameter((Object)renderingBuildStatusManager, (String)"renderingBuildStatusManager");
        Intrinsics.checkNotNullParameter((Object)previewRefreshManager, (String)"previewRefreshManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(psiFilePointer, (String)"psiFilePointer");
        Intrinsics.checkNotNullParameter(hasErrorRenderResult, (String)"hasErrorRenderResult");
        Intrinsics.checkNotNullParameter(previewRefreshNotificationFactory, (String)"previewRefreshNotificationFactory");
        this.previewView = previewView;
        this.renderingBuildStatusManager = renderingBuildStatusManager;
        this.previewRefreshManager = previewRefreshManager;
        this.project = project;
        this.psiFilePointer = psiFilePointer;
        this.hasErrorRenderResult = hasErrorRenderResult;
        this.previewRefreshNotificationFactory = previewRefreshNotificationFactory;
        this.hasRendered = new AtomicBoolean(false);
        this.hasPreviews = new AtomicBoolean(false);
    }

    @Override
    public boolean checkForNativeCrash(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (Bridge.hasNativeCrash()) {
            String message = "The preview has been disabled following a crash in the rendering engine. If the problem persists, please report the issue.";
            ActionData actionData = new ActionData("Re-enable rendering", null, () -> CommonPreviewViewModel.checkForNativeCrash$lambda$1(runnable, this), 2, null);
            UIUtil.invokeLaterIfNeeded(() -> CommonPreviewViewModel.checkForNativeCrash$lambda$2(this, message, actionData));
            return true;
        }
        return false;
    }

    @Override
    public void refreshStarted() {
        this.updateNotifications();
    }

    @Override
    public void refreshFinished() {
        this.updateNotifications();
    }

    @Override
    public void beforePreviewsRefreshed() {
        this.updateViewAndNotifications();
    }

    @Override
    public void afterPreviewsRefreshed() {
        this.hasRendered.set(true);
        this.updateViewAndNotifications();
    }

    public void buildStarted() {
        this.updateViewAndNotifications();
    }

    public void buildSucceeded() {
        this.updateViewAndNotifications();
    }

    public void buildFailed() {
        this.updateViewAndNotifications();
    }

    @Override
    public void setHasPreviews(boolean hasPreviews2) {
        this.hasPreviews.set(hasPreviews2);
    }

    @Override
    public void refreshCompleted(boolean isCancelled, long durationNanos) {
        this.updateViewAndNotifications();
        ActionsKt.invokeLater$default(null, () -> CommonPreviewViewModel.refreshCompleted$lambda$3(this, durationNanos), (int)1, null);
    }

    @Override
    public void onEnterSmartMode() {
        this.updateViewAndNotifications();
    }

    @Override
    public void activate() {
        this.updateViewAndNotifications();
    }

    private final void updateNotifications() {
        UIUtil.invokeLaterIfNeeded(() -> CommonPreviewViewModel.updateNotifications$lambda$4(this));
    }

    private final void updateViewAndNotifications() {
        UIUtil.invokeLaterIfNeeded(() -> CommonPreviewViewModel.updateViewAndNotifications$lambda$5(this));
    }

    private final ActionData getBuildAndRefreshAction() {
        String actionDataText = PreviewBundle.INSTANCE.message("panel.needs.build.action.text", new Object[0]) + UtilsKt.asString$default(UtilsKt.getBuildAndRefreshShortcut(), null, null, 3, null);
        return new ActionData(actionDataText, null, () -> CommonPreviewViewModel._get_buildAndRefreshAction_$lambda$7(this), 2, null);
    }

    private final void updateView() {
        if (this.hasRendered.get()) {
            this.previewView.showContent();
        } else if (DumbService.Companion.getInstance(this.project).isDumb()) {
            this.previewView.showLoadingMessage(PreviewBundle.INSTANCE.message("panel.indexing", new Object[0]));
        } else if (this.renderingBuildStatusManager.isBuilding()) {
            this.previewView.showLoadingMessage(PreviewBundle.INSTANCE.message("panel.building", new Object[0]));
        } else if (Intrinsics.areEqual((Object)this.renderingBuildStatusManager.getStatus(), (Object)RenderingBuildStatus.NeedsBuild.INSTANCE)) {
            this.previewView.showErrorMessage(PreviewBundle.INSTANCE.message("panel.needs.build", new Object[0]), null, this.getBuildAndRefreshAction());
        } else {
            this.previewView.showLoadingMessage(PreviewBundle.INSTANCE.message("panel.initializing", new Object[0]));
        }
    }

    @Override
    public boolean isRefreshing() {
        return this.previewRefreshManager.getRefreshingTypeFlow().getValue() != null || DumbService.Companion.isDumb(this.project) || this.renderingBuildStatusManager.isBuilding();
    }

    @Override
    public boolean getHasRenderErrors() {
        return this.hasPreviews.get() && (!this.hasRendered.get() || (Boolean)this.hasErrorRenderResult.invoke() != false);
    }

    @Override
    public boolean getHasSyntaxErrors() {
        return WolfTheProblemSolver.getInstance((Project)this.project).isProblemFile(this.psiFilePointer.getVirtualFile());
    }

    @Override
    public boolean isOutOfDate() {
        return this.renderingBuildStatusManager.getStatus() instanceof RenderingBuildStatus.OutOfDate;
    }

    @Override
    public boolean getAreResourcesOutOfDate() {
        RenderingBuildStatus.OutOfDate outOfDate;
        RenderingBuildStatus renderingBuildStatus = this.renderingBuildStatusManager.getStatus();
        RenderingBuildStatus.OutOfDate outOfDate2 = outOfDate = renderingBuildStatus instanceof RenderingBuildStatus.OutOfDate ? (RenderingBuildStatus.OutOfDate)renderingBuildStatus : null;
        return outOfDate != null ? outOfDate.getAreResourcesOutOfDate() : false;
    }

    @Override
    @Nullable
    public PsiFile getPreviewedFile() {
        return (PsiFile)this.psiFilePointer.getElement();
    }

    public void buildCleaned() {
        PreviewViewModel.super.buildCleaned();
    }

    public void startedListening() {
        PreviewViewModel.super.startedListening();
    }

    private static final void checkForNativeCrash$lambda$1$lambda$0(CommonPreviewViewModel this$0) {
        this$0.previewView.showLoadingMessage("Loading...");
    }

    private static final Unit checkForNativeCrash$lambda$1(Runnable $runnable, CommonPreviewViewModel this$0) {
        Bridge.setNativeCrash((boolean)false);
        UIUtil.invokeLaterIfNeeded(() -> CommonPreviewViewModel.checkForNativeCrash$lambda$1$lambda$0(this$0));
        $runnable.run();
        return Unit.INSTANCE;
    }

    private static final void checkForNativeCrash$lambda$2(CommonPreviewViewModel this$0, String $message, ActionData $actionData) {
        this$0.previewView.showErrorMessage($message, null, $actionData);
    }

    private static final Unit refreshCompleted$lambda$3(CommonPreviewViewModel this$0, long $durationNanos) {
        if (this$0.hasRendered.get()) {
            Duration duration = Duration.ofMillis($durationNanos / (long)1000000);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            String durationString = CommonPreviewViewModelKt.access$toDisplayString(duration);
            Notification notification = (Notification)this$0.previewRefreshNotificationFactory.invoke((Object)durationString);
            Notifications.Bus.notify((Notification)notification, (Project)this$0.project);
        }
        return Unit.INSTANCE;
    }

    private static final void updateNotifications$lambda$4(CommonPreviewViewModel this$0) {
        this$0.previewView.updateToolbar();
        if (!this$0.project.isDisposed()) {
            EditorNotifications.getInstance((Project)this$0.project).updateNotifications(this$0.psiFilePointer.getVirtualFile());
        }
    }

    private static final void updateViewAndNotifications$lambda$5(CommonPreviewViewModel this$0) {
        this$0.updateView();
        this$0.updateNotifications();
    }

    private static final Unit _get_buildAndRefreshAction_$lambda$7(CommonPreviewViewModel this$0) {
        block0: {
            PsiFile psiFile = (PsiFile)this$0.psiFilePointer.getElement();
            if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) break block0;
            PsiFile it = psiFile;
            boolean bl = false;
            BuildSystemFilePreviewServicesKt.requestBuildArtifactsForRendering((Project)this$0.project, (VirtualFile)it);
        }
        return Unit.INSTANCE;
    }
}

