/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.lifecycle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0003H\u0007J*\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0018\u001a\u00020\u00122\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002J\u001c\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/preview/lifecycle/DelayedLruActionQueue;", "", "maxLruPlaces", "", "delay", "Ljava/time/Duration;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "<init>", "(ILjava/time/Duration;Ljava/util/concurrent/ScheduledExecutorService;)V", "queueLock", "Ljava/util/concurrent/locks/ReentrantLock;", "lruQueue", "Ljava/util/ArrayDeque;", "Lkotlin/Function0;", "", "actionToDisposable", "Ljava/util/WeakHashMap;", "Lcom/intellij/openapi/Disposable;", "actionToScheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "queueSize", "addActionToQueue", "action", "actionDisposable", "scheduledFuture", "removeActionFromQueue", "", "addDelayedAction", "parentDisposable", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nDelayedLruActionQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelayedLruActionQueue.kt\ncom/android/tools/idea/preview/lifecycle/DelayedLruActionQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class DelayedLruActionQueue {
    private final int maxLruPlaces;
    @NotNull
    private final Duration delay;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final ReentrantLock queueLock;
    @NotNull
    private final ArrayDeque<Function0<Unit>> lruQueue;
    @NotNull
    private final WeakHashMap<Function0<Unit>, Disposable> actionToDisposable;
    @NotNull
    private final WeakHashMap<Function0<Unit>, ScheduledFuture<?>> actionToScheduledFuture;

    public DelayedLruActionQueue(int maxLruPlaces, @NotNull Duration delay, @NotNull ScheduledExecutorService scheduledExecutorService) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"scheduledExecutorService");
        this.maxLruPlaces = maxLruPlaces;
        this.delay = delay;
        this.scheduledExecutorService = scheduledExecutorService;
        this.queueLock = new ReentrantLock();
        this.lruQueue = new ArrayDeque(this.maxLruPlaces);
        this.actionToDisposable = new WeakHashMap();
        this.actionToScheduledFuture = new WeakHashMap();
    }

    public /* synthetic */ DelayedLruActionQueue(int n, Duration duration, ScheduledExecutorService scheduledExecutorService, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = AppExecutorUtil.createBoundedScheduledExecutorService((String)"DelayedLruActionQueue", (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"createBoundedScheduledExecutorService(...)");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(n, duration, scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TestOnly
    public final int queueSize() {
        Lock lock = this.queueLock;
        lock.lock();
        try {
            void var3_3;
            boolean bl;
            boolean bl2 = false;
            int queueSize = this.lruQueue.size();
            boolean bl3 = bl = queueSize == this.actionToDisposable.size();
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "actionToDisposable size must always match the size of the lruQueue";
                throw new AssertionError((Object)string);
            }
            void var6_8 = var3_3;
            return (int)var6_8;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addActionToQueue(Function0<Unit> action2, Disposable actionDisposable, ScheduledFuture<?> scheduledFuture) {
        Lock lock = this.queueLock;
        lock.lock();
        try {
            boolean bl = false;
            if (((Map)this.actionToDisposable).containsKey(action2)) {
                this.lruQueue.add(this.lruQueue.remove());
                ScheduledFuture<?> scheduledFuture2 = this.actionToScheduledFuture.get(action2);
                if (scheduledFuture2 != null) {
                    scheduledFuture2.cancel(false);
                }
                ((Map)this.actionToScheduledFuture).put(action2, scheduledFuture);
                return;
            }
            if (this.lruQueue.size() == this.maxLruPlaces) {
                Function0<Unit> removedAction = this.lruQueue.remove();
                this.actionToDisposable.remove(removedAction);
                this.actionToScheduledFuture.remove(removedAction);
                removedAction.invoke();
            }
            this.lruQueue.add(action2);
            ((Map)this.actionToDisposable).put(action2, actionDisposable);
            ((Map)this.actionToScheduledFuture).put(action2, scheduledFuture);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeActionFromQueue(Function0<Unit> action2) {
        if (action2 == null) {
            return false;
        }
        Lock lock = this.queueLock;
        lock.lock();
        try {
            boolean bl = false;
            boolean actionWasStillInTheQueue = this.lruQueue.remove(action2);
            ScheduledFuture<?> scheduledFuture = this.actionToScheduledFuture.remove(action2);
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            Disposable disposable = this.actionToDisposable.remove(action2);
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl2 = false;
                Disposer.dispose((Disposable)it);
            }
            boolean bl3 = actionWasStillInTheQueue;
            return bl3;
        }
        finally {
            lock.unlock();
        }
    }

    public final void addDelayedAction(@NotNull Disposable parentDisposable, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        WeakReference<Function0<Unit>> weakActionRef = new WeakReference<Function0<Unit>>(action2);
        Disposable disposable = () -> DelayedLruActionQueue.addDelayedAction$lambda$5(weakActionRef, this);
        if (!Disposer.tryRegister((Disposable)parentDisposable, (Disposable)disposable)) {
            Disposer.dispose((Disposable)disposable);
            return;
        }
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(() -> DelayedLruActionQueue.addDelayedAction$lambda$6(weakActionRef, this), this.delay.toMillis(), TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNull(scheduledFuture);
        this.addActionToQueue(action2, disposable, scheduledFuture);
    }

    private static final void addDelayedAction$lambda$5(WeakReference $weakActionRef, DelayedLruActionQueue this$0) {
        Function0 function0 = (Function0)$weakActionRef.get();
        if (function0 == null) {
            return;
        }
        Function0 actionToRemove = function0;
        this$0.removeActionFromQueue((Function0<Unit>)actionToRemove);
    }

    private static final void addDelayedAction$lambda$6(WeakReference $weakActionRef, DelayedLruActionQueue this$0) {
        Function0 function0 = (Function0)$weakActionRef.get();
        if (function0 == null) {
            return;
        }
        Function0 actionToRemove = function0;
        if (this$0.removeActionFromQueue((Function0<Unit>)actionToRemove)) {
            actionToRemove.invoke();
        }
    }
}

