/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.animation.timeline;

import com.android.tools.idea.preview.animation.AnimatedProperty;
import com.android.tools.idea.preview.animation.InspectorColors;
import com.android.tools.idea.preview.animation.InspectorLayout;
import com.android.tools.idea.preview.animation.InspectorPainter;
import com.android.tools.idea.preview.animation.SupportedAnimationManager;
import com.android.tools.idea.preview.animation.timeline.PositionProxy;
import com.android.tools.idea.preview.animation.timeline.TimelineElement;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/preview/animation/timeline/ComponentCurve;", "Lcom/android/tools/idea/preview/animation/timeline/TimelineElement;", "frozenState", "Lcom/android/tools/idea/preview/animation/SupportedAnimationManager$FrozenState;", "component", "Lcom/android/tools/idea/preview/animation/AnimatedProperty$AnimatedComponent;", "", "minX", "", "maxX", "rowMinY", "curve", "Ljava/awt/geom/Path2D;", "colorIndex", "positionProxy", "Lcom/android/tools/idea/preview/animation/timeline/PositionProxy;", "<init>", "(Lcom/android/tools/idea/preview/animation/SupportedAnimationManager$FrozenState;Lcom/android/tools/idea/preview/animation/AnimatedProperty$AnimatedComponent;IIILjava/awt/geom/Path2D;ILcom/android/tools/idea/preview/animation/timeline/PositionProxy;)V", "getComponent", "()Lcom/android/tools/idea/preview/animation/AnimatedProperty$AnimatedComponent;", "curveBaseY", "getCurveBaseY$annotations", "()V", "getCurveBaseY", "()I", "startDiamond", "Lcom/android/tools/idea/preview/animation/InspectorPainter$Diamond;", "endDiamond", "boxedLabelPositionWithoutOffset", "Ljava/awt/Point;", "boxedLabelPosition", "getBoxedLabelPosition", "()Ljava/awt/Point;", "height", "getHeight", "contains", "", "x", "y", "paint", "", "g", "Ljava/awt/Graphics2D;", "Companion", "intellij.android.preview-designer"})
public final class ComponentCurve
extends TimelineElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimatedProperty.AnimatedComponent<Double> component;
    @NotNull
    private final Path2D curve;
    private final int colorIndex;
    private final int curveBaseY;
    @NotNull
    private final InspectorPainter.Diamond startDiamond;
    @NotNull
    private final InspectorPainter.Diamond endDiamond;
    @NotNull
    private final Point boxedLabelPositionWithoutOffset;
    @NotNull
    private final Point boxedLabelPosition;
    private final int height;

    public ComponentCurve(@NotNull SupportedAnimationManager.FrozenState frozenState, @NotNull AnimatedProperty.AnimatedComponent<Double> component, int minX, int maxX, int rowMinY, @NotNull Path2D curve, int colorIndex, @NotNull PositionProxy positionProxy2) {
        Intrinsics.checkNotNullParameter((Object)frozenState, (String)"frozenState");
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        Intrinsics.checkNotNullParameter((Object)positionProxy2, (String)"positionProxy");
        super(frozenState, minX, maxX);
        this.component = component;
        this.curve = curve;
        this.colorIndex = colorIndex;
        this.curveBaseY = rowMinY + InspectorLayout.INSTANCE.timelineCurveRowHeightScaled() - InspectorLayout.INSTANCE.curveBottomOffset();
        this.startDiamond = new InspectorPainter.Diamond(minX, this.curveBaseY, this.colorIndex);
        this.endDiamond = new InspectorPainter.Diamond(maxX, this.curveBaseY, this.colorIndex);
        this.boxedLabelPositionWithoutOffset = new Point(minX + InspectorLayout.INSTANCE.getLabelOffset(), this.curveBaseY + InspectorLayout.INSTANCE.getLabelOffset());
        this.boxedLabelPosition = new Point(RangesKt.coerceIn((int)this.boxedLabelPositionWithoutOffset.x, (int)positionProxy2.minimumXPosition(), (int)positionProxy2.maximumXPosition()), this.boxedLabelPositionWithoutOffset.y);
        this.height = 75;
        this.curve.transform(AffineTransform.getTranslateInstance(0.0, 0.0));
    }

    @NotNull
    public final AnimatedProperty.AnimatedComponent<Double> getComponent() {
        return this.component;
    }

    public final int getCurveBaseY() {
        return this.curveBaseY;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCurveBaseY$annotations() {
    }

    @NotNull
    public final Point getBoxedLabelPosition() {
        return this.boxedLabelPosition;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.curve.contains(x, y) || this.startDiamond.contains(x, y) || this.endDiamond.contains(x, y);
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor((Color)InspectorColors.INSTANCE.getGRAPH_COLORS().get(this.colorIndex % InspectorColors.INSTANCE.getGRAPH_COLORS().size()));
        g.setStroke(InspectorLayout.INSTANCE.getSimpleStroke());
        g.drawLine(this.getMinX(), this.curveBaseY, this.getMaxX(), this.curveBaseY);
        if (this.component.getLinkToNext()) {
            g.setStroke(InspectorLayout.INSTANCE.getDashedStroke());
            g.drawLine(this.getMinX(), this.curveBaseY, this.getMinX(), this.curveBaseY + this.heightScaled() - InspectorPainter.Diamond.Companion.diamondSize());
            g.drawLine(this.getMaxX(), this.curveBaseY, this.getMaxX(), this.curveBaseY + this.heightScaled() - InspectorPainter.Diamond.Companion.diamondSize());
            g.setStroke(InspectorLayout.INSTANCE.getSimpleStroke());
        }
        g.setColor(InspectorColors.INSTANCE.getGRAPH_COLORS_WITH_ALPHA().get(this.colorIndex % InspectorColors.INSTANCE.getGRAPH_COLORS().size()));
        Object prevAntiAliasHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fill(this.curve);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, prevAntiAliasHint);
        this.startDiamond.paint(g);
        this.endDiamond.paint(g);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/preview/animation/timeline/ComponentCurve$Companion;", "", "<init>", "()V", "create", "Lcom/android/tools/idea/preview/animation/timeline/ComponentCurve;", "frozenState", "Lcom/android/tools/idea/preview/animation/SupportedAnimationManager$FrozenState;", "property", "Lcom/android/tools/idea/preview/animation/AnimatedProperty;", "", "componentId", "", "rowMinY", "positionProxy", "Lcom/android/tools/idea/preview/animation/timeline/PositionProxy;", "colorIndex", "intellij.android.preview-designer"})
    @SourceDebugExtension(value={"SMAP\nComponentCurve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentCurve.kt\ncom/android/tools/idea/preview/animation/timeline/ComponentCurve$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,186:1\n216#2,2:187\n*S KotlinDebug\n*F\n+ 1 ComponentCurve.kt\ncom/android/tools/idea/preview/animation/timeline/ComponentCurve$Companion\n*L\n89#1:187,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ComponentCurve create(@NotNull SupportedAnimationManager.FrozenState frozenState, @NotNull AnimatedProperty<Double> property, int componentId, int rowMinY, @NotNull PositionProxy positionProxy2, int colorIndex) {
            Intrinsics.checkNotNullParameter((Object)frozenState, (String)"frozenState");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)positionProxy2, (String)"positionProxy");
            AnimatedProperty.AnimatedComponent<Double> component = property.getComponents().get(componentId);
            boolean bl = false;
            Path2D curve = new Path2D.Double();
            double animationYMin = component.getMinValue();
            boolean isZeroDuration = property.getEndMs() == property.getStartMs();
            boolean isZeroHeight = ((Number)component.getMinValue()).doubleValue() == ((Number)component.getMaxValue()).doubleValue();
            boolean zeroDurationXOffset = isZeroDuration;
            int minX = positionProxy2.xPositionForValue(property.getStartMs());
            int maxX = positionProxy2.xPositionForValue(property.getEndMs());
            int minY = rowMinY + 10;
            int maxY = rowMinY + InspectorLayout.INSTANCE.timelineLineRowHeightScaled() - InspectorLayout.INSTANCE.curveBottomOffset();
            curve.moveTo((double)minX - (double)zeroDurationXOffset, maxY);
            if (isZeroDuration) {
                curve.lineTo((double)minX - (double)zeroDurationXOffset, minY);
                curve.lineTo((double)maxX + (double)zeroDurationXOffset, minY);
            } else if (!isZeroHeight) {
                double valueRange = component.getMaxValue() - component.getMinValue();
                int yRange2 = maxY - minY;
                double stepY = !(valueRange == 0.0) ? (double)yRange2 / valueRange : 0.0;
                Map $this$forEach$iv = component.getPoints();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Integer ms = (Integer)entry.getKey();
                    Double value = (Double)entry.getValue();
                    Intrinsics.checkNotNull((Object)ms);
                    curve.lineTo(positionProxy2.xPositionForValue(ms), (double)maxY - (value - animationYMin) * stepY);
                }
            }
            curve.lineTo((double)maxX + (double)zeroDurationXOffset, maxY);
            curve.lineTo((double)minX - (double)zeroDurationXOffset, maxY);
            return new ComponentCurve(frozenState, component, minX, maxX, rowMinY, curve, colorIndex, positionProxy2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

