/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.navigation;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.compose.preview.ComposeViewInfo;
import com.android.tools.idea.compose.preview.ComposeViewInfoKt;
import com.android.tools.idea.compose.preview.ComposeViewInfoParserKt;
import com.android.tools.idea.compose.preview.SourceLocation;
import com.android.tools.idea.compose.preview.navigation.PreviewNavigation;
import com.android.tools.idea.compose.preview.navigation.SourceLocationWithVirtualFile;
import com.android.tools.idea.compose.preview.navigation.SourceLocationWithVirtualFileKt;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.PreviewNavigatableWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002\u001a,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\u001aD\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u0012\u001a&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u001a>\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0013H\u0002\u00a8\u0006!"}, d2={"toNavigatable", "Lcom/intellij/pom/Navigatable;", "Lcom/android/tools/idea/compose/preview/SourceLocation;", "module", "Lcom/intellij/openapi/module/Module;", "dumpViewInfosToLog", "", "viewInfos", "", "Lcom/android/tools/idea/compose/preview/ComposeViewInfo;", "indent", "", "findComponentHits", "allViewInfos", "x", "y", "findNavigatableComponentHit", "locationFilter", "Lkotlin/Function1;", "", "findBoundsOfComponentsInFile", "Ljava/awt/Rectangle;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "fileName", "", "lineNumber", "findNavigatableComponents", "Lcom/android/tools/idea/uibuilder/surface/PreviewNavigatableWrapper;", "hitX", "hitY", "requestFocus", "shouldFindAllNavigatables", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nPreviewNavigation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewNavigation.kt\ncom/android/tools/idea/compose/preview/navigation/PreviewNavigationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,210:1\n1863#2,2:211\n774#2:213\n865#2,2:214\n1557#2:216\n1628#2,3:217\n774#2:220\n865#2,2:221\n774#2:223\n865#2,2:224\n1863#2,2:226\n774#2:229\n865#2,2:230\n1557#2:232\n1628#2,3:233\n774#2:241\n865#2,2:242\n1557#2:244\n1628#2,3:245\n1#3:228\n62#4,5:236\n*S KotlinDebug\n*F\n+ 1 PreviewNavigation.kt\ncom/android/tools/idea/compose/preview/navigation/PreviewNavigationKt\n*L\n71#1:211,2\n91#1:213\n91#1:214,2\n98#1:216\n98#1:217,3\n113#1:220\n113#1:221,2\n117#1:223\n117#1:224,2\n117#1:226,2\n137#1:229\n137#1:230,2\n138#1:232\n138#1:233,3\n183#1:241\n183#1:242,2\n185#1:244\n185#1:245,3\n166#1:236,5\n*E\n"})
public final class PreviewNavigationKt {
    private static final Navigatable toNavigatable(SourceLocation $this$toNavigatable, Module module) {
        SourceLocationWithVirtualFile sourceLocationWithVirtualFile;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if ($this$toNavigatable instanceof SourceLocationWithVirtualFile) {
            sourceLocationWithVirtualFile = (SourceLocationWithVirtualFile)$this$toNavigatable;
        } else {
            sourceLocationWithVirtualFile = SourceLocationWithVirtualFileKt.asSourceLocationWithVirtualFile$default($this$toNavigatable, module, null, 2, null);
            if (sourceLocationWithVirtualFile == null) {
                return null;
            }
        }
        SourceLocationWithVirtualFile sourceLocationWithVirtualFile2 = sourceLocationWithVirtualFile;
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> PreviewNavigationKt.toNavigatable$lambda$0(project2, sourceLocationWithVirtualFile2));
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Integer n = (Integer)ActionsKt.runReadAction(() -> PreviewNavigationKt.toNavigatable$lambda$1(psiFile2, sourceLocationWithVirtualFile2));
        int offset = n != null ? n : 0;
        return PsiNavigationSupport.getInstance().createNavigatable(project2, sourceLocationWithVirtualFile2.getVirtualFile$intellij_android_compose_designer(), offset);
    }

    private static final void dumpViewInfosToLog(Module module, List<ComposeViewInfo> viewInfos, int indent) {
        String margin = StringsKt.repeat((CharSequence)"-", (int)indent);
        Iterable $this$forEach$iv = viewInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComposeViewInfo it = (ComposeViewInfo)element$iv;
            boolean bl = false;
            PreviewNavigation.INSTANCE.getLOG().debug(margin + " " + it + " navigatable=" + PreviewNavigationKt.toNavigatable(it.getSourceLocation(), module));
            PreviewNavigationKt.dumpViewInfosToLog(module, it.getChildren(), indent + 1);
        }
    }

    static /* synthetic */ void dumpViewInfosToLog$default(Module module, List list, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        PreviewNavigationKt.dumpViewInfosToLog(module, list, n);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<SourceLocation> findComponentHits(@NotNull List<ComposeViewInfo> allViewInfos, int x, int y) {
        void $this$mapTo$iv$iv;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(allViewInfos, (String)"allViewInfos");
        Object $this$filter$iv = ComposeViewInfoKt.findHitWithDepth(allViewInfos, x, y);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((ComposeViewInfo)it.getSecond()).getSourceLocation().getLineNumber() >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getFirst();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getFirst()));
            }
        };
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator((Comparator)$this$filter$iv){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((ComposeViewInfo)it.getSecond()).getSourceLocation().getLineNumber());
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((ComposeViewInfo)it.getSecond()).getSourceLocation().getLineNumber()));
                }
                return n;
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ComposeViewInfo)it.getSecond()).getSourceLocation());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Navigatable findNavigatableComponentHit(@NotNull Module module, @NotNull List<ComposeViewInfo> allViewInfos, int x, int y, @NotNull Function1<? super SourceLocation, Boolean> locationFilter) {
        Iterable iterable;
        block5: {
            Object element$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(allViewInfos, (String)"allViewInfos");
            Intrinsics.checkNotNullParameter(locationFilter, (String)"locationFilter");
            Iterable $this$filter$iv = PreviewNavigationKt.findComponentHits(allViewInfos, x, y);
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                if (!((Boolean)locationFilter.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List hits = (List)destination$iv$iv;
            if (PreviewNavigation.INSTANCE.getLOG().isDebugEnabled()) {
                void $this$forEach$iv;
                PreviewNavigation.INSTANCE.getLOG().debug(hits.size() + " hits found in");
                $this$filter$iv = hits;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = iterator.next();
                    SourceLocation it = (SourceLocation)element$iv$iv;
                    boolean bl = false;
                    if (!(PreviewNavigationKt.toNavigatable(it, module) != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SourceLocation it = (SourceLocation)element$iv;
                    boolean bl = false;
                    PreviewNavigation.INSTANCE.getLOG().debug("  Navigatable hit: " + it);
                }
            }
            for (SourceLocation it : (Iterable)hits) {
                boolean bl = false;
                iterable2 = (Navigatable)ActionsKt.runReadAction(() -> PreviewNavigationKt.findNavigatableComponentHit$lambda$11$lambda$10(it, module));
                if (iterable2 == null) continue;
                iterable = iterable2;
                break block5;
            }
            iterable = null;
        }
        return iterable;
    }

    public static /* synthetic */ Navigatable findNavigatableComponentHit$default(Module module, List list, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            function1 = PreviewNavigationKt::findNavigatableComponentHit$lambda$7;
        }
        return PreviewNavigationKt.findNavigatableComponentHit(module, list, n, n2, (Function1<? super SourceLocation, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Rectangle> findBoundsOfComponentsInFile(SceneView sceneView, String fileName, int lineNumber) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ComposeViewInfo it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        NlModel model = sceneView.getSceneManager().getModel();
        NlComponent nlComponent = (NlComponent)CollectionsKt.firstOrNull((List)((List)model.getTreeReader().getComponents()));
        if (nlComponent == null) {
            return CollectionsKt.emptyList();
        }
        NlComponent root = nlComponent;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(root);
        if (viewInfo == null) {
            return CollectionsKt.emptyList();
        }
        ViewInfo viewInfo2 = viewInfo;
        List<ComposeViewInfo> allViewInfos = ComposeViewInfoParserKt.parseViewInfo(viewInfo2, PreviewNavigation.INSTANCE.getLOG());
        if (allViewInfos.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = ComposeViewInfoKt.findAllHitsInFile(allViewInfos, fileName);
        boolean $i$f$filter = false;
        void var10_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ComposeViewInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.getSourceLocation().getLineNumber() == lineNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ComposeViewInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Rectangle(it.getBounds().getLeft(), it.getBounds().getTop(), it.getBounds().getRight() - it.getBounds().getLeft(), it.getBounds().getBottom() - it.getBounds().getTop()));
        }
        List rectangles = (List)destination$iv$iv;
        return rectangles;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PreviewNavigatableWrapper> findNavigatableComponents(SceneView sceneView, int hitX, int hitY, boolean requestFocus, String fileName, boolean shouldFindAllNavigatables) {
        Object object;
        int x = Coordinates.getAndroidX(sceneView, hitX);
        int y = Coordinates.getAndroidY(sceneView, hitY);
        Logger $this$debug_u24default$iv = PreviewNavigation.INSTANCE.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            object.debug("handleNavigate x=" + x + ", y=" + y, e$iv);
        }
        NlModel model = sceneView.getSceneManager().getModel();
        NlComponent nlComponent = (NlComponent)CollectionsKt.firstOrNull((List)((List)model.getTreeReader().getComponents()));
        if (nlComponent == null) {
            return CollectionsKt.emptyList();
        }
        NlComponent root = nlComponent;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(root);
        if (viewInfo == null) {
            return CollectionsKt.emptyList();
        }
        ViewInfo viewInfo2 = viewInfo;
        Module module = model.getModule();
        List<ComposeViewInfo> allViewInfos = ComposeViewInfoParserKt.parseViewInfo(viewInfo2, PreviewNavigation.INSTANCE.getLOG());
        if (PreviewNavigation.INSTANCE.getLOG().isDebugEnabled()) {
            PreviewNavigationKt.dumpViewInfosToLog$default(module, allViewInfos, 0, 4, null);
        }
        if (shouldFindAllNavigatables) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ComposeViewInfo it;
            void $this$filterTo$iv$iv;
            Object $this$filter$iv;
            Iterable iterable = ComposeViewInfoKt.findAllHitsWithPoint(allViewInfos, x, y);
            boolean $i$f$filter = false;
            void var15_19 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ComposeViewInfo)element$iv$iv;
                boolean bl = false;
                if (!(PreviewNavigationKt.toNavigatable(it.getSourceLocation(), module) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = new Function1[]{PreviewNavigationKt::findNavigatableComponents$lambda$16, PreviewNavigationKt::findNavigatableComponents$lambda$17};
            $this$filter$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])$this$filter$iv));
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ComposeViewInfo)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Object name = it.getName();
                if (!StringsKt.isBlank((CharSequence)((CharSequence)name))) {
                    name = (String)name + ", ";
                }
                String string = (String)name + " " + it.getSourceLocation().getFileName() + ": " + it.getSourceLocation().getLineNumber();
                Navigatable navigatable = PreviewNavigationKt.toNavigatable(it.getSourceLocation(), module);
                Intrinsics.checkNotNull((Object)navigatable);
                object.add(new PreviewNavigatableWrapper(string, navigatable));
            }
            return (List)destination$iv$iv;
        }
        Navigatable navigatable = PreviewNavigationKt.findNavigatableComponentHit(module, allViewInfos, x, y, (Function1<? super SourceLocation, Boolean>)((Function1)arg_0 -> PreviewNavigationKt.findNavigatableComponents$lambda$19(requestFocus, fileName, arg_0)));
        if (navigatable != null) {
            return CollectionsKt.listOf((Object)new PreviewNavigatableWrapper("", navigatable));
        }
        return CollectionsKt.emptyList();
    }

    private static final PsiFile toNavigatable$lambda$0(Project $project, SourceLocationWithVirtualFile $sourceLocationWithVirtualFile) {
        return PsiManager.getInstance((Project)$project).findFile($sourceLocationWithVirtualFile.getVirtualFile$intellij_android_compose_designer());
    }

    private static final Integer toNavigatable$lambda$1(PsiFile $psiFile, SourceLocationWithVirtualFile $sourceLocationWithVirtualFile) {
        return PsiLinesUtilsKt.getLineStartOffset((PsiFile)$psiFile, (int)($sourceLocationWithVirtualFile.getLineNumber() - 1));
    }

    private static final boolean findNavigatableComponentHit$lambda$7(SourceLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Navigatable findNavigatableComponentHit$lambda$11$lambda$10(SourceLocation $it, Module $module) {
        return PreviewNavigationKt.toNavigatable($it, $module);
    }

    private static final Comparable findNavigatableComponents$lambda$16(ComposeViewInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getSourceLocation().getFileName());
    }

    private static final Comparable findNavigatableComponents$lambda$17(ComposeViewInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(it.getSourceLocation().getLineNumber());
    }

    private static final boolean findNavigatableComponents$lambda$19(boolean $requestFocus, String $fileName, SourceLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $requestFocus || Intrinsics.areEqual((Object)it.getFileName(), (Object)$fileName);
    }

    public static final /* synthetic */ List access$findNavigatableComponents(SceneView sceneView, int hitX, int hitY, boolean requestFocus, String fileName, boolean shouldFindAllNavigatables) {
        return PreviewNavigationKt.findNavigatableComponents(sceneView, hitX, hitY, requestFocus, fileName, shouldFindAllNavigatables);
    }

    public static final /* synthetic */ List access$findBoundsOfComponentsInFile(SceneView sceneView, String fileName, int lineNumber) {
        return PreviewNavigationKt.findBoundsOfComponentsInFile(sceneView, fileName, lineNumber);
    }
}

