/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.compose.preview.ComposeViewInfo;
import com.android.tools.idea.compose.preview.PxBounds;
import com.android.tools.idea.compose.preview.SourceLocation;
import com.android.tools.idea.compose.preview.SourceLocationImpl;
import com.android.tools.idea.compose.preview.util.ViewInfoUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"parseViewInfo", "", "Lcom/android/tools/idea/compose/preview/ComposeViewInfo;", "rootViewInfo", "Lcom/android/ide/common/rendering/api/ViewInfo;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "parseBounds", "elements", "", "getBound", "Lcom/android/tools/idea/compose/preview/PxBounds;", "viewInfo", "getInt", "", "px", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nComposeViewInfoParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeViewInfoParser.kt\ncom/android/tools/idea/compose/preview/ComposeViewInfoParserKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n2945#2,12:142\n1#3:154\n1#3:165\n1611#4,9:155\n1863#4:164\n1864#4:166\n1620#4:167\n*S KotlinDebug\n*F\n+ 1 ComposeViewInfoParser.kt\ncom/android/tools/idea/compose/preview/ComposeViewInfoParserKt\n*L\n60#1:142,12\n87#1:165\n87#1:155,9\n87#1:164\n87#1:166\n87#1:167\n*E\n"})
public final class ComposeViewInfoParserKt {
    @NotNull
    public static final List<ComposeViewInfo> parseViewInfo(@NotNull ViewInfo rootViewInfo, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)rootViewInfo, (String)"rootViewInfo");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            Object $this$single$iv;
            Object object = rootViewInfo.getViewObject();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getViewObject(...)");
            Object object2 = ViewInfoUtilsKt.findComposeViewAdapter(object);
            if (object2 == null) {
                return CollectionsKt.emptyList();
            }
            Object viewObj = object2;
            Method[] methodArray = viewObj.getClass().getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
            Object[] objectArray = methodArray;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (void element$iv : $this$single$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"getViewInfos", (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            $this$single$iv = single$iv;
            Method it = $this$single$iv;
            boolean bl = false;
            it.setAccessible(true);
            Method viewInfoField = $this$single$iv;
            Object object3 = viewInfoField.invoke(viewObj, new Object[0]);
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List composeViewInfos = (List)object3;
            List<ComposeViewInfo> viewInfos = ComposeViewInfoParserKt.parseBounds(composeViewInfos, logger);
            if (viewInfos.size() != 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                logger.warn("Expected one ComposeViewInfo. Received multiple entries. This indicates a failure in the stitchTree function's merging logic. While a list is accepted to prevent immediate failure, the presence of multiple entries here requires investigation of stitchTree. Alternatively, if multiple entries are now expected, this assert should be removed or modified.");
            }
            return viewInfos;
        }
        catch (Exception e) {
            logger.debug((Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ComposeViewInfo> parseBounds(List<? extends Object> elements, Logger logger) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = elements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ComposeViewInfo it$iv$iv;
            ComposeViewInfo composeViewInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object item = element$iv$iv;
            boolean bl2 = false;
            try {
                String string;
                Integer n;
                Object t = item;
                Intrinsics.checkNotNull(t);
                Object object = t.getClass().getMethod("getFileName", new Class[0]).invoke(item, new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String fileName = (String)object;
                Object object2 = item.getClass().getMethod("getLineNumber", new Class[0]).invoke(item, new Object[0]);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                int lineNumber = (Integer)object2;
                PxBounds bounds2 = ComposeViewInfoParserKt.getBound(item);
                Object object3 = item.getClass().getMethod("getChildren", new Class[0]).invoke(item, new Object[0]);
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
                List children = (List)object3;
                try {
                    Integer n2;
                    if (item.getClass().getMethod("getLocation", new Class[0]).invoke(item, new Object[0]) != null) {
                        Object it;
                        boolean bl3 = false;
                        Object object4 = it.getClass().getMethod("getPackageHash", new Class[0]).invoke(it, new Object[0]);
                        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Int");
                        n2 = (int)((Integer)object4);
                    } else {
                        n2 = null;
                    }
                    n = n2;
                }
                catch (Throwable t2) {
                    logger.warn(t2);
                    n = null;
                }
                Integer n3 = n;
                int packageHash = n3 != null ? n3 : -1;
                SourceLocationImpl sourceLocation = new SourceLocationImpl(fileName, lineNumber, packageHash);
                try {
                    string = (String)item.getClass().getMethod("getName", new Class[0]).invoke(item, new Object[0]);
                }
                catch (Throwable t3) {
                    string = null;
                }
                String name = string;
                SourceLocation sourceLocation2 = sourceLocation;
                List<ComposeViewInfo> list = ComposeViewInfoParserKt.parseBounds(children, logger);
                String string2 = name;
                if (string2 == null) {
                    string2 = "";
                }
                composeViewInfo = new ComposeViewInfo(sourceLocation2, bounds2, list, string2);
            }
            catch (Throwable t) {
                logger.warn(t);
                composeViewInfo = null;
            }
            if (composeViewInfo == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final PxBounds getBound(Object viewInfo) {
        Object bounds2 = viewInfo.getClass().getMethod("getBounds", new Class[0]).invoke(viewInfo, new Object[0]);
        Object topPx = bounds2.getClass().getMethod("getTop", new Class[0]).invoke(bounds2, new Object[0]);
        Object bottomPx = bounds2.getClass().getMethod("getBottom", new Class[0]).invoke(bounds2, new Object[0]);
        Object rightPx = bounds2.getClass().getMethod("getRight", new Class[0]).invoke(bounds2, new Object[0]);
        Object leftPx = bounds2.getClass().getMethod("getLeft", new Class[0]).invoke(bounds2, new Object[0]);
        Intrinsics.checkNotNull((Object)leftPx);
        int n = ComposeViewInfoParserKt.getInt(leftPx);
        Intrinsics.checkNotNull((Object)topPx);
        int n2 = ComposeViewInfoParserKt.getInt(topPx);
        Intrinsics.checkNotNull((Object)rightPx);
        int n3 = ComposeViewInfoParserKt.getInt(rightPx);
        Intrinsics.checkNotNull((Object)bottomPx);
        return new PxBounds(n, n2, n3, ComposeViewInfoParserKt.getInt(bottomPx));
    }

    private static final int getInt(Object px) {
        int n;
        if (px instanceof Integer) {
            return ((Number)px).intValue();
        }
        Object value = px.getClass().getMethod("getValue", new Class[0]).invoke(px, new Object[0]);
        Integer n2 = value instanceof Integer ? (Integer)value : null;
        if (n2 != null) {
            n = n2;
        } else {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Float");
            n = (int)((Float)value).floatValue();
        }
        return n;
    }
}

