/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.ZoomController;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.common.analytics.DesignerAnalyticsManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.ScaleChange;
import com.android.tools.idea.common.surface.ScaleListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ScenesOwner;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010&\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J*\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00112\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020-00H\u0003J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J \u00101\u001a\u00020\u00172\u0006\u00102\u001a\u0002032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0017J\b\u00104\u001a\u00020\u0017H\u0017J\u0010\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u000203H\u0017J\b\u00105\u001a\u00020\u0017H\u0016J\b\u00106\u001a\u00020\u0017H\u0016J\b\u00107\u001a\u00020\u0017H\u0016J\b\u00108\u001a\u00020\u0017H\u0016J\n\u00109\u001a\u0004\u0018\u00010:H\u0004J\u000e\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020\u001eJ\u0018\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u00112\u0006\u0010?\u001a\u00020\u0011H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b \u0010\u001c\u001a\u0004\b!\u0010\u0013R\u001a\u0010\"\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010%R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/android/tools/idea/common/surface/DesignSurfaceZoomController;", "Lcom/android/tools/adtui/ZoomController;", "designerAnalyticsManager", "Lcom/android/tools/idea/common/analytics/DesignerAnalyticsManager;", "selectionModel", "Lcom/android/tools/idea/common/model/SelectionModel;", "scenesOwner", "Lcom/android/tools/idea/common/surface/ScenesOwner;", "<init>", "(Lcom/android/tools/idea/common/analytics/DesignerAnalyticsManager;Lcom/android/tools/idea/common/model/SelectionModel;Lcom/android/tools/idea/common/surface/ScenesOwner;)V", "storeId", "", "getStoreId", "()Ljava/lang/String;", "setStoreId", "(Ljava/lang/String;)V", "minScale", "", "getMinScale", "()D", "maxScale", "getMaxScale", "shouldShowZoomAnimation", "", "getShouldShowZoomAnimation", "()Z", "currentScale", "getCurrentScale$annotations", "()V", "scaleListener", "Lcom/android/tools/idea/common/surface/ScaleListener;", "scale", "getScale$annotations", "getScale", "screenScalingFactor", "getScreenScalingFactor", "setScreenScalingFactor", "(D)V", "setScale", "x", "", "y", "currentTimer", "Ljavax/swing/Timer;", "animateScaleChange", "", "newScale", "changeScale", "Lkotlin/Function2;", "zoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "zoomToFit", "canZoomIn", "canZoomOut", "canZoomToFit", "canZoomToActual", "getFocusedSceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "setOnScaleListener", "listener", "isScaleSame", "scaleA", "scaleB", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesignSurfaceZoomController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignSurfaceZoomController.kt\ncom/android/tools/idea/common/surface/DesignSurfaceZoomController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,287:1\n1#2:288\n*E\n"})
public abstract class DesignSurfaceZoomController
implements ZoomController {
    @Nullable
    private final DesignerAnalyticsManager designerAnalyticsManager;
    @Nullable
    private final SelectionModel selectionModel;
    @Nullable
    private final ScenesOwner scenesOwner;
    @Nullable
    private String storeId;
    private final double minScale;
    private final double maxScale;
    private final boolean shouldShowZoomAnimation;
    private double currentScale;
    @Nullable
    private ScaleListener scaleListener;
    private double screenScalingFactor;
    @Nullable
    private Timer currentTimer;
    public static final int $stable = 8;

    public DesignSurfaceZoomController(@Nullable DesignerAnalyticsManager designerAnalyticsManager, @Nullable SelectionModel selectionModel, @Nullable ScenesOwner scenesOwner) {
        this.designerAnalyticsManager = designerAnalyticsManager;
        this.selectionModel = selectionModel;
        this.scenesOwner = scenesOwner;
        this.minScale = 0.01;
        this.maxScale = 10.0;
        this.currentScale = 1.0;
        this.screenScalingFactor = 1.0;
    }

    @Override
    @Nullable
    public String getStoreId() {
        return this.storeId;
    }

    @Override
    public void setStoreId(@Nullable String string) {
        this.storeId = string;
    }

    @Override
    public double getMinScale() {
        return this.minScale;
    }

    @Override
    public double getMaxScale() {
        return this.maxScale;
    }

    public boolean getShouldShowZoomAnimation() {
        return this.shouldShowZoomAnimation;
    }

    private static /* synthetic */ void getCurrentScale$annotations() {
    }

    public double getScale() {
        return this.currentScale;
    }

    public static /* synthetic */ void getScale$annotations() {
    }

    public double getScreenScalingFactor() {
        return this.screenScalingFactor;
    }

    public void setScreenScalingFactor(double d) {
        this.screenScalingFactor = d;
    }

    @Override
    public boolean setScale(double scale, int x, int y) {
        block2: {
            double newScale;
            block1: {
                newScale = this.getBoundedScale(scale);
                if (this.isScaleSame(this.currentScale, newScale)) {
                    return false;
                }
                if (!this.getShouldShowZoomAnimation()) break block1;
                this.animateScaleChange(newScale, (Function2<? super Double, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> DesignSurfaceZoomController.setScale$lambda$0(this, x, y, arg_0, arg_1)));
                break block2;
            }
            double previewsScale = this.currentScale;
            this.currentScale = newScale;
            ScaleListener scaleListener = this.scaleListener;
            if (scaleListener == null) break block2;
            scaleListener.onScaleChange(new ScaleChange(previewsScale, newScale, new Point(x, y), false, 8, null));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    private final void animateScaleChange(double newScale, Function2<? super Double, ? super Boolean, Unit> changeScale) {
        void $this$animateScaleChange_u24lambda_u243;
        Timer timer;
        Timer timer2 = this.currentTimer;
        if (timer2 != null) {
            timer2.stop();
        }
        double previousScale = this.currentScale;
        int intervalDelay = 4;
        double zoomChangePerInterval = Math.max(0.01, Math.abs(newScale - previousScale) / (double)intervalDelay);
        Function1 transformation = arg_0 -> DesignSurfaceZoomController.animateScaleChange$lambda$1(zoomChangePerInterval, arg_0);
        Ref.DoubleRef intervalCounter = new Ref.DoubleRef();
        Timer timer3 = timer = new Timer(intervalDelay, arg_0 -> DesignSurfaceZoomController.animateScaleChange$lambda$2(this, newScale, intervalCounter, changeScale, previousScale, transformation, arg_0));
        DesignSurfaceZoomController designSurfaceZoomController = this;
        boolean bl = false;
        $this$animateScaleChange_u24lambda_u243.start();
        designSurfaceZoomController.currentTimer = timer;
    }

    @Override
    public boolean setScale(double scale) {
        return this.setScale(scale, -1, -1);
    }

    @UiThread
    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int newX = x;
        int newY = y;
        DesignerAnalyticsManager designerAnalyticsManager = this.designerAnalyticsManager;
        if (designerAnalyticsManager != null) {
            designerAnalyticsManager.trackZoom(type);
        }
        SceneView view = this.getFocusedSceneView();
        if (type == ZoomType.IN && (newX < 0 || newY < 0) && view != null) {
            Scene scene;
            SceneComponent component;
            SelectionModel selectionModel = this.selectionModel;
            boolean bl = selectionModel != null ? !selectionModel.isEmpty() : false;
            if (bl && (component = (scene = view.getScene()).getSceneComponent(this.selectionModel.getPrimary())) != null) {
                newX = Coordinates.getSwingXDip(view, component.getCenterX());
                newY = Coordinates.getSwingYDip(view, component.getCenterY());
            }
        }
        boolean scaled = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                double currentScale = this.currentScale * this.getScreenScalingFactor();
                int current = (int)Math.round(currentScale * (double)100);
                double newScale = (double)ZoomType.zoomIn((int)current) / 100.0 / this.getScreenScalingFactor();
                yield this.setScale(newScale, newX, newY);
            }
            case 2 -> {
                double currentScale = this.currentScale * this.getScreenScalingFactor();
                int current = (int)(currentScale * (double)100);
                double newScale = (double)ZoomType.zoomOut((int)current) / 100.0 / this.getScreenScalingFactor();
                yield this.setScale(newScale, newX, newY);
            }
            case 3 -> this.setScale(1.0 / this.getScreenScalingFactor());
            case 4 -> this.setScale(this.getFitScale());
            default -> throw new UnsupportedOperationException("Not yet implemented: " + type);
        };
        return scaled;
    }

    @Override
    @UiThread
    public boolean zoomToFit() {
        return this.zoom(ZoomType.FIT, -1, -1);
    }

    @UiThread
    public boolean zoom(@NotNull ZoomType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.zoom(type, -1, -1);
    }

    public boolean canZoomIn() {
        return this.currentScale < this.getMaxScale() && !this.isScaleSame(this.getScale(), this.getMaxScale());
    }

    public boolean canZoomOut() {
        return this.currentScale > this.getMinScale() && !this.isScaleSame(this.getMinScale(), this.getScale());
    }

    public boolean canZoomToFit() {
        double zoomToFitScale = this.getFitScale();
        return this.currentScale > zoomToFitScale && this.canZoomOut() || this.currentScale < zoomToFitScale && this.canZoomIn();
    }

    public boolean canZoomToActual() {
        return this.getScale() > 1.0 && this.canZoomOut() || this.getScale() < 1.0 && this.canZoomIn();
    }

    @Nullable
    protected final SceneView getFocusedSceneView() {
        ScenesOwner scenesOwner = this.scenesOwner;
        return scenesOwner != null ? scenesOwner.getFocusedSceneView() : null;
    }

    public final void setOnScaleListener(@NotNull ScaleListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.scaleListener = listener2;
    }

    private final boolean isScaleSame(double scaleA, double scaleB) {
        double tolerance = 0.005 / this.getScreenScalingFactor();
        return Math.abs(scaleA - scaleB) < tolerance;
    }

    @Override
    public double getBoundedScale(double scale) {
        return ZoomController.super.getBoundedScale(scale);
    }

    private static final Unit setScale$lambda$0(DesignSurfaceZoomController this$0, int $x, int $y, double scaleIncrement, boolean isAnimating) {
        block0: {
            double previousScale = this$0.currentScale;
            this$0.currentScale = scaleIncrement;
            ScaleListener scaleListener = this$0.scaleListener;
            if (scaleListener == null) break block0;
            scaleListener.onScaleChange(new ScaleChange(previousScale, scaleIncrement, new Point($x, $y), isAnimating));
        }
        return Unit.INSTANCE;
    }

    private static final double animateScaleChange$lambda$1(double $zoomChangePerInterval, double t) {
        double x = t * $zoomChangePerInterval;
        int threshold = 25;
        return $zoomChangePerInterval > 0.05 && t <= (double)threshold ? (double)2 * x * x * x : (t <= (double)threshold ? (double)2 * x * x : (double)2 * x + ((double)50 - x) + (double)25);
    }

    private static final void animateScaleChange$lambda$2(DesignSurfaceZoomController this$0, double $newScale, Ref.DoubleRef $intervalCounter, Function2 $changeScale, double $previousScale, Function1 $transformation, ActionEvent it) {
        if (this$0.isScaleSame(this$0.currentScale, $newScale)) {
            Timer timer = this$0.currentTimer;
            if (timer != null) {
                timer.stop();
            }
        } else if ($intervalCounter.element >= 50.0) {
            $changeScale.invoke((Object)$newScale, (Object)false);
            Timer timer = this$0.currentTimer;
            if (timer != null) {
                timer.stop();
            }
        } else {
            double updatedScale = $previousScale <= $newScale ? Math.min($newScale, $previousScale + ((Number)$transformation.invoke((Object)$intervalCounter.element)).doubleValue()) : Math.max($newScale, $previousScale - ((Number)$transformation.invoke((Object)$intervalCounter.element)).doubleValue());
            $changeScale.invoke((Object)updatedScale, (Object)true);
        }
        double d = $intervalCounter.element;
        $intervalCounter.element = d + 1.0;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ZoomType.values().length];
            try {
                nArray[ZoomType.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.ACTUAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.FIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

