/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.ChangeType;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentUtil;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.util.XmlTagUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.LocalResourceRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#J.\u0010%\u001a\u00020\n2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\u001dJ2\u0010+\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010-\u001a\u00020#H\u0007J8\u0010.\u001a\u00020\n2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\u001d2\b\u0010/\u001a\u0004\u0018\u000100JP\u0010.\u001a\u00020\n2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\u001d2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00102\u001a\u0004\u0018\u0001002\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u0016H\u0007J,\u0010\u000b\u001a\u0004\u0018\u00010\r2\u0006\u00104\u001a\u00020\f2\b\u00105\u001a\u0004\u0018\u00010\r2\b\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\u001dJ\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010 \u001a\u00020!2\u0006\u0010*\u001a\u00020\u001dJ\u0016\u00107\u001a\u00020\n2\u000e\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r09J\u0016\u0010:\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0'H\u0002JN\u0010;\u001a\u00020\n2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\u001d2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00102\u001a\u0004\u0018\u0001002\b\u00103\u001a\u0004\u0018\u00010\u0016H\u0002J0\u0010<\u001a\u00020\n2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\u001dH\u0002J\u0018\u0010=\u001a\u00020\n2\u000e\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r09H\u0002J\u001e\u0010>\u001a\u00020\u00162\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010*\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006?"}, d2={"Lcom/android/tools/idea/common/model/NlTreeWriter;", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "file", "Lkotlin/Function0;", "Lcom/intellij/psi/xml/XmlFile;", "notifyModified", "Lkotlin/Function1;", "Lcom/android/tools/idea/common/model/ChangeType;", "", "createComponent", "Lcom/intellij/psi/xml/XmlTag;", "Lcom/android/tools/idea/common/model/NlComponent;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "id", "", "getId", "()J", "pendingIds", "", "", "getPendingIds", "()Ljava/util/Set;", "ids", "", "getIds", "determineInsertType", "Lcom/android/tools/idea/common/api/InsertType;", "dragType", "Lcom/android/tools/idea/common/api/DragType;", "item", "Lcom/android/tools/idea/common/model/DnDTransferItem;", "asPreview", "", "generateIds", "addTags", "added", "", "receiver", "before", "insertType", "canAddComponents", "toAdd", "ignoreMissingDependencies", "addComponents", "onComponentAdded", "Ljava/lang/Runnable;", "componentToAdd", "attributeUpdatingTask", "groupId", "tag", "parent", "createComponents", "delete", "components", "", "checkIfUserWantsToAddDependencies", "addComponentInWriteCommand", "handleAddition", "handleDeletion", "generateAddComponentsDescription", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class NlTreeWriter {
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final Function0<XmlFile> file;
    @NotNull
    private final Function1<ChangeType, Unit> notifyModified;
    @NotNull
    private final Function1<XmlTag, NlComponent> createComponent;
    private final long id;
    @NotNull
    private final Set<String> pendingIds;
    public static final int $stable = 8;

    public NlTreeWriter(@NotNull AndroidFacet facet, @NotNull Function0<? extends XmlFile> file2, @NotNull Function1<? super ChangeType, Unit> notifyModified, @NotNull Function1<? super XmlTag, ? extends NlComponent> createComponent) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter(file2, (String)"file");
        Intrinsics.checkNotNullParameter(notifyModified, (String)"notifyModified");
        Intrinsics.checkNotNullParameter(createComponent, (String)"createComponent");
        this.facet = facet;
        this.file = file2;
        this.notifyModified = notifyModified;
        this.createComponent = createComponent;
        this.id = System.nanoTime() ^ (long)((XmlFile)this.file.invoke()).getName().hashCode();
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        this.pendingIds = hashSet;
    }

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final Set<String> getPendingIds() {
        return this.pendingIds;
    }

    @NotNull
    public final Set<String> getIds() {
        LocalResourceRepository localResourceRepository = StudioResourceRepositoryManager.getAppResources((AndroidFacet)this.facet);
        Intrinsics.checkNotNullExpressionValue((Object)localResourceRepository, (String)"getAppResources(...)");
        ResourceRepository resources = (ResourceRepository)localResourceRepository;
        Set ids = new HashSet(resources.getResources(ResourceNamespace.TODO(), ResourceType.ID).keySet());
        Set<String> pendingIds = this.pendingIds;
        if (!((Collection)pendingIds).isEmpty()) {
            Set all = new HashSet(pendingIds.size() + ids.size());
            all.addAll(ids);
            all.addAll((Collection)pendingIds);
            ids = all;
        }
        return ids;
    }

    @NotNull
    public final InsertType determineInsertType(@NotNull DragType dragType, @Nullable DnDTransferItem item, boolean asPreview, boolean generateIds) {
        Intrinsics.checkNotNullParameter((Object)((Object)dragType), (String)"dragType");
        if (item != null && item.isFromPalette()) {
            return asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[dragType.ordinal()]) {
            case 1 -> {
                if (asPreview) {
                    yield InsertType.CREATE_PREVIEW;
                }
                yield InsertType.CREATE;
            }
            case 2 -> {
                if (item != null && this.id != item.getModelId()) {
                    yield InsertType.COPY;
                }
                yield InsertType.MOVE;
            }
            case 3 -> InsertType.COPY;
            default -> generateIds ? InsertType.PASTE_GENERATE_NEW_IDS : InsertType.PASTE;
        };
    }

    public final void addTags(@NotNull List<? extends NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        Intrinsics.checkNotNullParameter(added, (String)"added");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        NlWriteCommandActionUtil.run(added, this.generateAddComponentsDescription(added, insertType), () -> NlTreeWriter.addTags$lambda$0(added, receiver, before, insertType));
        this.notifyModified.invoke((Object)ChangeType.ADD_COMPONENTS);
    }

    @JvmOverloads
    public final boolean canAddComponents(@NotNull List<? extends NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, boolean ignoreMissingDependencies) {
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        if (before != null && before.getParent() != receiver) {
            return false;
        }
        if (toAdd.isEmpty()) {
            return false;
        }
        if (toAdd.stream().anyMatch(arg_0 -> NlTreeWriter.canAddComponents$lambda$2(arg_0 -> NlTreeWriter.canAddComponents$lambda$1(receiver, arg_0), arg_0))) {
            return false;
        }
        if (NlComponentUtil.isDescendant(receiver, (Collection<NlComponent>)toAdd)) {
            return false;
        }
        return ignoreMissingDependencies || this.checkIfUserWantsToAddDependencies(toAdd);
    }

    public static /* synthetic */ boolean canAddComponents$default(NlTreeWriter nlTreeWriter, List list, NlComponent nlComponent, NlComponent nlComponent2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return nlTreeWriter.canAddComponents(list, nlComponent, nlComponent2, bl);
    }

    public final void addComponents(@NotNull List<? extends NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable Runnable onComponentAdded) {
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        NlTreeWriter.addComponents$default(this, toAdd, receiver, before, insertType, onComponentAdded, null, null, 64, null);
    }

    @JvmOverloads
    public final void addComponents(@NotNull List<? extends NlComponent> componentToAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable Runnable onComponentAdded, @Nullable Runnable attributeUpdatingTask, @Nullable String groupId) {
        Intrinsics.checkNotNullParameter(componentToAdd, (String)"componentToAdd");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        ImmutableList toAdd = ImmutableList.copyOf((Collection)componentToAdd);
        Intrinsics.checkNotNull((Object)toAdd);
        if (!this.canAddComponents((List)toAdd, receiver, before, insertType == InsertType.MOVE)) {
            return;
        }
        Runnable callback = () -> NlTreeWriter.addComponents$lambda$3(this, toAdd, receiver, before, insertType, onComponentAdded, attributeUpdatingTask, groupId);
        if (insertType == InsertType.MOVE) {
            callback.run();
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> NlTreeWriter.addComponents$lambda$4(toAdd, this, callback));
    }

    public static /* synthetic */ void addComponents$default(NlTreeWriter nlTreeWriter, List list, NlComponent nlComponent, NlComponent nlComponent2, InsertType insertType, Runnable runnable, Runnable runnable2, String string, int n, Object object) {
        if ((n & 0x40) != 0) {
            string = null;
        }
        nlTreeWriter.addComponents(list, nlComponent, nlComponent2, insertType, runnable, runnable2, string);
    }

    @Nullable
    public final NlComponent createComponent(@NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before, @NotNull InsertType insertType) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        XmlTag addedTag = tag;
        if (parent != null) {
            XmlTag xmlTag = parent.getTagDeprecated();
            Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"getTagDeprecated(...)");
            XmlTag parentTag = xmlTag;
            Object object = WriteAction.compute(() -> NlTreeWriter.createComponent$lambda$5(before, parentTag, tag));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
            addedTag = (XmlTag)object;
        }
        NlComponent child = (NlComponent)this.createComponent.invoke((Object)addedTag);
        NlComponent nlComponent = parent;
        if (nlComponent != null) {
            nlComponent.addChild(child, before);
        }
        if (child.postCreate(insertType)) {
            return child;
        }
        return null;
    }

    @NotNull
    public final List<NlComponent> createComponents(@NotNull DnDTransferItem item, @NotNull InsertType insertType) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        List components = new ArrayList(item.getComponents().size());
        UnmodifiableIterator unmodifiableIterator = item.getComponents().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            NlComponent component;
            XmlTag tag;
            DnDTransferComponent dndComponent = (DnDTransferComponent)unmodifiableIterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)XmlTagUtil.createTag(this.facet.getModule().getProject(), dndComponent.getRepresentation()), (String)"createTag(...)");
            if (this.createComponent(tag, null, null, insertType) == null) {
                return CollectionsKt.emptyList();
            }
            component.postCreateFromTransferrable(dndComponent);
            components.add(component);
        }
        return components;
    }

    public final void delete(@NotNull Collection<? extends NlComponent> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        PsiFile[] psiFileArray = new PsiFile[]{this.file.invoke()};
        WriteCommandAction.runWriteCommandAction((Project)this.facet.getModule().getProject(), (String)"Delete Component", null, () -> NlTreeWriter.delete$lambda$6(this, components), (PsiFile[])psiFileArray);
        this.notifyModified.invoke((Object)ChangeType.DELETE);
    }

    private final boolean checkIfUserWantsToAddDependencies(List<? extends NlComponent> toAdd) {
        return NlDependencyManager.Companion.getInstance().checkIfUserWantsToAddDependencies(toAdd, this.facet);
    }

    private final void addComponentInWriteCommand(List<? extends NlComponent> toAdd, NlComponent receiver, NlComponent before, InsertType insertType, Runnable onComponentAdded, Runnable attributeUpdatingTask, String groupId) {
        Project project = this.facet.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DumbService.Companion.getInstance(project).runWhenSmart(() -> NlTreeWriter.addComponentInWriteCommand$lambda$8(toAdd, this, insertType, groupId, onComponentAdded, attributeUpdatingTask, receiver, before));
    }

    private final void handleAddition(List<? extends NlComponent> added, NlComponent receiver, NlComponent before, InsertType insertType) {
        for (NlComponent nlComponent : added) {
            nlComponent.moveTo(receiver, before, insertType, this.getIds());
        }
    }

    private final void handleDeletion(Collection<? extends NlComponent> components) {
        Multimap<NlComponent, NlComponent> multimap = NlComponentUtil.groupSiblings(components);
        Intrinsics.checkNotNullExpressionValue(multimap, (String)"groupSiblings(...)");
        Multimap<NlComponent, NlComponent> siblingLists = multimap;
        for (NlComponent parent : siblingLists.keySet()) {
            if (parent == null) continue;
            Collection children = siblingLists.get((Object)parent);
            NlComponent.XmlModelComponentMixin xmlModelComponentMixin = parent.getMixin();
            Intrinsics.checkNotNull((Object)xmlModelComponentMixin);
            if (xmlModelComponentMixin.maybeHandleDeletion(children)) continue;
            for (NlComponent component : children) {
                XmlTag tag;
                NlComponent p;
                NlComponent nlComponent = p = component.getParent();
                if (nlComponent != null) {
                    nlComponent.removeChild(component);
                }
                Intrinsics.checkNotNullExpressionValue((Object)component.getTagDeprecated(), (String)"getTagDeprecated(...)");
                if (!tag.isValid()) continue;
                PsiElement parentTag = tag.getParent();
                tag.delete();
                if (!(parentTag instanceof XmlTag)) continue;
                ((XmlTag)parentTag).collapseIfEmpty();
            }
        }
    }

    private final String generateAddComponentsDescription(List<? extends NlComponent> toAdd, InsertType insertType) {
        DragType dragType = insertType.getDragType();
        String componentType = "";
        if (toAdd.size() == 1) {
            String string = toAdd.get(0).getTagName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagName(...)");
            String tagName = string;
            String string2 = tagName.substring(StringsKt.lastIndexOf$default((CharSequence)tagName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            componentType = string2;
        }
        String string = dragType.getDescription(componentType);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
        return string;
    }

    @JvmOverloads
    public final boolean canAddComponents(@NotNull List<? extends NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before) {
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        return NlTreeWriter.canAddComponents$default(this, toAdd, receiver, before, false, 8, null);
    }

    @JvmOverloads
    public final void addComponents(@NotNull List<? extends NlComponent> componentToAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable Runnable onComponentAdded, @Nullable Runnable attributeUpdatingTask) {
        Intrinsics.checkNotNullParameter(componentToAdd, (String)"componentToAdd");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        NlTreeWriter.addComponents$default(this, componentToAdd, receiver, before, insertType, onComponentAdded, attributeUpdatingTask, null, 64, null);
    }

    private static final void addTags$lambda$0(List $added, NlComponent $receiver, NlComponent $before, InsertType $insertType) {
        for (NlComponent component : $added) {
            component.addTags($receiver, $before, $insertType);
        }
    }

    private static final boolean canAddComponents$lambda$1(NlComponent $receiver, NlComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return !c.canAddTo($receiver);
    }

    private static final boolean canAddComponents$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void addComponents$lambda$3(NlTreeWriter this$0, ImmutableList $toAdd, NlComponent $receiver, NlComponent $before, InsertType $insertType, Runnable $onComponentAdded, Runnable $attributeUpdatingTask, String $groupId) {
        Intrinsics.checkNotNull((Object)$toAdd);
        this$0.addComponentInWriteCommand((List)$toAdd, $receiver, $before, $insertType, $onComponentAdded, $attributeUpdatingTask, $groupId);
    }

    private static final void addComponents$lambda$4(ImmutableList $toAdd, NlTreeWriter this$0, Runnable $callback) {
        NlDependencyManager nlDependencyManager = NlDependencyManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)$toAdd);
        nlDependencyManager.addDependencies((Iterable)$toAdd, this$0.facet, false, $callback);
    }

    private static final XmlTag createComponent$lambda$5(NlComponent $before, XmlTag $parentTag, XmlTag $tag) {
        if ($before != null) {
            PsiElement psiElement = $parentTag.addBefore((PsiElement)$tag, (PsiElement)$before.getTagDeprecated());
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
            return (XmlTag)psiElement;
        }
        return $parentTag.addSubTag($tag, false);
    }

    private static final void delete$lambda$6(NlTreeWriter this$0, Collection $components) {
        this$0.handleDeletion($components);
    }

    private static final void addComponentInWriteCommand$lambda$8$lambda$7(Runnable $attributeUpdatingTask, NlTreeWriter this$0, List $toAdd, NlComponent $receiver, NlComponent $before, InsertType $insertType) {
        Runnable runnable = $attributeUpdatingTask;
        if (runnable != null) {
            runnable.run();
        }
        this$0.handleAddition($toAdd, $receiver, $before, $insertType);
    }

    private static final void addComponentInWriteCommand$lambda$8(List $toAdd, NlTreeWriter this$0, InsertType $insertType, String $groupId, Runnable $onComponentAdded, Runnable $attributeUpdatingTask, NlComponent $receiver, NlComponent $before) {
        block0: {
            NlWriteCommandActionUtil.run($toAdd, this$0.generateAddComponentsDescription($toAdd, $insertType), $groupId, () -> NlTreeWriter.addComponentInWriteCommand$lambda$8$lambda$7($attributeUpdatingTask, this$0, $toAdd, $receiver, $before, $insertType));
            this$0.notifyModified.invoke((Object)ChangeType.ADD_COMPONENTS);
            Runnable runnable = $onComponentAdded;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DragType.values().length];
            try {
                nArray[DragType.CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DragType.MOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DragType.COPY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

