/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.lint;

import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.NlComponentIssueSource;
import com.android.tools.idea.common.lint.AttributeKey;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.SuppressLintQuickFix;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintAnnotationsModel {
    private ListMultimap<NlComponent, IssueData> myIssues = ImmutableListMultimap.of();
    private ListMultimap<AttributeKey, IssueData> myAttributeIssues = ImmutableListMultimap.of();
    private List<IssueData> myIssueList = Collections.emptyList();

    @Nullable
    public String getIssueMessage(@NotNull NlComponent component) {
        if (this.myIssues == null) {
            return null;
        }
        List issueData = this.myIssues.get((Object)component);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        return LintAnnotationsModel.findHighestSeverityIssue((List<IssueData>)issueData).message;
    }

    @Nullable
    public IssueData findIssue(@NotNull NlComponent component, @NotNull String namespace, @NotNull String attributeName) {
        if (this.myAttributeIssues == null) {
            return null;
        }
        AttributeKey attributeKey = new AttributeKey(component, namespace, attributeName);
        List issueData = this.myAttributeIssues.get((Object)attributeKey);
        if (issueData == null || issueData.isEmpty()) {
            return null;
        }
        return LintAnnotationsModel.findHighestSeverityIssue(issueData);
    }

    private static IssueData findHighestSeverityIssue(List<IssueData> issueData) {
        return Collections.max(issueData);
    }

    public void addIssue(@NotNull NlComponent component, @Nullable AttributeKey attribute, @NotNull Incident incident, @NotNull Issue issue, @NotNull String message, @NotNull AndroidLintInspectionBase inspection, @NotNull HighlightDisplayLevel level, @NotNull SmartPsiElementPointer<PsiElement> startElement, @NotNull SmartPsiElementPointer<PsiElement> endElement, @Nullable LintFix quickfixData) {
        if (issue == RtlDetector.COMPAT) {
            return;
        }
        if (this.myIssues.isEmpty()) {
            this.myIssues = ArrayListMultimap.create();
            this.myAttributeIssues = ArrayListMultimap.create();
            this.myIssueList = new ArrayList<IssueData>();
        }
        IssueData data = new IssueData(component, attribute, inspection, incident, issue, message, level, startElement, endElement, quickfixData);
        this.myIssues.put((Object)component, (Object)data);
        this.myIssueList.add(data);
        if (attribute != null) {
            this.myAttributeIssues.put((Object)attribute, (Object)data);
        }
    }

    public int getIssueCount() {
        return this.myIssueList == null ? 0 : this.myIssueList.size();
    }

    @NotNull
    public List<IssueData> getIssues() {
        return this.myIssueList != null ? this.myIssueList : Collections.emptyList();
    }

    public static class IssueData
    implements Comparable<IssueData> {
        @NotNull
        public final AndroidLintInspectionBase inspection;
        @NotNull
        public final HighlightDisplayLevel level;
        @NotNull
        public final String message;
        @NotNull
        public final Issue issue;
        @NotNull
        public final Incident incident;
        @NotNull
        public final SmartPsiElementPointer<PsiElement> endElementPointer;
        @NotNull
        public final SmartPsiElementPointer<PsiElement> startElementPointer;
        @NotNull
        public final NlComponent component;
        @NotNull
        public final IssueSource issueSource;
        @Nullable
        public final AttributeKey attribute;
        @Nullable
        public final LintFix quickfixData;

        private IssueData(@NotNull NlComponent component, @Nullable AttributeKey attribute, @NotNull AndroidLintInspectionBase inspection, @NotNull Incident incident, @NotNull Issue issue, @NotNull String message, @NotNull HighlightDisplayLevel level, @NotNull SmartPsiElementPointer<PsiElement> startElementPointer, @NotNull SmartPsiElementPointer<PsiElement> endElementPointer, @Nullable LintFix quickfixData) {
            this.component = component;
            this.issueSource = new NlComponentIssueSource(component);
            this.attribute = attribute;
            this.inspection = inspection;
            this.incident = incident;
            this.issue = issue;
            this.message = message;
            this.level = level;
            this.startElementPointer = startElementPointer;
            this.endElementPointer = endElementPointer;
            this.quickfixData = quickfixData;
        }

        @Nullable
        public SuppressLintQuickFix getSuppressLintQuickFix() {
            HighlightDisplayKey key = HighlightDisplayKey.find((String)this.inspection.getShortName());
            return key == null ? null : new SuppressLintQuickFix(key.getID(), this.startElementPointer.getElement());
        }

        @Override
        public int compareTo(@NotNull IssueData o) {
            return ComparisonChain.start().compare((Comparable)this.level.getSeverity(), (Comparable)o.level.getSeverity()).compare(this.issue.getPriority(), o.issue.getPriority()).compare((Comparable)this.issue.getDefaultSeverity(), (Comparable)o.issue.getDefaultSeverity()).result();
        }
    }
}

