/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.layout.scroller;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.layout.scroller.DesignSurfaceViewportScroller;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewport;
import java.awt.Dimension;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/common/layout/scroller/ZoomCenterScroller;", "Lcom/android/tools/idea/common/layout/scroller/DesignSurfaceViewportScroller;", "oldViewSize", "Ljava/awt/Dimension;", "scrollPosition", "Ljava/awt/Point;", "zoomCenter", "<init>", "(Ljava/awt/Dimension;Ljava/awt/Point;Ljava/awt/Point;)V", "scroll", "", "port", "Lcom/android/tools/idea/common/surface/layout/DesignSurfaceViewport;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class ZoomCenterScroller
implements DesignSurfaceViewportScroller {
    @NotNull
    private final Dimension oldViewSize;
    @NotNull
    private final Point scrollPosition;
    @NotNull
    private final Point zoomCenter;
    public static final int $stable = 8;

    public ZoomCenterScroller(@NotNull Dimension oldViewSize, @NotNull Point scrollPosition, @NotNull Point zoomCenter) {
        Intrinsics.checkNotNullParameter((Object)oldViewSize, (String)"oldViewSize");
        Intrinsics.checkNotNullParameter((Object)scrollPosition, (String)"scrollPosition");
        Intrinsics.checkNotNullParameter((Object)zoomCenter, (String)"zoomCenter");
        this.oldViewSize = oldViewSize;
        this.scrollPosition = scrollPosition;
        this.zoomCenter = zoomCenter;
    }

    @Override
    public void scroll(@NotNull DesignSurfaceViewport port) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Dimension newViewSize = port.getViewSize();
        if (newViewSize.width == 0 || newViewSize.height == 0 || Intrinsics.areEqual((Object)newViewSize, (Object)this.oldViewSize)) {
            return;
        }
        double weightInPaneX = (double)(this.scrollPosition.x + this.zoomCenter.x) / (double)this.oldViewSize.width;
        double weightInPaneY = (double)(this.scrollPosition.y + this.zoomCenter.y) / (double)this.oldViewSize.height;
        int newViewWidth = newViewSize.width;
        int newViewHeight = newViewSize.height;
        double newZoomCenterInViewX = (double)newViewWidth * weightInPaneX;
        double newZoomCenterInViewY = (double)newViewHeight * weightInPaneY;
        int newViewPositionX = RangesKt.coerceIn((int)((int)(newZoomCenterInViewX - (double)this.zoomCenter.x)), (int)0, (int)(newViewWidth - port.getViewportComponent().getWidth()));
        int newViewPositionY = RangesKt.coerceIn((int)((int)(newZoomCenterInViewY - (double)this.zoomCenter.y)), (int)0, (int)(newViewHeight - port.getViewportComponent().getHeight()));
        port.setViewPosition(new Point(newViewPositionX, newViewPositionY));
    }
}

