/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.Bridge;
import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.editor.DefaultModelProviderKt;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.editor.ModelProvider;
import com.android.tools.idea.common.editor.SplitEditorKt;
import com.android.tools.idea.common.lint.ModelLintIssueAnnotator;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.editors.notifications.NotificationPanel;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.rendering.AndroidBuildTargetReference;
import com.android.tools.idea.startup.ClearResourceCacheAfterFirstBuild;
import com.android.tools.idea.uibuilder.editor.AnimationToolbar;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.android.tools.idea.util.SyncUtil;
import com.google.common.collect.Iterables;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignerEditorPanel
extends JPanel
implements Disposable,
UiDataProvider {
    private static final String DESIGN_UNAVAILABLE_MESSAGE = "Design editor is unavailable until after a successful project sync";
    private static final String ACCESSORY_PROPORTION = "AndroidStudio.AccessoryProportion";
    @NotNull
    private final DesignerEditor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final DesignSurface<?> mySurface;
    @NotNull
    private final DesignSurfaceListener mySurfaceListener;
    @NotNull
    private final ModelLintIssueAnnotator myModelLintIssueAnnotator;
    @NotNull
    private final Consumer<NlComponent> myComponentRegistrar;
    @NotNull
    private final ModelProvider myModelProvider;
    @NotNull
    private final MyContentPanel myContentPanel;
    @NotNull
    private final WorkBench<DesignSurface<?>> myWorkBench;
    @Nullable
    private final JPanel myAccessoryPanel;
    @Nullable
    private JComponent myBottomComponent;
    private boolean myGradleSyncHappenedAfterModelCreation;
    @NotNull
    private final Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface<?>>>> myToolWindowDefinitions;
    @NotNull
    private State myState;
    @NotNull
    private final AtomicBoolean myIsModelInitializated = new AtomicBoolean(false);
    NotificationPanel myNotificationPanel = new NotificationPanel((ExtensionPointName<EditorNotificationProvider>)ExtensionPointName.create((String)"com.android.tools.idea.uibuilder.editorNotificationProvider"));
    @NotNull
    private final ModelListener myModelListener = new ModelListener(){

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model) {
            DesignerEditorPanel.this.myModelLintIssueAnnotator.annotateRenderInformationToLint(model);
        }
    };
    private final IdeView myIdeView = new IdeView(){

        public void selectElement(@NotNull PsiElement element) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element);
        }

        @NotNull
        public @NotNull PsiDirectory @NotNull [] getDirectories() {
            PsiDirectory[] psiDirectoryArray;
            PsiDirectory directory = this.getOrChooseDirectory();
            if (directory != null) {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = directory;
            } else {
                psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
            }
            return psiDirectoryArray;
        }

        @Nullable
        public PsiDirectory getOrChooseDirectory() {
            return DesignerEditorPanel.this.getFile().getContainingDirectory();
        }
    };
    @Nullable
    private AnimationToolbar myAnimationToolbar;

    public DesignerEditorPanel(@NotNull DesignerEditor editor, @NotNull Project project, @NotNull VirtualFile file2, @NotNull WorkBench<DesignSurface<?>> workBench, @NotNull Function<DesignerEditorPanel, DesignSurface<?>> surface2, @NotNull Consumer<NlComponent> componentConsumer, @NotNull ModelProvider modelProvider, @NotNull Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface<?>>>> toolWindowDefinitions, final @Nullable BiFunction<DesignerEditorPanel, ? super NlModel, JComponent> bottomModelComponent, @NotNull State defaultEditorPanelState) {
        super(new BorderLayout());
        this.myEditor = editor;
        this.myProject = project;
        this.myFile = file2;
        this.myWorkBench = workBench;
        this.myContentPanel = new MyContentPanel();
        this.mySurface = surface2.apply(this);
        Disposer.register((Disposable)this, this.mySurface);
        this.myModelLintIssueAnnotator = new ModelLintIssueAnnotator(this.mySurface);
        this.myComponentRegistrar = componentConsumer;
        this.myModelProvider = modelProvider;
        this.myAccessoryPanel = this.mySurface.getAccessoryPanel();
        JComponent toolbar = DesignerEditorPanel.createSurfaceToolbar(this.mySurface);
        JPanel toolbarAndNotification = new JPanel();
        toolbarAndNotification.setLayout(new BorderLayout());
        toolbarAndNotification.add((Component)toolbar, "North");
        toolbarAndNotification.add((Component)this.myNotificationPanel, "South");
        this.myContentPanel.add(toolbarAndNotification, "North");
        if (this.shouldRecommendSyncing()) {
            this.initNeleModelWhenSmart();
        } else {
            this.myWorkBench.setLoadingText("Loading...");
        }
        this.myState = defaultEditorPanelState;
        this.mySurface.getAnalyticsManager().setEditorModeWithoutTracking(this.myState);
        this.onStateChange();
        this.add((Component)this.myWorkBench);
        this.myToolWindowDefinitions = toolWindowDefinitions;
        this.mySurfaceListener = new DesignSurfaceListener(){

            @Override
            @UiThread
            public void modelsChanged(@NotNull DesignSurface<?> surface2, @NotNull List<? extends @Nullable NlModel> models) {
                NlModel model = (NlModel)Iterables.getFirst(models, null);
                if (bottomModelComponent != null) {
                    if (DesignerEditorPanel.this.myBottomComponent != null) {
                        DesignerEditorPanel.this.myContentPanel.remove(DesignerEditorPanel.this.myBottomComponent);
                    }
                    DesignerEditorPanel.this.myBottomComponent = (JComponent)bottomModelComponent.apply(DesignerEditorPanel.this, model);
                    if (DesignerEditorPanel.this.myBottomComponent != null) {
                        DesignerEditorPanel.this.myContentPanel.add(DesignerEditorPanel.this.myBottomComponent, "South");
                    }
                }
                if (model == null) {
                    return;
                }
                DesignerEditorPanel.this.myWorkBench.setContext(DesignerEditorPanel.this.getState().name());
                DesignerEditorPanel.this.myWorkBench.init((JComponent)((Object)DesignerEditorPanel.this.myContentPanel), DesignerEditorPanel.this.mySurface, DesignerEditorPanel.this.myToolWindowDefinitions.apply(model.getFacet()), DesignerEditorPanel.this.getState() == State.SPLIT);
            }
        };
        this.mySurface.addListener(this.mySurfaceListener);
    }

    public void setState(@NotNull State state) {
        this.mySurface.getAnalyticsManager().setEditorModeWithoutTracking(state);
        if (this.myState != state) {
            this.myState = state;
            this.onStateChange();
        }
    }

    private boolean shouldRecommendSyncing() {
        ProjectSystemSyncManager syncManager = ProjectSystemService.getInstance((Project)this.myProject).getProjectSystem().getSyncManager();
        boolean syncResultUnknown = syncManager.getLastSyncResult() == ProjectSystemSyncManager.SyncResult.UNKNOWN;
        boolean syncInProgress = syncManager.isSyncInProgress();
        return syncResultUnknown && !syncInProgress;
    }

    private void onStateChange() {
        State currentState = this.getState();
        this.myWorkBench.setContext(currentState.name());
        this.myWorkBench.setDefaultPropertiesForContext(currentState == State.SPLIT);
        if (currentState != State.DEACTIVATED && !this.myIsModelInitializated.getAndSet(true)) {
            ClearResourceCacheAfterFirstBuild.getInstance((Project)this.myProject).runWhenResourceCacheClean(this::initNeleModel, this::buildError, (Disposable)this);
        }
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public DesignerEditorPanel(@NotNull DesignerEditor editor, @NotNull Project project, @NotNull VirtualFile file2, @NotNull WorkBench<DesignSurface<?>> workBench, @NotNull Function<DesignerEditorPanel, DesignSurface<?>> surface2, @NotNull Consumer<NlComponent> componentRegistrar, @NotNull Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface<?>>>> toolWindowDefinitions, @NotNull State defaultState) {
        this(editor, project, file2, workBench, surface2, componentRegistrar, DefaultModelProviderKt.getDEFAULT_MODEL_PROVIDER(), toolWindowDefinitions, null, defaultState);
    }

    void updateNotifications(@NotNull VirtualFile file2, @NotNull DesignerEditor editor, @NotNull Project project) {
        this.myNotificationPanel.updateNotifications(file2, editor, project);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        FileEditor fileEditorDelegate = this.getSurface().getFileEditorDelegate();
        if (fileEditorDelegate instanceof TextEditor) {
            sink.set(SplitEditorKt.getSPLIT_TEXT_EDITOR_KEY(), (Object)((TextEditor)fileEditorDelegate));
            sink.set(LangDataKeys.IDE_VIEW, (Object)this.myIdeView);
        }
        if (this.myAnimationToolbar != null) {
            sink.set(DesignerDataKeys.ANIMATION_TOOLBAR, (Object)this.myAnimationToolbar);
        }
    }

    void setFileEditorDelegate(TextEditor editor) {
        this.getSurface().setFileEditorDelegate((FileEditor)editor);
    }

    public void setAnimationToolbar(@Nullable AnimationToolbar toolbar) {
        this.myAnimationToolbar = toolbar;
    }

    @NotNull
    private static JComponent createSurfaceToolbar(@NotNull DesignSurface<?> surface2) {
        return surface2.getActionManager().createToolbar();
    }

    private void buildError() {
        this.myWorkBench.loadingStopped(DESIGN_UNAVAILABLE_MESSAGE);
    }

    public void initNeleModel() {
        SyncUtil.runWhenSmartAndSynced((Project)this.myProject, (Disposable)this, result -> {
            if (result.isSuccessful()) {
                this.initNeleModelWhenSmart();
            } else {
                this.buildError();
                SyncUtil.listenUntilNextSync((Project)this.myProject, (Disposable)this, ignore -> this.initNeleModel());
            }
        });
    }

    private void initNeleModelWhenSmart() {
        if (Disposer.isDisposed((Disposable)this.myEditor)) {
            return;
        }
        CompletableFuture.supplyAsync(this::createAndInitNeleModel, AppExecutorUtil.getAppExecutorService()).whenComplete((model, exception) -> {
            if (exception == null) {
                this.mySurface.goingToSetModel((NlModel)model).join();
                this.myWorkBench.setLoadingText("Waiting for build to finish...");
                SyncUtil.runWhenSmartAndSyncedOnEdt((Project)this.myProject, (Disposable)this, result -> {
                    if (Bridge.hasNativeCrash()) {
                        DesignSurfaceHelper.handleLayoutlibNativeCrash(this.myWorkBench, this::initNeleModel);
                        return;
                    }
                    this.myWorkBench.setLoadingText("Initializing...");
                    if (result.isSuccessful()) {
                        this.initNeleModelOnEventDispatchThread((NlModel)model);
                    } else {
                        this.buildError();
                        SyncUtil.listenUntilNextSync((Project)this.myProject, (Disposable)this, ignore -> this.initNeleModel());
                    }
                });
            } else {
                ApplicationManager.getApplication().invokeLater(() -> {
                    Throwable cause = exception.getCause();
                    if (cause instanceof WaitingForGradleSyncException) {
                        Logger.getInstance(DesignerEditorPanel.class).info(cause.getMessage());
                        SyncUtil.listenUntilNextSync((Project)this.myProject, (Disposable)this, ignore -> this.initNeleModel());
                        this.myWorkBench.loadingStopped("Design editor is unavailable until next gradle sync.");
                        return;
                    }
                    this.myWorkBench.loadingStopped("Failed to initialize editor.");
                    Logger.getInstance(DesignerEditorPanel.class).warn("Failed to initialize DesignerEditorPanel", exception);
                });
            }
        });
    }

    @NotNull
    private NlModel createAndInitNeleModel() {
        XmlFile file2 = (XmlFile)ReadAction.compute(() -> this.getFile());
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file2);
        if (facet == null) {
            if (this.myGradleSyncHappenedAfterModelCreation) {
                throw new IllegalStateException("Could not init NlModel. AndroidFacet is unexpectedly null. That might happen if the file does not belong to an Android module of the project.");
            }
            this.myGradleSyncHappenedAfterModelCreation = true;
            throw new WaitingForGradleSyncException("Waiting for next gradle sync to set AndroidFacet.");
        }
        NlModel model = this.myModelProvider.createModel((Disposable)this.myEditor, this.myProject, AndroidBuildTargetReference.from((AndroidFacet)facet, (VirtualFile)this.myFile), this.myComponentRegistrar, this.myFile);
        final Module modelModule = AndroidPsiUtils.getModuleSafely((Project)this.myProject, (VirtualFile)this.myFile);
        this.myProject.getMessageBus().connect(this.mySurface).subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (module.equals(modelModule)) {
                    FileEditorManager.getInstance((Project)project).closeFile(DesignerEditorPanel.this.myFile);
                }
            }
        });
        return model;
    }

    @UiThread
    private void initNeleModelOnEventDispatchThread(@NotNull NlModel model) {
        if (model.isDisposed()) {
            return;
        }
        this.mySurface.getModels().forEach(it -> it.removeListener(this.myModelListener));
        this.mySurface.setModel(model);
        model.addListener(this.myModelListener);
        if (this.myAccessoryPanel != null) {
            float initialProportion = PropertiesComponent.getInstance().getFloat(ACCESSORY_PROPORTION, 0.5f);
            final OnePixelSplitter splitter = new OnePixelSplitter(false, initialProportion, 0.05f, 0.95f);
            splitter.setHonorComponentsMinimumSize(false);
            splitter.setFirstComponent(this.mySurface);
            splitter.setSecondComponent((JComponent)this.myAccessoryPanel);
            this.mySurface.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (DesignerEditorPanel.this.myAccessoryPanel.isVisible()) {
                        float proportion = splitter.getProportion();
                        PropertiesComponent.getInstance().setValue(DesignerEditorPanel.ACCESSORY_PROPORTION, proportion, 0.5f);
                    }
                }
            });
            this.myContentPanel.add((Component)splitter, "Center");
        } else {
            this.myContentPanel.add((Component)((Object)this.mySurface), "Center");
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void activate() {
        this.mySurface.activate();
    }

    public void deactivate() {
        this.mySurface.deactivate();
        this.mySurface.getConfigurations().forEach(Configuration::save);
    }

    @NotNull
    public DesignSurface<?> getSurface() {
        return this.mySurface;
    }

    @NotNull
    public ModelLintIssueAnnotator getModelLintIssueAnnotator() {
        return this.myModelLintIssueAnnotator;
    }

    @NotNull
    private XmlFile getFile() {
        XmlFile file2 = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)this.myFile);
        assert (file2 != null);
        return file2;
    }

    public void dispose() {
        this.mySurface.removeListener(this.mySurfaceListener);
        this.mySurface.getModels().forEach(model -> model.removeListener(this.myModelListener));
    }

    @NotNull
    public WorkBench<DesignSurface<?>> getWorkBench() {
        return this.myWorkBench;
    }

    private class MyContentPanel
    extends AdtPrimaryPanel
    implements UiDataProvider {
        private MyContentPanel() {
            super((LayoutManager)new BorderLayout());
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            NlDesignSurface o;
            ScreenViewProvider mode;
            DesignSurface<?> surface2 = DesignerEditorPanel.this.getSurface();
            DataSink.uiDataSnapshot((DataSink)sink, surface2);
            if (surface2 instanceof NlDesignSurface && ((mode = (o = (NlDesignSurface)surface2).getScreenViewProvider()) == NlScreenViewProvider.RENDER || mode == NlScreenViewProvider.BLUEPRINT || mode == NlScreenViewProvider.RENDER_AND_BLUEPRINT)) {
                sink.set(NlActionManager.LAYOUT_EDITOR, (Object)o);
            }
        }
    }

    public static enum State {
        FULL,
        SPLIT,
        DEACTIVATED;

    }

    private static class WaitingForGradleSyncException
    extends RuntimeException {
        private WaitingForGradleSyncException(@NotNull String message) {
            super(message);
        }
    }
}

