/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.assistant;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.assistant.AssistantPanelMetricsTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DesignEditorHelpPanelEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/common/assistant/HelpPanelToolWindowListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isOpen", "", "type", "Lcom/google/wireless/android/sdk/stats/DesignEditorHelpPanelEvent$HelpPanelType;", "currActionId", "", "metrics", "Ljava/util/HashMap;", "Lcom/android/tools/idea/common/assistant/AssistantPanelMetricsTracker;", "Lkotlin/collections/HashMap;", "currMetric", "getCurrMetric", "()Lcom/android/tools/idea/common/assistant/AssistantPanelMetricsTracker;", "dispose", "", "toolWindowUnregistered", "id", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "closeAndRemove", "stateChanged", "Companion", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class HelpPanelToolWindowListener
implements ToolWindowManagerListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Project project;
    private boolean isOpen;
    @NotNull
    private DesignEditorHelpPanelEvent.HelpPanelType type;
    @NotNull
    private String currActionId;
    @NotNull
    private final HashMap<String, AssistantPanelMetricsTracker> metrics;
    public static final int $stable = 8;
    @NotNull
    private static final HashMap<String, DesignEditorHelpPanelEvent.HelpPanelType> map = new HashMap();
    @NotNull
    private static final HashMap<Project, HelpPanelToolWindowListener> projectToListener = new HashMap();

    private HelpPanelToolWindowListener(Project project) {
        this.project = project;
        this.type = DesignEditorHelpPanelEvent.HelpPanelType.UNKNOWN_PANEL_TYPE;
        this.currActionId = "";
        this.metrics = new HashMap();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this.project);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
    }

    private final AssistantPanelMetricsTracker getCurrMetric() {
        return this.metrics.get(this.currActionId);
    }

    public void dispose() {
        this.closeAndRemove();
    }

    public void toolWindowUnregistered(@NotNull String id, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.closeAndRemove();
    }

    private final void closeAndRemove() {
        if (this.isOpen) {
            AssistantPanelMetricsTracker assistantPanelMetricsTracker = this.getCurrMetric();
            if (assistantPanelMetricsTracker != null) {
                assistantPanelMetricsTracker.logClose();
            }
            this.isOpen = false;
        }
        projectToListener.remove(this.project);
    }

    public void stateChanged() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Assistant");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window = toolWindow;
        String string = window.getHelpId();
        if (string == null) {
            string = "";
        }
        this.currActionId = string;
        DesignEditorHelpPanelEvent.HelpPanelType helpPanelType = map.get(this.currActionId);
        if (helpPanelType == null) {
            return;
        }
        this.type = helpPanelType;
        if (this.type == DesignEditorHelpPanelEvent.HelpPanelType.UNKNOWN_PANEL_TYPE) {
            return;
        }
        this.metrics.putIfAbsent(this.currActionId, new AssistantPanelMetricsTracker(this.type));
        if (this.isOpen && !window.isVisible()) {
            this.isOpen = false;
            AssistantPanelMetricsTracker assistantPanelMetricsTracker = this.getCurrMetric();
            Intrinsics.checkNotNull((Object)assistantPanelMetricsTracker);
            assistantPanelMetricsTracker.logClose();
            this.metrics.remove(this.currActionId);
        } else if (!this.isOpen && window.isVisible()) {
            this.isOpen = true;
            AssistantPanelMetricsTracker assistantPanelMetricsTracker = this.getCurrMetric();
            Intrinsics.checkNotNull((Object)assistantPanelMetricsTracker);
            assistantPanelMetricsTracker.logOpen();
        }
    }

    public /* synthetic */ HelpPanelToolWindowListener(Project project, DefaultConstructorMarker $constructor_marker) {
        this(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fR-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR8\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0005j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/common/assistant/HelpPanelToolWindowListener$Companion;", "", "<init>", "()V", "map", "Ljava/util/HashMap;", "", "Lcom/google/wireless/android/sdk/stats/DesignEditorHelpPanelEvent$HelpPanelType;", "Lkotlin/collections/HashMap;", "getMap", "()Ljava/util/HashMap;", "projectToListener", "Lcom/intellij/openapi/project/Project;", "Lcom/android/tools/idea/common/assistant/HelpPanelToolWindowListener;", "getProjectToListener$annotations", "getProjectToListener", "registerListener", "", "project", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<String, DesignEditorHelpPanelEvent.HelpPanelType> getMap() {
            return map;
        }

        @NotNull
        public final HashMap<Project, HelpPanelToolWindowListener> getProjectToListener() {
            return projectToListener;
        }

        @VisibleForTesting
        public static /* synthetic */ void getProjectToListener$annotations() {
        }

        public final void registerListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!this.getProjectToListener().containsKey(project)) {
                ((Map)this.getProjectToListener()).put(project, new HelpPanelToolWindowListener(project, null));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

