/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationListener;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.configurations.ConfigurationForFile;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.google.common.collect.Iterables;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationAction
extends AnAction
implements ConfigurationListener,
Toggleable {
    private static final String FILE_ARROW = " \u2192 ";
    private int myFlags;

    public ConfigurationAction() {
        this(null, null);
    }

    public ConfigurationAction(@Nullable String title) {
        this(title, null);
    }

    public ConfigurationAction(@Nullable String title, @Nullable Icon icon2) {
        super(title, null, icon2);
    }

    protected void updatePresentation(@NotNull AnActionEvent event) {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ActionUtil.performDumbAwareWithCallbacks((AnAction)this, (AnActionEvent)e, () -> {
            this.tryUpdateConfiguration(e.getDataContext());
            this.updatePresentation(e);
        });
    }

    protected void tryUpdateConfiguration(@NotNull DataContext dataContext) {
        Collection configurations = (Collection)dataContext.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null) {
            return;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        if (configuration != null) {
            boolean affectsFileSelection;
            Configuration clone = configuration.clone();
            this.myFlags = 0;
            clone.addListener((ConfigurationListener)this);
            this.updateConfiguration(clone, false);
            clone.removeListener((ConfigurationListener)this);
            boolean bl = affectsFileSelection = (this.myFlags & 0xF6) != 0;
            if (affectsFileSelection) {
                VirtualFile file2;
                ConfigurationMatcher matcher;
                List matchingFiles;
                ConfigurationForFile configForFile;
                ConfigurationForFile configurationForFile = configForFile = configuration instanceof ConfigurationForFile ? (ConfigurationForFile)clone : null;
                if (configForFile != null && !(matchingFiles = (matcher = new ConfigurationMatcher(configForFile, file2 = configForFile.getFile())).getBestFileMatches()).isEmpty() && !matchingFiles.contains(file2)) {
                    this.pickedBetterMatch(configuration, (VirtualFile)matchingFiles.get(0), file2);
                    ConfigurationManager configurationManager = configForFile.getSettings();
                    this.updateConfiguration((Configuration)configurationManager.getConfiguration((VirtualFile)matchingFiles.get(0)), true);
                    return;
                }
            }
            this.updateConfiguration(configuration, true);
        }
    }

    protected void pickedBetterMatch(@NotNull Configuration configuration, @NotNull VirtualFile file2, @NotNull VirtualFile old) {
        Project project = ConfigurationManager.getFromConfiguration((Configuration)configuration).getProject();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file2, -1);
        FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)project);
        FileEditorWithProvider previousSelection = manager.getSelectedEditorWithProvider(old);
        manager.openEditor(descriptor, true);
        if (previousSelection != null) {
            manager.setSelectedEditor(file2, previousSelection.getProvider().getEditorTypeId());
        }
    }

    public boolean changed(int flags) {
        this.myFlags |= flags;
        return true;
    }

    protected abstract void updateConfiguration(@NotNull Configuration var1, boolean var2);

    public static boolean isBetterMatchLabel(@NotNull String label) {
        return label.contains(FILE_ARROW);
    }

    public static String getBetterMatchLabel(@NotNull String prefix, @NotNull VirtualFile better, @Nullable VirtualFile file2) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(FILE_ARROW);
        String folderName = better.getParent().getName();
        if (folderName.equals("layout")) {
            if (file2 != null && !Objects.equals(file2.getParent(), better.getParent())) {
                sb.append("layout");
                sb.append(File.separatorChar);
            }
        } else {
            if (folderName.startsWith("layout")) {
                folderName = folderName.substring("layout".length() + 1);
            }
            sb.append(folderName);
            sb.append(File.separatorChar);
        }
        sb.append(better.getName());
        return sb.toString();
    }

    public static Icon getBetterMatchIcon() {
        return AllIcons.Actions.CloseDarkGrey;
    }
}

