/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8wrappers.utils;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.DiagnosticsLevel;
import com.android.tools.r8.errors.DuplicateTypeInProgramAndLibraryDiagnostic;
import com.android.tools.r8.errors.FinalRClassEntriesWithOptimizedShrinkingDiagnostic;
import com.android.tools.r8.errors.UnsupportedMainDexListUsageDiagnostic;

public class WrapperDiagnosticsHandler
implements DiagnosticsHandler {
    private boolean printInfoDiagnostics = false;
    private boolean warnOnUnsupportedMainDexList = false;
    private DiagnosticsLevel duplicateTypesLevel = DiagnosticsLevel.INFO;

    public void setPrintInfoDiagnostics(boolean value) {
        this.printInfoDiagnostics = value;
    }

    public void setWarnOnUnsupportedMainDexList(boolean value) {
        this.warnOnUnsupportedMainDexList = value;
    }

    public void setDuplicateTypesDiagnosticsLevel(DiagnosticsLevel level) {
        this.duplicateTypesLevel = level;
    }

    @Override
    public DiagnosticsLevel modifyDiagnosticsLevel(DiagnosticsLevel level, Diagnostic diagnostic) {
        if (this.warnOnUnsupportedMainDexList && diagnostic instanceof UnsupportedMainDexListUsageDiagnostic) {
            return DiagnosticsLevel.WARNING;
        }
        if (diagnostic instanceof DuplicateTypeInProgramAndLibraryDiagnostic && ((level = this.duplicateTypesLevel) == DiagnosticsLevel.WARNING || level == DiagnosticsLevel.ERROR) && WrapperDiagnosticsHandler.isBenignDuplicateType((DuplicateTypeInProgramAndLibraryDiagnostic)diagnostic)) {
            level = DiagnosticsLevel.INFO;
        }
        if (diagnostic instanceof FinalRClassEntriesWithOptimizedShrinkingDiagnostic) {
            return DiagnosticsLevel.ERROR;
        }
        if (!this.printInfoDiagnostics && level == DiagnosticsLevel.INFO) {
            return DiagnosticsLevel.NONE;
        }
        return level;
    }

    private static boolean isBenignDuplicateType(DuplicateTypeInProgramAndLibraryDiagnostic diagnostic) {
        boolean isKotlinAnnotationDuplicate = diagnostic.getType().getTypeName().startsWith("kotlin") && diagnostic.getLibraryOrigin().toString().contains("androidx.annotation_annotation");
        return isKotlinAnnotationDuplicate;
    }
}

